/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The catalog data for a repository. This data is publicly visible in the Amazon ECR Public Gallery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryCatalogData implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryCatalogData.Builder, RepositoryCatalogData> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RepositoryCatalogData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("architectures")
            .getter(getter(RepositoryCatalogData::architectures))
            .setter(setter(Builder::architectures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OPERATING_SYSTEMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("operatingSystems")
            .getter(getter(RepositoryCatalogData::operatingSystems))
            .setter(setter(Builder::operatingSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOGO_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logoUrl").getter(getter(RepositoryCatalogData::logoUrl)).setter(setter(Builder::logoUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logoUrl").build()).build();

    private static final SdkField<String> ABOUT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aboutText").getter(getter(RepositoryCatalogData::aboutText)).setter(setter(Builder::aboutText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aboutText").build()).build();

    private static final SdkField<String> USAGE_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageText").getter(getter(RepositoryCatalogData::usageText)).setter(setter(Builder::usageText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageText").build()).build();

    private static final SdkField<Boolean> MARKETPLACE_CERTIFIED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("marketplaceCertified").getter(getter(RepositoryCatalogData::marketplaceCertified))
            .setter(setter(Builder::marketplaceCertified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marketplaceCertified").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ARCHITECTURES_FIELD, OPERATING_SYSTEMS_FIELD, LOGO_URL_FIELD, ABOUT_TEXT_FIELD, USAGE_TEXT_FIELD,
            MARKETPLACE_CERTIFIED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final List<String> architectures;

    private final List<String> operatingSystems;

    private final String logoUrl;

    private final String aboutText;

    private final String usageText;

    private final Boolean marketplaceCertified;

    private RepositoryCatalogData(BuilderImpl builder) {
        this.description = builder.description;
        this.architectures = builder.architectures;
        this.operatingSystems = builder.operatingSystems;
        this.logoUrl = builder.logoUrl;
        this.aboutText = builder.aboutText;
        this.usageText = builder.usageText;
        this.marketplaceCertified = builder.marketplaceCertified;
    }

    /**
     * <p>
     * The short description of the repository.
     * </p>
     * 
     * @return The short description of the repository.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Architectures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchitectures() {
        return architectures != null && !(architectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The architecture tags that are associated with the repository.
     * </p>
     * <note>
     * <p>
     * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information, see
     * <a>RepositoryCatalogDataInput</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectures} method.
     * </p>
     * 
     * @return The architecture tags that are associated with the repository.</p> <note>
     *         <p>
     *         Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more
     *         information, see <a>RepositoryCatalogDataInput</a>.
     *         </p>
     */
    public final List<String> architectures() {
        return architectures;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperatingSystems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperatingSystems() {
        return operatingSystems != null && !(operatingSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operating system tags that are associated with the repository.
     * </p>
     * <note>
     * <p>
     * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information, see
     * <a>RepositoryCatalogDataInput</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperatingSystems} method.
     * </p>
     * 
     * @return The operating system tags that are associated with the repository.</p> <note>
     *         <p>
     *         Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more
     *         information, see <a>RepositoryCatalogDataInput</a>.
     *         </p>
     */
    public final List<String> operatingSystems() {
        return operatingSystems;
    }

    /**
     * <p>
     * The URL containing the logo associated with the repository.
     * </p>
     * 
     * @return The URL containing the logo associated with the repository.
     */
    public final String logoUrl() {
        return logoUrl;
    }

    /**
     * <p>
     * The longform description of the contents of the repository. This text appears in the repository details on the
     * Amazon ECR Public Gallery.
     * </p>
     * 
     * @return The longform description of the contents of the repository. This text appears in the repository details
     *         on the Amazon ECR Public Gallery.
     */
    public final String aboutText() {
        return aboutText;
    }

    /**
     * <p>
     * The longform usage details of the contents of the repository. The usage text provides context for users of the
     * repository.
     * </p>
     * 
     * @return The longform usage details of the contents of the repository. The usage text provides context for users
     *         of the repository.
     */
    public final String usageText() {
        return usageText;
    }

    /**
     * <p>
     * Whether or not the repository is certified by AWS Marketplace.
     * </p>
     * 
     * @return Whether or not the repository is certified by AWS Marketplace.
     */
    public final Boolean marketplaceCertified() {
        return marketplaceCertified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasArchitectures() ? architectures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOperatingSystems() ? operatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logoUrl());
        hashCode = 31 * hashCode + Objects.hashCode(aboutText());
        hashCode = 31 * hashCode + Objects.hashCode(usageText());
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceCertified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryCatalogData)) {
            return false;
        }
        RepositoryCatalogData other = (RepositoryCatalogData) obj;
        return Objects.equals(description(), other.description()) && hasArchitectures() == other.hasArchitectures()
                && Objects.equals(architectures(), other.architectures()) && hasOperatingSystems() == other.hasOperatingSystems()
                && Objects.equals(operatingSystems(), other.operatingSystems()) && Objects.equals(logoUrl(), other.logoUrl())
                && Objects.equals(aboutText(), other.aboutText()) && Objects.equals(usageText(), other.usageText())
                && Objects.equals(marketplaceCertified(), other.marketplaceCertified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryCatalogData").add("Description", description())
                .add("Architectures", hasArchitectures() ? architectures() : null)
                .add("OperatingSystems", hasOperatingSystems() ? operatingSystems() : null).add("LogoUrl", logoUrl())
                .add("AboutText", aboutText()).add("UsageText", usageText()).add("MarketplaceCertified", marketplaceCertified())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "architectures":
            return Optional.ofNullable(clazz.cast(architectures()));
        case "operatingSystems":
            return Optional.ofNullable(clazz.cast(operatingSystems()));
        case "logoUrl":
            return Optional.ofNullable(clazz.cast(logoUrl()));
        case "aboutText":
            return Optional.ofNullable(clazz.cast(aboutText()));
        case "usageText":
            return Optional.ofNullable(clazz.cast(usageText()));
        case "marketplaceCertified":
            return Optional.ofNullable(clazz.cast(marketplaceCertified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryCatalogData, T> g) {
        return obj -> g.apply((RepositoryCatalogData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryCatalogData> {
        /**
         * <p>
         * The short description of the repository.
         * </p>
         * 
         * @param description
         *        The short description of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The architecture tags that are associated with the repository.
         * </p>
         * <note>
         * <p>
         * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information,
         * see <a>RepositoryCatalogDataInput</a>.
         * </p>
         * </note>
         * 
         * @param architectures
         *        The architecture tags that are associated with the repository.</p> <note>
         *        <p>
         *        Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more
         *        information, see <a>RepositoryCatalogDataInput</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(Collection<String> architectures);

        /**
         * <p>
         * The architecture tags that are associated with the repository.
         * </p>
         * <note>
         * <p>
         * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information,
         * see <a>RepositoryCatalogDataInput</a>.
         * </p>
         * </note>
         * 
         * @param architectures
         *        The architecture tags that are associated with the repository.</p> <note>
         *        <p>
         *        Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more
         *        information, see <a>RepositoryCatalogDataInput</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(String... architectures);

        /**
         * <p>
         * The operating system tags that are associated with the repository.
         * </p>
         * <note>
         * <p>
         * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information,
         * see <a>RepositoryCatalogDataInput</a>.
         * </p>
         * </note>
         * 
         * @param operatingSystems
         *        The operating system tags that are associated with the repository.</p> <note>
         *        <p>
         *        Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more
         *        information, see <a>RepositoryCatalogDataInput</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystems(Collection<String> operatingSystems);

        /**
         * <p>
         * The operating system tags that are associated with the repository.
         * </p>
         * <note>
         * <p>
         * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information,
         * see <a>RepositoryCatalogDataInput</a>.
         * </p>
         * </note>
         * 
         * @param operatingSystems
         *        The operating system tags that are associated with the repository.</p> <note>
         *        <p>
         *        Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more
         *        information, see <a>RepositoryCatalogDataInput</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystems(String... operatingSystems);

        /**
         * <p>
         * The URL containing the logo associated with the repository.
         * </p>
         * 
         * @param logoUrl
         *        The URL containing the logo associated with the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoUrl(String logoUrl);

        /**
         * <p>
         * The longform description of the contents of the repository. This text appears in the repository details on
         * the Amazon ECR Public Gallery.
         * </p>
         * 
         * @param aboutText
         *        The longform description of the contents of the repository. This text appears in the repository
         *        details on the Amazon ECR Public Gallery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aboutText(String aboutText);

        /**
         * <p>
         * The longform usage details of the contents of the repository. The usage text provides context for users of
         * the repository.
         * </p>
         * 
         * @param usageText
         *        The longform usage details of the contents of the repository. The usage text provides context for
         *        users of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageText(String usageText);

        /**
         * <p>
         * Whether or not the repository is certified by AWS Marketplace.
         * </p>
         * 
         * @param marketplaceCertified
         *        Whether or not the repository is certified by AWS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplaceCertified(Boolean marketplaceCertified);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();

        private List<String> operatingSystems = DefaultSdkAutoConstructList.getInstance();

        private String logoUrl;

        private String aboutText;

        private String usageText;

        private Boolean marketplaceCertified;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryCatalogData model) {
            description(model.description);
            architectures(model.architectures);
            operatingSystems(model.operatingSystems);
            logoUrl(model.logoUrl);
            aboutText(model.aboutText);
            usageText(model.usageText);
            marketplaceCertified(model.marketplaceCertified);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getArchitectures() {
            if (architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
        }

        @Override
        public final Builder architectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(String... architectures) {
            architectures(Arrays.asList(architectures));
            return this;
        }

        public final Collection<String> getOperatingSystems() {
            if (operatingSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return operatingSystems;
        }

        public final void setOperatingSystems(Collection<String> operatingSystems) {
            this.operatingSystems = OperatingSystemListCopier.copy(operatingSystems);
        }

        @Override
        public final Builder operatingSystems(Collection<String> operatingSystems) {
            this.operatingSystems = OperatingSystemListCopier.copy(operatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(String... operatingSystems) {
            operatingSystems(Arrays.asList(operatingSystems));
            return this;
        }

        public final String getLogoUrl() {
            return logoUrl;
        }

        public final void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        @Override
        public final Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public final String getAboutText() {
            return aboutText;
        }

        public final void setAboutText(String aboutText) {
            this.aboutText = aboutText;
        }

        @Override
        public final Builder aboutText(String aboutText) {
            this.aboutText = aboutText;
            return this;
        }

        public final String getUsageText() {
            return usageText;
        }

        public final void setUsageText(String usageText) {
            this.usageText = usageText;
        }

        @Override
        public final Builder usageText(String usageText) {
            this.usageText = usageText;
            return this;
        }

        public final Boolean getMarketplaceCertified() {
            return marketplaceCertified;
        }

        public final void setMarketplaceCertified(Boolean marketplaceCertified) {
            this.marketplaceCertified = marketplaceCertified;
        }

        @Override
        public final Builder marketplaceCertified(Boolean marketplaceCertified) {
            this.marketplaceCertified = marketplaceCertified;
            return this;
        }

        @Override
        public RepositoryCatalogData build() {
            return new RepositoryCatalogData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
