/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicException;
import software.amazon.awssdk.services.ecrpublic.model.EmptyUploadException;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.ImageDigestDoesNotMatchException;
import software.amazon.awssdk.services.ecrpublic.model.ImageNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.ImageTagAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.InvalidLayerException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidLayerPartException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidParameterException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidTagParameterException;
import software.amazon.awssdk.services.ecrpublic.model.LayerAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.LayerPartTooSmallException;
import software.amazon.awssdk.services.ecrpublic.model.LayersNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.LimitExceededException;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.ReferencedImagesNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RegistryNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryCatalogDataNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryNotEmptyException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryPolicyNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.ServerException;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.TooManyTagsException;
import software.amazon.awssdk.services.ecrpublic.model.UnsupportedCommandException;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecrpublic.model.UploadNotFoundException;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsIterable;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesIterable;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesIterable;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesIterable;

/**
 * Service client for accessing Amazon ECR Public. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Elastic Container Registry Public</fullname>
 * <p>
 * Amazon Elastic Container Registry Public (Amazon ECR Public) is a managed container image registry service. Amazon
 * ECR provides both public and private registries to host your container images. You can use the Docker CLI or your
 * preferred client to push, pull, and manage images. Amazon ECR provides a secure, scalable, and reliable registry for
 * your Docker or Open Container Initiative (OCI) images. Amazon ECR supports public repositories with this API. For
 * information about the Amazon ECR API for private repositories, see <a
 * href="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/Welcome.html">Amazon Elastic Container Registry API
 * Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EcrPublicClient extends SdkClient {
    String SERVICE_NAME = "ecr-public";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.ecr-public";

    /**
     * <p>
     * Checks the availability of one or more image layers that are within a repository in a public registry. When an
     * image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has
     * been uploaded, then the image layer is skipped.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param batchCheckLayerAvailabilityRequest
     * @return Result of the BatchCheckLayerAvailability operation returned by the service.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.BatchCheckLayerAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchCheckLayerAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCheckLayerAvailabilityResponse batchCheckLayerAvailability(
            BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) throws RepositoryNotFoundException,
            InvalidParameterException, ServerException, RegistryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the availability of one or more image layers that are within a repository in a public registry. When an
     * image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has
     * been uploaded, then the image layer is skipped.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCheckLayerAvailabilityRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCheckLayerAvailabilityRequest#builder()}
     * </p>
     *
     * @param batchCheckLayerAvailabilityRequest
     *        A {@link Consumer} that will call methods on {@link BatchCheckLayerAvailabilityRequest.Builder} to create
     *        a request.
     * @return Result of the BatchCheckLayerAvailability operation returned by the service.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.BatchCheckLayerAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchCheckLayerAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCheckLayerAvailabilityResponse batchCheckLayerAvailability(
            Consumer<BatchCheckLayerAvailabilityRequest.Builder> batchCheckLayerAvailabilityRequest)
            throws RepositoryNotFoundException, InvalidParameterException, ServerException, RegistryNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest.builder()
                .applyMutation(batchCheckLayerAvailabilityRequest).build());
    }

    /**
     * <p>
     * Deletes a list of specified images that are within a repository in a public registry. Images are specified with
     * either an <code>imageTag</code> or <code>imageDigest</code>.
     * </p>
     * <p>
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag
     * from an image, the image is deleted from your repository.
     * </p>
     * <p>
     * You can completely delete an image (and all of its tags) by specifying the digest of the image in your request.
     * </p>
     *
     * @param batchDeleteImageRequest
     * @return Result of the BatchDeleteImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.BatchDeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchDeleteImage" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteImageResponse batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a list of specified images that are within a repository in a public registry. Images are specified with
     * either an <code>imageTag</code> or <code>imageDigest</code>.
     * </p>
     * <p>
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag
     * from an image, the image is deleted from your repository.
     * </p>
     * <p>
     * You can completely delete an image (and all of its tags) by specifying the digest of the image in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteImageRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDeleteImageRequest#builder()}
     * </p>
     *
     * @param batchDeleteImageRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteImageRequest.Builder} to create a request.
     * @return Result of the BatchDeleteImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.BatchDeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchDeleteImage" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteImageResponse batchDeleteImage(Consumer<BatchDeleteImageRequest.Builder> batchDeleteImageRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        return batchDeleteImage(BatchDeleteImageRequest.builder().applyMutation(batchDeleteImageRequest).build());
    }

    /**
     * <p>
     * Informs Amazon ECR that the image layer upload is complete for a specified public registry, repository name, and
     * upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation
     * purposes.
     * </p>
     * <p>
     * When an image is pushed, the CompleteLayerUpload API is called once for each new image layer to verify that the
     * upload is complete.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param completeLayerUploadRequest
     * @return Result of the CompleteLayerUpload operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UploadNotFoundException
     *         The upload can't be found, or the specified upload ID isn't valid for this repository.
     * @throws InvalidLayerException
     *         The layer digest calculation performed by Amazon ECR when the image layer doesn't match the digest
     *         specified.
     * @throws LayerPartTooSmallException
     *         Layer parts must be at least 5 MiB in size.
     * @throws LayerAlreadyExistsException
     *         The image layer already exists in the associated repository.
     * @throws EmptyUploadException
     *         The specified layer upload doesn't contain any layer parts.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.CompleteLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CompleteLayerUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompleteLayerUploadResponse completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, UploadNotFoundException,
            InvalidLayerException, LayerPartTooSmallException, LayerAlreadyExistsException, EmptyUploadException,
            RegistryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Informs Amazon ECR that the image layer upload is complete for a specified public registry, repository name, and
     * upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation
     * purposes.
     * </p>
     * <p>
     * When an image is pushed, the CompleteLayerUpload API is called once for each new image layer to verify that the
     * upload is complete.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteLayerUploadRequest.Builder} avoiding the
     * need to create one manually via {@link CompleteLayerUploadRequest#builder()}
     * </p>
     *
     * @param completeLayerUploadRequest
     *        A {@link Consumer} that will call methods on {@link CompleteLayerUploadRequest.Builder} to create a
     *        request.
     * @return Result of the CompleteLayerUpload operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UploadNotFoundException
     *         The upload can't be found, or the specified upload ID isn't valid for this repository.
     * @throws InvalidLayerException
     *         The layer digest calculation performed by Amazon ECR when the image layer doesn't match the digest
     *         specified.
     * @throws LayerPartTooSmallException
     *         Layer parts must be at least 5 MiB in size.
     * @throws LayerAlreadyExistsException
     *         The image layer already exists in the associated repository.
     * @throws EmptyUploadException
     *         The specified layer upload doesn't contain any layer parts.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.CompleteLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CompleteLayerUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompleteLayerUploadResponse completeLayerUpload(
            Consumer<CompleteLayerUploadRequest.Builder> completeLayerUploadRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, UploadNotFoundException, InvalidLayerException,
            LayerPartTooSmallException, LayerAlreadyExistsException, EmptyUploadException, RegistryNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return completeLayerUpload(CompleteLayerUploadRequest.builder().applyMutation(completeLayerUploadRequest).build());
    }

    /**
     * <p>
     * Creates a repository in a public registry. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in
     * the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param createRepositoryRequest
     * @return Result of the CreateRepository operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryAlreadyExistsException
     *         The specified repository already exists in the specified registry.
     * @throws LimitExceededException
     *         The operation didn't succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest) throws ServerException,
            InvalidParameterException, InvalidTagParameterException, TooManyTagsException, RepositoryAlreadyExistsException,
            LimitExceededException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a repository in a public registry. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in
     * the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRepositoryRequest#builder()}
     * </p>
     *
     * @param createRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link CreateRepositoryRequest.Builder} to create a request.
     * @return Result of the CreateRepository operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryAlreadyExistsException
     *         The specified repository already exists in the specified registry.
     * @throws LimitExceededException
     *         The operation didn't succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRepositoryResponse createRepository(Consumer<CreateRepositoryRequest.Builder> createRepositoryRequest)
            throws ServerException, InvalidParameterException, InvalidTagParameterException, TooManyTagsException,
            RepositoryAlreadyExistsException, LimitExceededException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        return createRepository(CreateRepositoryRequest.builder().applyMutation(createRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes a repository in a public registry. If the repository contains images, you must either manually delete all
     * images in the repository or use the <code>force</code> option. This option deletes all images on your behalf
     * before deleting the repository.
     * </p>
     *
     * @param deleteRepositoryRequest
     * @return Result of the DeleteRepository operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws RepositoryNotEmptyException
     *         The specified repository contains images. To delete a repository that contains images, you must force the
     *         deletion with the <code>force</code> parameter.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, RepositoryNotEmptyException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a repository in a public registry. If the repository contains images, you must either manually delete all
     * images in the repository or use the <code>force</code> option. This option deletes all images on your behalf
     * before deleting the repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRepositoryRequest.Builder} to create a request.
     * @return Result of the DeleteRepository operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws RepositoryNotEmptyException
     *         The specified repository contains images. To delete a repository that contains images, you must force the
     *         deletion with the <code>force</code> parameter.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRepositoryResponse deleteRepository(Consumer<DeleteRepositoryRequest.Builder> deleteRepositoryRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryNotEmptyException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return deleteRepository(DeleteRepositoryRequest.builder().applyMutation(deleteRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes the repository policy that's associated with the specified repository.
     * </p>
     *
     * @param deleteRepositoryPolicyRequest
     * @return Result of the DeleteRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws RepositoryPolicyNotFoundException
     *         The specified repository and registry combination doesn't have an associated repository policy.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DeleteRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRepositoryPolicyResponse deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the repository policy that's associated with the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws RepositoryPolicyNotFoundException
     *         The specified repository and registry combination doesn't have an associated repository policy.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DeleteRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRepositoryPolicyResponse deleteRepositoryPolicy(
            Consumer<DeleteRepositoryPolicyRequest.Builder> deleteRepositoryPolicyRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return deleteRepositoryPolicy(DeleteRepositoryPolicyRequest.builder().applyMutation(deleteRepositoryPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the image tag details for a repository in a public registry.
     * </p>
     *
     * @param describeImageTagsRequest
     * @return Result of the DescribeImageTags operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeImageTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageTagsResponse describeImageTags(DescribeImageTagsRequest describeImageTagsRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the image tag details for a repository in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageTagsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeImageTagsRequest#builder()}
     * </p>
     *
     * @param describeImageTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImageTagsRequest.Builder} to create a request.
     * @return Result of the DescribeImageTags operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeImageTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageTagsResponse describeImageTags(Consumer<DescribeImageTagsRequest.Builder> describeImageTagsRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        return describeImageTags(DescribeImageTagsRequest.builder().applyMutation(describeImageTagsRequest).build());
    }

    /**
     * <p>
     * Returns the image tag details for a repository in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImageTags(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsIterable responses = client.describeImageTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsIterable responses = client
     *             .describeImageTagsPaginator(request);
     *     for (software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsIterable responses = client.describeImageTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImageTags(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImageTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeImageTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageTagsIterable describeImageTagsPaginator(DescribeImageTagsRequest describeImageTagsRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the image tag details for a repository in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImageTags(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsIterable responses = client.describeImageTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsIterable responses = client
     *             .describeImageTagsPaginator(request);
     *     for (software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsIterable responses = client.describeImageTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImageTags(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageTagsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeImageTagsRequest#builder()}
     * </p>
     *
     * @param describeImageTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImageTagsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeImageTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageTagsIterable describeImageTagsPaginator(
            Consumer<DescribeImageTagsRequest.Builder> describeImageTagsRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        return describeImageTagsPaginator(DescribeImageTagsRequest.builder().applyMutation(describeImageTagsRequest).build());
    }

    /**
     * <p>
     * Returns metadata that's related to the images in a repository in a public registry.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size. Therefore, it
     * might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.
     * </p>
     * </note>
     *
     * @param describeImagesRequest
     * @return Result of the DescribeImages operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested doesn't exist in the specified repository.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata that's related to the images in a repository in a public registry.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size. Therefore, it
     * might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagesRequest.Builder} to create a request.
     * @return Result of the DescribeImages operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested doesn't exist in the specified repository.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages(Consumer<DescribeImagesRequest.Builder> describeImagesRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return describeImages(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Returns metadata that's related to the images in a repository in a public registry.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size. Therefore, it
     * might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeImages(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesIterable responses = client
     *             .describeImagesPaginator(request);
     *     for (software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest)} operation.</b>
     * </p>
     *
     * @param describeImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested doesn't exist in the specified repository.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesIterable describeImagesPaginator(DescribeImagesRequest describeImagesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata that's related to the images in a repository in a public registry.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size. Therefore, it
     * might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeImages(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesIterable responses = client
     *             .describeImagesPaginator(request);
     *     for (software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested doesn't exist in the specified repository.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesIterable describeImagesPaginator(Consumer<DescribeImagesRequest.Builder> describeImagesRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return describeImagesPaginator(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Returns details for a public registry.
     * </p>
     *
     * @param describeRegistriesRequest
     * @return Result of the DescribeRegistries operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRegistriesResponse describeRegistries(DescribeRegistriesRequest describeRegistriesRequest)
            throws InvalidParameterException, UnsupportedCommandException, ServerException, AwsServiceException,
            SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegistriesRequest#builder()}
     * </p>
     *
     * @param describeRegistriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRegistriesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRegistries operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRegistriesResponse describeRegistries(Consumer<DescribeRegistriesRequest.Builder> describeRegistriesRequest)
            throws InvalidParameterException, UnsupportedCommandException, ServerException, AwsServiceException,
            SdkClientException, EcrPublicException {
        return describeRegistries(DescribeRegistriesRequest.builder().applyMutation(describeRegistriesRequest).build());
    }

    /**
     * <p>
     * Returns details for a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRegistries(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesIterable responses = client.describeRegistriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesIterable responses = client
     *             .describeRegistriesPaginator(request);
     *     for (software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesIterable responses = client.describeRegistriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistries(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRegistriesIterable describeRegistriesPaginator(DescribeRegistriesRequest describeRegistriesRequest)
            throws InvalidParameterException, UnsupportedCommandException, ServerException, AwsServiceException,
            SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRegistries(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesIterable responses = client.describeRegistriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesIterable responses = client
     *             .describeRegistriesPaginator(request);
     *     for (software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesIterable responses = client.describeRegistriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistries(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegistriesRequest#builder()}
     * </p>
     *
     * @param describeRegistriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRegistriesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRegistriesIterable describeRegistriesPaginator(
            Consumer<DescribeRegistriesRequest.Builder> describeRegistriesRequest) throws InvalidParameterException,
            UnsupportedCommandException, ServerException, AwsServiceException, SdkClientException, EcrPublicException {
        return describeRegistriesPaginator(DescribeRegistriesRequest.builder().applyMutation(describeRegistriesRequest).build());
    }

    /**
     * <p>
     * Describes repositories that are in a public registry.
     * </p>
     *
     * @param describeRepositoriesRequest
     * @return Result of the DescribeRepositories operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRepositoriesResponse describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes repositories that are in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRepositoriesRequest#builder()}
     * </p>
     *
     * @param describeRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRepositoriesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRepositories operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRepositoriesResponse describeRepositories(
            Consumer<DescribeRepositoriesRequest.Builder> describeRepositoriesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        return describeRepositories(DescribeRepositoriesRequest.builder().applyMutation(describeRepositoriesRequest).build());
    }

    /**
     * <p>
     * Describes repositories that are in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesIterable responses = client
     *             .describeRepositoriesPaginator(request);
     *     for (software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRepositoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRepositoriesIterable describeRepositoriesPaginator(DescribeRepositoriesRequest describeRepositoriesRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes repositories that are in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesIterable responses = client
     *             .describeRepositoriesPaginator(request);
     *     for (software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRepositoriesRequest#builder()}
     * </p>
     *
     * @param describeRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRepositoriesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRepositoriesIterable describeRepositoriesPaginator(
            Consumer<DescribeRepositoriesRequest.Builder> describeRepositoriesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        return describeRepositoriesPaginator(DescribeRepositoriesRequest.builder().applyMutation(describeRepositoriesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves an authorization token. An authorization token represents your IAM authentication credentials. You can
     * use it to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid
     * for 12 hours. This API requires the <code>ecr-public:GetAuthorizationToken</code> and
     * <code>sts:GetServiceBearerToken</code> permissions.
     * </p>
     *
     * @param getAuthorizationTokenRequest
     * @return Result of the GetAuthorizationToken operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.GetAuthorizationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetAuthorizationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAuthorizationTokenResponse getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest)
            throws ServerException, InvalidParameterException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an authorization token. An authorization token represents your IAM authentication credentials. You can
     * use it to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid
     * for 12 hours. This API requires the <code>ecr-public:GetAuthorizationToken</code> and
     * <code>sts:GetServiceBearerToken</code> permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizationTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetAuthorizationTokenRequest#builder()}
     * </p>
     *
     * @param getAuthorizationTokenRequest
     *        A {@link Consumer} that will call methods on {@link GetAuthorizationTokenRequest.Builder} to create a
     *        request.
     * @return Result of the GetAuthorizationToken operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.GetAuthorizationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetAuthorizationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAuthorizationTokenResponse getAuthorizationToken(
            Consumer<GetAuthorizationTokenRequest.Builder> getAuthorizationTokenRequest) throws ServerException,
            InvalidParameterException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return getAuthorizationToken(GetAuthorizationTokenRequest.builder().applyMutation(getAuthorizationTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves catalog metadata for a public registry.
     * </p>
     *
     * @param getRegistryCatalogDataRequest
     * @return Result of the GetRegistryCatalogData operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.GetRegistryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRegistryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRegistryCatalogDataResponse getRegistryCatalogData(GetRegistryCatalogDataRequest getRegistryCatalogDataRequest)
            throws ServerException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves catalog metadata for a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegistryCatalogDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetRegistryCatalogDataRequest#builder()}
     * </p>
     *
     * @param getRegistryCatalogDataRequest
     *        A {@link Consumer} that will call methods on {@link GetRegistryCatalogDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetRegistryCatalogData operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.GetRegistryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRegistryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRegistryCatalogDataResponse getRegistryCatalogData(
            Consumer<GetRegistryCatalogDataRequest.Builder> getRegistryCatalogDataRequest) throws ServerException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return getRegistryCatalogData(GetRegistryCatalogDataRequest.builder().applyMutation(getRegistryCatalogDataRequest)
                .build());
    }

    /**
     * <p>
     * Retrieve catalog metadata for a repository in a public registry. This metadata is displayed publicly in the
     * Amazon ECR Public Gallery.
     * </p>
     *
     * @param getRepositoryCatalogDataRequest
     * @return Result of the GetRepositoryCatalogData operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryCatalogDataNotFoundException
     *         The repository catalog data doesn't exist.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.GetRepositoryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRepositoryCatalogDataResponse getRepositoryCatalogData(
            GetRepositoryCatalogDataRequest getRepositoryCatalogDataRequest) throws ServerException, InvalidParameterException,
            RepositoryCatalogDataNotFoundException, RepositoryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve catalog metadata for a repository in a public registry. This metadata is displayed publicly in the
     * Amazon ECR Public Gallery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryCatalogDataRequest.Builder} avoiding
     * the need to create one manually via {@link GetRepositoryCatalogDataRequest#builder()}
     * </p>
     *
     * @param getRepositoryCatalogDataRequest
     *        A {@link Consumer} that will call methods on {@link GetRepositoryCatalogDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetRepositoryCatalogData operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryCatalogDataNotFoundException
     *         The repository catalog data doesn't exist.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.GetRepositoryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRepositoryCatalogDataResponse getRepositoryCatalogData(
            Consumer<GetRepositoryCatalogDataRequest.Builder> getRepositoryCatalogDataRequest) throws ServerException,
            InvalidParameterException, RepositoryCatalogDataNotFoundException, RepositoryNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return getRepositoryCatalogData(GetRepositoryCatalogDataRequest.builder().applyMutation(getRepositoryCatalogDataRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the repository policy for the specified repository.
     * </p>
     *
     * @param getRepositoryPolicyRequest
     * @return Result of the GetRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws RepositoryPolicyNotFoundException
     *         The specified repository and registry combination doesn't have an associated repository policy.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.GetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRepositoryPolicyResponse getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the repository policy for the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param getRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws RepositoryPolicyNotFoundException
     *         The specified repository and registry combination doesn't have an associated repository policy.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.GetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRepositoryPolicyResponse getRepositoryPolicy(
            Consumer<GetRepositoryPolicyRequest.Builder> getRepositoryPolicyRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return getRepositoryPolicy(GetRepositoryPolicyRequest.builder().applyMutation(getRepositoryPolicyRequest).build());
    }

    /**
     * <p>
     * Notifies Amazon ECR that you intend to upload an image layer.
     * </p>
     * <p>
     * When an image is pushed, the InitiateLayerUpload API is called once for each image layer that hasn't already been
     * uploaded. Whether an image layer uploads is determined by the BatchCheckLayerAvailability API action.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param initiateLayerUploadRequest
     * @return Result of the InitiateLayerUpload operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.InitiateLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/InitiateLayerUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default InitiateLayerUploadResponse initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, RegistryNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies Amazon ECR that you intend to upload an image layer.
     * </p>
     * <p>
     * When an image is pushed, the InitiateLayerUpload API is called once for each image layer that hasn't already been
     * uploaded. Whether an image layer uploads is determined by the BatchCheckLayerAvailability API action.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateLayerUploadRequest.Builder} avoiding the
     * need to create one manually via {@link InitiateLayerUploadRequest#builder()}
     * </p>
     *
     * @param initiateLayerUploadRequest
     *        A {@link Consumer} that will call methods on {@link InitiateLayerUploadRequest.Builder} to create a
     *        request.
     * @return Result of the InitiateLayerUpload operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.InitiateLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/InitiateLayerUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default InitiateLayerUploadResponse initiateLayerUpload(
            Consumer<InitiateLayerUploadRequest.Builder> initiateLayerUploadRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, RegistryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        return initiateLayerUpload(InitiateLayerUploadRequest.builder().applyMutation(initiateLayerUploadRequest).build());
    }

    /**
     * <p>
     * List the tags for an Amazon ECR Public resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, ServerException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for an Amazon ECR Public resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidParameterException,
            RepositoryNotFoundException, UnsupportedCommandException, ServerException, AwsServiceException, SdkClientException,
            EcrPublicException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates the image manifest and tags that are associated with an image.
     * </p>
     * <p>
     * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or
     * update the image manifest and the tags that are associated with the image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param putImageRequest
     * @return Result of the PutImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws ImageAlreadyExistsException
     *         The specified image has already been pushed, and there were no changes to the manifest or image tag after
     *         the last push.
     * @throws LayersNotFoundException
     *         The specified layers can't be found, or the specified layer isn't valid for this repository.
     * @throws ReferencedImagesNotFoundException
     *         The manifest list is referencing an image that doesn't exist.
     * @throws LimitExceededException
     *         The operation didn't succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.
     * @throws ImageTagAlreadyExistsException
     *         The specified image is tagged with a tag that already exists. The repository is configured for tag
     *         immutability.
     * @throws ImageDigestDoesNotMatchException
     *         The specified image digest doesn't match the digest that Amazon ECR calculated for the image.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.PutImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutImage" target="_top">AWS API
     *      Documentation</a>
     */
    default PutImageResponse putImage(PutImageRequest putImageRequest) throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, ImageAlreadyExistsException, LayersNotFoundException, ReferencedImagesNotFoundException,
            LimitExceededException, ImageTagAlreadyExistsException, ImageDigestDoesNotMatchException, RegistryNotFoundException,
            UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the image manifest and tags that are associated with an image.
     * </p>
     * <p>
     * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or
     * update the image manifest and the tags that are associated with the image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageRequest.Builder} avoiding the need to
     * create one manually via {@link PutImageRequest#builder()}
     * </p>
     *
     * @param putImageRequest
     *        A {@link Consumer} that will call methods on {@link PutImageRequest.Builder} to create a request.
     * @return Result of the PutImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws ImageAlreadyExistsException
     *         The specified image has already been pushed, and there were no changes to the manifest or image tag after
     *         the last push.
     * @throws LayersNotFoundException
     *         The specified layers can't be found, or the specified layer isn't valid for this repository.
     * @throws ReferencedImagesNotFoundException
     *         The manifest list is referencing an image that doesn't exist.
     * @throws LimitExceededException
     *         The operation didn't succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.
     * @throws ImageTagAlreadyExistsException
     *         The specified image is tagged with a tag that already exists. The repository is configured for tag
     *         immutability.
     * @throws ImageDigestDoesNotMatchException
     *         The specified image digest doesn't match the digest that Amazon ECR calculated for the image.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.PutImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutImage" target="_top">AWS API
     *      Documentation</a>
     */
    default PutImageResponse putImage(Consumer<PutImageRequest.Builder> putImageRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, ImageAlreadyExistsException, LayersNotFoundException,
            ReferencedImagesNotFoundException, LimitExceededException, ImageTagAlreadyExistsException,
            ImageDigestDoesNotMatchException, RegistryNotFoundException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        return putImage(PutImageRequest.builder().applyMutation(putImageRequest).build());
    }

    /**
     * <p>
     * Create or update the catalog data for a public registry.
     * </p>
     *
     * @param putRegistryCatalogDataRequest
     * @return Result of the PutRegistryCatalogData operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.PutRegistryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRegistryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRegistryCatalogDataResponse putRegistryCatalogData(PutRegistryCatalogDataRequest putRegistryCatalogDataRequest)
            throws ServerException, InvalidParameterException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create or update the catalog data for a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRegistryCatalogDataRequest.Builder} avoiding the
     * need to create one manually via {@link PutRegistryCatalogDataRequest#builder()}
     * </p>
     *
     * @param putRegistryCatalogDataRequest
     *        A {@link Consumer} that will call methods on {@link PutRegistryCatalogDataRequest.Builder} to create a
     *        request.
     * @return Result of the PutRegistryCatalogData operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.PutRegistryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRegistryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRegistryCatalogDataResponse putRegistryCatalogData(
            Consumer<PutRegistryCatalogDataRequest.Builder> putRegistryCatalogDataRequest) throws ServerException,
            InvalidParameterException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        return putRegistryCatalogData(PutRegistryCatalogDataRequest.builder().applyMutation(putRegistryCatalogDataRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates the catalog data for a repository in a public registry.
     * </p>
     *
     * @param putRepositoryCatalogDataRequest
     * @return Result of the PutRepositoryCatalogData operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.PutRepositoryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRepositoryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRepositoryCatalogDataResponse putRepositoryCatalogData(
            PutRepositoryCatalogDataRequest putRepositoryCatalogDataRequest) throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the catalog data for a repository in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRepositoryCatalogDataRequest.Builder} avoiding
     * the need to create one manually via {@link PutRepositoryCatalogDataRequest#builder()}
     * </p>
     *
     * @param putRepositoryCatalogDataRequest
     *        A {@link Consumer} that will call methods on {@link PutRepositoryCatalogDataRequest.Builder} to create a
     *        request.
     * @return Result of the PutRepositoryCatalogData operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.PutRepositoryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRepositoryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRepositoryCatalogDataResponse putRepositoryCatalogData(
            Consumer<PutRepositoryCatalogDataRequest.Builder> putRepositoryCatalogDataRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        return putRepositoryCatalogData(PutRepositoryCatalogDataRequest.builder().applyMutation(putRepositoryCatalogDataRequest)
                .build());
    }

    /**
     * <p>
     * Applies a repository policy to the specified public repository to control access permissions. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon
     * ECR Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param setRepositoryPolicyRequest
     * @return Result of the SetRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.SetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/SetRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default SetRepositoryPolicyResponse setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a repository policy to the specified public repository to control access permissions. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon
     * ECR Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link SetRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param setRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on {@link SetRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the SetRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.SetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/SetRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default SetRepositoryPolicyResponse setRepositoryPolicy(
            Consumer<SetRepositoryPolicyRequest.Builder> setRepositoryPolicyRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        return setRepositoryPolicy(SetRepositoryPolicyRequest.builder().applyMutation(setRepositoryPolicyRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException,
            InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException, UnsupportedCommandException,
            ServerException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidParameterException, InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException,
            UnsupportedCommandException, ServerException, AwsServiceException, SdkClientException, EcrPublicException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException,
            InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException, UnsupportedCommandException,
            ServerException, AwsServiceException, SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidParameterException, InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException,
            UnsupportedCommandException, ServerException, AwsServiceException, SdkClientException, EcrPublicException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Uploads an image layer part to Amazon ECR.
     * </p>
     * <p>
     * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can
     * be 20971520 bytes (about 20MB). The UploadLayerPart API is called once for each new image layer part.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param uploadLayerPartRequest
     * @return Result of the UploadLayerPart operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidLayerPartException
     *         The layer part size isn't valid, or the first byte specified isn't consecutive to the last byte of a
     *         previous layer part upload.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UploadNotFoundException
     *         The upload can't be found, or the specified upload ID isn't valid for this repository.
     * @throws LimitExceededException
     *         The operation didn't succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.UploadLayerPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UploadLayerPart" target="_top">AWS
     *      API Documentation</a>
     */
    default UploadLayerPartResponse uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) throws ServerException,
            InvalidParameterException, InvalidLayerPartException, RepositoryNotFoundException, UploadNotFoundException,
            LimitExceededException, RegistryNotFoundException, UnsupportedCommandException, AwsServiceException,
            SdkClientException, EcrPublicException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads an image layer part to Amazon ECR.
     * </p>
     * <p>
     * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can
     * be 20971520 bytes (about 20MB). The UploadLayerPart API is called once for each new image layer part.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadLayerPartRequest.Builder} avoiding the need
     * to create one manually via {@link UploadLayerPartRequest#builder()}
     * </p>
     *
     * @param uploadLayerPartRequest
     *        A {@link Consumer} that will call methods on {@link UploadLayerPartRequest.Builder} to create a request.
     * @return Result of the UploadLayerPart operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidLayerPartException
     *         The layer part size isn't valid, or the first byte specified isn't consecutive to the last byte of a
     *         previous layer part upload.
     * @throws RepositoryNotFoundException
     *         The specified repository can't be found. Check the spelling of the specified repository and ensure that
     *         you're performing operations on the correct registry.
     * @throws UploadNotFoundException
     *         The upload can't be found, or the specified upload ID isn't valid for this repository.
     * @throws LimitExceededException
     *         The operation didn't succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.
     * @throws RegistryNotFoundException
     *         The registry doesn't exist.
     * @throws UnsupportedCommandException
     *         The action isn't supported in this Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrPublicException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrPublicClient.UploadLayerPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UploadLayerPart" target="_top">AWS
     *      API Documentation</a>
     */
    default UploadLayerPartResponse uploadLayerPart(Consumer<UploadLayerPartRequest.Builder> uploadLayerPartRequest)
            throws ServerException, InvalidParameterException, InvalidLayerPartException, RepositoryNotFoundException,
            UploadNotFoundException, LimitExceededException, RegistryNotFoundException, UnsupportedCommandException,
            AwsServiceException, SdkClientException, EcrPublicException {
        return uploadLayerPart(UploadLayerPartRequest.builder().applyMutation(uploadLayerPartRequest).build());
    }

    /**
     * Create a {@link EcrPublicClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EcrPublicClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EcrPublicClient}.
     */
    static EcrPublicClientBuilder builder() {
        return new DefaultEcrPublicClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
