/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecrpublic.DefaultEcrPublicBaseClientBuilder;
import software.amazon.awssdk.services.ecrpublic.DefaultEcrPublicClient;
import software.amazon.awssdk.services.ecrpublic.EcrPublicClient;
import software.amazon.awssdk.services.ecrpublic.EcrPublicClientBuilder;
import software.amazon.awssdk.services.ecrpublic.EcrPublicServiceClientConfiguration;
import software.amazon.awssdk.services.ecrpublic.endpoints.EcrPublicEndpointProvider;

@SdkInternalApi
final class DefaultEcrPublicClientBuilder
extends DefaultEcrPublicBaseClientBuilder<EcrPublicClientBuilder, EcrPublicClient>
implements EcrPublicClientBuilder {
    DefaultEcrPublicClientBuilder() {
    }

    @Override
    public DefaultEcrPublicClientBuilder endpointProvider(EcrPublicEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EcrPublicClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEcrPublicClientBuilder.validateClientOptions(clientConfiguration);
        EcrPublicServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEcrPublicClient client = new DefaultEcrPublicClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EcrPublicServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EcrPublicServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

