/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecrpublic.EcrPublicAsyncClient;
import software.amazon.awssdk.services.ecrpublic.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.Registry;

public class DescribeRegistriesPublisher
implements SdkPublisher<DescribeRegistriesResponse> {
    private final EcrPublicAsyncClient client;
    private final DescribeRegistriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRegistriesPublisher(EcrPublicAsyncClient client, DescribeRegistriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRegistriesPublisher(EcrPublicAsyncClient client, DescribeRegistriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRegistriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRegistriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Registry> registries() {
        Function<DescribeRegistriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.registries() != null) {
                return response.registries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRegistriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRegistriesResponseFetcher
    implements AsyncPageFetcher<DescribeRegistriesResponse> {
        private DescribeRegistriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRegistriesResponse> nextPage(DescribeRegistriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistriesPublisher.this.client.describeRegistries(DescribeRegistriesPublisher.this.firstRequest);
            }
            return DescribeRegistriesPublisher.this.client.describeRegistries((DescribeRegistriesRequest)((Object)DescribeRegistriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

