/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsPublisher;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesPublisher;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesPublisher;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesPublisher;

/**
 * Service client for accessing Amazon ECR Public asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <fullname>Amazon Elastic Container Registry Public</fullname>
 * <p>
 * Amazon Elastic Container Registry Public (Amazon ECR Public) is a managed container image registry service. Amazon
 * ECR provides both public and private registries to host your container images. You can use the Docker CLI or your
 * preferred client to push, pull, and manage images. Amazon ECR provides a secure, scalable, and reliable registry for
 * your Docker or Open Container Initiative (OCI) images. Amazon ECR supports public repositories with this API. For
 * information about the Amazon ECR API for private repositories, see <a
 * href="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/Welcome.html">Amazon Elastic Container Registry API
 * Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EcrPublicAsyncClient extends AwsClient {
    String SERVICE_NAME = "ecr-public";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.ecr-public";

    /**
     * <p>
     * Checks the availability of one or more image layers that are within a repository in a public registry. When an
     * image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has
     * been uploaded, then the image layer is skipped.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param batchCheckLayerAvailabilityRequest
     * @return A Java Future containing the result of the BatchCheckLayerAvailability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.BatchCheckLayerAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchCheckLayerAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCheckLayerAvailabilityResponse> batchCheckLayerAvailability(
            BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the availability of one or more image layers that are within a repository in a public registry. When an
     * image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has
     * been uploaded, then the image layer is skipped.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCheckLayerAvailabilityRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCheckLayerAvailabilityRequest#builder()}
     * </p>
     *
     * @param batchCheckLayerAvailabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchCheckLayerAvailability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.BatchCheckLayerAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchCheckLayerAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCheckLayerAvailabilityResponse> batchCheckLayerAvailability(
            Consumer<BatchCheckLayerAvailabilityRequest.Builder> batchCheckLayerAvailabilityRequest) {
        return batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest.builder()
                .applyMutation(batchCheckLayerAvailabilityRequest).build());
    }

    /**
     * <p>
     * Deletes a list of specified images that are within a repository in a public registry. Images are specified with
     * either an <code>imageTag</code> or <code>imageDigest</code>.
     * </p>
     * <p>
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag
     * from an image, the image is deleted from your repository.
     * </p>
     * <p>
     * You can completely delete an image (and all of its tags) by specifying the digest of the image in your request.
     * </p>
     *
     * @param batchDeleteImageRequest
     * @return A Java Future containing the result of the BatchDeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.BatchDeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchDeleteImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteImageResponse> batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a list of specified images that are within a repository in a public registry. Images are specified with
     * either an <code>imageTag</code> or <code>imageDigest</code>.
     * </p>
     * <p>
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag
     * from an image, the image is deleted from your repository.
     * </p>
     * <p>
     * You can completely delete an image (and all of its tags) by specifying the digest of the image in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteImageRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDeleteImageRequest#builder()}
     * </p>
     *
     * @param batchDeleteImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.BatchDeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchDeleteImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteImageResponse> batchDeleteImage(
            Consumer<BatchDeleteImageRequest.Builder> batchDeleteImageRequest) {
        return batchDeleteImage(BatchDeleteImageRequest.builder().applyMutation(batchDeleteImageRequest).build());
    }

    /**
     * <p>
     * Informs Amazon ECR that the image layer upload is complete for a specified public registry, repository name, and
     * upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation
     * purposes.
     * </p>
     * <p>
     * When an image is pushed, the CompleteLayerUpload API is called once for each new image layer to verify that the
     * upload is complete.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param completeLayerUploadRequest
     * @return A Java Future containing the result of the CompleteLayerUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UploadNotFoundException The upload can't be found, or the specified upload ID isn't valid for this
     *         repository.</li>
     *         <li>InvalidLayerException The layer digest calculation performed by Amazon ECR when the image layer
     *         doesn't match the digest specified.</li>
     *         <li>LayerPartTooSmallException Layer parts must be at least 5 MiB in size.</li>
     *         <li>LayerAlreadyExistsException The image layer already exists in the associated repository.</li>
     *         <li>EmptyUploadException The specified layer upload doesn't contain any layer parts.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.CompleteLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CompleteLayerUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CompleteLayerUploadResponse> completeLayerUpload(
            CompleteLayerUploadRequest completeLayerUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Informs Amazon ECR that the image layer upload is complete for a specified public registry, repository name, and
     * upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation
     * purposes.
     * </p>
     * <p>
     * When an image is pushed, the CompleteLayerUpload API is called once for each new image layer to verify that the
     * upload is complete.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteLayerUploadRequest.Builder} avoiding the
     * need to create one manually via {@link CompleteLayerUploadRequest#builder()}
     * </p>
     *
     * @param completeLayerUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CompleteLayerUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UploadNotFoundException The upload can't be found, or the specified upload ID isn't valid for this
     *         repository.</li>
     *         <li>InvalidLayerException The layer digest calculation performed by Amazon ECR when the image layer
     *         doesn't match the digest specified.</li>
     *         <li>LayerPartTooSmallException Layer parts must be at least 5 MiB in size.</li>
     *         <li>LayerAlreadyExistsException The image layer already exists in the associated repository.</li>
     *         <li>EmptyUploadException The specified layer upload doesn't contain any layer parts.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.CompleteLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CompleteLayerUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CompleteLayerUploadResponse> completeLayerUpload(
            Consumer<CompleteLayerUploadRequest.Builder> completeLayerUploadRequest) {
        return completeLayerUpload(CompleteLayerUploadRequest.builder().applyMutation(completeLayerUploadRequest).build());
    }

    /**
     * <p>
     * Creates a repository in a public registry. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in
     * the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param createRepositoryRequest
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryAlreadyExistsException The specified repository already exists in the specified registry.</li>
     *         <li>LimitExceededException The operation didn't succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a repository in a public registry. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in
     * the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRepositoryRequest#builder()}
     * </p>
     *
     * @param createRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryAlreadyExistsException The specified repository already exists in the specified registry.</li>
     *         <li>LimitExceededException The operation didn't succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(
            Consumer<CreateRepositoryRequest.Builder> createRepositoryRequest) {
        return createRepository(CreateRepositoryRequest.builder().applyMutation(createRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes a repository in a public registry. If the repository contains images, you must either manually delete all
     * images in the repository or use the <code>force</code> option. This option deletes all images on your behalf
     * before deleting the repository.
     * </p>
     *
     * @param deleteRepositoryRequest
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>RepositoryNotEmptyException The specified repository contains images. To delete a repository that
     *         contains images, you must force the deletion with the <code>force</code> parameter.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a repository in a public registry. If the repository contains images, you must either manually delete all
     * images in the repository or use the <code>force</code> option. This option deletes all images on your behalf
     * before deleting the repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>RepositoryNotEmptyException The specified repository contains images. To delete a repository that
     *         contains images, you must force the deletion with the <code>force</code> parameter.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(
            Consumer<DeleteRepositoryRequest.Builder> deleteRepositoryRequest) {
        return deleteRepository(DeleteRepositoryRequest.builder().applyMutation(deleteRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes the repository policy that's associated with the specified repository.
     * </p>
     *
     * @param deleteRepositoryPolicyRequest
     * @return A Java Future containing the result of the DeleteRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>RepositoryPolicyNotFoundException The specified repository and registry combination doesn't have an
     *         associated repository policy.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DeleteRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryPolicyResponse> deleteRepositoryPolicy(
            DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the repository policy that's associated with the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>RepositoryPolicyNotFoundException The specified repository and registry combination doesn't have an
     *         associated repository policy.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DeleteRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryPolicyResponse> deleteRepositoryPolicy(
            Consumer<DeleteRepositoryPolicyRequest.Builder> deleteRepositoryPolicyRequest) {
        return deleteRepositoryPolicy(DeleteRepositoryPolicyRequest.builder().applyMutation(deleteRepositoryPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the image tag details for a repository in a public registry.
     * </p>
     *
     * @param describeImageTagsRequest
     * @return A Java Future containing the result of the DescribeImageTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeImageTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeImageTagsResponse> describeImageTags(DescribeImageTagsRequest describeImageTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the image tag details for a repository in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageTagsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeImageTagsRequest#builder()}
     * </p>
     *
     * @param describeImageTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeImageTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeImageTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeImageTagsResponse> describeImageTags(
            Consumer<DescribeImageTagsRequest.Builder> describeImageTagsRequest) {
        return describeImageTags(DescribeImageTagsRequest.builder().applyMutation(describeImageTagsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeImageTags(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsPublisher publisher = client.describeImageTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsPublisher publisher = client.describeImageTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImageTags(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImageTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeImageTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageTagsPublisher describeImageTagsPaginator(DescribeImageTagsRequest describeImageTagsRequest) {
        return new DescribeImageTagsPublisher(this, describeImageTagsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeImageTags(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsPublisher publisher = client.describeImageTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsPublisher publisher = client.describeImageTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImageTags(software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageTagsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeImageTagsRequest#builder()}
     * </p>
     *
     * @param describeImageTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeImageTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageTagsPublisher describeImageTagsPaginator(
            Consumer<DescribeImageTagsRequest.Builder> describeImageTagsRequest) {
        return describeImageTagsPaginator(DescribeImageTagsRequest.builder().applyMutation(describeImageTagsRequest).build());
    }

    /**
     * <p>
     * Returns metadata that's related to the images in a repository in a public registry.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size. Therefore, it
     * might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.
     * </p>
     * </note>
     *
     * @param describeImagesRequest
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested doesn't exist in the specified repository.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImagesResponse> describeImages(DescribeImagesRequest describeImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata that's related to the images in a repository in a public registry.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size. Therefore, it
     * might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested doesn't exist in the specified repository.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImagesResponse> describeImages(Consumer<DescribeImagesRequest.Builder> describeImagesRequest) {
        return describeImages(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeImages(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesPublisher publisher = client.describeImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesPublisher publisher = client.describeImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest)} operation.</b>
     * </p>
     *
     * @param describeImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested doesn't exist in the specified repository.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesPublisher describeImagesPaginator(DescribeImagesRequest describeImagesRequest) {
        return new DescribeImagesPublisher(this, describeImagesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeImages(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesPublisher publisher = client.describeImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesPublisher publisher = client.describeImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested doesn't exist in the specified repository.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesPublisher describeImagesPaginator(Consumer<DescribeImagesRequest.Builder> describeImagesRequest) {
        return describeImagesPaginator(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Returns details for a public registry.
     * </p>
     *
     * @param describeRegistriesRequest
     * @return A Java Future containing the result of the DescribeRegistries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRegistriesResponse> describeRegistries(DescribeRegistriesRequest describeRegistriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegistriesRequest#builder()}
     * </p>
     *
     * @param describeRegistriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRegistries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRegistriesResponse> describeRegistries(
            Consumer<DescribeRegistriesRequest.Builder> describeRegistriesRequest) {
        return describeRegistries(DescribeRegistriesRequest.builder().applyMutation(describeRegistriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistries(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesPublisher publisher = client.describeRegistriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesPublisher publisher = client.describeRegistriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistries(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRegistriesPublisher describeRegistriesPaginator(DescribeRegistriesRequest describeRegistriesRequest) {
        return new DescribeRegistriesPublisher(this, describeRegistriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistries(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesPublisher publisher = client.describeRegistriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesPublisher publisher = client.describeRegistriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistries(software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegistriesRequest#builder()}
     * </p>
     *
     * @param describeRegistriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRegistriesPublisher describeRegistriesPaginator(
            Consumer<DescribeRegistriesRequest.Builder> describeRegistriesRequest) {
        return describeRegistriesPaginator(DescribeRegistriesRequest.builder().applyMutation(describeRegistriesRequest).build());
    }

    /**
     * <p>
     * Describes repositories that are in a public registry.
     * </p>
     *
     * @param describeRepositoriesRequest
     * @return A Java Future containing the result of the DescribeRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRepositoriesResponse> describeRepositories(
            DescribeRepositoriesRequest describeRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes repositories that are in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRepositoriesRequest#builder()}
     * </p>
     *
     * @param describeRepositoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRepositoriesResponse> describeRepositories(
            Consumer<DescribeRepositoriesRequest.Builder> describeRepositoriesRequest) {
        return describeRepositories(DescribeRepositoriesRequest.builder().applyMutation(describeRepositoriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRepositoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRepositoriesPublisher describeRepositoriesPaginator(DescribeRepositoriesRequest describeRepositoriesRequest) {
        return new DescribeRepositoriesPublisher(this, describeRepositoriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRepositoriesRequest#builder()}
     * </p>
     *
     * @param describeRepositoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRepositoriesPublisher describeRepositoriesPaginator(
            Consumer<DescribeRepositoriesRequest.Builder> describeRepositoriesRequest) {
        return describeRepositoriesPaginator(DescribeRepositoriesRequest.builder().applyMutation(describeRepositoriesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves an authorization token. An authorization token represents your IAM authentication credentials. You can
     * use it to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid
     * for 12 hours. This API requires the <code>ecr-public:GetAuthorizationToken</code> and
     * <code>sts:GetServiceBearerToken</code> permissions.
     * </p>
     *
     * @param getAuthorizationTokenRequest
     * @return A Java Future containing the result of the GetAuthorizationToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.GetAuthorizationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetAuthorizationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAuthorizationTokenResponse> getAuthorizationToken(
            GetAuthorizationTokenRequest getAuthorizationTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an authorization token. An authorization token represents your IAM authentication credentials. You can
     * use it to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid
     * for 12 hours. This API requires the <code>ecr-public:GetAuthorizationToken</code> and
     * <code>sts:GetServiceBearerToken</code> permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizationTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetAuthorizationTokenRequest#builder()}
     * </p>
     *
     * @param getAuthorizationTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAuthorizationToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.GetAuthorizationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetAuthorizationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAuthorizationTokenResponse> getAuthorizationToken(
            Consumer<GetAuthorizationTokenRequest.Builder> getAuthorizationTokenRequest) {
        return getAuthorizationToken(GetAuthorizationTokenRequest.builder().applyMutation(getAuthorizationTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves catalog metadata for a public registry.
     * </p>
     *
     * @param getRegistryCatalogDataRequest
     * @return A Java Future containing the result of the GetRegistryCatalogData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.GetRegistryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRegistryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRegistryCatalogDataResponse> getRegistryCatalogData(
            GetRegistryCatalogDataRequest getRegistryCatalogDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves catalog metadata for a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegistryCatalogDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetRegistryCatalogDataRequest#builder()}
     * </p>
     *
     * @param getRegistryCatalogDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRegistryCatalogData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.GetRegistryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRegistryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRegistryCatalogDataResponse> getRegistryCatalogData(
            Consumer<GetRegistryCatalogDataRequest.Builder> getRegistryCatalogDataRequest) {
        return getRegistryCatalogData(GetRegistryCatalogDataRequest.builder().applyMutation(getRegistryCatalogDataRequest)
                .build());
    }

    /**
     * <p>
     * Retrieve catalog metadata for a repository in a public registry. This metadata is displayed publicly in the
     * Amazon ECR Public Gallery.
     * </p>
     *
     * @param getRepositoryCatalogDataRequest
     * @return A Java Future containing the result of the GetRepositoryCatalogData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryCatalogDataNotFoundException The repository catalog data doesn't exist.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.GetRepositoryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryCatalogDataResponse> getRepositoryCatalogData(
            GetRepositoryCatalogDataRequest getRepositoryCatalogDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve catalog metadata for a repository in a public registry. This metadata is displayed publicly in the
     * Amazon ECR Public Gallery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryCatalogDataRequest.Builder} avoiding
     * the need to create one manually via {@link GetRepositoryCatalogDataRequest#builder()}
     * </p>
     *
     * @param getRepositoryCatalogDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetRepositoryCatalogData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryCatalogDataNotFoundException The repository catalog data doesn't exist.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.GetRepositoryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryCatalogDataResponse> getRepositoryCatalogData(
            Consumer<GetRepositoryCatalogDataRequest.Builder> getRepositoryCatalogDataRequest) {
        return getRepositoryCatalogData(GetRepositoryCatalogDataRequest.builder().applyMutation(getRepositoryCatalogDataRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the repository policy for the specified repository.
     * </p>
     *
     * @param getRepositoryPolicyRequest
     * @return A Java Future containing the result of the GetRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>RepositoryPolicyNotFoundException The specified repository and registry combination doesn't have an
     *         associated repository policy.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.GetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryPolicyResponse> getRepositoryPolicy(
            GetRepositoryPolicyRequest getRepositoryPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the repository policy for the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param getRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>RepositoryPolicyNotFoundException The specified repository and registry combination doesn't have an
     *         associated repository policy.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.GetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryPolicyResponse> getRepositoryPolicy(
            Consumer<GetRepositoryPolicyRequest.Builder> getRepositoryPolicyRequest) {
        return getRepositoryPolicy(GetRepositoryPolicyRequest.builder().applyMutation(getRepositoryPolicyRequest).build());
    }

    /**
     * <p>
     * Notifies Amazon ECR that you intend to upload an image layer.
     * </p>
     * <p>
     * When an image is pushed, the InitiateLayerUpload API is called once for each image layer that hasn't already been
     * uploaded. Whether an image layer uploads is determined by the BatchCheckLayerAvailability API action.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param initiateLayerUploadRequest
     * @return A Java Future containing the result of the InitiateLayerUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.InitiateLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/InitiateLayerUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InitiateLayerUploadResponse> initiateLayerUpload(
            InitiateLayerUploadRequest initiateLayerUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies Amazon ECR that you intend to upload an image layer.
     * </p>
     * <p>
     * When an image is pushed, the InitiateLayerUpload API is called once for each image layer that hasn't already been
     * uploaded. Whether an image layer uploads is determined by the BatchCheckLayerAvailability API action.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateLayerUploadRequest.Builder} avoiding the
     * need to create one manually via {@link InitiateLayerUploadRequest#builder()}
     * </p>
     *
     * @param initiateLayerUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InitiateLayerUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.InitiateLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/InitiateLayerUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InitiateLayerUploadResponse> initiateLayerUpload(
            Consumer<InitiateLayerUploadRequest.Builder> initiateLayerUploadRequest) {
        return initiateLayerUpload(InitiateLayerUploadRequest.builder().applyMutation(initiateLayerUploadRequest).build());
    }

    /**
     * <p>
     * List the tags for an Amazon ECR Public resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for an Amazon ECR Public resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates the image manifest and tags that are associated with an image.
     * </p>
     * <p>
     * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or
     * update the image manifest and the tags that are associated with the image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param putImageRequest
     * @return A Java Future containing the result of the PutImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>ImageAlreadyExistsException The specified image has already been pushed, and there were no changes to
     *         the manifest or image tag after the last push.</li>
     *         <li>LayersNotFoundException The specified layers can't be found, or the specified layer isn't valid for
     *         this repository.</li>
     *         <li>ReferencedImagesNotFoundException The manifest list is referencing an image that doesn't exist.</li>
     *         <li>LimitExceededException The operation didn't succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ImageTagAlreadyExistsException The specified image is tagged with a tag that already exists. The
     *         repository is configured for tag immutability.</li>
     *         <li>ImageDigestDoesNotMatchException The specified image digest doesn't match the digest that Amazon ECR
     *         calculated for the image.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.PutImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutImageResponse> putImage(PutImageRequest putImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the image manifest and tags that are associated with an image.
     * </p>
     * <p>
     * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or
     * update the image manifest and the tags that are associated with the image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageRequest.Builder} avoiding the need to
     * create one manually via {@link PutImageRequest#builder()}
     * </p>
     *
     * @param putImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.PutImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>ImageAlreadyExistsException The specified image has already been pushed, and there were no changes to
     *         the manifest or image tag after the last push.</li>
     *         <li>LayersNotFoundException The specified layers can't be found, or the specified layer isn't valid for
     *         this repository.</li>
     *         <li>ReferencedImagesNotFoundException The manifest list is referencing an image that doesn't exist.</li>
     *         <li>LimitExceededException The operation didn't succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ImageTagAlreadyExistsException The specified image is tagged with a tag that already exists. The
     *         repository is configured for tag immutability.</li>
     *         <li>ImageDigestDoesNotMatchException The specified image digest doesn't match the digest that Amazon ECR
     *         calculated for the image.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.PutImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutImageResponse> putImage(Consumer<PutImageRequest.Builder> putImageRequest) {
        return putImage(PutImageRequest.builder().applyMutation(putImageRequest).build());
    }

    /**
     * <p>
     * Create or update the catalog data for a public registry.
     * </p>
     *
     * @param putRegistryCatalogDataRequest
     * @return A Java Future containing the result of the PutRegistryCatalogData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.PutRegistryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRegistryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRegistryCatalogDataResponse> putRegistryCatalogData(
            PutRegistryCatalogDataRequest putRegistryCatalogDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create or update the catalog data for a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRegistryCatalogDataRequest.Builder} avoiding the
     * need to create one manually via {@link PutRegistryCatalogDataRequest#builder()}
     * </p>
     *
     * @param putRegistryCatalogDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutRegistryCatalogData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.PutRegistryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRegistryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRegistryCatalogDataResponse> putRegistryCatalogData(
            Consumer<PutRegistryCatalogDataRequest.Builder> putRegistryCatalogDataRequest) {
        return putRegistryCatalogData(PutRegistryCatalogDataRequest.builder().applyMutation(putRegistryCatalogDataRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates the catalog data for a repository in a public registry.
     * </p>
     *
     * @param putRepositoryCatalogDataRequest
     * @return A Java Future containing the result of the PutRepositoryCatalogData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.PutRepositoryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRepositoryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRepositoryCatalogDataResponse> putRepositoryCatalogData(
            PutRepositoryCatalogDataRequest putRepositoryCatalogDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the catalog data for a repository in a public registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRepositoryCatalogDataRequest.Builder} avoiding
     * the need to create one manually via {@link PutRepositoryCatalogDataRequest#builder()}
     * </p>
     *
     * @param putRepositoryCatalogDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutRepositoryCatalogData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.PutRepositoryCatalogData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRepositoryCatalogData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRepositoryCatalogDataResponse> putRepositoryCatalogData(
            Consumer<PutRepositoryCatalogDataRequest.Builder> putRepositoryCatalogDataRequest) {
        return putRepositoryCatalogData(PutRepositoryCatalogDataRequest.builder().applyMutation(putRepositoryCatalogDataRequest)
                .build());
    }

    /**
     * <p>
     * Applies a repository policy to the specified public repository to control access permissions. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon
     * ECR Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param setRepositoryPolicyRequest
     * @return A Java Future containing the result of the SetRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.SetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/SetRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetRepositoryPolicyResponse> setRepositoryPolicy(
            SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a repository policy to the specified public repository to control access permissions. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon
     * ECR Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link SetRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param setRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.SetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/SetRepositoryPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetRepositoryPolicyResponse> setRepositoryPolicy(
            Consumer<SetRepositoryPolicyRequest.Builder> setRepositoryPolicyRequest) {
        return setRepositoryPolicy(SetRepositoryPolicyRequest.builder().applyMutation(setRepositoryPolicyRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Uploads an image layer part to Amazon ECR.
     * </p>
     * <p>
     * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can
     * be 20971520 bytes (about 20MB). The UploadLayerPart API is called once for each new image layer part.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param uploadLayerPartRequest
     * @return A Java Future containing the result of the UploadLayerPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidLayerPartException The layer part size isn't valid, or the first byte specified isn't
     *         consecutive to the last byte of a previous layer part upload.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UploadNotFoundException The upload can't be found, or the specified upload ID isn't valid for this
     *         repository.</li>
     *         <li>LimitExceededException The operation didn't succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.UploadLayerPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UploadLayerPart" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UploadLayerPartResponse> uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads an image layer part to Amazon ECR.
     * </p>
     * <p>
     * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can
     * be 20971520 bytes (about 20MB). The UploadLayerPart API is called once for each new image layer part.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadLayerPartRequest.Builder} avoiding the need
     * to create one manually via {@link UploadLayerPartRequest#builder()}
     * </p>
     *
     * @param uploadLayerPartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UploadLayerPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidLayerPartException The layer part size isn't valid, or the first byte specified isn't
     *         consecutive to the last byte of a previous layer part upload.</li>
     *         <li>RepositoryNotFoundException The specified repository can't be found. Check the spelling of the
     *         specified repository and ensure that you're performing operations on the correct registry.</li>
     *         <li>UploadNotFoundException The upload can't be found, or the specified upload ID isn't valid for this
     *         repository.</li>
     *         <li>LimitExceededException The operation didn't succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service
     *         Quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>RegistryNotFoundException The registry doesn't exist.</li>
     *         <li>UnsupportedCommandException The action isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrPublicException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EcrPublicAsyncClient.UploadLayerPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UploadLayerPart" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UploadLayerPartResponse> uploadLayerPart(
            Consumer<UploadLayerPartRequest.Builder> uploadLayerPartRequest) {
        return uploadLayerPart(UploadLayerPartRequest.builder().applyMutation(uploadLayerPartRequest).build());
    }

    @Override
    default EcrPublicServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link EcrPublicAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EcrPublicAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EcrPublicAsyncClient}.
     */
    static EcrPublicAsyncClientBuilder builder() {
        return new DefaultEcrPublicAsyncClientBuilder();
    }
}
