/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRegistriesResponse extends EcrPublicResponse implements
        ToCopyableBuilder<DescribeRegistriesResponse.Builder, DescribeRegistriesResponse> {
    private static final SdkField<List<Registry>> REGISTRIES_FIELD = SdkField
            .<List<Registry>> builder(MarshallingType.LIST)
            .memberName("registries")
            .getter(getter(DescribeRegistriesResponse::registries))
            .setter(setter(Builder::registries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Registry> builder(MarshallingType.SDK_POJO)
                                            .constructor(Registry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeRegistriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Registry> registries;

    private final String nextToken;

    private DescribeRegistriesResponse(BuilderImpl builder) {
        super(builder);
        this.registries = builder.registries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Registries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegistries() {
        return registries != null && !(registries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains the details for a public registry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistries} method.
     * </p>
     * 
     * @return An object that contains the details for a public registry.
     */
    public final List<Registry> registries() {
        return registries;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. If the results
     * of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, you can use this value to retrieve
     * the next page of results. If there are no more results, this value is <code>null</code>.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. If the
     *         results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, you can use this
     *         value to retrieve the next page of results. If there are no more results, this value is <code>null</code>
     *         .
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistries() ? registries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistriesResponse)) {
            return false;
        }
        DescribeRegistriesResponse other = (DescribeRegistriesResponse) obj;
        return hasRegistries() == other.hasRegistries() && Objects.equals(registries(), other.registries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRegistriesResponse").add("Registries", hasRegistries() ? registries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registries":
            return Optional.ofNullable(clazz.cast(registries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registries", REGISTRIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistriesResponse, T> g) {
        return obj -> g.apply((DescribeRegistriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRegistriesResponse> {
        /**
         * <p>
         * An object that contains the details for a public registry.
         * </p>
         * 
         * @param registries
         *        An object that contains the details for a public registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registries(Collection<Registry> registries);

        /**
         * <p>
         * An object that contains the details for a public registry.
         * </p>
         * 
         * @param registries
         *        An object that contains the details for a public registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registries(Registry... registries);

        /**
         * <p>
         * An object that contains the details for a public registry.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecrpublic.model.Registry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecrpublic.model.Registry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecrpublic.model.Registry.Builder#build()} is called immediately and
         * its result is passed to {@link #registries(List<Registry>)}.
         * 
         * @param registries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecrpublic.model.Registry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registries(java.util.Collection<Registry>)
         */
        Builder registries(Consumer<Registry.Builder>... registries);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. If the
         * results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, you can use this value
         * to retrieve the next page of results. If there are no more results, this value is <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. If
         *        the results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, you can use
         *        this value to retrieve the next page of results. If there are no more results, this value is
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcrPublicResponse.BuilderImpl implements Builder {
        private List<Registry> registries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistriesResponse model) {
            super(model);
            registries(model.registries);
            nextToken(model.nextToken);
        }

        public final List<Registry.Builder> getRegistries() {
            List<Registry.Builder> result = RegistryListCopier.copyToBuilder(this.registries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistries(Collection<Registry.BuilderImpl> registries) {
            this.registries = RegistryListCopier.copyFromBuilder(registries);
        }

        @Override
        public final Builder registries(Collection<Registry> registries) {
            this.registries = RegistryListCopier.copy(registries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Registry... registries) {
            registries(Arrays.asList(registries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Consumer<Registry.Builder>... registries) {
            registries(Stream.of(registries).map(c -> Registry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistriesResponse build() {
            return new DescribeRegistriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
