/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ecrpublic.EcrPublicAsyncClient;
import software.amazon.awssdk.services.ecrpublic.EcrPublicServiceClientConfiguration;
import software.amazon.awssdk.services.ecrpublic.internal.EcrPublicServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicException;
import software.amazon.awssdk.services.ecrpublic.model.EmptyUploadException;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.ImageDigestDoesNotMatchException;
import software.amazon.awssdk.services.ecrpublic.model.ImageNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.ImageTagAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.InvalidLayerException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidLayerPartException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidParameterException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidTagParameterException;
import software.amazon.awssdk.services.ecrpublic.model.LayerAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.LayerPartTooSmallException;
import software.amazon.awssdk.services.ecrpublic.model.LayersNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.LimitExceededException;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.ReferencedImagesNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RegistryNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryCatalogDataNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryNotEmptyException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryPolicyNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.ServerException;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.TooManyTagsException;
import software.amazon.awssdk.services.ecrpublic.model.UnsupportedCommandException;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecrpublic.model.UploadNotFoundException;
import software.amazon.awssdk.services.ecrpublic.transform.BatchCheckLayerAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.BatchDeleteImageRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.CompleteLayerUploadRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DeleteRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeImageTagsRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeRegistriesRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetAuthorizationTokenRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetRegistryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetRepositoryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.InitiateLayerUploadRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.PutImageRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.PutRegistryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.PutRepositoryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.SetRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.UploadLayerPartRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultEcrPublicAsyncClient
implements EcrPublicAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultEcrPublicAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEcrPublicAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"ECR_PUBLIC#2.31.78").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<BatchCheckLayerAvailabilityResponse> batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchCheckLayerAvailabilityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, batchCheckLayerAvailabilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCheckLayerAvailability");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCheckLayerAvailabilityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCheckLayerAvailability").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchCheckLayerAvailabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchCheckLayerAvailabilityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$batchCheckLayerAvailability$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$batchCheckLayerAvailability$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeleteImageResponse> batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, batchDeleteImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteImageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDeleteImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDeleteImageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$batchDeleteImage$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$batchDeleteImage$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CompleteLayerUploadResponse> completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)completeLayerUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, completeLayerUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CompleteLayerUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CompleteLayerUploadResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteLayerUpload").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CompleteLayerUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)completeLayerUploadRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$completeLayerUpload$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$completeLayerUpload$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, createRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRepositoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRepository").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$createRepository$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$createRepository$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepository").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$deleteRepository$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$deleteRepository$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRepositoryPolicyResponse> deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRepositoryPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRepositoryPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRepositoryPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepositoryPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRepositoryPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRepositoryPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$deleteRepositoryPolicy$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$deleteRepositoryPolicy$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeImageTagsResponse> describeImageTags(DescribeImageTagsRequest describeImageTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImageTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, describeImageTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImageTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImageTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImageTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeImageTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeImageTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$describeImageTags$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$describeImageTags$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeImagesResponse> describeImages(DescribeImagesRequest describeImagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, describeImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeImagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$describeImages$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$describeImages$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRegistriesResponse> describeRegistries(DescribeRegistriesRequest describeRegistriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRegistriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, describeRegistriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRegistries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRegistriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRegistries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRegistriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRegistriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$describeRegistries$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$describeRegistries$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRepositoriesResponse> describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRepositoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, describeRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRepositoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRepositories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$describeRepositories$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$describeRepositories$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAuthorizationTokenResponse> getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAuthorizationTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, getAuthorizationTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAuthorizationToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAuthorizationTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAuthorizationToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAuthorizationTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAuthorizationTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$getAuthorizationToken$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$getAuthorizationToken$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRegistryCatalogDataResponse> getRegistryCatalogData(GetRegistryCatalogDataRequest getRegistryCatalogDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRegistryCatalogDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, getRegistryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRegistryCatalogData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRegistryCatalogDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRegistryCatalogData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRegistryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRegistryCatalogDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$getRegistryCatalogData$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$getRegistryCatalogData$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRepositoryCatalogDataResponse> getRepositoryCatalogData(GetRepositoryCatalogDataRequest getRepositoryCatalogDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRepositoryCatalogDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, getRepositoryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositoryCatalogData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryCatalogDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryCatalogData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRepositoryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRepositoryCatalogDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$getRepositoryCatalogData$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$getRepositoryCatalogData$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRepositoryPolicyResponse> getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRepositoryPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, getRepositoryPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositoryPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRepositoryPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRepositoryPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$getRepositoryPolicy$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$getRepositoryPolicy$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InitiateLayerUploadResponse> initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)initiateLayerUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, initiateLayerUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitiateLayerUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateLayerUploadResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateLayerUpload").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new InitiateLayerUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)initiateLayerUploadRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$initiateLayerUpload$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$initiateLayerUpload$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$listTagsForResource$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$listTagsForResource$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutImageResponse> putImage(PutImageRequest putImageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, putImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutImageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putImageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$putImage$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$putImage$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutRegistryCatalogDataResponse> putRegistryCatalogData(PutRegistryCatalogDataRequest putRegistryCatalogDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRegistryCatalogDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, putRegistryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRegistryCatalogData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRegistryCatalogDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRegistryCatalogData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutRegistryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putRegistryCatalogDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$putRegistryCatalogData$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$putRegistryCatalogData$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutRepositoryCatalogDataResponse> putRepositoryCatalogData(PutRepositoryCatalogDataRequest putRepositoryCatalogDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRepositoryCatalogDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, putRepositoryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRepositoryCatalogData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRepositoryCatalogDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRepositoryCatalogData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutRepositoryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putRepositoryCatalogDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$putRepositoryCatalogData$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$putRepositoryCatalogData$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetRepositoryPolicyResponse> setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setRepositoryPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, setRepositoryPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetRepositoryPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetRepositoryPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetRepositoryPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetRepositoryPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setRepositoryPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$setRepositoryPolicy$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$setRepositoryPolicy$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$tagResource$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$tagResource$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$untagResource$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$untagResource$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UploadLayerPartResponse> uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)uploadLayerPartRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(clientConfiguration, uploadLayerPartRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UploadLayerPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UploadLayerPartResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnsupportedCommandException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "LayerPartTooSmallException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                    }
                    case "InvalidLayerPartException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                    }
                    case "ImageTagAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "RepositoryNotEmptyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                    }
                    case "LayerAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                    }
                    case "ImageDigestDoesNotMatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                    }
                    case "RegistryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                    }
                    case "EmptyUploadException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "ImageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                    }
                    case "RepositoryCatalogDataNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                    }
                    case "LayersNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                    }
                    case "ReferencedImagesNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                    }
                    case "InvalidLayerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                    }
                    case "RepositoryNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                    }
                    case "RepositoryAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                    }
                    case "RepositoryPolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                    }
                    case "ImageAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UploadNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadLayerPart").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UploadLayerPartRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)uploadLayerPartRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$uploadLayerPart$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$uploadLayerPart$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final EcrPublicServiceClientConfiguration serviceClientConfiguration() {
        return new EcrPublicServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "ecr-public";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EcrPublicException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        EcrPublicServiceClientConfigurationBuilder serviceConfigBuilder = new EcrPublicServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$uploadLayerPart$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$uploadLayerPart$90(List metricPublishers, MetricCollector apiCallMetricCollector, UploadLayerPartResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$86(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$82(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setRepositoryPolicy$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setRepositoryPolicy$78(List metricPublishers, MetricCollector apiCallMetricCollector, SetRepositoryPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putRepositoryCatalogData$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRepositoryCatalogData$74(List metricPublishers, MetricCollector apiCallMetricCollector, PutRepositoryCatalogDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putRegistryCatalogData$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRegistryCatalogData$70(List metricPublishers, MetricCollector apiCallMetricCollector, PutRegistryCatalogDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putImage$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putImage$66(List metricPublishers, MetricCollector apiCallMetricCollector, PutImageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$62(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$initiateLayerUpload$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initiateLayerUpload$58(List metricPublishers, MetricCollector apiCallMetricCollector, InitiateLayerUploadResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRepositoryPolicy$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositoryPolicy$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetRepositoryPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRepositoryCatalogData$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositoryCatalogData$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetRepositoryCatalogDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRegistryCatalogData$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRegistryCatalogData$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetRegistryCatalogDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAuthorizationToken$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAuthorizationToken$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetAuthorizationTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRepositories$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRepositories$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRepositoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRegistries$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRegistries$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRegistriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeImages$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImages$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeImagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeImageTags$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImageTags$26(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeImageTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRepositoryPolicy$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRepositoryPolicy$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRepositoryPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRepository$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRepository$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRepository$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRepository$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$completeLayerUpload$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$completeLayerUpload$10(List metricPublishers, MetricCollector apiCallMetricCollector, CompleteLayerUploadResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDeleteImage$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteImage$6(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDeleteImageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchCheckLayerAvailability$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCheckLayerAvailability$2(List metricPublishers, MetricCollector apiCallMetricCollector, BatchCheckLayerAvailabilityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

