/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompleteLayerUploadRequest extends EcrPublicRequest implements
        ToCopyableBuilder<CompleteLayerUploadRequest.Builder, CompleteLayerUploadRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(CompleteLayerUploadRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(CompleteLayerUploadRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(CompleteLayerUploadRequest::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<List<String>> LAYER_DIGESTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("layerDigests")
            .getter(getter(CompleteLayerUploadRequest::layerDigests))
            .setter(setter(Builder::layerDigests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerDigests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, UPLOAD_ID_FIELD, LAYER_DIGESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registryId;

    private final String repositoryName;

    private final String uploadId;

    private final List<String> layerDigests;

    private CompleteLayerUploadRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.layerDigests = builder.layerDigests;
    }

    /**
     * <p>
     * The Amazon Web Services account ID, or registry alias, associated with the registry where layers are uploaded. If
     * you do not specify a registry, the default public registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID, or registry alias, associated with the registry where layers are
     *         uploaded. If you do not specify a registry, the default public registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository in a public registry to associate with the image layer.
     * </p>
     * 
     * @return The name of the repository in a public registry to associate with the image layer.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the image layer.
     * </p>
     * 
     * @return The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the image layer.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LayerDigests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLayerDigests() {
        return layerDigests != null && !(layerDigests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>sha256</code> digest of the image layer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayerDigests} method.
     * </p>
     * 
     * @return The <code>sha256</code> digest of the image layer.
     */
    public final List<String> layerDigests() {
        return layerDigests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLayerDigests() ? layerDigests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteLayerUploadRequest)) {
            return false;
        }
        CompleteLayerUploadRequest other = (CompleteLayerUploadRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(uploadId(), other.uploadId()) && hasLayerDigests() == other.hasLayerDigests()
                && Objects.equals(layerDigests(), other.layerDigests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompleteLayerUploadRequest").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("UploadId", uploadId())
                .add("LayerDigests", hasLayerDigests() ? layerDigests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "layerDigests":
            return Optional.ofNullable(clazz.cast(layerDigests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("layerDigests", LAYER_DIGESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompleteLayerUploadRequest, T> g) {
        return obj -> g.apply((CompleteLayerUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrPublicRequest.Builder, SdkPojo, CopyableBuilder<Builder, CompleteLayerUploadRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID, or registry alias, associated with the registry where layers are
         * uploaded. If you do not specify a registry, the default public registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID, or registry alias, associated with the registry where layers are
         *        uploaded. If you do not specify a registry, the default public registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository in a public registry to associate with the image layer.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository in a public registry to associate with the image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the image layer.
         * </p>
         * 
         * @param uploadId
         *        The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The <code>sha256</code> digest of the image layer.
         * </p>
         * 
         * @param layerDigests
         *        The <code>sha256</code> digest of the image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerDigests(Collection<String> layerDigests);

        /**
         * <p>
         * The <code>sha256</code> digest of the image layer.
         * </p>
         * 
         * @param layerDigests
         *        The <code>sha256</code> digest of the image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerDigests(String... layerDigests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrPublicRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String uploadId;

        private List<String> layerDigests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteLayerUploadRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            uploadId(model.uploadId);
            layerDigests(model.layerDigests);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final Collection<String> getLayerDigests() {
            if (layerDigests instanceof SdkAutoConstructList) {
                return null;
            }
            return layerDigests;
        }

        public final void setLayerDigests(Collection<String> layerDigests) {
            this.layerDigests = LayerDigestListCopier.copy(layerDigests);
        }

        @Override
        public final Builder layerDigests(Collection<String> layerDigests) {
            this.layerDigests = LayerDigestListCopier.copy(layerDigests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerDigests(String... layerDigests) {
            layerDigests(Arrays.asList(layerDigests));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteLayerUploadRequest build() {
            return new CompleteLayerUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
