/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRepositoryRequest extends EcrPublicRequest implements
        ToCopyableBuilder<CreateRepositoryRequest.Builder, CreateRepositoryRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(CreateRepositoryRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<RepositoryCatalogDataInput> CATALOG_DATA_FIELD = SdkField
            .<RepositoryCatalogDataInput> builder(MarshallingType.SDK_POJO).memberName("catalogData")
            .getter(getter(CreateRepositoryRequest::catalogData)).setter(setter(Builder::catalogData))
            .constructor(RepositoryCatalogDataInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogData").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateRepositoryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            CATALOG_DATA_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String repositoryName;

    private final RepositoryCatalogDataInput catalogData;

    private final List<Tag> tags;

    private CreateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.catalogData = builder.catalogData;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery. The repository name
     * can be specified on its own (for example <code>nginx-web-app</code>) or prepended with a namespace to group the
     * repository into a category (for example <code>project-a/nginx-web-app</code>).
     * </p>
     * 
     * @return The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery. The
     *         repository name can be specified on its own (for example <code>nginx-web-app</code>) or prepended with a
     *         namespace to group the repository into a category (for example <code>project-a/nginx-web-app</code>).
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
     * </p>
     * 
     * @return The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
     */
    public final RepositoryCatalogDataInput catalogData() {
        return catalogData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to each repository to help categorize and organize your repositories. Each tag
     * consists of a key and an optional value. You define both of them. Tag keys can have a maximum character length of
     * 128 characters, and tag values can have a maximum length of 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to each repository to help categorize and organize your repositories. Each
     *         tag consists of a key and an optional value. You define both of them. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(catalogData());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(catalogData(), other.catalogData())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRepositoryRequest").add("RepositoryName", repositoryName())
                .add("CatalogData", catalogData()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "catalogData":
            return Optional.ofNullable(clazz.cast(catalogData()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("catalogData", CATALOG_DATA_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryRequest, T> g) {
        return obj -> g.apply((CreateRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrPublicRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRepositoryRequest> {
        /**
         * <p>
         * The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery. The repository
         * name can be specified on its own (for example <code>nginx-web-app</code>) or prepended with a namespace to
         * group the repository into a category (for example <code>project-a/nginx-web-app</code>).
         * </p>
         * 
         * @param repositoryName
         *        The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery. The
         *        repository name can be specified on its own (for example <code>nginx-web-app</code>) or prepended with
         *        a namespace to group the repository into a category (for example <code>project-a/nginx-web-app</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
         * </p>
         * 
         * @param catalogData
         *        The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogData(RepositoryCatalogDataInput catalogData);

        /**
         * <p>
         * The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryCatalogDataInput.Builder}
         * avoiding the need to create one manually via {@link RepositoryCatalogDataInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepositoryCatalogDataInput.Builder#build()} is called immediately
         * and its result is passed to {@link #catalogData(RepositoryCatalogDataInput)}.
         * 
         * @param catalogData
         *        a consumer that will call methods on {@link RepositoryCatalogDataInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogData(RepositoryCatalogDataInput)
         */
        default Builder catalogData(Consumer<RepositoryCatalogDataInput.Builder> catalogData) {
            return catalogData(RepositoryCatalogDataInput.builder().applyMutation(catalogData).build());
        }

        /**
         * <p>
         * The metadata that you apply to each repository to help categorize and organize your repositories. Each tag
         * consists of a key and an optional value. You define both of them. Tag keys can have a maximum character
         * length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to each repository to help categorize and organize your repositories. Each
         *        tag consists of a key and an optional value. You define both of them. Tag keys can have a maximum
         *        character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to each repository to help categorize and organize your repositories. Each tag
         * consists of a key and an optional value. You define both of them. Tag keys can have a maximum character
         * length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to each repository to help categorize and organize your repositories. Each
         *        tag consists of a key and an optional value. You define both of them. Tag keys can have a maximum
         *        character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to each repository to help categorize and organize your repositories. Each tag
         * consists of a key and an optional value. You define both of them. Tag keys can have a maximum character
         * length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecrpublic.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ecrpublic.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecrpublic.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecrpublic.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrPublicRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private RepositoryCatalogDataInput catalogData;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            catalogData(model.catalogData);
            tags(model.tags);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final RepositoryCatalogDataInput.Builder getCatalogData() {
            return catalogData != null ? catalogData.toBuilder() : null;
        }

        public final void setCatalogData(RepositoryCatalogDataInput.BuilderImpl catalogData) {
            this.catalogData = catalogData != null ? catalogData.build() : null;
        }

        @Override
        public final Builder catalogData(RepositoryCatalogDataInput catalogData) {
            this.catalogData = catalogData;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
