/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRegistryCatalogDataResponse extends EcrPublicResponse implements
        ToCopyableBuilder<GetRegistryCatalogDataResponse.Builder, GetRegistryCatalogDataResponse> {
    private static final SdkField<RegistryCatalogData> REGISTRY_CATALOG_DATA_FIELD = SdkField
            .<RegistryCatalogData> builder(MarshallingType.SDK_POJO).memberName("registryCatalogData")
            .getter(getter(GetRegistryCatalogDataResponse::registryCatalogData)).setter(setter(Builder::registryCatalogData))
            .constructor(RegistryCatalogData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryCatalogData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_CATALOG_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RegistryCatalogData registryCatalogData;

    private GetRegistryCatalogDataResponse(BuilderImpl builder) {
        super(builder);
        this.registryCatalogData = builder.registryCatalogData;
    }

    /**
     * <p>
     * The catalog metadata for the public registry.
     * </p>
     * 
     * @return The catalog metadata for the public registry.
     */
    public final RegistryCatalogData registryCatalogData() {
        return registryCatalogData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryCatalogData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegistryCatalogDataResponse)) {
            return false;
        }
        GetRegistryCatalogDataResponse other = (GetRegistryCatalogDataResponse) obj;
        return Objects.equals(registryCatalogData(), other.registryCatalogData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRegistryCatalogDataResponse").add("RegistryCatalogData", registryCatalogData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryCatalogData":
            return Optional.ofNullable(clazz.cast(registryCatalogData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryCatalogData", REGISTRY_CATALOG_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRegistryCatalogDataResponse, T> g) {
        return obj -> g.apply((GetRegistryCatalogDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrPublicResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRegistryCatalogDataResponse> {
        /**
         * <p>
         * The catalog metadata for the public registry.
         * </p>
         * 
         * @param registryCatalogData
         *        The catalog metadata for the public registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryCatalogData(RegistryCatalogData registryCatalogData);

        /**
         * <p>
         * The catalog metadata for the public registry.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistryCatalogData.Builder} avoiding the
         * need to create one manually via {@link RegistryCatalogData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegistryCatalogData.Builder#build()} is called immediately and
         * its result is passed to {@link #registryCatalogData(RegistryCatalogData)}.
         * 
         * @param registryCatalogData
         *        a consumer that will call methods on {@link RegistryCatalogData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryCatalogData(RegistryCatalogData)
         */
        default Builder registryCatalogData(Consumer<RegistryCatalogData.Builder> registryCatalogData) {
            return registryCatalogData(RegistryCatalogData.builder().applyMutation(registryCatalogData).build());
        }
    }

    static final class BuilderImpl extends EcrPublicResponse.BuilderImpl implements Builder {
        private RegistryCatalogData registryCatalogData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegistryCatalogDataResponse model) {
            super(model);
            registryCatalogData(model.registryCatalogData);
        }

        public final RegistryCatalogData.Builder getRegistryCatalogData() {
            return registryCatalogData != null ? registryCatalogData.toBuilder() : null;
        }

        public final void setRegistryCatalogData(RegistryCatalogData.BuilderImpl registryCatalogData) {
            this.registryCatalogData = registryCatalogData != null ? registryCatalogData.build() : null;
        }

        @Override
        public final Builder registryCatalogData(RegistryCatalogData registryCatalogData) {
            this.registryCatalogData = registryCatalogData;
            return this;
        }

        @Override
        public GetRegistryCatalogDataResponse build() {
            return new GetRegistryCatalogDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
