/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes the image tag details that are returned by a <a>DescribeImageTags</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferencedImageDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferencedImageDetail.Builder, ReferencedImageDetail> {
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageDigest").getter(getter(ReferencedImageDetail::imageDigest)).setter(setter(Builder::imageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()).build();

    private static final SdkField<Long> IMAGE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("imageSizeInBytes").getter(getter(ReferencedImageDetail::imageSizeInBytes))
            .setter(setter(Builder::imageSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSizeInBytes").build()).build();

    private static final SdkField<Instant> IMAGE_PUSHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("imagePushedAt").getter(getter(ReferencedImageDetail::imagePushedAt))
            .setter(setter(Builder::imagePushedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePushedAt").build()).build();

    private static final SdkField<String> IMAGE_MANIFEST_MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageManifestMediaType").getter(getter(ReferencedImageDetail::imageManifestMediaType))
            .setter(setter(Builder::imageManifestMediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifestMediaType").build())
            .build();

    private static final SdkField<String> ARTIFACT_MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("artifactMediaType").getter(getter(ReferencedImageDetail::artifactMediaType))
            .setter(setter(Builder::artifactMediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactMediaType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_DIGEST_FIELD,
            IMAGE_SIZE_IN_BYTES_FIELD, IMAGE_PUSHED_AT_FIELD, IMAGE_MANIFEST_MEDIA_TYPE_FIELD, ARTIFACT_MEDIA_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String imageDigest;

    private final Long imageSizeInBytes;

    private final Instant imagePushedAt;

    private final String imageManifestMediaType;

    private final String artifactMediaType;

    private ReferencedImageDetail(BuilderImpl builder) {
        this.imageDigest = builder.imageDigest;
        this.imageSizeInBytes = builder.imageSizeInBytes;
        this.imagePushedAt = builder.imagePushedAt;
        this.imageManifestMediaType = builder.imageManifestMediaType;
        this.artifactMediaType = builder.artifactMediaType;
    }

    /**
     * <p>
     * The <code>sha256</code> digest of the image manifest.
     * </p>
     * 
     * @return The <code>sha256</code> digest of the image manifest.
     */
    public final String imageDigest() {
        return imageDigest;
    }

    /**
     * <p>
     * The size, in bytes, of the image in the repository.
     * </p>
     * <p>
     * If the image is a manifest list, this is the max size of all manifests in the list.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it might
     * return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.
     * </p>
     * </note>
     * 
     * @return The size, in bytes, of the image in the repository.</p>
     *         <p>
     *         If the image is a manifest list, this is the max size of all manifests in the list.
     *         </p>
     *         <note>
     *         <p>
     *         Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2
     *         Docker registry. The output of the <code>docker images</code> command shows the uncompressed image size,
     *         so it might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.
     *         </p>
     */
    public final Long imageSizeInBytes() {
        return imageSizeInBytes;
    }

    /**
     * <p>
     * The date and time, expressed in standard JavaScript date format, which the current image tag was pushed to the
     * repository at.
     * </p>
     * 
     * @return The date and time, expressed in standard JavaScript date format, which the current image tag was pushed
     *         to the repository at.
     */
    public final Instant imagePushedAt() {
        return imagePushedAt;
    }

    /**
     * <p>
     * The media type of the image manifest.
     * </p>
     * 
     * @return The media type of the image manifest.
     */
    public final String imageManifestMediaType() {
        return imageManifestMediaType;
    }

    /**
     * <p>
     * The artifact media type of the image.
     * </p>
     * 
     * @return The artifact media type of the image.
     */
    public final String artifactMediaType() {
        return artifactMediaType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(imageSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(imagePushedAt());
        hashCode = 31 * hashCode + Objects.hashCode(imageManifestMediaType());
        hashCode = 31 * hashCode + Objects.hashCode(artifactMediaType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferencedImageDetail)) {
            return false;
        }
        ReferencedImageDetail other = (ReferencedImageDetail) obj;
        return Objects.equals(imageDigest(), other.imageDigest()) && Objects.equals(imageSizeInBytes(), other.imageSizeInBytes())
                && Objects.equals(imagePushedAt(), other.imagePushedAt())
                && Objects.equals(imageManifestMediaType(), other.imageManifestMediaType())
                && Objects.equals(artifactMediaType(), other.artifactMediaType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferencedImageDetail").add("ImageDigest", imageDigest())
                .add("ImageSizeInBytes", imageSizeInBytes()).add("ImagePushedAt", imagePushedAt())
                .add("ImageManifestMediaType", imageManifestMediaType()).add("ArtifactMediaType", artifactMediaType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageDigest":
            return Optional.ofNullable(clazz.cast(imageDigest()));
        case "imageSizeInBytes":
            return Optional.ofNullable(clazz.cast(imageSizeInBytes()));
        case "imagePushedAt":
            return Optional.ofNullable(clazz.cast(imagePushedAt()));
        case "imageManifestMediaType":
            return Optional.ofNullable(clazz.cast(imageManifestMediaType()));
        case "artifactMediaType":
            return Optional.ofNullable(clazz.cast(artifactMediaType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageDigest", IMAGE_DIGEST_FIELD);
        map.put("imageSizeInBytes", IMAGE_SIZE_IN_BYTES_FIELD);
        map.put("imagePushedAt", IMAGE_PUSHED_AT_FIELD);
        map.put("imageManifestMediaType", IMAGE_MANIFEST_MEDIA_TYPE_FIELD);
        map.put("artifactMediaType", ARTIFACT_MEDIA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferencedImageDetail, T> g) {
        return obj -> g.apply((ReferencedImageDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferencedImageDetail> {
        /**
         * <p>
         * The <code>sha256</code> digest of the image manifest.
         * </p>
         * 
         * @param imageDigest
         *        The <code>sha256</code> digest of the image manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDigest(String imageDigest);

        /**
         * <p>
         * The size, in bytes, of the image in the repository.
         * </p>
         * <p>
         * If the image is a manifest list, this is the max size of all manifests in the list.
         * </p>
         * <note>
         * <p>
         * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2
         * Docker registry. The output of the <code>docker images</code> command shows the uncompressed image size, so
         * it might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.
         * </p>
         * </note>
         * 
         * @param imageSizeInBytes
         *        The size, in bytes, of the image in the repository.</p>
         *        <p>
         *        If the image is a manifest list, this is the max size of all manifests in the list.
         *        </p>
         *        <note>
         *        <p>
         *        Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a
         *        V2 Docker registry. The output of the <code>docker images</code> command shows the uncompressed image
         *        size, so it might return a larger image size than the image sizes that are returned by
         *        <a>DescribeImages</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSizeInBytes(Long imageSizeInBytes);

        /**
         * <p>
         * The date and time, expressed in standard JavaScript date format, which the current image tag was pushed to
         * the repository at.
         * </p>
         * 
         * @param imagePushedAt
         *        The date and time, expressed in standard JavaScript date format, which the current image tag was
         *        pushed to the repository at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePushedAt(Instant imagePushedAt);

        /**
         * <p>
         * The media type of the image manifest.
         * </p>
         * 
         * @param imageManifestMediaType
         *        The media type of the image manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageManifestMediaType(String imageManifestMediaType);

        /**
         * <p>
         * The artifact media type of the image.
         * </p>
         * 
         * @param artifactMediaType
         *        The artifact media type of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactMediaType(String artifactMediaType);
    }

    static final class BuilderImpl implements Builder {
        private String imageDigest;

        private Long imageSizeInBytes;

        private Instant imagePushedAt;

        private String imageManifestMediaType;

        private String artifactMediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferencedImageDetail model) {
            imageDigest(model.imageDigest);
            imageSizeInBytes(model.imageSizeInBytes);
            imagePushedAt(model.imagePushedAt);
            imageManifestMediaType(model.imageManifestMediaType);
            artifactMediaType(model.artifactMediaType);
        }

        public final String getImageDigest() {
            return imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final Long getImageSizeInBytes() {
            return imageSizeInBytes;
        }

        public final void setImageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
        }

        @Override
        public final Builder imageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
            return this;
        }

        public final Instant getImagePushedAt() {
            return imagePushedAt;
        }

        public final void setImagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
        }

        @Override
        public final Builder imagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
            return this;
        }

        public final String getImageManifestMediaType() {
            return imageManifestMediaType;
        }

        public final void setImageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
        }

        @Override
        public final Builder imageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
            return this;
        }

        public final String getArtifactMediaType() {
            return artifactMediaType;
        }

        public final void setArtifactMediaType(String artifactMediaType) {
            this.artifactMediaType = artifactMediaType;
        }

        @Override
        public final Builder artifactMediaType(String artifactMediaType) {
            this.artifactMediaType = artifactMediaType;
            return this;
        }

        @Override
        public ReferencedImageDetail build() {
            return new ReferencedImageDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
