/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deployment> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Deployment.getter(Deployment::id)).setter(Deployment.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Deployment.getter(Deployment::status)).setter(Deployment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Deployment.getter(Deployment::taskDefinition)).setter(Deployment.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Deployment.getter(Deployment::desiredCount)).setter(Deployment.setter(Builder::desiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()}).build();
    private static final SdkField<Integer> PENDING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Deployment.getter(Deployment::pendingCount)).setter(Deployment.setter(Builder::pendingCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingCount").build()}).build();
    private static final SdkField<Integer> RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Deployment.getter(Deployment::runningCount)).setter(Deployment.setter(Builder::runningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningCount").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Deployment.getter(Deployment::createdAt)).setter(Deployment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Deployment.getter(Deployment::updatedAt)).setter(Deployment.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Deployment.getter(Deployment::launchTypeAsString)).setter(Deployment.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Deployment.getter(Deployment::platformVersion)).setter(Deployment.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Deployment.getter(Deployment::networkConfiguration)).setter(Deployment.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD, TASK_DEFINITION_FIELD, DESIRED_COUNT_FIELD, PENDING_COUNT_FIELD, RUNNING_COUNT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, LAUNCH_TYPE_FIELD, PLATFORM_VERSION_FIELD, NETWORK_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String status;
    private final String taskDefinition;
    private final Integer desiredCount;
    private final Integer pendingCount;
    private final Integer runningCount;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String launchType;
    private final String platformVersion;
    private final NetworkConfiguration networkConfiguration;

    private Deployment(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.taskDefinition = builder.taskDefinition;
        this.desiredCount = builder.desiredCount;
        this.pendingCount = builder.pendingCount;
        this.runningCount = builder.runningCount;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.launchType = builder.launchType;
        this.platformVersion = builder.platformVersion;
        this.networkConfiguration = builder.networkConfiguration;
    }

    public String id() {
        return this.id;
    }

    public String status() {
        return this.status;
    }

    public String taskDefinition() {
        return this.taskDefinition;
    }

    public Integer desiredCount() {
        return this.desiredCount;
    }

    public Integer pendingCount() {
        return this.pendingCount;
    }

    public Integer runningCount() {
        return this.runningCount;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public String launchTypeAsString() {
        return this.launchType;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.desiredCount(), other.desiredCount()) && Objects.equals(this.pendingCount(), other.pendingCount()) && Objects.equals(this.runningCount(), other.runningCount()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"Deployment").add("Id", (Object)this.id()).add("Status", (Object)this.status()).add("TaskDefinition", (Object)this.taskDefinition()).add("DesiredCount", (Object)this.desiredCount()).add("PendingCount", (Object)this.pendingCount()).add("RunningCount", (Object)this.runningCount()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("LaunchType", (Object)this.launchTypeAsString()).add("PlatformVersion", (Object)this.platformVersion()).add("NetworkConfiguration", (Object)this.networkConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "desiredCount": {
                return Optional.ofNullable(clazz.cast(this.desiredCount()));
            }
            case "pendingCount": {
                return Optional.ofNullable(clazz.cast(this.pendingCount()));
            }
            case "runningCount": {
                return Optional.ofNullable(clazz.cast(this.runningCount()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private String taskDefinition;
        private Integer desiredCount;
        private Integer pendingCount;
        private Integer runningCount;
        private Instant createdAt;
        private Instant updatedAt;
        private String launchType;
        private String platformVersion;
        private NetworkConfiguration networkConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.id(model.id);
            this.status(model.status);
            this.taskDefinition(model.taskDefinition);
            this.desiredCount(model.desiredCount);
            this.pendingCount(model.pendingCount);
            this.runningCount(model.runningCount);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.launchType(model.launchType);
            this.platformVersion(model.platformVersion);
            this.networkConfiguration(model.networkConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final Integer getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        public final Integer getPendingCount() {
            return this.pendingCount;
        }

        @Override
        public final Builder pendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
            return this;
        }

        public final void setPendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
        }

        public final Integer getRunningCount() {
            return this.runningCount;
        }

        @Override
        public final Builder runningCount(Integer runningCount) {
            this.runningCount = runningCount;
            return this;
        }

        public final void setRunningCount(Integer runningCount) {
            this.runningCount = runningCount;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final String getLaunchTypeAsString() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public Deployment build() {
            return new Deployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deployment> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder taskDefinition(String var1);

        public Builder desiredCount(Integer var1);

        public Builder pendingCount(Integer var1);

        public Builder runningCount(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder platformVersion(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }
    }
}

