/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTaskSetsRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, DescribeTaskSetsRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskSetsRequest.getter(DescribeTaskSetsRequest::cluster)).setter(DescribeTaskSetsRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskSetsRequest.getter(DescribeTaskSetsRequest::service)).setter(DescribeTaskSetsRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<List<String>> TASK_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTaskSetsRequest.getter(DescribeTaskSetsRequest::taskSets)).setter(DescribeTaskSetsRequest.setter(Builder::taskSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD, TASK_SETS_FIELD));
    private final String cluster;
    private final String service;
    private final List<String> taskSets;

    private DescribeTaskSetsRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.taskSets = builder.taskSets;
    }

    public String cluster() {
        return this.cluster;
    }

    public String service() {
        return this.service;
    }

    public List<String> taskSets() {
        return this.taskSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskSetsRequest)) {
            return false;
        }
        DescribeTaskSetsRequest other = (DescribeTaskSetsRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.taskSets(), other.taskSets());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTaskSetsRequest").add("Cluster", (Object)this.cluster()).add("Service", (Object)this.service()).add("TaskSets", this.taskSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "taskSets": {
                return Optional.ofNullable(clazz.cast(this.taskSets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskSetsRequest, T> g) {
        return obj -> g.apply((DescribeTaskSetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String service;
        private List<String> taskSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskSetsRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.service(model.service);
            this.taskSets(model.taskSets);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final Collection<String> getTaskSets() {
            return this.taskSets;
        }

        @Override
        public final Builder taskSets(Collection<String> taskSets) {
            this.taskSets = StringListCopier.copy(taskSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(String ... taskSets) {
            this.taskSets(Arrays.asList(taskSets));
            return this;
        }

        public final void setTaskSets(Collection<String> taskSets) {
            this.taskSets = StringListCopier.copy(taskSets);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTaskSetsRequest build() {
            return new DescribeTaskSetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTaskSetsRequest> {
        public Builder cluster(String var1);

        public Builder service(String var1);

        public Builder taskSets(Collection<String> var1);

        public Builder taskSets(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

