/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterTaskDefinitionResponse extends EcsResponse implements
        ToCopyableBuilder<DeregisterTaskDefinitionResponse.Builder, DeregisterTaskDefinitionResponse> {
    private static final SdkField<TaskDefinition> TASK_DEFINITION_FIELD = SdkField
            .<TaskDefinition> builder(MarshallingType.SDK_POJO).getter(getter(DeregisterTaskDefinitionResponse::taskDefinition))
            .setter(setter(Builder::taskDefinition)).constructor(TaskDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITION_FIELD));

    private final TaskDefinition taskDefinition;

    private DeregisterTaskDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.taskDefinition = builder.taskDefinition;
    }

    /**
     * <p>
     * The full description of the deregistered task.
     * </p>
     * 
     * @return The full description of the deregistered task.
     */
    public TaskDefinition taskDefinition() {
        return taskDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTaskDefinitionResponse)) {
            return false;
        }
        DeregisterTaskDefinitionResponse other = (DeregisterTaskDefinitionResponse) obj;
        return Objects.equals(taskDefinition(), other.taskDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeregisterTaskDefinitionResponse").add("TaskDefinition", taskDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterTaskDefinitionResponse, T> g) {
        return obj -> g.apply((DeregisterTaskDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeregisterTaskDefinitionResponse> {
        /**
         * <p>
         * The full description of the deregistered task.
         * </p>
         * 
         * @param taskDefinition
         *        The full description of the deregistered task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(TaskDefinition taskDefinition);

        /**
         * <p>
         * The full description of the deregistered task.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskDefinition.Builder} avoiding the need to
         * create one manually via {@link TaskDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #taskDefinition(TaskDefinition)}.
         * 
         * @param taskDefinition
         *        a consumer that will call methods on {@link TaskDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskDefinition(TaskDefinition)
         */
        default Builder taskDefinition(Consumer<TaskDefinition.Builder> taskDefinition) {
            return taskDefinition(TaskDefinition.builder().applyMutation(taskDefinition).build());
        }
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private TaskDefinition taskDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTaskDefinitionResponse model) {
            super(model);
            taskDefinition(model.taskDefinition);
        }

        public final TaskDefinition.Builder getTaskDefinition() {
            return taskDefinition != null ? taskDefinition.toBuilder() : null;
        }

        @Override
        public final Builder taskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(TaskDefinition.BuilderImpl taskDefinition) {
            this.taskDefinition = taskDefinition != null ? taskDefinition.build() : null;
        }

        @Override
        public DeregisterTaskDefinitionResponse build() {
            return new DeregisterTaskDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
