/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContainerInstancesRequest extends EcsRequest implements
        ToCopyableBuilder<DescribeContainerInstancesRequest.Builder, DescribeContainerInstancesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeContainerInstancesRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<List<String>> CONTAINER_INSTANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeContainerInstancesRequest::containerInstances))
            .setter(setter(Builder::containerInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeContainerInstancesRequest::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            CONTAINER_INSTANCES_FIELD, INCLUDE_FIELD));

    private final String cluster;

    private final List<String> containerInstances;

    private final List<String> include;

    private DescribeContainerInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.containerInstances = builder.containerInstances;
        this.include = builder.include;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to describe.
     * If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container
     * instance or container instances you are describing were launched in any cluster other than the default cluster.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
     *         describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if
     *         the container instance or container instances you are describing were launched in any cluster other than
     *         the default cluster.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * Returns true if the ContainerInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasContainerInstances() {
        return containerInstances != null && !(containerInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContainerInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
     */
    public List<String> containerInstances() {
        return containerInstances;
    }

    /**
     * <p>
     * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
     * specified, the tags are included in the response. If this field is omitted, tags are not included in the
     * response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInclude()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
     *         specified, the tags are included in the response. If this field is omitted, tags are not included in the
     *         response.
     */
    public List<ContainerInstanceField> include() {
        return ContainerInstanceFieldListCopier.copyStringToEnum(include);
    }

    /**
     * Returns true if the Include property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
     * specified, the tags are included in the response. If this field is omitted, tags are not included in the
     * response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInclude()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
     *         specified, the tags are included in the response. If this field is omitted, tags are not included in the
     *         response.
     */
    public List<String> includeAsStrings() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(containerInstances());
        hashCode = 31 * hashCode + Objects.hashCode(includeAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerInstancesRequest)) {
            return false;
        }
        DescribeContainerInstancesRequest other = (DescribeContainerInstancesRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(containerInstances(), other.containerInstances())
                && Objects.equals(includeAsStrings(), other.includeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeContainerInstancesRequest").add("Cluster", cluster())
                .add("ContainerInstances", containerInstances()).add("Include", includeAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "containerInstances":
            return Optional.ofNullable(clazz.cast(containerInstances()));
        case "include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContainerInstancesRequest, T> g) {
        return obj -> g.apply((DescribeContainerInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeContainerInstancesRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
         * describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the
         * container instance or container instances you are describing were launched in any cluster other than the
         * default cluster.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
         *        describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required
         *        if the container instance or container instances you are describing were launched in any cluster other
         *        than the default cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param containerInstances
         *        A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstances(Collection<String> containerInstances);

        /**
         * <p>
         * A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param containerInstances
         *        A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstances(String... containerInstances);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags are not included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code>
         *        is specified, the tags are included in the response. If this field is omitted, tags are not included
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Collection<String> include);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags are not included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code>
         *        is specified, the tags are included in the response. If this field is omitted, tags are not included
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(String... include);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags are not included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code>
         *        is specified, the tags are included in the response. If this field is omitted, tags are not included
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<ContainerInstanceField> include);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags are not included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code>
         *        is specified, the tags are included in the response. If this field is omitted, tags are not included
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(ContainerInstanceField... include);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private List<String> containerInstances = DefaultSdkAutoConstructList.getInstance();

        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContainerInstancesRequest model) {
            super(model);
            cluster(model.cluster);
            containerInstances(model.containerInstances);
            includeWithStrings(model.include);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final Collection<String> getContainerInstances() {
            return containerInstances;
        }

        @Override
        public final Builder containerInstances(Collection<String> containerInstances) {
            this.containerInstances = StringListCopier.copy(containerInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerInstances(String... containerInstances) {
            containerInstances(Arrays.asList(containerInstances));
            return this;
        }

        public final void setContainerInstances(Collection<String> containerInstances) {
            this.containerInstances = StringListCopier.copy(containerInstances);
        }

        public final Collection<String> getIncludeAsStrings() {
            return include;
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = ContainerInstanceFieldListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String... include) {
            includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<ContainerInstanceField> include) {
            this.include = ContainerInstanceFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(ContainerInstanceField... include) {
            include(Arrays.asList(include));
            return this;
        }

        public final void setIncludeWithStrings(Collection<String> include) {
            this.include = ContainerInstanceFieldListCopier.copy(include);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeContainerInstancesRequest build() {
            return new DescribeContainerInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
