/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This parameter is specified when you are using an Amazon Elastic File System (Amazon EFS) file storage. Amazon EFS
 * file systems are only supported when you are using the EC2 launch type.
 * </p>
 * <important>
 * <p>
 * <code>EFSVolumeConfiguration</code> remains in preview and is a Beta Service as defined by and subject to the Beta
 * Service Participation Service Terms located at <a
 * href="https://aws.amazon.com/service-terms">https://aws.amazon.com/service-terms</a> ("Beta Terms"). These Beta Terms
 * apply to your participation in this preview of <code>EFSVolumeConfiguration</code>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EFSVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EFSVolumeConfiguration.Builder, EFSVolumeConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EFSVolumeConfiguration::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemId").build()).build();

    private static final SdkField<String> ROOT_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EFSVolumeConfiguration::rootDirectory)).setter(setter(Builder::rootDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            ROOT_DIRECTORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileSystemId;

    private final String rootDirectory;

    private EFSVolumeConfiguration(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.rootDirectory = builder.rootDirectory;
    }

    /**
     * <p>
     * The Amazon EFS file system ID to use.
     * </p>
     * 
     * @return The Amazon EFS file system ID to use.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The directory within the Amazon EFS file system to mount as the root directory inside the host.
     * </p>
     * 
     * @return The directory within the Amazon EFS file system to mount as the root directory inside the host.
     */
    public String rootDirectory() {
        return rootDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(rootDirectory());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EFSVolumeConfiguration)) {
            return false;
        }
        EFSVolumeConfiguration other = (EFSVolumeConfiguration) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(rootDirectory(), other.rootDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EFSVolumeConfiguration").add("FileSystemId", fileSystemId())
                .add("RootDirectory", rootDirectory()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "rootDirectory":
            return Optional.ofNullable(clazz.cast(rootDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EFSVolumeConfiguration, T> g) {
        return obj -> g.apply((EFSVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EFSVolumeConfiguration> {
        /**
         * <p>
         * The Amazon EFS file system ID to use.
         * </p>
         * 
         * @param fileSystemId
         *        The Amazon EFS file system ID to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The directory within the Amazon EFS file system to mount as the root directory inside the host.
         * </p>
         * 
         * @param rootDirectory
         *        The directory within the Amazon EFS file system to mount as the root directory inside the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDirectory(String rootDirectory);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemId;

        private String rootDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(EFSVolumeConfiguration model) {
            fileSystemId(model.fileSystemId);
            rootDirectory(model.rootDirectory);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getRootDirectory() {
            return rootDirectory;
        }

        @Override
        public final Builder rootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public final void setRootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
        }

        @Override
        public EFSVolumeConfiguration build() {
            return new EFSVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
