/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountSettingsRequest extends EcsRequest implements
        ToCopyableBuilder<ListAccountSettingsRequest.Builder, ListAccountSettingsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAccountSettingsRequest::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAccountSettingsRequest::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAccountSettingsRequest::principalArn)).setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()).build();

    private static final SdkField<Boolean> EFFECTIVE_SETTINGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListAccountSettingsRequest::effectiveSettings)).setter(setter(Builder::effectiveSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveSettings").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAccountSettingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListAccountSettingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            PRINCIPAL_ARN_FIELD, EFFECTIVE_SETTINGS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String name;

    private final String value;

    private final String principalArn;

    private final Boolean effectiveSettings;

    private final String nextToken;

    private final Integer maxResults;

    private ListAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.value = builder.value;
        this.principalArn = builder.principalArn;
        this.effectiveSettings = builder.effectiveSettings;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The resource name you want to list the account settings for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SettingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The resource name you want to list the account settings for.
     * @see SettingName
     */
    public SettingName name() {
        return SettingName.fromValue(name);
    }

    /**
     * <p>
     * The resource name you want to list the account settings for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SettingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The resource name you want to list the account settings for.
     * @see SettingName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The value of the account settings with which to filter results. You must also specify an account setting name to
     * use this parameter.
     * </p>
     * 
     * @return The value of the account settings with which to filter results. You must also specify an account setting
     *         name to use this parameter.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is omitted, the
     * account settings are listed only for the authenticated user.
     * </p>
     * 
     * @return The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is omitted,
     *         the account settings are listed only for the authenticated user.
     */
    public String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * Specifies whether to return the effective settings. If <code>true</code>, the account settings for the root user
     * or the default setting for the <code>principalArn</code> are returned. If <code>false</code>, the account
     * settings for the <code>principalArn</code> are returned if they are set. Otherwise, no account settings are
     * returned.
     * </p>
     * 
     * @return Specifies whether to return the effective settings. If <code>true</code>, the account settings for the
     *         root user or the default setting for the <code>principalArn</code> are returned. If <code>false</code>,
     *         the account settings for the <code>principalArn</code> are returned if they are set. Otherwise, no
     *         account settings are returned.
     */
    public Boolean effectiveSettings() {
        return effectiveSettings;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a <code>ListAccountSettings</code> request indicating that more
     * results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was
     * provided, it is possible the number of results to be fewer than <code>maxResults</code>.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a <code>ListAccountSettings</code> request indicating that
     *         more results are available to fulfill the request and further calls will be needed. If
     *         <code>maxResults</code> was provided, it is possible the number of results to be fewer than
     *         <code>maxResults</code>.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of account setting results returned by <code>ListAccountSettings</code> in paginated output.
     * When this parameter is used, <code>ListAccountSettings</code> only returns <code>maxResults</code> results in a
     * single page along with a <code>nextToken</code> response element. The remaining results of the initial request
     * can be seen by sending another <code>ListAccountSettings</code> request with the returned <code>nextToken</code>
     * value. This value can be between 1 and 10. If this parameter is not used, then <code>ListAccountSettings</code>
     * returns up to 10 results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of account setting results returned by <code>ListAccountSettings</code> in paginated
     *         output. When this parameter is used, <code>ListAccountSettings</code> only returns
     *         <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
     *         The remaining results of the initial request can be seen by sending another
     *         <code>ListAccountSettings</code> request with the returned <code>nextToken</code> value. This value can
     *         be between 1 and 10. If this parameter is not used, then <code>ListAccountSettings</code> returns up to
     *         10 results and a <code>nextToken</code> value if applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveSettings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountSettingsRequest)) {
            return false;
        }
        ListAccountSettingsRequest other = (ListAccountSettingsRequest) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value())
                && Objects.equals(principalArn(), other.principalArn())
                && Objects.equals(effectiveSettings(), other.effectiveSettings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAccountSettingsRequest").add("Name", nameAsString()).add("Value", value())
                .add("PrincipalArn", principalArn()).add("EffectiveSettings", effectiveSettings()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "effectiveSettings":
            return Optional.ofNullable(clazz.cast(effectiveSettings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountSettingsRequest, T> g) {
        return obj -> g.apply((ListAccountSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAccountSettingsRequest> {
        /**
         * <p>
         * The resource name you want to list the account settings for.
         * </p>
         * 
         * @param name
         *        The resource name you want to list the account settings for.
         * @see SettingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingName
         */
        Builder name(String name);

        /**
         * <p>
         * The resource name you want to list the account settings for.
         * </p>
         * 
         * @param name
         *        The resource name you want to list the account settings for.
         * @see SettingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingName
         */
        Builder name(SettingName name);

        /**
         * <p>
         * The value of the account settings with which to filter results. You must also specify an account setting name
         * to use this parameter.
         * </p>
         * 
         * @param value
         *        The value of the account settings with which to filter results. You must also specify an account
         *        setting name to use this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is omitted, the
         * account settings are listed only for the authenticated user.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is
         *        omitted, the account settings are listed only for the authenticated user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * Specifies whether to return the effective settings. If <code>true</code>, the account settings for the root
         * user or the default setting for the <code>principalArn</code> are returned. If <code>false</code>, the
         * account settings for the <code>principalArn</code> are returned if they are set. Otherwise, no account
         * settings are returned.
         * </p>
         * 
         * @param effectiveSettings
         *        Specifies whether to return the effective settings. If <code>true</code>, the account settings for the
         *        root user or the default setting for the <code>principalArn</code> are returned. If <code>false</code>
         *        , the account settings for the <code>principalArn</code> are returned if they are set. Otherwise, no
         *        account settings are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveSettings(Boolean effectiveSettings);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a <code>ListAccountSettings</code> request indicating that
         * more results are available to fulfill the request and further calls will be needed. If
         * <code>maxResults</code> was provided, it is possible the number of results to be fewer than
         * <code>maxResults</code>.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a <code>ListAccountSettings</code> request indicating
         *        that more results are available to fulfill the request and further calls will be needed. If
         *        <code>maxResults</code> was provided, it is possible the number of results to be fewer than
         *        <code>maxResults</code>.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of account setting results returned by <code>ListAccountSettings</code> in paginated
         * output. When this parameter is used, <code>ListAccountSettings</code> only returns <code>maxResults</code>
         * results in a single page along with a <code>nextToken</code> response element. The remaining results of the
         * initial request can be seen by sending another <code>ListAccountSettings</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 10. If this parameter is not used, then
         * <code>ListAccountSettings</code> returns up to 10 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of account setting results returned by <code>ListAccountSettings</code> in
         *        paginated output. When this parameter is used, <code>ListAccountSettings</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>ListAccountSettings</code> request with the returned <code>nextToken</code> value. This value
         *        can be between 1 and 10. If this parameter is not used, then <code>ListAccountSettings</code> returns
         *        up to 10 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String name;

        private String value;

        private String principalArn;

        private Boolean effectiveSettings;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountSettingsRequest model) {
            super(model);
            name(model.name);
            value(model.value);
            principalArn(model.principalArn);
            effectiveSettings(model.effectiveSettings);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getNameAsString() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(SettingName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final Boolean getEffectiveSettings() {
            return effectiveSettings;
        }

        @Override
        public final Builder effectiveSettings(Boolean effectiveSettings) {
            this.effectiveSettings = effectiveSettings;
            return this;
        }

        public final void setEffectiveSettings(Boolean effectiveSettings) {
            this.effectiveSettings = effectiveSettings;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountSettingsRequest build() {
            return new ListAccountSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
