/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A floating-point percentage of the desired number of tasks to place and keep running in the task set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scale implements SdkPojo, Serializable, ToCopyableBuilder<Scale.Builder, Scale> {
    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Scale::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Scale::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double value;

    private final String unit;

    private Scale(BuilderImpl builder) {
        this.value = builder.value;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The value, specified as a percent total of a service's <code>desiredCount</code>, to scale the task set. Accepted
     * values are numbers between 0 and 100.
     * </p>
     * 
     * @return The value, specified as a percent total of a service's <code>desiredCount</code>, to scale the task set.
     *         Accepted values are numbers between 0 and 100.
     */
    public Double value() {
        return value;
    }

    /**
     * <p>
     * The unit of measure for the scale value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link ScaleUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measure for the scale value.
     * @see ScaleUnit
     */
    public ScaleUnit unit() {
        return ScaleUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit of measure for the scale value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link ScaleUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measure for the scale value.
     * @see ScaleUnit
     */
    public String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scale)) {
            return false;
        }
        Scale other = (Scale) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Scale").add("Value", value()).add("Unit", unitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scale, T> g) {
        return obj -> g.apply((Scale) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scale> {
        /**
         * <p>
         * The value, specified as a percent total of a service's <code>desiredCount</code>, to scale the task set.
         * Accepted values are numbers between 0 and 100.
         * </p>
         * 
         * @param value
         *        The value, specified as a percent total of a service's <code>desiredCount</code>, to scale the task
         *        set. Accepted values are numbers between 0 and 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * The unit of measure for the scale value.
         * </p>
         * 
         * @param unit
         *        The unit of measure for the scale value.
         * @see ScaleUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScaleUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of measure for the scale value.
         * </p>
         * 
         * @param unit
         *        The unit of measure for the scale value.
         * @see ScaleUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScaleUnit
         */
        Builder unit(ScaleUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Double value;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(Scale model) {
            value(model.value);
            unit(model.unit);
        }

        public final Double getValue() {
            return value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        public final String getUnitAsString() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(ScaleUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public Scale build() {
            return new Scale(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
