/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.DeploymentConfiguration;
import software.amazon.awssdk.services.ecs.model.DeploymentController;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.LoadBalancer;
import software.amazon.awssdk.services.ecs.model.LoadBalancersCopier;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.PlacementConstraint;
import software.amazon.awssdk.services.ecs.model.PlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategiesCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategy;
import software.amazon.awssdk.services.ecs.model.PropagateTags;
import software.amazon.awssdk.services.ecs.model.SchedulingStrategy;
import software.amazon.awssdk.services.ecs.model.ServiceRegistriesCopier;
import software.amazon.awssdk.services.ecs.model.ServiceRegistry;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, CreateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServiceRequest.getter(CreateServiceRequest::cluster)).setter(CreateServiceRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServiceRequest.getter(CreateServiceRequest::serviceName)).setter(CreateServiceRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServiceRequest.getter(CreateServiceRequest::taskDefinition)).setter(CreateServiceRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateServiceRequest.getter(CreateServiceRequest::loadBalancers)).setter(CreateServiceRequest.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateServiceRequest.getter(CreateServiceRequest::serviceRegistries)).setter(CreateServiceRequest.setter(Builder::serviceRegistries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceRegistry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateServiceRequest.getter(CreateServiceRequest::desiredCount)).setter(CreateServiceRequest.setter(Builder::desiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServiceRequest.getter(CreateServiceRequest::clientToken)).setter(CreateServiceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServiceRequest.getter(CreateServiceRequest::launchTypeAsString)).setter(CreateServiceRequest.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateServiceRequest.getter(CreateServiceRequest::capacityProviderStrategy)).setter(CreateServiceRequest.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServiceRequest.getter(CreateServiceRequest::platformVersion)).setter(CreateServiceRequest.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServiceRequest.getter(CreateServiceRequest::role)).setter(CreateServiceRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateServiceRequest.getter(CreateServiceRequest::deploymentConfiguration)).setter(CreateServiceRequest.setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build()}).build();
    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateServiceRequest.getter(CreateServiceRequest::placementConstraints)).setter(CreateServiceRequest.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateServiceRequest.getter(CreateServiceRequest::placementStrategy)).setter(CreateServiceRequest.setter(Builder::placementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateServiceRequest.getter(CreateServiceRequest::networkConfiguration)).setter(CreateServiceRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateServiceRequest.getter(CreateServiceRequest::healthCheckGracePeriodSeconds)).setter(CreateServiceRequest.setter(Builder::healthCheckGracePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds").build()}).build();
    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServiceRequest.getter(CreateServiceRequest::schedulingStrategyAsString)).setter(CreateServiceRequest.setter(Builder::schedulingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build()}).build();
    private static final SdkField<DeploymentController> DEPLOYMENT_CONTROLLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateServiceRequest.getter(CreateServiceRequest::deploymentController)).setter(CreateServiceRequest.setter(Builder::deploymentController)).constructor(DeploymentController::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentController").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateServiceRequest.getter(CreateServiceRequest::tags)).setter(CreateServiceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateServiceRequest.getter(CreateServiceRequest::enableECSManagedTags)).setter(CreateServiceRequest.setter(Builder::enableECSManagedTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServiceRequest.getter(CreateServiceRequest::propagateTagsAsString)).setter(CreateServiceRequest.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_NAME_FIELD, TASK_DEFINITION_FIELD, LOAD_BALANCERS_FIELD, SERVICE_REGISTRIES_FIELD, DESIRED_COUNT_FIELD, CLIENT_TOKEN_FIELD, LAUNCH_TYPE_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, ROLE_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, NETWORK_CONFIGURATION_FIELD, HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, SCHEDULING_STRATEGY_FIELD, DEPLOYMENT_CONTROLLER_FIELD, TAGS_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, PROPAGATE_TAGS_FIELD));
    private final String cluster;
    private final String serviceName;
    private final String taskDefinition;
    private final List<LoadBalancer> loadBalancers;
    private final List<ServiceRegistry> serviceRegistries;
    private final Integer desiredCount;
    private final String clientToken;
    private final String launchType;
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final String platformVersion;
    private final String role;
    private final DeploymentConfiguration deploymentConfiguration;
    private final List<PlacementConstraint> placementConstraints;
    private final List<PlacementStrategy> placementStrategy;
    private final NetworkConfiguration networkConfiguration;
    private final Integer healthCheckGracePeriodSeconds;
    private final String schedulingStrategy;
    private final DeploymentController deploymentController;
    private final List<Tag> tags;
    private final Boolean enableECSManagedTags;
    private final String propagateTags;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.serviceName = builder.serviceName;
        this.taskDefinition = builder.taskDefinition;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.desiredCount = builder.desiredCount;
        this.clientToken = builder.clientToken;
        this.launchType = builder.launchType;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.platformVersion = builder.platformVersion;
        this.role = builder.role;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.networkConfiguration = builder.networkConfiguration;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.deploymentController = builder.deploymentController;
        this.tags = builder.tags;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.propagateTags = builder.propagateTags;
    }

    public String cluster() {
        return this.cluster;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String taskDefinition() {
        return this.taskDefinition;
    }

    public boolean hasLoadBalancers() {
        return this.loadBalancers != null && !(this.loadBalancers instanceof SdkAutoConstructList);
    }

    public List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public boolean hasServiceRegistries() {
        return this.serviceRegistries != null && !(this.serviceRegistries instanceof SdkAutoConstructList);
    }

    public List<ServiceRegistry> serviceRegistries() {
        return this.serviceRegistries;
    }

    public Integer desiredCount() {
        return this.desiredCount;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public String launchTypeAsString() {
        return this.launchType;
    }

    public boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public String role() {
        return this.role;
    }

    public DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public boolean hasPlacementConstraints() {
        return this.placementConstraints != null && !(this.placementConstraints instanceof SdkAutoConstructList);
    }

    public List<PlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public boolean hasPlacementStrategy() {
        return this.placementStrategy != null && !(this.placementStrategy instanceof SdkAutoConstructList);
    }

    public List<PlacementStrategy> placementStrategy() {
        return this.placementStrategy;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public Integer healthCheckGracePeriodSeconds() {
        return this.healthCheckGracePeriodSeconds;
    }

    public SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(this.schedulingStrategy);
    }

    public String schedulingStrategyAsString() {
        return this.schedulingStrategy;
    }

    public DeploymentController deploymentController() {
        return this.deploymentController;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean enableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public PropagateTags propagateTags() {
        return PropagateTags.fromValue(this.propagateTags);
    }

    public String propagateTagsAsString() {
        return this.propagateTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancers());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRegistries());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentController());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.loadBalancers(), other.loadBalancers()) && Objects.equals(this.serviceRegistries(), other.serviceRegistries()) && Objects.equals(this.desiredCount(), other.desiredCount()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration()) && Objects.equals(this.placementConstraints(), other.placementConstraints()) && Objects.equals(this.placementStrategy(), other.placementStrategy()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds()) && Objects.equals(this.schedulingStrategyAsString(), other.schedulingStrategyAsString()) && Objects.equals(this.deploymentController(), other.deploymentController()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.enableECSManagedTags(), other.enableECSManagedTags()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateServiceRequest").add("Cluster", (Object)this.cluster()).add("ServiceName", (Object)this.serviceName()).add("TaskDefinition", (Object)this.taskDefinition()).add("LoadBalancers", this.loadBalancers()).add("ServiceRegistries", this.serviceRegistries()).add("DesiredCount", (Object)this.desiredCount()).add("ClientToken", (Object)this.clientToken()).add("LaunchType", (Object)this.launchTypeAsString()).add("CapacityProviderStrategy", this.capacityProviderStrategy()).add("PlatformVersion", (Object)this.platformVersion()).add("Role", (Object)this.role()).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).add("PlacementConstraints", this.placementConstraints()).add("PlacementStrategy", this.placementStrategy()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("HealthCheckGracePeriodSeconds", (Object)this.healthCheckGracePeriodSeconds()).add("SchedulingStrategy", (Object)this.schedulingStrategyAsString()).add("DeploymentController", (Object)this.deploymentController()).add("Tags", this.tags()).add("EnableECSManagedTags", (Object)this.enableECSManagedTags()).add("PropagateTags", (Object)this.propagateTagsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "loadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
            case "serviceRegistries": {
                return Optional.ofNullable(clazz.cast(this.serviceRegistries()));
            }
            case "desiredCount": {
                return Optional.ofNullable(clazz.cast(this.desiredCount()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "capacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "deploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "placementStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementStrategy()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "healthCheckGracePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriodSeconds()));
            }
            case "schedulingStrategy": {
                return Optional.ofNullable(clazz.cast(this.schedulingStrategyAsString()));
            }
            case "deploymentController": {
                return Optional.ofNullable(clazz.cast(this.deploymentController()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "enableECSManagedTags": {
                return Optional.ofNullable(clazz.cast(this.enableECSManagedTags()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String serviceName;
        private String taskDefinition;
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();
        private Integer desiredCount;
        private String clientToken;
        private String launchType;
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private String platformVersion;
        private String role;
        private DeploymentConfiguration deploymentConfiguration;
        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();
        private NetworkConfiguration networkConfiguration;
        private Integer healthCheckGracePeriodSeconds;
        private String schedulingStrategy;
        private DeploymentController deploymentController;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableECSManagedTags;
        private String propagateTags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.serviceName(model.serviceName);
            this.taskDefinition(model.taskDefinition);
            this.loadBalancers(model.loadBalancers);
            this.serviceRegistries(model.serviceRegistries);
            this.desiredCount(model.desiredCount);
            this.clientToken(model.clientToken);
            this.launchType(model.launchType);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.platformVersion(model.platformVersion);
            this.role(model.role);
            this.deploymentConfiguration(model.deploymentConfiguration);
            this.placementConstraints(model.placementConstraints);
            this.placementStrategy(model.placementStrategy);
            this.networkConfiguration(model.networkConfiguration);
            this.healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            this.schedulingStrategy(model.schedulingStrategy);
            this.deploymentController(model.deploymentController);
            this.tags(model.tags);
            this.enableECSManagedTags(model.enableECSManagedTags);
            this.propagateTags(model.propagateTags);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            return this.loadBalancers != null ? (Collection)this.loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        public final Collection<ServiceRegistry.Builder> getServiceRegistries() {
            return this.serviceRegistries != null ? (Collection)this.serviceRegistries.stream().map(ServiceRegistry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry ... serviceRegistries) {
            this.serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... serviceRegistries) {
            this.serviceRegistries(Stream.of(serviceRegistries).map(c -> (ServiceRegistry)((ServiceRegistry.Builder)ServiceRegistry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        public final Integer getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getLaunchTypeAsString() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final Collection<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            return this.capacityProviderStrategy != null ? (Collection)this.capacityProviderStrategy.stream().map(CapacityProviderStrategyItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        public final Collection<PlacementConstraint.Builder> getPlacementConstraints() {
            return this.placementConstraints != null ? (Collection)this.placementConstraints.stream().map(PlacementConstraint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (PlacementConstraint)((PlacementConstraint.Builder)PlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<PlacementStrategy.Builder> getPlacementStrategy() {
            return this.placementStrategy != null ? (Collection)this.placementStrategy.stream().map(PlacementStrategy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy ... placementStrategy) {
            this.placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... placementStrategy) {
            this.placementStrategy(Stream.of(placementStrategy).map(c -> (PlacementStrategy)((PlacementStrategy.Builder)PlacementStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return this.healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        public final String getSchedulingStrategyAsString() {
            return this.schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        public final DeploymentController.Builder getDeploymentController() {
            return this.deploymentController != null ? this.deploymentController.toBuilder() : null;
        }

        @Override
        public final Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public final void setDeploymentController(DeploymentController.BuilderImpl deploymentController) {
            this.deploymentController = deploymentController != null ? deploymentController.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Boolean getEnableECSManagedTags() {
            return this.enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        public final String getPropagateTagsAsString() {
            return this.propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceRequest> {
        public Builder cluster(String var1);

        public Builder serviceName(String var1);

        public Builder taskDefinition(String var1);

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);

        public Builder serviceRegistries(Collection<ServiceRegistry> var1);

        public Builder serviceRegistries(ServiceRegistry ... var1);

        public Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... var1);

        public Builder desiredCount(Integer var1);

        public Builder clientToken(String var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder platformVersion(String var1);

        public Builder role(String var1);

        public Builder deploymentConfiguration(DeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder placementConstraints(Collection<PlacementConstraint> var1);

        public Builder placementConstraints(PlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... var1);

        public Builder placementStrategy(Collection<PlacementStrategy> var1);

        public Builder placementStrategy(PlacementStrategy ... var1);

        public Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder healthCheckGracePeriodSeconds(Integer var1);

        public Builder schedulingStrategy(String var1);

        public Builder schedulingStrategy(SchedulingStrategy var1);

        public Builder deploymentController(DeploymentController var1);

        default public Builder deploymentController(Consumer<DeploymentController.Builder> deploymentController) {
            return this.deploymentController((DeploymentController)((DeploymentController.Builder)DeploymentController.builder().applyMutation(deploymentController)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder enableECSManagedTags(Boolean var1);

        public Builder propagateTags(String var1);

        public Builder propagateTags(PropagateTags var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

