/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EFSVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EFSVolumeConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EFSVolumeConfiguration.getter(EFSVolumeConfiguration::fileSystemId)).setter(EFSVolumeConfiguration.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemId").build()}).build();
    private static final SdkField<String> ROOT_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EFSVolumeConfiguration.getter(EFSVolumeConfiguration::rootDirectory)).setter(EFSVolumeConfiguration.setter(Builder::rootDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDirectory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, ROOT_DIRECTORY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileSystemId;
    private final String rootDirectory;

    private EFSVolumeConfiguration(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.rootDirectory = builder.rootDirectory;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public String rootDirectory() {
        return this.rootDirectory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDirectory());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EFSVolumeConfiguration)) {
            return false;
        }
        EFSVolumeConfiguration other = (EFSVolumeConfiguration)obj;
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.rootDirectory(), other.rootDirectory());
    }

    public String toString() {
        return ToString.builder((String)"EFSVolumeConfiguration").add("FileSystemId", (Object)this.fileSystemId()).add("RootDirectory", (Object)this.rootDirectory()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "rootDirectory": {
                return Optional.ofNullable(clazz.cast(this.rootDirectory()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EFSVolumeConfiguration, T> g) {
        return obj -> g.apply((EFSVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String rootDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(EFSVolumeConfiguration model) {
            this.fileSystemId(model.fileSystemId);
            this.rootDirectory(model.rootDirectory);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getRootDirectory() {
            return this.rootDirectory;
        }

        @Override
        public final Builder rootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public final void setRootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
        }

        public EFSVolumeConfiguration build() {
            return new EFSVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EFSVolumeConfiguration> {
        public Builder fileSystemId(String var1);

        public Builder rootDirectory(String var1);
    }
}

