/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.GpuIdsCopier;
import software.amazon.awssdk.services.ecs.model.HealthStatus;
import software.amazon.awssdk.services.ecs.model.NetworkBinding;
import software.amazon.awssdk.services.ecs.model.NetworkBindingsCopier;
import software.amazon.awssdk.services.ecs.model.NetworkInterface;
import software.amazon.awssdk.services.ecs.model.NetworkInterfacesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Container
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Container> {
    private static final SdkField<String> CONTAINER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::containerArn)).setter(Container.setter(Builder::containerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerArn").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::taskArn)).setter(Container.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::name)).setter(Container.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::image)).setter(Container.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::imageDigest)).setter(Container.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final SdkField<String> RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::runtimeId)).setter(Container.setter(Builder::runtimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeId").build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::lastStatus)).setter(Container.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Container.getter(Container::exitCode)).setter(Container.setter(Builder::exitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::reason)).setter(Container.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<List<NetworkBinding>> NETWORK_BINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Container.getter(Container::networkBindings)).setter(Container.setter(Builder::networkBindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkBindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkBinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Container.getter(Container::networkInterfaces)).setter(Container.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::healthStatusAsString)).setter(Container.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::cpu)).setter(Container.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::memory)).setter(Container.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<String> MEMORY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::memoryReservation)).setter(Container.setter(Builder::memoryReservation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryReservation").build()}).build();
    private static final SdkField<List<String>> GPU_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Container.getter(Container::gpuIds)).setter(Container.setter(Builder::gpuIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gpuIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_ARN_FIELD, TASK_ARN_FIELD, NAME_FIELD, IMAGE_FIELD, IMAGE_DIGEST_FIELD, RUNTIME_ID_FIELD, LAST_STATUS_FIELD, EXIT_CODE_FIELD, REASON_FIELD, NETWORK_BINDINGS_FIELD, NETWORK_INTERFACES_FIELD, HEALTH_STATUS_FIELD, CPU_FIELD, MEMORY_FIELD, MEMORY_RESERVATION_FIELD, GPU_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerArn;
    private final String taskArn;
    private final String name;
    private final String image;
    private final String imageDigest;
    private final String runtimeId;
    private final String lastStatus;
    private final Integer exitCode;
    private final String reason;
    private final List<NetworkBinding> networkBindings;
    private final List<NetworkInterface> networkInterfaces;
    private final String healthStatus;
    private final String cpu;
    private final String memory;
    private final String memoryReservation;
    private final List<String> gpuIds;

    private Container(BuilderImpl builder) {
        this.containerArn = builder.containerArn;
        this.taskArn = builder.taskArn;
        this.name = builder.name;
        this.image = builder.image;
        this.imageDigest = builder.imageDigest;
        this.runtimeId = builder.runtimeId;
        this.lastStatus = builder.lastStatus;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.networkBindings = builder.networkBindings;
        this.networkInterfaces = builder.networkInterfaces;
        this.healthStatus = builder.healthStatus;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.memoryReservation = builder.memoryReservation;
        this.gpuIds = builder.gpuIds;
    }

    public String containerArn() {
        return this.containerArn;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String name() {
        return this.name;
    }

    public String image() {
        return this.image;
    }

    public String imageDigest() {
        return this.imageDigest;
    }

    public String runtimeId() {
        return this.runtimeId;
    }

    public String lastStatus() {
        return this.lastStatus;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public String reason() {
        return this.reason;
    }

    public boolean hasNetworkBindings() {
        return this.networkBindings != null && !(this.networkBindings instanceof SdkAutoConstructList);
    }

    public List<NetworkBinding> networkBindings() {
        return this.networkBindings;
    }

    public boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public HealthStatus healthStatus() {
        return HealthStatus.fromValue(this.healthStatus);
    }

    public String healthStatusAsString() {
        return this.healthStatus;
    }

    public String cpu() {
        return this.cpu;
    }

    public String memory() {
        return this.memory;
    }

    public String memoryReservation() {
        return this.memoryReservation;
    }

    public boolean hasGpuIds() {
        return this.gpuIds != null && !(this.gpuIds instanceof SdkAutoConstructList);
    }

    public List<String> gpuIds() {
        return this.gpuIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.gpuIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        return Objects.equals(this.containerArn(), other.containerArn()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.runtimeId(), other.runtimeId()) && Objects.equals(this.lastStatus(), other.lastStatus()) && Objects.equals(this.exitCode(), other.exitCode()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.networkBindings(), other.networkBindings()) && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.memoryReservation(), other.memoryReservation()) && Objects.equals(this.gpuIds(), other.gpuIds());
    }

    public String toString() {
        return ToString.builder((String)"Container").add("ContainerArn", (Object)this.containerArn()).add("TaskArn", (Object)this.taskArn()).add("Name", (Object)this.name()).add("Image", (Object)this.image()).add("ImageDigest", (Object)this.imageDigest()).add("RuntimeId", (Object)this.runtimeId()).add("LastStatus", (Object)this.lastStatus()).add("ExitCode", (Object)this.exitCode()).add("Reason", (Object)this.reason()).add("NetworkBindings", this.networkBindings()).add("NetworkInterfaces", this.networkInterfaces()).add("HealthStatus", (Object)this.healthStatusAsString()).add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("MemoryReservation", (Object)this.memoryReservation()).add("GpuIds", this.gpuIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerArn": {
                return Optional.ofNullable(clazz.cast(this.containerArn()));
            }
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "runtimeId": {
                return Optional.ofNullable(clazz.cast(this.runtimeId()));
            }
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatus()));
            }
            case "exitCode": {
                return Optional.ofNullable(clazz.cast(this.exitCode()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "networkBindings": {
                return Optional.ofNullable(clazz.cast(this.networkBindings()));
            }
            case "networkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "healthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "memoryReservation": {
                return Optional.ofNullable(clazz.cast(this.memoryReservation()));
            }
            case "gpuIds": {
                return Optional.ofNullable(clazz.cast(this.gpuIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Container, T> g) {
        return obj -> g.apply((Container)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerArn;
        private String taskArn;
        private String name;
        private String image;
        private String imageDigest;
        private String runtimeId;
        private String lastStatus;
        private Integer exitCode;
        private String reason;
        private List<NetworkBinding> networkBindings = DefaultSdkAutoConstructList.getInstance();
        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String healthStatus;
        private String cpu;
        private String memory;
        private String memoryReservation;
        private List<String> gpuIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            this.containerArn(model.containerArn);
            this.taskArn(model.taskArn);
            this.name(model.name);
            this.image(model.image);
            this.imageDigest(model.imageDigest);
            this.runtimeId(model.runtimeId);
            this.lastStatus(model.lastStatus);
            this.exitCode(model.exitCode);
            this.reason(model.reason);
            this.networkBindings(model.networkBindings);
            this.networkInterfaces(model.networkInterfaces);
            this.healthStatus(model.healthStatus);
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.memoryReservation(model.memoryReservation);
            this.gpuIds(model.gpuIds);
        }

        public final String getContainerArn() {
            return this.containerArn;
        }

        @Override
        public final Builder containerArn(String containerArn) {
            this.containerArn = containerArn;
            return this;
        }

        public final void setContainerArn(String containerArn) {
            this.containerArn = containerArn;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final String getRuntimeId() {
            return this.runtimeId;
        }

        @Override
        public final Builder runtimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public final void setRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Collection<NetworkBinding.Builder> getNetworkBindings() {
            return this.networkBindings != null ? (Collection)this.networkBindings.stream().map(NetworkBinding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkBindings(Collection<NetworkBinding> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copy(networkBindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(NetworkBinding ... networkBindings) {
            this.networkBindings(Arrays.asList(networkBindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(Consumer<NetworkBinding.Builder> ... networkBindings) {
            this.networkBindings(Stream.of(networkBindings).map(c -> (NetworkBinding)((NetworkBinding.Builder)NetworkBinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkBindings(Collection<NetworkBinding.BuilderImpl> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copyFromBuilder(networkBindings);
        }

        public final Collection<NetworkInterface.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(NetworkInterface::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getHealthStatusAsString() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final String getCpu() {
            return this.cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public final String getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        public final String getMemoryReservation() {
            return this.memoryReservation;
        }

        @Override
        public final Builder memoryReservation(String memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public final void setMemoryReservation(String memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        public final Collection<String> getGpuIds() {
            return this.gpuIds;
        }

        @Override
        public final Builder gpuIds(Collection<String> gpuIds) {
            this.gpuIds = GpuIdsCopier.copy(gpuIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gpuIds(String ... gpuIds) {
            this.gpuIds(Arrays.asList(gpuIds));
            return this;
        }

        public final void setGpuIds(Collection<String> gpuIds) {
            this.gpuIds = GpuIdsCopier.copy(gpuIds);
        }

        public Container build() {
            return new Container(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Container> {
        public Builder containerArn(String var1);

        public Builder taskArn(String var1);

        public Builder name(String var1);

        public Builder image(String var1);

        public Builder imageDigest(String var1);

        public Builder runtimeId(String var1);

        public Builder lastStatus(String var1);

        public Builder exitCode(Integer var1);

        public Builder reason(String var1);

        public Builder networkBindings(Collection<NetworkBinding> var1);

        public Builder networkBindings(NetworkBinding ... var1);

        public Builder networkBindings(Consumer<NetworkBinding.Builder> ... var1);

        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(HealthStatus var1);

        public Builder cpu(String var1);

        public Builder memory(String var1);

        public Builder memoryReservation(String var1);

        public Builder gpuIds(Collection<String> var1);

        public Builder gpuIds(String ... var1);
    }
}

