/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.TransportProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortMapping> {
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PortMapping.getter(PortMapping::containerPort)).setter(PortMapping.setter(Builder::containerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()}).build();
    private static final SdkField<Integer> HOST_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PortMapping.getter(PortMapping::hostPort)).setter(PortMapping.setter(Builder::hostPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PortMapping.getter(PortMapping::protocolAsString)).setter(PortMapping.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PORT_FIELD, HOST_PORT_FIELD, PROTOCOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer containerPort;
    private final Integer hostPort;
    private final String protocol;

    private PortMapping(BuilderImpl builder) {
        this.containerPort = builder.containerPort;
        this.hostPort = builder.hostPort;
        this.protocol = builder.protocol;
    }

    public Integer containerPort() {
        return this.containerPort;
    }

    public Integer hostPort() {
        return this.hostPort;
    }

    public TransportProtocol protocol() {
        return TransportProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortMapping)) {
            return false;
        }
        PortMapping other = (PortMapping)obj;
        return Objects.equals(this.containerPort(), other.containerPort()) && Objects.equals(this.hostPort(), other.hostPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public String toString() {
        return ToString.builder((String)"PortMapping").add("ContainerPort", (Object)this.containerPort()).add("HostPort", (Object)this.hostPort()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerPort": {
                return Optional.ofNullable(clazz.cast(this.containerPort()));
            }
            case "hostPort": {
                return Optional.ofNullable(clazz.cast(this.hostPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortMapping, T> g) {
        return obj -> g.apply((PortMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer containerPort;
        private Integer hostPort;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(PortMapping model) {
            this.containerPort(model.containerPort);
            this.hostPort(model.hostPort);
            this.protocol(model.protocol);
        }

        public final Integer getContainerPort() {
            return this.containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        public final Integer getHostPort() {
            return this.hostPort;
        }

        @Override
        public final Builder hostPort(Integer hostPort) {
            this.hostPort = hostPort;
            return this;
        }

        public final void setHostPort(Integer hostPort) {
            this.hostPort = hostPort;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TransportProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public PortMapping build() {
            return new PortMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortMapping> {
        public Builder containerPort(Integer var1);

        public Builder hostPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(TransportProtocol var1);
    }
}

