/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a change in state for a task attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachmentStateChange implements SdkPojo, Serializable,
        ToCopyableBuilder<AttachmentStateChange.Builder, AttachmentStateChange> {
    private static final SdkField<String> ATTACHMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachmentStateChange::attachmentArn)).setter(setter(Builder::attachmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachmentStateChange::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ARN_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachmentArn;

    private final String status;

    private AttachmentStateChange(BuilderImpl builder) {
        this.attachmentArn = builder.attachmentArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the attachment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the attachment.
     */
    public String attachmentArn() {
        return attachmentArn;
    }

    /**
     * <p>
     * The status of the attachment.
     * </p>
     * 
     * @return The status of the attachment.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentStateChange)) {
            return false;
        }
        AttachmentStateChange other = (AttachmentStateChange) obj;
        return Objects.equals(attachmentArn(), other.attachmentArn()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttachmentStateChange").add("AttachmentArn", attachmentArn()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentArn":
            return Optional.ofNullable(clazz.cast(attachmentArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachmentStateChange, T> g) {
        return obj -> g.apply((AttachmentStateChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachmentStateChange> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the attachment.
         * </p>
         * 
         * @param attachmentArn
         *        The Amazon Resource Name (ARN) of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentArn(String attachmentArn);

        /**
         * <p>
         * The status of the attachment.
         * </p>
         * 
         * @param status
         *        The status of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentStateChange model) {
            attachmentArn(model.attachmentArn);
            status(model.status);
        }

        public final String getAttachmentArn() {
            return attachmentArn;
        }

        @Override
        public final Builder attachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
            return this;
        }

        public final void setAttachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public AttachmentStateChange build() {
            return new AttachmentStateChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
