/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container definitions are used in task definitions to describe the different containers that are launched as part of
 * a task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerDefinition.Builder, ContainerDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<RepositoryCredentials> REPOSITORY_CREDENTIALS_FIELD = SdkField
            .<RepositoryCredentials> builder(MarshallingType.SDK_POJO).getter(getter(ContainerDefinition::repositoryCredentials))
            .setter(setter(Builder::repositoryCredentials)).constructor(RepositoryCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCredentials").build())
            .build();

    private static final SdkField<Integer> CPU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ContainerDefinition::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<Integer> MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ContainerDefinition::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<Integer> MEMORY_RESERVATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ContainerDefinition::memoryReservation)).setter(setter(Builder::memoryReservation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryReservation").build()).build();

    private static final SdkField<List<String>> LINKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::links))
            .setter(setter(Builder::links))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("links").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PortMapping>> PORT_MAPPINGS_FIELD = SdkField
            .<List<PortMapping>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::portMappings))
            .setter(setter(Builder::portMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ESSENTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ContainerDefinition::essential)).setter(setter(Builder::essential))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("essential").build()).build();

    private static final SdkField<List<String>> ENTRY_POINT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::entryPoint))
            .setter(setter(Builder::entryPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> COMMAND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::command))
            .setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KeyValuePair>> ENVIRONMENT_FIELD = SdkField
            .<List<KeyValuePair>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EnvironmentFile>> ENVIRONMENT_FILES_FIELD = SdkField
            .<List<EnvironmentFile>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::environmentFiles))
            .setter(setter(Builder::environmentFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentFiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentFile> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentFile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MountPoint>> MOUNT_POINTS_FIELD = SdkField
            .<List<MountPoint>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::mountPoints))
            .setter(setter(Builder::mountPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MountPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(MountPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VolumeFrom>> VOLUMES_FROM_FIELD = SdkField
            .<List<VolumeFrom>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::volumesFrom))
            .setter(setter(Builder::volumesFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumesFrom").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeFrom> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeFrom::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LinuxParameters> LINUX_PARAMETERS_FIELD = SdkField
            .<LinuxParameters> builder(MarshallingType.SDK_POJO).getter(getter(ContainerDefinition::linuxParameters))
            .setter(setter(Builder::linuxParameters)).constructor(LinuxParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linuxParameters").build()).build();

    private static final SdkField<List<Secret>> SECRETS_FIELD = SdkField
            .<List<Secret>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::secrets))
            .setter(setter(Builder::secrets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secrets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Secret> builder(MarshallingType.SDK_POJO)
                                            .constructor(Secret::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContainerDependency>> DEPENDS_ON_FIELD = SdkField
            .<List<ContainerDependency>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::dependsOn))
            .setter(setter(Builder::dependsOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerDependency> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerDependency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> START_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ContainerDefinition::startTimeout)).setter(setter(Builder::startTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeout").build()).build();

    private static final SdkField<Integer> STOP_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ContainerDefinition::stopTimeout)).setter(setter(Builder::stopTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTimeout").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::workingDirectory)).setter(setter(Builder::workingDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workingDirectory").build()).build();

    private static final SdkField<Boolean> DISABLE_NETWORKING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ContainerDefinition::disableNetworking)).setter(setter(Builder::disableNetworking))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableNetworking").build()).build();

    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ContainerDefinition::privileged)).setter(setter(Builder::privileged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privileged").build()).build();

    private static final SdkField<Boolean> READONLY_ROOT_FILESYSTEM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ContainerDefinition::readonlyRootFilesystem)).setter(setter(Builder::readonlyRootFilesystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readonlyRootFilesystem").build())
            .build();

    private static final SdkField<List<String>> DNS_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::dnsServers))
            .setter(setter(Builder::dnsServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DNS_SEARCH_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::dnsSearchDomains))
            .setter(setter(Builder::dnsSearchDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsSearchDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HostEntry>> EXTRA_HOSTS_FIELD = SdkField
            .<List<HostEntry>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::extraHosts))
            .setter(setter(Builder::extraHosts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraHosts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HostEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(HostEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DOCKER_SECURITY_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::dockerSecurityOptions))
            .setter(setter(Builder::dockerSecurityOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerSecurityOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INTERACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ContainerDefinition::interactive)).setter(setter(Builder::interactive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactive").build()).build();

    private static final SdkField<Boolean> PSEUDO_TERMINAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ContainerDefinition::pseudoTerminal)).setter(setter(Builder::pseudoTerminal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pseudoTerminal").build()).build();

    private static final SdkField<Map<String, String>> DOCKER_LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ContainerDefinition::dockerLabels))
            .setter(setter(Builder::dockerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerLabels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Ulimit>> ULIMITS_FIELD = SdkField
            .<List<Ulimit>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::ulimits))
            .setter(setter(Builder::ulimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ulimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ulimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ulimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(ContainerDefinition::logConfiguration))
            .setter(setter(Builder::logConfiguration)).constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final SdkField<HealthCheck> HEALTH_CHECK_FIELD = SdkField.<HealthCheck> builder(MarshallingType.SDK_POJO)
            .getter(getter(ContainerDefinition::healthCheck)).setter(setter(Builder::healthCheck))
            .constructor(HealthCheck::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()).build();

    private static final SdkField<List<SystemControl>> SYSTEM_CONTROLS_FIELD = SdkField
            .<List<SystemControl>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::systemControls))
            .setter(setter(Builder::systemControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SystemControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(SystemControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField
            .<List<ResourceRequirement>> builder(MarshallingType.LIST)
            .getter(getter(ContainerDefinition::resourceRequirements))
            .setter(setter(Builder::resourceRequirements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRequirements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceRequirement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceRequirement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FirelensConfiguration> FIRELENS_CONFIGURATION_FIELD = SdkField
            .<FirelensConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(ContainerDefinition::firelensConfiguration))
            .setter(setter(Builder::firelensConfiguration)).constructor(FirelensConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firelensConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_FIELD,
            REPOSITORY_CREDENTIALS_FIELD, CPU_FIELD, MEMORY_FIELD, MEMORY_RESERVATION_FIELD, LINKS_FIELD, PORT_MAPPINGS_FIELD,
            ESSENTIAL_FIELD, ENTRY_POINT_FIELD, COMMAND_FIELD, ENVIRONMENT_FIELD, ENVIRONMENT_FILES_FIELD, MOUNT_POINTS_FIELD,
            VOLUMES_FROM_FIELD, LINUX_PARAMETERS_FIELD, SECRETS_FIELD, DEPENDS_ON_FIELD, START_TIMEOUT_FIELD, STOP_TIMEOUT_FIELD,
            HOSTNAME_FIELD, USER_FIELD, WORKING_DIRECTORY_FIELD, DISABLE_NETWORKING_FIELD, PRIVILEGED_FIELD,
            READONLY_ROOT_FILESYSTEM_FIELD, DNS_SERVERS_FIELD, DNS_SEARCH_DOMAINS_FIELD, EXTRA_HOSTS_FIELD,
            DOCKER_SECURITY_OPTIONS_FIELD, INTERACTIVE_FIELD, PSEUDO_TERMINAL_FIELD, DOCKER_LABELS_FIELD, ULIMITS_FIELD,
            LOG_CONFIGURATION_FIELD, HEALTH_CHECK_FIELD, SYSTEM_CONTROLS_FIELD, RESOURCE_REQUIREMENTS_FIELD,
            FIRELENS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String image;

    private final RepositoryCredentials repositoryCredentials;

    private final Integer cpu;

    private final Integer memory;

    private final Integer memoryReservation;

    private final List<String> links;

    private final List<PortMapping> portMappings;

    private final Boolean essential;

    private final List<String> entryPoint;

    private final List<String> command;

    private final List<KeyValuePair> environment;

    private final List<EnvironmentFile> environmentFiles;

    private final List<MountPoint> mountPoints;

    private final List<VolumeFrom> volumesFrom;

    private final LinuxParameters linuxParameters;

    private final List<Secret> secrets;

    private final List<ContainerDependency> dependsOn;

    private final Integer startTimeout;

    private final Integer stopTimeout;

    private final String hostname;

    private final String user;

    private final String workingDirectory;

    private final Boolean disableNetworking;

    private final Boolean privileged;

    private final Boolean readonlyRootFilesystem;

    private final List<String> dnsServers;

    private final List<String> dnsSearchDomains;

    private final List<HostEntry> extraHosts;

    private final List<String> dockerSecurityOptions;

    private final Boolean interactive;

    private final Boolean pseudoTerminal;

    private final Map<String, String> dockerLabels;

    private final List<Ulimit> ulimits;

    private final LogConfiguration logConfiguration;

    private final HealthCheck healthCheck;

    private final List<SystemControl> systemControls;

    private final List<ResourceRequirement> resourceRequirements;

    private final FirelensConfiguration firelensConfiguration;

    private ContainerDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.image = builder.image;
        this.repositoryCredentials = builder.repositoryCredentials;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.memoryReservation = builder.memoryReservation;
        this.links = builder.links;
        this.portMappings = builder.portMappings;
        this.essential = builder.essential;
        this.entryPoint = builder.entryPoint;
        this.command = builder.command;
        this.environment = builder.environment;
        this.environmentFiles = builder.environmentFiles;
        this.mountPoints = builder.mountPoints;
        this.volumesFrom = builder.volumesFrom;
        this.linuxParameters = builder.linuxParameters;
        this.secrets = builder.secrets;
        this.dependsOn = builder.dependsOn;
        this.startTimeout = builder.startTimeout;
        this.stopTimeout = builder.stopTimeout;
        this.hostname = builder.hostname;
        this.user = builder.user;
        this.workingDirectory = builder.workingDirectory;
        this.disableNetworking = builder.disableNetworking;
        this.privileged = builder.privileged;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.dnsServers = builder.dnsServers;
        this.dnsSearchDomains = builder.dnsSearchDomains;
        this.extraHosts = builder.extraHosts;
        this.dockerSecurityOptions = builder.dockerSecurityOptions;
        this.interactive = builder.interactive;
        this.pseudoTerminal = builder.pseudoTerminal;
        this.dockerLabels = builder.dockerLabels;
        this.ulimits = builder.ulimits;
        this.logConfiguration = builder.logConfiguration;
        this.healthCheck = builder.healthCheck;
        this.systemControls = builder.systemControls;
        this.resourceRequirements = builder.resourceRequirements;
        this.firelensConfiguration = builder.firelensConfiguration;
    }

    /**
     * <p>
     * The name of a container. If you are linking multiple containers together in a task definition, the
     * <code>name</code> of one container can be entered in the <code>links</code> of another container to connect the
     * containers. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed. This parameter maps to
     * <code>name</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a
     * container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     * <code>--name</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * 
     * @return The name of a container. If you are linking multiple containers together in a task definition, the
     *         <code>name</code> of one container can be entered in the <code>links</code> of another container to
     *         connect the containers. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed.
     *         This parameter maps to <code>name</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--name</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker
     * Hub registry are available by default. Other repositories are specified with either
     * <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code> or
     * <code> <i>repository-url</i>/<i>image</i>@<i>digest</i> </code>. Up to 255 letters (uppercase and lowercase),
     * numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter
     * maps to <code>Image</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>IMAGE</code> parameter of
     * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image and tag
     * for the container to use. However, subsequent updates to a repository image are not propagated to already running
     * tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * Images in Amazon ECR repositories can be specified by either using the full <code>registry/repository:tag</code>
     * or <code>registry/repository@digest</code>. For example,
     * <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;:latest</code> or
     * <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or
     * <code>mongo</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Images in other repositories on Docker Hub are qualified with an organization name (for example,
     * <code>amazon/amazon-ecs-agent</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Images in other online repositories are qualified further by a domain name (for example,
     * <code>quay.io/assemblyline/ubuntu</code>).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The image used to start a container. This string is passed directly to the Docker daemon. Images in the
     *         Docker Hub registry are available by default. Other repositories are specified with either
     *         <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code> or
     *         <code> <i>repository-url</i>/<i>image</i>@<i>digest</i> </code>. Up to 255 letters (uppercase and
     *         lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are
     *         allowed. This parameter maps to <code>Image</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>IMAGE</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image
     *         and tag for the container to use. However, subsequent updates to a repository image are not propagated to
     *         already running tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Images in Amazon ECR repositories can be specified by either using the full
     *         <code>registry/repository:tag</code> or <code>registry/repository@digest</code>. For example,
     *         <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;:latest</code> or
     *         <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or
     *         <code>mongo</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Images in other repositories on Docker Hub are qualified with an organization name (for example,
     *         <code>amazon/amazon-ecs-agent</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Images in other online repositories are qualified further by a domain name (for example,
     *         <code>quay.io/assemblyline/ubuntu</code>).
     *         </p>
     *         </li>
     */
    public String image() {
        return image;
    }

    /**
     * <p>
     * The private repository authentication credentials to use.
     * </p>
     * 
     * @return The private repository authentication credentials to use.
     */
    public RepositoryCredentials repositoryCredentials() {
        return repositoryCredentials;
    }

    /**
     * <p>
     * The number of <code>cpu</code> units reserved for the container. This parameter maps to <code>CpuShares</code> in
     * the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     * of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     * <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <p>
     * This field is optional for tasks using the Fargate launch type, and the only requirement is that the total amount
     * of CPU reserved for all containers within a task be lower than the task-level <code>cpu</code> value.
     * </p>
     * <note>
     * <p>
     * You can determine the number of CPU units that are available per EC2 instance type by multiplying the vCPUs
     * listed for that instance type on the <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instances</a>
     * detail page by 1,024.
     * </p>
     * </note>
     * <p>
     * Linux containers share unallocated CPU units with other containers on the container instance with the same ratio
     * as their allocated amount. For example, if you run a single-container task on a single-core instance type with
     * 512 CPU units specified for that container, and that is the only task running on the container instance, that
     * container could use the full 1,024 CPU unit share at any given time. However, if you launched another copy of the
     * same task on that container instance, each task would be guaranteed a minimum of 512 CPU units when needed, and
     * each container could float to higher CPU usage if the other container was not using it, but if both tasks were
     * 100% active all of the time, they would be limited to 512 CPU units.
     * </p>
     * <p>
     * On Linux container instances, the Docker daemon on the container instance uses the CPU value to calculate the
     * relative CPU share ratios for running containers. For more information, see <a
     * href="https://docs.docker.com/engine/reference/run/#cpu-share-constraint">CPU share constraint</a> in the Docker
     * documentation. The minimum valid CPU share value that the Linux kernel allows is 2. However, the CPU parameter is
     * not required, and you can use CPU values below 2 in your container definitions. For CPU values below 2 (including
     * null), the behavior varies based on your Amazon ECS container agent version:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Agent versions less than or equal to 1.1.0:</b> Null and zero CPU values are passed to Docker as 0, which
     * Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux kernel
     * converts to two CPU shares.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Agent versions greater than or equal to 1.2.0:</b> Null, zero, and CPU values of 1 are passed to Docker as 2.
     * </p>
     * </li>
     * </ul>
     * <p>
     * On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows containers
     * only have access to the specified amount of CPU that is described in the task definition.
     * </p>
     * 
     * @return The number of <code>cpu</code> units reserved for the container. This parameter maps to
     *         <code>CpuShares</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p>
     *         <p>
     *         This field is optional for tasks using the Fargate launch type, and the only requirement is that the
     *         total amount of CPU reserved for all containers within a task be lower than the task-level
     *         <code>cpu</code> value.
     *         </p>
     *         <note>
     *         <p>
     *         You can determine the number of CPU units that are available per EC2 instance type by multiplying the
     *         vCPUs listed for that instance type on the <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     *         Instances</a> detail page by 1,024.
     *         </p>
     *         </note>
     *         <p>
     *         Linux containers share unallocated CPU units with other containers on the container instance with the
     *         same ratio as their allocated amount. For example, if you run a single-container task on a single-core
     *         instance type with 512 CPU units specified for that container, and that is the only task running on the
     *         container instance, that container could use the full 1,024 CPU unit share at any given time. However, if
     *         you launched another copy of the same task on that container instance, each task would be guaranteed a
     *         minimum of 512 CPU units when needed, and each container could float to higher CPU usage if the other
     *         container was not using it, but if both tasks were 100% active all of the time, they would be limited to
     *         512 CPU units.
     *         </p>
     *         <p>
     *         On Linux container instances, the Docker daemon on the container instance uses the CPU value to calculate
     *         the relative CPU share ratios for running containers. For more information, see <a
     *         href="https://docs.docker.com/engine/reference/run/#cpu-share-constraint">CPU share constraint</a> in the
     *         Docker documentation. The minimum valid CPU share value that the Linux kernel allows is 2. However, the
     *         CPU parameter is not required, and you can use CPU values below 2 in your container definitions. For CPU
     *         values below 2 (including null), the behavior varies based on your Amazon ECS container agent version:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Agent versions less than or equal to 1.1.0:</b> Null and zero CPU values are passed to Docker as 0,
     *         which Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the
     *         Linux kernel converts to two CPU shares.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Agent versions greater than or equal to 1.2.0:</b> Null, zero, and CPU values of 1 are passed to
     *         Docker as 2.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows
     *         containers only have access to the specified amount of CPU that is described in the task definition.
     */
    public Integer cpu() {
        return cpu;
    }

    /**
     * <p>
     * The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory
     * specified here, the container is killed. The total amount of memory reserved for all containers within a task
     * must be lower than the task <code>memory</code> value, if one is specified. This parameter maps to
     * <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a
     * container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     * <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <p>
     * If using the Fargate launch type, this parameter is optional.
     * </p>
     * <p>
     * If using the EC2 launch type, you must specify either a task-level memory value or a container-level memory
     * value. If you specify both a container-level <code>memory</code> and <code>memoryReservation</code> value,
     * <code>memory</code> must be greater than <code>memoryReservation</code>. If you specify
     * <code>memoryReservation</code>, then that value is subtracted from the available memory resources for the
     * container instance on which the container is placed. Otherwise, the value of <code>memory</code> is used.
     * </p>
     * <p>
     * The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer than 4
     * MiB of memory for your containers.
     * </p>
     * 
     * @return The amount (in MiB) of memory to present to the container. If your container attempts to exceed the
     *         memory specified here, the container is killed. The total amount of memory reserved for all containers
     *         within a task must be lower than the task <code>memory</code> value, if one is specified. This parameter
     *         maps to <code>Memory</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p>
     *         <p>
     *         If using the Fargate launch type, this parameter is optional.
     *         </p>
     *         <p>
     *         If using the EC2 launch type, you must specify either a task-level memory value or a container-level
     *         memory value. If you specify both a container-level <code>memory</code> and
     *         <code>memoryReservation</code> value, <code>memory</code> must be greater than
     *         <code>memoryReservation</code>. If you specify <code>memoryReservation</code>, then that value is
     *         subtracted from the available memory resources for the container instance on which the container is
     *         placed. Otherwise, the value of <code>memory</code> is used.
     *         </p>
     *         <p>
     *         The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer
     *         than 4 MiB of memory for your containers.
     */
    public Integer memory() {
        return memory;
    }

    /**
     * <p>
     * The soft limit (in MiB) of memory to reserve for the container. When system memory is under heavy contention,
     * Docker attempts to keep the container memory to this soft limit. However, your container can consume more memory
     * when it needs to, up to either the hard limit specified with the <code>memory</code> parameter (if applicable),
     * or all of the available memory on the container instance, whichever comes first. This parameter maps to
     * <code>MemoryReservation</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     * <code>--memory-reservation</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     * run</a>.
     * </p>
     * <p>
     * If a task-level memory value is not specified, you must specify a non-zero integer for one or both of
     * <code>memory</code> or <code>memoryReservation</code> in a container definition. If you specify both,
     * <code>memory</code> must be greater than <code>memoryReservation</code>. If you specify
     * <code>memoryReservation</code>, then that value is subtracted from the available memory resources for the
     * container instance on which the container is placed. Otherwise, the value of <code>memory</code> is used.
     * </p>
     * <p>
     * For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of memory for
     * short periods of time, you can set a <code>memoryReservation</code> of 128 MiB, and a <code>memory</code> hard
     * limit of 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory from the
     * remaining resources on the container instance, but also allow the container to consume more memory resources when
     * needed.
     * </p>
     * <p>
     * The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer than 4
     * MiB of memory for your containers.
     * </p>
     * 
     * @return The soft limit (in MiB) of memory to reserve for the container. When system memory is under heavy
     *         contention, Docker attempts to keep the container memory to this soft limit. However, your container can
     *         consume more memory when it needs to, up to either the hard limit specified with the <code>memory</code>
     *         parameter (if applicable), or all of the available memory on the container instance, whichever comes
     *         first. This parameter maps to <code>MemoryReservation</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--memory-reservation</code> option to <a
     *         href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>
     *         <p>
     *         If a task-level memory value is not specified, you must specify a non-zero integer for one or both of
     *         <code>memory</code> or <code>memoryReservation</code> in a container definition. If you specify both,
     *         <code>memory</code> must be greater than <code>memoryReservation</code>. If you specify
     *         <code>memoryReservation</code>, then that value is subtracted from the available memory resources for the
     *         container instance on which the container is placed. Otherwise, the value of <code>memory</code> is used.
     *         </p>
     *         <p>
     *         For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of
     *         memory for short periods of time, you can set a <code>memoryReservation</code> of 128 MiB, and a
     *         <code>memory</code> hard limit of 300 MiB. This configuration would allow the container to only reserve
     *         128 MiB of memory from the remaining resources on the container instance, but also allow the container to
     *         consume more memory resources when needed.
     *         </p>
     *         <p>
     *         The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer
     *         than 4 MiB of memory for your containers.
     */
    public Integer memoryReservation() {
        return memoryReservation;
    }

    /**
     * Returns true if the Links property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLinks() {
        return links != null && !(links instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>links</code> parameter allows containers to communicate with each other without the need for port
     * mappings. This parameter is only supported if the network mode of a task definition is <code>bridge</code>. The
     * <code>name:internalName</code> construct is analogous to <code>name:alias</code> in Docker links. Up to 255
     * letters (uppercase and lowercase), numbers, and hyphens are allowed. For more information about linking Docker
     * containers, go to <a href="https://docs.docker.com/network/links/">Legacy container links</a> in the Docker
     * documentation. This parameter maps to <code>Links</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--link</code> option to
     * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers.
     * </p>
     * </note> <important>
     * <p>
     * Containers that are collocated on a single container instance may be able to communicate with each other without
     * requiring links or host port mappings. Network isolation is achieved on the container instance using security
     * groups and VPC settings.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLinks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The <code>links</code> parameter allows containers to communicate with each other without the need for
     *         port mappings. This parameter is only supported if the network mode of a task definition is
     *         <code>bridge</code>. The <code>name:internalName</code> construct is analogous to <code>name:alias</code>
     *         in Docker links. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed. For more
     *         information about linking Docker containers, go to <a
     *         href="https://docs.docker.com/network/links/">Legacy container links</a> in the Docker documentation.
     *         This parameter maps to <code>Links</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--link</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>
     *         <note>
     *         <p>
     *         This parameter is not supported for Windows containers.
     *         </p>
     *         </note> <important>
     *         <p>
     *         Containers that are collocated on a single container instance may be able to communicate with each other
     *         without requiring links or host port mappings. Network isolation is achieved on the container instance
     *         using security groups and VPC settings.
     *         </p>
     */
    public List<String> links() {
        return links;
    }

    /**
     * Returns true if the PortMappings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPortMappings() {
        return portMappings != null && !(portMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of port mappings for the container. Port mappings allow containers to access ports on the host container
     * instance to send or receive traffic.
     * </p>
     * <p>
     * For task definitions that use the <code>awsvpc</code> network mode, you should only specify the
     * <code>containerPort</code>. The <code>hostPort</code> can be left blank or it must be the same value as the
     * <code>containerPort</code>.
     * </p>
     * <p>
     * Port mappings on Windows use the <code>NetNAT</code> gateway address rather than <code>localhost</code>. There is
     * no loopback for port mappings on Windows, so you cannot access a container's mapped port from the host itself.
     * </p>
     * <p>
     * This parameter maps to <code>PortBindings</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--publish</code> option
     * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. If the network mode of a task
     * definition is set to <code>none</code>, then you can't specify port mappings. If the network mode of a task
     * definition is set to <code>host</code>, then host ports must either be undefined or they must match the container
     * port in the port mapping.
     * </p>
     * <note>
     * <p>
     * After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port assignments
     * are visible in the <b>Network Bindings</b> section of a container description for a selected task in the Amazon
     * ECS console. The assignments are also visible in the <code>networkBindings</code> section <a>DescribeTasks</a>
     * responses.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPortMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of port mappings for the container. Port mappings allow containers to access ports on the host
     *         container instance to send or receive traffic.</p>
     *         <p>
     *         For task definitions that use the <code>awsvpc</code> network mode, you should only specify the
     *         <code>containerPort</code>. The <code>hostPort</code> can be left blank or it must be the same value as
     *         the <code>containerPort</code>.
     *         </p>
     *         <p>
     *         Port mappings on Windows use the <code>NetNAT</code> gateway address rather than <code>localhost</code>.
     *         There is no loopback for port mappings on Windows, so you cannot access a container's mapped port from
     *         the host itself.
     *         </p>
     *         <p>
     *         This parameter maps to <code>PortBindings</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--publish</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     *         If the network mode of a task definition is set to <code>none</code>, then you can't specify port
     *         mappings. If the network mode of a task definition is set to <code>host</code>, then host ports must
     *         either be undefined or they must match the container port in the port mapping.
     *         </p>
     *         <note>
     *         <p>
     *         After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port
     *         assignments are visible in the <b>Network Bindings</b> section of a container description for a selected
     *         task in the Amazon ECS console. The assignments are also visible in the <code>networkBindings</code>
     *         section <a>DescribeTasks</a> responses.
     *         </p>
     */
    public List<PortMapping> portMappings() {
        return portMappings;
    }

    /**
     * <p>
     * If the <code>essential</code> parameter of a container is marked as <code>true</code>, and that container fails
     * or stops for any reason, all other containers that are part of the task are stopped. If the
     * <code>essential</code> parameter of a container is marked as <code>false</code>, then its failure does not affect
     * the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
     * </p>
     * <p>
     * All tasks must have at least one essential container. If you have an application that is composed of multiple
     * containers, you should group containers that are used for a common purpose into components, and separate the
     * different components into multiple task definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application
     * Architecture</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return If the <code>essential</code> parameter of a container is marked as <code>true</code>, and that container
     *         fails or stops for any reason, all other containers that are part of the task are stopped. If the
     *         <code>essential</code> parameter of a container is marked as <code>false</code>, then its failure does
     *         not affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to
     *         be essential.</p>
     *         <p>
     *         All tasks must have at least one essential container. If you have an application that is composed of
     *         multiple containers, you should group containers that are used for a common purpose into components, and
     *         separate the different components into multiple task definitions. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html"
     *         >Application Architecture</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public Boolean essential() {
        return essential;
    }

    /**
     * Returns true if the EntryPoint property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntryPoint() {
        return entryPoint != null && !(entryPoint instanceof SdkAutoConstructList);
    }

    /**
     * <important>
     * <p>
     * Early versions of the Amazon ECS container agent do not properly handle <code>entryPoint</code> parameters. If
     * you have problems using <code>entryPoint</code>, update your container agent or enter your commands and arguments
     * as <code>command</code> array items instead.
     * </p>
     * </important>
     * <p>
     * The entry point that is passed to the container. This parameter maps to <code>Entrypoint</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--entrypoint</code>
     * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more information, see <a
     * href
     * ="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.docker.com/engine/reference/builder
     * /#entrypoint</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntryPoint()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         Early versions of the Amazon ECS container agent do not properly handle <code>entryPoint</code>
     *         parameters. If you have problems using <code>entryPoint</code>, update your container agent or enter your
     *         commands and arguments as <code>command</code> array items instead.
     *         </p>
     *         </important>
     *         <p>
     *         The entry point that is passed to the container. This parameter maps to <code>Entrypoint</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--entrypoint</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>. For more information, see <a
     *         href="https://docs.docker.com/engine/reference/builder/#entrypoint">
     *         https://docs.docker.com/engine/reference/builder/#entrypoint</a>.
     */
    public List<String> entryPoint() {
        return entryPoint;
    }

    /**
     * Returns true if the Command property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCommand() {
        return command != null && !(command instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>COMMAND</code> parameter
     * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more information, see <a
     * href="https://docs.docker.com/engine/reference/builder/#cmd"
     * >https://docs.docker.com/engine/reference/builder/#cmd</a>. If there are multiple arguments, each argument should
     * be a separated string in the array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCommand()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     *         For more information, see <a
     *         href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker
     *         .com/engine/reference/builder/#cmd</a>. If there are multiple arguments, each argument should be a
     *         separated string in the array.
     */
    public List<String> command() {
        return command;
    }

    /**
     * Returns true if the Environment property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--env</code> option to <a
     * href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <important>
     * <p>
     * We do not recommend using plaintext environment variables for sensitive information, such as credential data.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironment()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>
     *         <important>
     *         <p>
     *         We do not recommend using plaintext environment variables for sensitive information, such as credential
     *         data.
     *         </p>
     */
    public List<KeyValuePair> environment() {
        return environment;
    }

    /**
     * Returns true if the EnvironmentFiles property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEnvironmentFiles() {
        return environmentFiles != null && !(environmentFiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of files containing the environment variables to pass to a container. This parameter maps to the
     * <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <p>
     * You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line in
     * an environment file should contain an environment variable in <code>VARIABLE=VALUE</code> format. Lines beginning
     * with <code>#</code> are treated as comments and are ignored. For more information on the environment variable
     * file syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default environment variables in
     * file</a>.
     * </p>
     * <p>
     * If there are environment variables specified using the <code>environment</code> parameter in a container
     * definition, they take precedence over the variables contained within an environment file. If multiple environment
     * files are specified that contain the same variable, they are processed from the top down. It is recommended to
     * use unique variable names. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying Environment
     * Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * This field is not valid for containers in tasks using the Fargate launch type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironmentFiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of files containing the environment variables to pass to a container. This parameter maps to the
     *         <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p>
     *         <p>
     *         You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each
     *         line in an environment file should contain an environment variable in <code>VARIABLE=VALUE</code> format.
     *         Lines beginning with <code>#</code> are treated as comments and are ignored. For more information on the
     *         environment variable file syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default
     *         environment variables in file</a>.
     *         </p>
     *         <p>
     *         If there are environment variables specified using the <code>environment</code> parameter in a container
     *         definition, they take precedence over the variables contained within an environment file. If multiple
     *         environment files are specified that contain the same variable, they are processed from the top down. It
     *         is recommended to use unique variable names. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying
     *         Environment Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         This field is not valid for containers in tasks using the Fargate launch type.
     */
    public List<EnvironmentFile> environmentFiles() {
        return environmentFiles;
    }

    /**
     * Returns true if the MountPoints property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMountPoints() {
        return mountPoints != null && !(mountPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The mount points for data volumes in your container.
     * </p>
     * <p>
     * This parameter maps to <code>Volumes</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volume</code> option to
     * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <p>
     * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>. Windows
     * containers cannot mount directories on a different drive, and mount point cannot be across drives.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMountPoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The mount points for data volumes in your container.</p>
     *         <p>
     *         This parameter maps to <code>Volumes</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     *         </p>
     *         <p>
     *         Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>.
     *         Windows containers cannot mount directories on a different drive, and mount point cannot be across
     *         drives.
     */
    public List<MountPoint> mountPoints() {
        return mountPoints;
    }

    /**
     * Returns true if the VolumesFrom property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVolumesFrom() {
        return volumesFrom != null && !(volumesFrom instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Data volumes to mount from another container. This parameter maps to <code>VolumesFrom</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volumes-from</code>
     * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVolumesFrom()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Data volumes to mount from another container. This parameter maps to <code>VolumesFrom</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--volumes-from</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.
     */
    public List<VolumeFrom> volumesFrom() {
        return volumesFrom;
    }

    /**
     * <p>
     * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more
     * information see <a>KernelCapabilities</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers.
     * </p>
     * </note>
     * 
     * @return Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For
     *         more information see <a>KernelCapabilities</a>.</p> <note>
     *         <p>
     *         This parameter is not supported for Windows containers.
     *         </p>
     */
    public LinuxParameters linuxParameters() {
        return linuxParameters;
    }

    /**
     * Returns true if the Secrets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecrets() {
        return secrets != null && !(secrets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The secrets to pass to the container. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
     * Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecrets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The secrets to pass to the container. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html"
     *         >Specifying Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public List<Secret> secrets() {
        return secrets;
    }

    /**
     * Returns true if the DependsOn property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDependsOn() {
        return dependsOn != null && !(dependsOn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dependencies defined for container startup and shutdown. A container can contain multiple dependencies. When
     * a dependency is defined for container startup, for container shutdown it is reversed.
     * </p>
     * <p>
     * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container
     * agent to enable container dependencies. However, we recommend using the latest container agent version. For
     * information about checking your agent version and updating to the latest version, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
     * Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are using an Amazon
     * ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code> package. If
     * your container instances are launched from version <code>20190301</code> or later, then they contain the required
     * versions of the container agent and <code>ecs-init</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized
     * Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * For tasks using the Fargate launch type, the task or service requires platform version <code>1.3.0</code> or
     * later.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDependsOn()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The dependencies defined for container startup and shutdown. A container can contain multiple
     *         dependencies. When a dependency is defined for container startup, for container shutdown it is
     *         reversed.</p>
     *         <p>
     *         For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the
     *         container agent to enable container dependencies. However, we recommend using the latest container agent
     *         version. For information about checking your agent version and updating to the latest version, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the
     *         Amazon ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
     *         using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
     *         <code>ecs-init</code> package. If your container instances are launched from version
     *         <code>20190301</code> or later, then they contain the required versions of the container agent and
     *         <code>ecs-init</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
     *         ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         For tasks using the Fargate launch type, the task or service requires platform version <code>1.3.0</code>
     *         or later.
     */
    public List<ContainerDependency> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * Time duration (in seconds) to wait before giving up on resolving dependencies for a container. For example, you
     * specify two containers in a task definition with containerA having a dependency on containerB reaching a
     * <code>COMPLETE</code>, <code>SUCCESS</code>, or <code>HEALTHY</code> status. If a <code>startTimeout</code> value
     * is specified for containerB and it does not reach the desired status within that time then containerA will give
     * up and not start. This results in the task transitioning to a <code>STOPPED</code> state.
     * </p>
     * <p>
     * For tasks using the Fargate launch type, this parameter requires that the task or service uses platform version
     * 1.3.0 or later. If this parameter is not specified, the default value of 3 minutes is used.
     * </p>
     * <p>
     * For tasks using the EC2 launch type, if the <code>startTimeout</code> parameter is not specified, the value set
     * for the Amazon ECS container agent configuration variable <code>ECS_CONTAINER_START_TIMEOUT</code> is used by
     * default. If neither the <code>startTimeout</code> parameter or the <code>ECS_CONTAINER_START_TIMEOUT</code> agent
     * configuration variable are set, then the default values of 3 minutes for Linux containers and 8 minutes on
     * Windows containers are used. Your container instances require at least version 1.26.0 of the container agent to
     * enable a container start timeout value. However, we recommend using the latest container agent version. For
     * information about checking your agent version and updating to the latest version, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
     * Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are using an Amazon
     * ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code> package. If
     * your container instances are launched from version <code>20190301</code> or later, then they contain the required
     * versions of the container agent and <code>ecs-init</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized
     * Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return Time duration (in seconds) to wait before giving up on resolving dependencies for a container. For
     *         example, you specify two containers in a task definition with containerA having a dependency on
     *         containerB reaching a <code>COMPLETE</code>, <code>SUCCESS</code>, or <code>HEALTHY</code> status. If a
     *         <code>startTimeout</code> value is specified for containerB and it does not reach the desired status
     *         within that time then containerA will give up and not start. This results in the task transitioning to a
     *         <code>STOPPED</code> state.</p>
     *         <p>
     *         For tasks using the Fargate launch type, this parameter requires that the task or service uses platform
     *         version 1.3.0 or later. If this parameter is not specified, the default value of 3 minutes is used.
     *         </p>
     *         <p>
     *         For tasks using the EC2 launch type, if the <code>startTimeout</code> parameter is not specified, the
     *         value set for the Amazon ECS container agent configuration variable
     *         <code>ECS_CONTAINER_START_TIMEOUT</code> is used by default. If neither the <code>startTimeout</code>
     *         parameter or the <code>ECS_CONTAINER_START_TIMEOUT</code> agent configuration variable are set, then the
     *         default values of 3 minutes for Linux containers and 8 minutes on Windows containers are used. Your
     *         container instances require at least version 1.26.0 of the container agent to enable a container start
     *         timeout value. However, we recommend using the latest container agent version. For information about
     *         checking your agent version and updating to the latest version, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the
     *         Amazon ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
     *         using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
     *         <code>ecs-init</code> package. If your container instances are launched from version
     *         <code>20190301</code> or later, then they contain the required versions of the container agent and
     *         <code>ecs-init</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
     *         ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public Integer startTimeout() {
        return startTimeout;
    }

    /**
     * <p>
     * Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its
     * own.
     * </p>
     * <p>
     * For tasks using the Fargate launch type, the task or service requires platform version 1.3.0 or later. The max
     * stop timeout value is 120 seconds and if the parameter is not specified, the default value of 30 seconds is used.
     * </p>
     * <p>
     * For tasks using the EC2 launch type, if the <code>stopTimeout</code> parameter is not specified, the value set
     * for the Amazon ECS container agent configuration variable <code>ECS_CONTAINER_STOP_TIMEOUT</code> is used by
     * default. If neither the <code>stopTimeout</code> parameter or the <code>ECS_CONTAINER_STOP_TIMEOUT</code> agent
     * configuration variable are set, then the default values of 30 seconds for Linux containers and 30 seconds on
     * Windows containers are used. Your container instances require at least version 1.26.0 of the container agent to
     * enable a container stop timeout value. However, we recommend using the latest container agent version. For
     * information about checking your agent version and updating to the latest version, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
     * Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are using an Amazon
     * ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code> package. If
     * your container instances are launched from version <code>20190301</code> or later, then they contain the required
     * versions of the container agent and <code>ecs-init</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized
     * Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally
     *         on its own.</p>
     *         <p>
     *         For tasks using the Fargate launch type, the task or service requires platform version 1.3.0 or later.
     *         The max stop timeout value is 120 seconds and if the parameter is not specified, the default value of 30
     *         seconds is used.
     *         </p>
     *         <p>
     *         For tasks using the EC2 launch type, if the <code>stopTimeout</code> parameter is not specified, the
     *         value set for the Amazon ECS container agent configuration variable
     *         <code>ECS_CONTAINER_STOP_TIMEOUT</code> is used by default. If neither the <code>stopTimeout</code>
     *         parameter or the <code>ECS_CONTAINER_STOP_TIMEOUT</code> agent configuration variable are set, then the
     *         default values of 30 seconds for Linux containers and 30 seconds on Windows containers are used. Your
     *         container instances require at least version 1.26.0 of the container agent to enable a container stop
     *         timeout value. However, we recommend using the latest container agent version. For information about
     *         checking your agent version and updating to the latest version, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the
     *         Amazon ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
     *         using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
     *         <code>ecs-init</code> package. If your container instances are launched from version
     *         <code>20190301</code> or later, then they contain the required versions of the container agent and
     *         <code>ecs-init</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
     *         ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public Integer stopTimeout() {
        return stopTimeout;
    }

    /**
     * <p>
     * The hostname to use for your container. This parameter maps to <code>Hostname</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--hostname</code> option
     * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * The <code>hostname</code> parameter is not supported if you are using the <code>awsvpc</code> network mode.
     * </p>
     * </note>
     * 
     * @return The hostname to use for your container. This parameter maps to <code>Hostname</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--hostname</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p> <note>
     *         <p>
     *         The <code>hostname</code> parameter is not supported if you are using the <code>awsvpc</code> network
     *         mode.
     *         </p>
     */
    public String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The user name to use inside the container. This parameter maps to <code>User</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--user</code> option to
     * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <p>
     * You can use the following formats. If specifying a UID or GID, you must specify it as a positive integer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>user</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>user:group</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>uid</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>uid:gid</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>user:gid</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>uid:group</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers.
     * </p>
     * </note>
     * 
     * @return The user name to use inside the container. This parameter maps to <code>User</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--user</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>
     *         <p>
     *         You can use the following formats. If specifying a UID or GID, you must specify it as a positive integer.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>user</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>user:group</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>uid</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>uid:gid</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>user:gid</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>uid:group</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This parameter is not supported for Windows containers.
     *         </p>
     */
    public String user() {
        return user;
    }

    /**
     * <p>
     * The working directory in which to run commands inside the container. This parameter maps to
     * <code>WorkingDir</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--workdir</code> option
     * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * 
     * @return The working directory in which to run commands inside the container. This parameter maps to
     *         <code>WorkingDir</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--workdir</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     */
    public String workingDirectory() {
        return workingDirectory;
    }

    /**
     * <p>
     * When this parameter is true, networking is disabled within the container. This parameter maps to
     * <code>NetworkDisabled</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers.
     * </p>
     * </note>
     * 
     * @return When this parameter is true, networking is disabled within the container. This parameter maps to
     *         <code>NetworkDisabled</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.</p> <note>
     *         <p>
     *         This parameter is not supported for Windows containers.
     *         </p>
     */
    public Boolean disableNetworking() {
        return disableNetworking;
    }

    /**
     * <p>
     * When this parameter is true, the container is given elevated privileges on the host container instance (similar
     * to the <code>root</code> user). This parameter maps to <code>Privileged</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--privileged</code>
     * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers or tasks using the Fargate launch type.
     * </p>
     * </note>
     * 
     * @return When this parameter is true, the container is given elevated privileges on the host container instance
     *         (similar to the <code>root</code> user). This parameter maps to <code>Privileged</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p> <note>
     *         <p>
     *         This parameter is not supported for Windows containers or tasks using the Fargate launch type.
     *         </p>
     */
    public Boolean privileged() {
        return privileged;
    }

    /**
     * <p>
     * When this parameter is true, the container is given read-only access to its root file system. This parameter maps
     * to <code>ReadonlyRootfs</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--read-only</code> option
     * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers.
     * </p>
     * </note>
     * 
     * @return When this parameter is true, the container is given read-only access to its root file system. This
     *         parameter maps to <code>ReadonlyRootfs</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--read-only</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p> <note>
     *         <p>
     *         This parameter is not supported for Windows containers.
     *         </p>
     */
    public Boolean readonlyRootFilesystem() {
        return readonlyRootFilesystem;
    }

    /**
     * Returns true if the DnsServers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDnsServers() {
        return dnsServers != null && !(dnsServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DNS servers that are presented to the container. This parameter maps to <code>Dns</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--dns</code> option to <a
     * href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDnsServers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DNS servers that are presented to the container. This parameter maps to <code>Dns</code> in the
     *         <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
     *         section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--dns</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>
     *         <note>
     *         <p>
     *         This parameter is not supported for Windows containers.
     *         </p>
     */
    public List<String> dnsServers() {
        return dnsServers;
    }

    /**
     * Returns true if the DnsSearchDomains property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDnsSearchDomains() {
        return dnsSearchDomains != null && !(dnsSearchDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DNS search domains that are presented to the container. This parameter maps to <code>DnsSearch</code>
     * in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
     * section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     * <code>--dns-search</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDnsSearchDomains()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DNS search domains that are presented to the container. This parameter maps to
     *         <code>DnsSearch</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--dns-search</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p> <note>
     *         <p>
     *         This parameter is not supported for Windows containers.
     *         </p>
     */
    public List<String> dnsSearchDomains() {
        return dnsSearchDomains;
    }

    /**
     * Returns true if the ExtraHosts property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExtraHosts() {
        return extraHosts != null && !(extraHosts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the container. This
     * parameter maps to <code>ExtraHosts</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--add-host</code> option
     * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers or tasks that use the <code>awsvpc</code> network mode.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExtraHosts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the
     *         container. This parameter maps to <code>ExtraHosts</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--add-host</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p> <note>
     *         <p>
     *         This parameter is not supported for Windows containers or tasks that use the <code>awsvpc</code> network
     *         mode.
     *         </p>
     */
    public List<HostEntry> extraHosts() {
        return extraHosts;
    }

    /**
     * Returns true if the DockerSecurityOptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDockerSecurityOptions() {
        return dockerSecurityOptions != null && !(dockerSecurityOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems. This field is
     * not valid for containers in tasks using the Fargate launch type.
     * </p>
     * <p>
     * With Windows containers, this parameter can be used to reference a credential spec file when configuring a
     * container for Active Directory authentication. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows
     * Containers</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * This parameter maps to <code>SecurityOpt</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--security-opt</code>
     * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent running on a container instance must register with the
     * <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code> environment variables before
     * containers placed on that instance can use these security options. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
     * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDockerSecurityOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems. This
     *         field is not valid for containers in tasks using the Fargate launch type.</p>
     *         <p>
     *         With Windows containers, this parameter can be used to reference a credential spec file when configuring
     *         a container for Active Directory authentication. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for
     *         Windows Containers</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         This parameter maps to <code>SecurityOpt</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--security-opt</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.
     *         </p>
     *         <note>
     *         <p>
     *         The Amazon ECS container agent running on a container instance must register with the
     *         <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code> environment variables
     *         before containers placed on that instance can use these security options. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS
     *         Container Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     */
    public List<String> dockerSecurityOptions() {
        return dockerSecurityOptions;
    }

    /**
     * <p>
     * When this parameter is <code>true</code>, this allows you to deploy containerized applications that require
     * <code>stdin</code> or a <code>tty</code> to be allocated. This parameter maps to <code>OpenStdin</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--interactive</code>
     * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * 
     * @return When this parameter is <code>true</code>, this allows you to deploy containerized applications that
     *         require <code>stdin</code> or a <code>tty</code> to be allocated. This parameter maps to
     *         <code>OpenStdin</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--interactive</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.
     */
    public Boolean interactive() {
        return interactive;
    }

    /**
     * <p>
     * When this parameter is <code>true</code>, a TTY is allocated. This parameter maps to <code>Tty</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--tty</code> option to <a
     * href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * 
     * @return When this parameter is <code>true</code>, a TTY is allocated. This parameter maps to <code>Tty</code> in
     *         the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
     *         section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--tty</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     */
    public Boolean pseudoTerminal() {
        return pseudoTerminal;
    }

    /**
     * Returns true if the DockerLabels property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDockerLabels() {
        return dockerLabels != null && !(dockerLabels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key/value map of labels to add to the container. This parameter maps to <code>Labels</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--label</code> option to
     * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. This parameter requires version 1.18 of
     * the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your
     * container instance, log in to your container instance and run the following command:
     * <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDockerLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key/value map of labels to add to the container. This parameter maps to <code>Labels</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--label</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     *         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To
     *         check the Docker Remote API version on your container instance, log in to your container instance and run
     *         the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
     */
    public Map<String, String> dockerLabels() {
        return dockerLabels;
    }

    /**
     * Returns true if the Ulimits property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUlimits() {
        return ulimits != null && !(ulimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ulimits</code> to set in the container. If a ulimit value is specified in a task definition, it
     * will override the default values set by Docker. This parameter maps to <code>Ulimits</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to
     * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Valid naming values are displayed in the
     * <a>Ulimit</a> data type. This parameter requires version 1.18 of the Docker Remote API or greater on your
     * container instance. To check the Docker Remote API version on your container instance, log in to your container
     * instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUlimits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ulimits</code> to set in the container. If a ulimit value is specified in a task
     *         definition, it will override the default values set by Docker. This parameter maps to
     *         <code>Ulimits</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     *         Valid naming values are displayed in the <a>Ulimit</a> data type. This parameter requires version 1.18 of
     *         the Docker Remote API or greater on your container instance. To check the Docker Remote API version on
     *         your container instance, log in to your container instance and run the following command:
     *         <code>sudo docker version --format '{{.Server.APIVersion}}'</code> </p> <note>
     *         <p>
     *         This parameter is not supported for Windows containers.
     *         </p>
     */
    public List<Ulimit> ulimits() {
        return ulimits;
    }

    /**
     * <p>
     * The log configuration specification for the container.
     * </p>
     * <p>
     * This parameter maps to <code>LogConfig</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--log-driver</code>
     * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. By default, containers use the
     * same logging driver that the Docker daemon uses. However the container may use a different logging driver than
     * the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different
     * logging driver for a container, the log system must be configured properly on the container instance (or on a
     * different log server for remote logging options). For more information on the options for different supported log
     * drivers, see <a href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in
     * the Docker documentation.
     * </p>
     * <note>
     * <p>
     * Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the
     * <a>LogConfiguration</a> data type). Additional log drivers may be available in future releases of the Amazon ECS
     * container agent.
     * </p>
     * </note>
     * <p>
     * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the
     * Docker Remote API version on your container instance, log in to your container instance and run the following
     * command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent running on a container instance must register the logging drivers available on
     * that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed
     * on that instance can use these log configuration options. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
     * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note>
     * 
     * @return The log configuration specification for the container.</p>
     *         <p>
     *         This parameter maps to <code>LogConfig</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>. By default, containers use the same logging driver that the Docker daemon uses. However the
     *         container may use a different logging driver than the Docker daemon by specifying a log driver with this
     *         parameter in the container definition. To use a different logging driver for a container, the log system
     *         must be configured properly on the container instance (or on a different log server for remote logging
     *         options). For more information on the options for different supported log drivers, see <a
     *         href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker
     *         documentation.
     *         </p>
     *         <note>
     *         <p>
     *         Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in
     *         the <a>LogConfiguration</a> data type). Additional log drivers may be available in future releases of the
     *         Amazon ECS container agent.
     *         </p>
     *         </note>
     *         <p>
     *         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To
     *         check the Docker Remote API version on your container instance, log in to your container instance and run
     *         the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
     *         </p>
     *         <note>
     *         <p>
     *         The Amazon ECS container agent running on a container instance must register the logging drivers
     *         available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable
     *         before containers placed on that instance can use these log configuration options. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon
     *         ECS Container Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     */
    public LogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The container health check command and associated configuration parameters for the container. This parameter maps
     * to <code>HealthCheck</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
     * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>HEALTHCHECK</code>
     * parameter of <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * 
     * @return The container health check command and associated configuration parameters for the container. This
     *         parameter maps to <code>HealthCheck</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>HEALTHCHECK</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.
     */
    public HealthCheck healthCheck() {
        return healthCheck;
    }

    /**
     * Returns true if the SystemControls property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSystemControls() {
        return systemControls != null && !(systemControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of namespaced kernel parameters to set in the container. This parameter maps to <code>Sysctls</code> in
     * the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     * of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--sysctl</code>
     * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * It is not recommended that you specify network-related <code>systemControls</code> parameters for multiple
     * containers in a single task that also uses either the <code>awsvpc</code> or <code>host</code> network modes. For
     * tasks that use the <code>awsvpc</code> network mode, the container that is started last determines which
     * <code>systemControls</code> parameters take effect. For tasks that use the <code>host</code> network mode, it
     * changes the container instance's namespaced kernel parameters as well as the containers.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSystemControls()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of namespaced kernel parameters to set in the container. This parameter maps to
     *         <code>Sysctls</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p> <note>
     *         <p>
     *         It is not recommended that you specify network-related <code>systemControls</code> parameters for
     *         multiple containers in a single task that also uses either the <code>awsvpc</code> or <code>host</code>
     *         network modes. For tasks that use the <code>awsvpc</code> network mode, the container that is started
     *         last determines which <code>systemControls</code> parameters take effect. For tasks that use the
     *         <code>host</code> network mode, it changes the container instance's namespaced kernel parameters as well
     *         as the containers.
     *         </p>
     */
    public List<SystemControl> systemControls() {
        return systemControls;
    }

    /**
     * Returns true if the ResourceRequirements property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceRequirements() {
        return resourceRequirements != null && !(resourceRequirements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceRequirements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type and amount of a resource to assign to a container. The only supported resource is a GPU.
     */
    public List<ResourceRequirement> resourceRequirements() {
        return resourceRequirements;
    }

    /**
     * <p>
     * The FireLens configuration for the container. This is used to specify and configure a log router for container
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The FireLens configuration for the container. This is used to specify and configure a log router for
     *         container logs. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log
     *         Routing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public FirelensConfiguration firelensConfiguration() {
        return firelensConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(memoryReservation());
        hashCode = 31 * hashCode + Objects.hashCode(links());
        hashCode = 31 * hashCode + Objects.hashCode(portMappings());
        hashCode = 31 * hashCode + Objects.hashCode(essential());
        hashCode = 31 * hashCode + Objects.hashCode(entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(environmentFiles());
        hashCode = 31 * hashCode + Objects.hashCode(mountPoints());
        hashCode = 31 * hashCode + Objects.hashCode(volumesFrom());
        hashCode = 31 * hashCode + Objects.hashCode(linuxParameters());
        hashCode = 31 * hashCode + Objects.hashCode(secrets());
        hashCode = 31 * hashCode + Objects.hashCode(dependsOn());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(stopTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(disableNetworking());
        hashCode = 31 * hashCode + Objects.hashCode(privileged());
        hashCode = 31 * hashCode + Objects.hashCode(readonlyRootFilesystem());
        hashCode = 31 * hashCode + Objects.hashCode(dnsServers());
        hashCode = 31 * hashCode + Objects.hashCode(dnsSearchDomains());
        hashCode = 31 * hashCode + Objects.hashCode(extraHosts());
        hashCode = 31 * hashCode + Objects.hashCode(dockerSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(interactive());
        hashCode = 31 * hashCode + Objects.hashCode(pseudoTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(dockerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(ulimits());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(systemControls());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(firelensConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(image(), other.image())
                && Objects.equals(repositoryCredentials(), other.repositoryCredentials()) && Objects.equals(cpu(), other.cpu())
                && Objects.equals(memory(), other.memory()) && Objects.equals(memoryReservation(), other.memoryReservation())
                && Objects.equals(links(), other.links()) && Objects.equals(portMappings(), other.portMappings())
                && Objects.equals(essential(), other.essential()) && Objects.equals(entryPoint(), other.entryPoint())
                && Objects.equals(command(), other.command()) && Objects.equals(environment(), other.environment())
                && Objects.equals(environmentFiles(), other.environmentFiles())
                && Objects.equals(mountPoints(), other.mountPoints()) && Objects.equals(volumesFrom(), other.volumesFrom())
                && Objects.equals(linuxParameters(), other.linuxParameters()) && Objects.equals(secrets(), other.secrets())
                && Objects.equals(dependsOn(), other.dependsOn()) && Objects.equals(startTimeout(), other.startTimeout())
                && Objects.equals(stopTimeout(), other.stopTimeout()) && Objects.equals(hostname(), other.hostname())
                && Objects.equals(user(), other.user()) && Objects.equals(workingDirectory(), other.workingDirectory())
                && Objects.equals(disableNetworking(), other.disableNetworking())
                && Objects.equals(privileged(), other.privileged())
                && Objects.equals(readonlyRootFilesystem(), other.readonlyRootFilesystem())
                && Objects.equals(dnsServers(), other.dnsServers())
                && Objects.equals(dnsSearchDomains(), other.dnsSearchDomains())
                && Objects.equals(extraHosts(), other.extraHosts())
                && Objects.equals(dockerSecurityOptions(), other.dockerSecurityOptions())
                && Objects.equals(interactive(), other.interactive()) && Objects.equals(pseudoTerminal(), other.pseudoTerminal())
                && Objects.equals(dockerLabels(), other.dockerLabels()) && Objects.equals(ulimits(), other.ulimits())
                && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(healthCheck(), other.healthCheck()) && Objects.equals(systemControls(), other.systemControls())
                && Objects.equals(resourceRequirements(), other.resourceRequirements())
                && Objects.equals(firelensConfiguration(), other.firelensConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContainerDefinition").add("Name", name()).add("Image", image())
                .add("RepositoryCredentials", repositoryCredentials()).add("Cpu", cpu()).add("Memory", memory())
                .add("MemoryReservation", memoryReservation()).add("Links", links()).add("PortMappings", portMappings())
                .add("Essential", essential()).add("EntryPoint", entryPoint()).add("Command", command())
                .add("Environment", environment()).add("EnvironmentFiles", environmentFiles()).add("MountPoints", mountPoints())
                .add("VolumesFrom", volumesFrom()).add("LinuxParameters", linuxParameters()).add("Secrets", secrets())
                .add("DependsOn", dependsOn()).add("StartTimeout", startTimeout()).add("StopTimeout", stopTimeout())
                .add("Hostname", hostname()).add("User", user()).add("WorkingDirectory", workingDirectory())
                .add("DisableNetworking", disableNetworking()).add("Privileged", privileged())
                .add("ReadonlyRootFilesystem", readonlyRootFilesystem()).add("DnsServers", dnsServers())
                .add("DnsSearchDomains", dnsSearchDomains()).add("ExtraHosts", extraHosts())
                .add("DockerSecurityOptions", dockerSecurityOptions()).add("Interactive", interactive())
                .add("PseudoTerminal", pseudoTerminal()).add("DockerLabels", dockerLabels()).add("Ulimits", ulimits())
                .add("LogConfiguration", logConfiguration()).add("HealthCheck", healthCheck())
                .add("SystemControls", systemControls()).add("ResourceRequirements", resourceRequirements())
                .add("FirelensConfiguration", firelensConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "repositoryCredentials":
            return Optional.ofNullable(clazz.cast(repositoryCredentials()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "memoryReservation":
            return Optional.ofNullable(clazz.cast(memoryReservation()));
        case "links":
            return Optional.ofNullable(clazz.cast(links()));
        case "portMappings":
            return Optional.ofNullable(clazz.cast(portMappings()));
        case "essential":
            return Optional.ofNullable(clazz.cast(essential()));
        case "entryPoint":
            return Optional.ofNullable(clazz.cast(entryPoint()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "environmentFiles":
            return Optional.ofNullable(clazz.cast(environmentFiles()));
        case "mountPoints":
            return Optional.ofNullable(clazz.cast(mountPoints()));
        case "volumesFrom":
            return Optional.ofNullable(clazz.cast(volumesFrom()));
        case "linuxParameters":
            return Optional.ofNullable(clazz.cast(linuxParameters()));
        case "secrets":
            return Optional.ofNullable(clazz.cast(secrets()));
        case "dependsOn":
            return Optional.ofNullable(clazz.cast(dependsOn()));
        case "startTimeout":
            return Optional.ofNullable(clazz.cast(startTimeout()));
        case "stopTimeout":
            return Optional.ofNullable(clazz.cast(stopTimeout()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        case "workingDirectory":
            return Optional.ofNullable(clazz.cast(workingDirectory()));
        case "disableNetworking":
            return Optional.ofNullable(clazz.cast(disableNetworking()));
        case "privileged":
            return Optional.ofNullable(clazz.cast(privileged()));
        case "readonlyRootFilesystem":
            return Optional.ofNullable(clazz.cast(readonlyRootFilesystem()));
        case "dnsServers":
            return Optional.ofNullable(clazz.cast(dnsServers()));
        case "dnsSearchDomains":
            return Optional.ofNullable(clazz.cast(dnsSearchDomains()));
        case "extraHosts":
            return Optional.ofNullable(clazz.cast(extraHosts()));
        case "dockerSecurityOptions":
            return Optional.ofNullable(clazz.cast(dockerSecurityOptions()));
        case "interactive":
            return Optional.ofNullable(clazz.cast(interactive()));
        case "pseudoTerminal":
            return Optional.ofNullable(clazz.cast(pseudoTerminal()));
        case "dockerLabels":
            return Optional.ofNullable(clazz.cast(dockerLabels()));
        case "ulimits":
            return Optional.ofNullable(clazz.cast(ulimits()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "healthCheck":
            return Optional.ofNullable(clazz.cast(healthCheck()));
        case "systemControls":
            return Optional.ofNullable(clazz.cast(systemControls()));
        case "resourceRequirements":
            return Optional.ofNullable(clazz.cast(resourceRequirements()));
        case "firelensConfiguration":
            return Optional.ofNullable(clazz.cast(firelensConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDefinition, T> g) {
        return obj -> g.apply((ContainerDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerDefinition> {
        /**
         * <p>
         * The name of a container. If you are linking multiple containers together in a task definition, the
         * <code>name</code> of one container can be entered in the <code>links</code> of another container to connect
         * the containers. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed. This parameter
         * maps to <code>name</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--name</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param name
         *        The name of a container. If you are linking multiple containers together in a task definition, the
         *        <code>name</code> of one container can be entered in the <code>links</code> of another container to
         *        connect the containers. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed.
         *        This parameter maps to <code>name</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--name</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The image used to start a container. This string is passed directly to the Docker daemon. Images in the
         * Docker Hub registry are available by default. Other repositories are specified with either
         * <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code> or
         * <code> <i>repository-url</i>/<i>image</i>@<i>digest</i> </code>. Up to 255 letters (uppercase and lowercase),
         * numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter
         * maps to <code>Image</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>IMAGE</code>
         * parameter of <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image and
         * tag for the container to use. However, subsequent updates to a repository image are not propagated to already
         * running tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * Images in Amazon ECR repositories can be specified by either using the full
         * <code>registry/repository:tag</code> or <code>registry/repository@digest</code>. For example,
         * <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;:latest</code> or
         * <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE</code>
         * .
         * </p>
         * </li>
         * <li>
         * <p>
         * Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or
         * <code>mongo</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * Images in other repositories on Docker Hub are qualified with an organization name (for example,
         * <code>amazon/amazon-ecs-agent</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * Images in other online repositories are qualified further by a domain name (for example,
         * <code>quay.io/assemblyline/ubuntu</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param image
         *        The image used to start a container. This string is passed directly to the Docker daemon. Images in
         *        the Docker Hub registry are available by default. Other repositories are specified with either
         *        <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code> or
         *        <code> <i>repository-url</i>/<i>image</i>@<i>digest</i> </code>. Up to 255 letters (uppercase and
         *        lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are
         *        allowed. This parameter maps to <code>Image</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>IMAGE</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image
         *        and tag for the container to use. However, subsequent updates to a repository image are not propagated
         *        to already running tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Images in Amazon ECR repositories can be specified by either using the full
         *        <code>registry/repository:tag</code> or <code>registry/repository@digest</code>. For example,
         *        <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;:latest</code> or
         *        <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or
         *        <code>mongo</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Images in other repositories on Docker Hub are qualified with an organization name (for example,
         *        <code>amazon/amazon-ecs-agent</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Images in other online repositories are qualified further by a domain name (for example,
         *        <code>quay.io/assemblyline/ubuntu</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The private repository authentication credentials to use.
         * </p>
         * 
         * @param repositoryCredentials
         *        The private repository authentication credentials to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryCredentials(RepositoryCredentials repositoryCredentials);

        /**
         * <p>
         * The private repository authentication credentials to use.
         * </p>
         * This is a convenience that creates an instance of the {@link RepositoryCredentials.Builder} avoiding the need
         * to create one manually via {@link RepositoryCredentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #repositoryCredentials(RepositoryCredentials)}.
         * 
         * @param repositoryCredentials
         *        a consumer that will call methods on {@link RepositoryCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryCredentials(RepositoryCredentials)
         */
        default Builder repositoryCredentials(Consumer<RepositoryCredentials.Builder> repositoryCredentials) {
            return repositoryCredentials(RepositoryCredentials.builder().applyMutation(repositoryCredentials).build());
        }

        /**
         * <p>
         * The number of <code>cpu</code> units reserved for the container. This parameter maps to
         * <code>CpuShares</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <p>
         * This field is optional for tasks using the Fargate launch type, and the only requirement is that the total
         * amount of CPU reserved for all containers within a task be lower than the task-level <code>cpu</code> value.
         * </p>
         * <note>
         * <p>
         * You can determine the number of CPU units that are available per EC2 instance type by multiplying the vCPUs
         * listed for that instance type on the <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
         * Instances</a> detail page by 1,024.
         * </p>
         * </note>
         * <p>
         * Linux containers share unallocated CPU units with other containers on the container instance with the same
         * ratio as their allocated amount. For example, if you run a single-container task on a single-core instance
         * type with 512 CPU units specified for that container, and that is the only task running on the container
         * instance, that container could use the full 1,024 CPU unit share at any given time. However, if you launched
         * another copy of the same task on that container instance, each task would be guaranteed a minimum of 512 CPU
         * units when needed, and each container could float to higher CPU usage if the other container was not using
         * it, but if both tasks were 100% active all of the time, they would be limited to 512 CPU units.
         * </p>
         * <p>
         * On Linux container instances, the Docker daemon on the container instance uses the CPU value to calculate the
         * relative CPU share ratios for running containers. For more information, see <a
         * href="https://docs.docker.com/engine/reference/run/#cpu-share-constraint">CPU share constraint</a> in the
         * Docker documentation. The minimum valid CPU share value that the Linux kernel allows is 2. However, the CPU
         * parameter is not required, and you can use CPU values below 2 in your container definitions. For CPU values
         * below 2 (including null), the behavior varies based on your Amazon ECS container agent version:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Agent versions less than or equal to 1.1.0:</b> Null and zero CPU values are passed to Docker as 0, which
         * Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux kernel
         * converts to two CPU shares.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Agent versions greater than or equal to 1.2.0:</b> Null, zero, and CPU values of 1 are passed to Docker as
         * 2.
         * </p>
         * </li>
         * </ul>
         * <p>
         * On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows
         * containers only have access to the specified amount of CPU that is described in the task definition.
         * </p>
         * 
         * @param cpu
         *        The number of <code>cpu</code> units reserved for the container. This parameter maps to
         *        <code>CpuShares</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p>
         *        <p>
         *        This field is optional for tasks using the Fargate launch type, and the only requirement is that the
         *        total amount of CPU reserved for all containers within a task be lower than the task-level
         *        <code>cpu</code> value.
         *        </p>
         *        <note>
         *        <p>
         *        You can determine the number of CPU units that are available per EC2 instance type by multiplying the
         *        vCPUs listed for that instance type on the <a href="http://aws.amazon.com/ec2/instance-types/">Amazon
         *        EC2 Instances</a> detail page by 1,024.
         *        </p>
         *        </note>
         *        <p>
         *        Linux containers share unallocated CPU units with other containers on the container instance with the
         *        same ratio as their allocated amount. For example, if you run a single-container task on a single-core
         *        instance type with 512 CPU units specified for that container, and that is the only task running on
         *        the container instance, that container could use the full 1,024 CPU unit share at any given time.
         *        However, if you launched another copy of the same task on that container instance, each task would be
         *        guaranteed a minimum of 512 CPU units when needed, and each container could float to higher CPU usage
         *        if the other container was not using it, but if both tasks were 100% active all of the time, they
         *        would be limited to 512 CPU units.
         *        </p>
         *        <p>
         *        On Linux container instances, the Docker daemon on the container instance uses the CPU value to
         *        calculate the relative CPU share ratios for running containers. For more information, see <a
         *        href="https://docs.docker.com/engine/reference/run/#cpu-share-constraint">CPU share constraint</a> in
         *        the Docker documentation. The minimum valid CPU share value that the Linux kernel allows is 2.
         *        However, the CPU parameter is not required, and you can use CPU values below 2 in your container
         *        definitions. For CPU values below 2 (including null), the behavior varies based on your Amazon ECS
         *        container agent version:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Agent versions less than or equal to 1.1.0:</b> Null and zero CPU values are passed to Docker as 0,
         *        which Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the
         *        Linux kernel converts to two CPU shares.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Agent versions greater than or equal to 1.2.0:</b> Null, zero, and CPU values of 1 are passed to
         *        Docker as 2.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows
         *        containers only have access to the specified amount of CPU that is described in the task definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(Integer cpu);

        /**
         * <p>
         * The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory
         * specified here, the container is killed. The total amount of memory reserved for all containers within a task
         * must be lower than the task <code>memory</code> value, if one is specified. This parameter maps to
         * <code>Memory</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--memory</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <p>
         * If using the Fargate launch type, this parameter is optional.
         * </p>
         * <p>
         * If using the EC2 launch type, you must specify either a task-level memory value or a container-level memory
         * value. If you specify both a container-level <code>memory</code> and <code>memoryReservation</code> value,
         * <code>memory</code> must be greater than <code>memoryReservation</code>. If you specify
         * <code>memoryReservation</code>, then that value is subtracted from the available memory resources for the
         * container instance on which the container is placed. Otherwise, the value of <code>memory</code> is used.
         * </p>
         * <p>
         * The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer than
         * 4 MiB of memory for your containers.
         * </p>
         * 
         * @param memory
         *        The amount (in MiB) of memory to present to the container. If your container attempts to exceed the
         *        memory specified here, the container is killed. The total amount of memory reserved for all containers
         *        within a task must be lower than the task <code>memory</code> value, if one is specified. This
         *        parameter maps to <code>Memory</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p>
         *        <p>
         *        If using the Fargate launch type, this parameter is optional.
         *        </p>
         *        <p>
         *        If using the EC2 launch type, you must specify either a task-level memory value or a container-level
         *        memory value. If you specify both a container-level <code>memory</code> and
         *        <code>memoryReservation</code> value, <code>memory</code> must be greater than
         *        <code>memoryReservation</code>. If you specify <code>memoryReservation</code>, then that value is
         *        subtracted from the available memory resources for the container instance on which the container is
         *        placed. Otherwise, the value of <code>memory</code> is used.
         *        </p>
         *        <p>
         *        The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify
         *        fewer than 4 MiB of memory for your containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * The soft limit (in MiB) of memory to reserve for the container. When system memory is under heavy contention,
         * Docker attempts to keep the container memory to this soft limit. However, your container can consume more
         * memory when it needs to, up to either the hard limit specified with the <code>memory</code> parameter (if
         * applicable), or all of the available memory on the container instance, whichever comes first. This parameter
         * maps to <code>MemoryReservation</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--memory-reservation</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         * run</a>.
         * </p>
         * <p>
         * If a task-level memory value is not specified, you must specify a non-zero integer for one or both of
         * <code>memory</code> or <code>memoryReservation</code> in a container definition. If you specify both,
         * <code>memory</code> must be greater than <code>memoryReservation</code>. If you specify
         * <code>memoryReservation</code>, then that value is subtracted from the available memory resources for the
         * container instance on which the container is placed. Otherwise, the value of <code>memory</code> is used.
         * </p>
         * <p>
         * For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of memory
         * for short periods of time, you can set a <code>memoryReservation</code> of 128 MiB, and a <code>memory</code>
         * hard limit of 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory from
         * the remaining resources on the container instance, but also allow the container to consume more memory
         * resources when needed.
         * </p>
         * <p>
         * The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer than
         * 4 MiB of memory for your containers.
         * </p>
         * 
         * @param memoryReservation
         *        The soft limit (in MiB) of memory to reserve for the container. When system memory is under heavy
         *        contention, Docker attempts to keep the container memory to this soft limit. However, your container
         *        can consume more memory when it needs to, up to either the hard limit specified with the
         *        <code>memory</code> parameter (if applicable), or all of the available memory on the container
         *        instance, whichever comes first. This parameter maps to <code>MemoryReservation</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--memory-reservation</code> option to <a
         *        href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>
         *        <p>
         *        If a task-level memory value is not specified, you must specify a non-zero integer for one or both of
         *        <code>memory</code> or <code>memoryReservation</code> in a container definition. If you specify both,
         *        <code>memory</code> must be greater than <code>memoryReservation</code>. If you specify
         *        <code>memoryReservation</code>, then that value is subtracted from the available memory resources for
         *        the container instance on which the container is placed. Otherwise, the value of <code>memory</code>
         *        is used.
         *        </p>
         *        <p>
         *        For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of
         *        memory for short periods of time, you can set a <code>memoryReservation</code> of 128 MiB, and a
         *        <code>memory</code> hard limit of 300 MiB. This configuration would allow the container to only
         *        reserve 128 MiB of memory from the remaining resources on the container instance, but also allow the
         *        container to consume more memory resources when needed.
         *        </p>
         *        <p>
         *        The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify
         *        fewer than 4 MiB of memory for your containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryReservation(Integer memoryReservation);

        /**
         * <p>
         * The <code>links</code> parameter allows containers to communicate with each other without the need for port
         * mappings. This parameter is only supported if the network mode of a task definition is <code>bridge</code>.
         * The <code>name:internalName</code> construct is analogous to <code>name:alias</code> in Docker links. Up to
         * 255 letters (uppercase and lowercase), numbers, and hyphens are allowed. For more information about linking
         * Docker containers, go to <a href="https://docs.docker.com/network/links/">Legacy container links</a> in the
         * Docker documentation. This parameter maps to <code>Links</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--link</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note> <important>
         * <p>
         * Containers that are collocated on a single container instance may be able to communicate with each other
         * without requiring links or host port mappings. Network isolation is achieved on the container instance using
         * security groups and VPC settings.
         * </p>
         * </important>
         * 
         * @param links
         *        The <code>links</code> parameter allows containers to communicate with each other without the need for
         *        port mappings. This parameter is only supported if the network mode of a task definition is
         *        <code>bridge</code>. The <code>name:internalName</code> construct is analogous to
         *        <code>name:alias</code> in Docker links. Up to 255 letters (uppercase and lowercase), numbers, and
         *        hyphens are allowed. For more information about linking Docker containers, go to <a
         *        href="https://docs.docker.com/network/links/">Legacy container links</a> in the Docker documentation.
         *        This parameter maps to <code>Links</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--link</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         *        </note> <important>
         *        <p>
         *        Containers that are collocated on a single container instance may be able to communicate with each
         *        other without requiring links or host port mappings. Network isolation is achieved on the container
         *        instance using security groups and VPC settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(Collection<String> links);

        /**
         * <p>
         * The <code>links</code> parameter allows containers to communicate with each other without the need for port
         * mappings. This parameter is only supported if the network mode of a task definition is <code>bridge</code>.
         * The <code>name:internalName</code> construct is analogous to <code>name:alias</code> in Docker links. Up to
         * 255 letters (uppercase and lowercase), numbers, and hyphens are allowed. For more information about linking
         * Docker containers, go to <a href="https://docs.docker.com/network/links/">Legacy container links</a> in the
         * Docker documentation. This parameter maps to <code>Links</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--link</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note> <important>
         * <p>
         * Containers that are collocated on a single container instance may be able to communicate with each other
         * without requiring links or host port mappings. Network isolation is achieved on the container instance using
         * security groups and VPC settings.
         * </p>
         * </important>
         * 
         * @param links
         *        The <code>links</code> parameter allows containers to communicate with each other without the need for
         *        port mappings. This parameter is only supported if the network mode of a task definition is
         *        <code>bridge</code>. The <code>name:internalName</code> construct is analogous to
         *        <code>name:alias</code> in Docker links. Up to 255 letters (uppercase and lowercase), numbers, and
         *        hyphens are allowed. For more information about linking Docker containers, go to <a
         *        href="https://docs.docker.com/network/links/">Legacy container links</a> in the Docker documentation.
         *        This parameter maps to <code>Links</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--link</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         *        </note> <important>
         *        <p>
         *        Containers that are collocated on a single container instance may be able to communicate with each
         *        other without requiring links or host port mappings. Network isolation is achieved on the container
         *        instance using security groups and VPC settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(String... links);

        /**
         * <p>
         * The list of port mappings for the container. Port mappings allow containers to access ports on the host
         * container instance to send or receive traffic.
         * </p>
         * <p>
         * For task definitions that use the <code>awsvpc</code> network mode, you should only specify the
         * <code>containerPort</code>. The <code>hostPort</code> can be left blank or it must be the same value as the
         * <code>containerPort</code>.
         * </p>
         * <p>
         * Port mappings on Windows use the <code>NetNAT</code> gateway address rather than <code>localhost</code>.
         * There is no loopback for port mappings on Windows, so you cannot access a container's mapped port from the
         * host itself.
         * </p>
         * <p>
         * This parameter maps to <code>PortBindings</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--publish</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. If the network mode of a
         * task definition is set to <code>none</code>, then you can't specify port mappings. If the network mode of a
         * task definition is set to <code>host</code>, then host ports must either be undefined or they must match the
         * container port in the port mapping.
         * </p>
         * <note>
         * <p>
         * After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port
         * assignments are visible in the <b>Network Bindings</b> section of a container description for a selected task
         * in the Amazon ECS console. The assignments are also visible in the <code>networkBindings</code> section
         * <a>DescribeTasks</a> responses.
         * </p>
         * </note>
         * 
         * @param portMappings
         *        The list of port mappings for the container. Port mappings allow containers to access ports on the
         *        host container instance to send or receive traffic.</p>
         *        <p>
         *        For task definitions that use the <code>awsvpc</code> network mode, you should only specify the
         *        <code>containerPort</code>. The <code>hostPort</code> can be left blank or it must be the same value
         *        as the <code>containerPort</code>.
         *        </p>
         *        <p>
         *        Port mappings on Windows use the <code>NetNAT</code> gateway address rather than
         *        <code>localhost</code>. There is no loopback for port mappings on Windows, so you cannot access a
         *        container's mapped port from the host itself.
         *        </p>
         *        <p>
         *        This parameter maps to <code>PortBindings</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--publish</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. If the network mode of a task definition is set to <code>none</code>, then you can't specify
         *        port mappings. If the network mode of a task definition is set to <code>host</code>, then host ports
         *        must either be undefined or they must match the container port in the port mapping.
         *        </p>
         *        <note>
         *        <p>
         *        After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port
         *        assignments are visible in the <b>Network Bindings</b> section of a container description for a
         *        selected task in the Amazon ECS console. The assignments are also visible in the
         *        <code>networkBindings</code> section <a>DescribeTasks</a> responses.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMappings(Collection<PortMapping> portMappings);

        /**
         * <p>
         * The list of port mappings for the container. Port mappings allow containers to access ports on the host
         * container instance to send or receive traffic.
         * </p>
         * <p>
         * For task definitions that use the <code>awsvpc</code> network mode, you should only specify the
         * <code>containerPort</code>. The <code>hostPort</code> can be left blank or it must be the same value as the
         * <code>containerPort</code>.
         * </p>
         * <p>
         * Port mappings on Windows use the <code>NetNAT</code> gateway address rather than <code>localhost</code>.
         * There is no loopback for port mappings on Windows, so you cannot access a container's mapped port from the
         * host itself.
         * </p>
         * <p>
         * This parameter maps to <code>PortBindings</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--publish</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. If the network mode of a
         * task definition is set to <code>none</code>, then you can't specify port mappings. If the network mode of a
         * task definition is set to <code>host</code>, then host ports must either be undefined or they must match the
         * container port in the port mapping.
         * </p>
         * <note>
         * <p>
         * After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port
         * assignments are visible in the <b>Network Bindings</b> section of a container description for a selected task
         * in the Amazon ECS console. The assignments are also visible in the <code>networkBindings</code> section
         * <a>DescribeTasks</a> responses.
         * </p>
         * </note>
         * 
         * @param portMappings
         *        The list of port mappings for the container. Port mappings allow containers to access ports on the
         *        host container instance to send or receive traffic.</p>
         *        <p>
         *        For task definitions that use the <code>awsvpc</code> network mode, you should only specify the
         *        <code>containerPort</code>. The <code>hostPort</code> can be left blank or it must be the same value
         *        as the <code>containerPort</code>.
         *        </p>
         *        <p>
         *        Port mappings on Windows use the <code>NetNAT</code> gateway address rather than
         *        <code>localhost</code>. There is no loopback for port mappings on Windows, so you cannot access a
         *        container's mapped port from the host itself.
         *        </p>
         *        <p>
         *        This parameter maps to <code>PortBindings</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--publish</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. If the network mode of a task definition is set to <code>none</code>, then you can't specify
         *        port mappings. If the network mode of a task definition is set to <code>host</code>, then host ports
         *        must either be undefined or they must match the container port in the port mapping.
         *        </p>
         *        <note>
         *        <p>
         *        After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port
         *        assignments are visible in the <b>Network Bindings</b> section of a container description for a
         *        selected task in the Amazon ECS console. The assignments are also visible in the
         *        <code>networkBindings</code> section <a>DescribeTasks</a> responses.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMappings(PortMapping... portMappings);

        /**
         * <p>
         * The list of port mappings for the container. Port mappings allow containers to access ports on the host
         * container instance to send or receive traffic.
         * </p>
         * <p>
         * For task definitions that use the <code>awsvpc</code> network mode, you should only specify the
         * <code>containerPort</code>. The <code>hostPort</code> can be left blank or it must be the same value as the
         * <code>containerPort</code>.
         * </p>
         * <p>
         * Port mappings on Windows use the <code>NetNAT</code> gateway address rather than <code>localhost</code>.
         * There is no loopback for port mappings on Windows, so you cannot access a container's mapped port from the
         * host itself.
         * </p>
         * <p>
         * This parameter maps to <code>PortBindings</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--publish</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. If the network mode of a
         * task definition is set to <code>none</code>, then you can't specify port mappings. If the network mode of a
         * task definition is set to <code>host</code>, then host ports must either be undefined or they must match the
         * container port in the port mapping.
         * </p>
         * <note>
         * <p>
         * After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port
         * assignments are visible in the <b>Network Bindings</b> section of a container description for a selected task
         * in the Amazon ECS console. The assignments are also visible in the <code>networkBindings</code> section
         * <a>DescribeTasks</a> responses.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<PortMapping>.Builder} avoiding the
         * need to create one manually via {@link List<PortMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortMapping>.Builder#build()} is called immediately and its
         * result is passed to {@link #portMappings(List<PortMapping>)}.
         * 
         * @param portMappings
         *        a consumer that will call methods on {@link List<PortMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portMappings(List<PortMapping>)
         */
        Builder portMappings(Consumer<PortMapping.Builder>... portMappings);

        /**
         * <p>
         * If the <code>essential</code> parameter of a container is marked as <code>true</code>, and that container
         * fails or stops for any reason, all other containers that are part of the task are stopped. If the
         * <code>essential</code> parameter of a container is marked as <code>false</code>, then its failure does not
         * affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be
         * essential.
         * </p>
         * <p>
         * All tasks must have at least one essential container. If you have an application that is composed of multiple
         * containers, you should group containers that are used for a common purpose into components, and separate the
         * different components into multiple task definitions. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application
         * Architecture</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param essential
         *        If the <code>essential</code> parameter of a container is marked as <code>true</code>, and that
         *        container fails or stops for any reason, all other containers that are part of the task are stopped.
         *        If the <code>essential</code> parameter of a container is marked as <code>false</code>, then its
         *        failure does not affect the rest of the containers in a task. If this parameter is omitted, a
         *        container is assumed to be essential.</p>
         *        <p>
         *        All tasks must have at least one essential container. If you have an application that is composed of
         *        multiple containers, you should group containers that are used for a common purpose into components,
         *        and separate the different components into multiple task definitions. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">
         *        Application Architecture</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder essential(Boolean essential);

        /**
         * <important>
         * <p>
         * Early versions of the Amazon ECS container agent do not properly handle <code>entryPoint</code> parameters.
         * If you have problems using <code>entryPoint</code>, update your container agent or enter your commands and
         * arguments as <code>command</code> array items instead.
         * </p>
         * </important>
         * <p>
         * The entry point that is passed to the container. This parameter maps to <code>Entrypoint</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--entrypoint</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * For more information, see <a
         * href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.
         * docker.com/engine/reference/builder/#entrypoint</a>.
         * </p>
         * 
         * @param entryPoint
         *        <p>
         *        Early versions of the Amazon ECS container agent do not properly handle <code>entryPoint</code>
         *        parameters. If you have problems using <code>entryPoint</code>, update your container agent or enter
         *        your commands and arguments as <code>command</code> array items instead.
         *        </p>
         *        </important>
         *        <p>
         *        The entry point that is passed to the container. This parameter maps to <code>Entrypoint</code> in the
         *        <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--entrypoint</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. For more information, see <a
         *        href="https://docs.docker.com/engine/reference/builder/#entrypoint"
         *        >https://docs.docker.com/engine/reference/builder/#entrypoint</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(Collection<String> entryPoint);

        /**
         * <important>
         * <p>
         * Early versions of the Amazon ECS container agent do not properly handle <code>entryPoint</code> parameters.
         * If you have problems using <code>entryPoint</code>, update your container agent or enter your commands and
         * arguments as <code>command</code> array items instead.
         * </p>
         * </important>
         * <p>
         * The entry point that is passed to the container. This parameter maps to <code>Entrypoint</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--entrypoint</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * For more information, see <a
         * href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.
         * docker.com/engine/reference/builder/#entrypoint</a>.
         * </p>
         * 
         * @param entryPoint
         *        <p>
         *        Early versions of the Amazon ECS container agent do not properly handle <code>entryPoint</code>
         *        parameters. If you have problems using <code>entryPoint</code>, update your container agent or enter
         *        your commands and arguments as <code>command</code> array items instead.
         *        </p>
         *        </important>
         *        <p>
         *        The entry point that is passed to the container. This parameter maps to <code>Entrypoint</code> in the
         *        <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--entrypoint</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. For more information, see <a
         *        href="https://docs.docker.com/engine/reference/builder/#entrypoint"
         *        >https://docs.docker.com/engine/reference/builder/#entrypoint</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(String... entryPoint);

        /**
         * <p>
         * The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>COMMAND</code>
         * parameter to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more information,
         * see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/
         * builder/#cmd</a>. If there are multiple arguments, each argument should be a separated string in the array.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. For more information, see <a
         *        href="https://docs.docker.com/engine/reference/builder/#cmd">https
         *        ://docs.docker.com/engine/reference/builder/#cmd</a>. If there are multiple arguments, each argument
         *        should be a separated string in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Collection<String> command);

        /**
         * <p>
         * The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>COMMAND</code>
         * parameter to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more information,
         * see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/
         * builder/#cmd</a>. If there are multiple arguments, each argument should be a separated string in the array.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. For more information, see <a
         *        href="https://docs.docker.com/engine/reference/builder/#cmd">https
         *        ://docs.docker.com/engine/reference/builder/#cmd</a>. If there are multiple arguments, each argument
         *        should be a separated string in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String... command);

        /**
         * <p>
         * The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--env</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <important>
         * <p>
         * We do not recommend using plaintext environment variables for sensitive information, such as credential data.
         * </p>
         * </important>
         * 
         * @param environment
         *        The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <important>
         *        <p>
         *        We do not recommend using plaintext environment variables for sensitive information, such as
         *        credential data.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<KeyValuePair> environment);

        /**
         * <p>
         * The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--env</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <important>
         * <p>
         * We do not recommend using plaintext environment variables for sensitive information, such as credential data.
         * </p>
         * </important>
         * 
         * @param environment
         *        The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <important>
         *        <p>
         *        We do not recommend using plaintext environment variables for sensitive information, such as
         *        credential data.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(KeyValuePair... environment);

        /**
         * <p>
         * The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--env</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <important>
         * <p>
         * We do not recommend using plaintext environment variables for sensitive information, such as credential data.
         * </p>
         * </important> This is a convenience that creates an instance of the {@link List<KeyValuePair>.Builder}
         * avoiding the need to create one manually via {@link List<KeyValuePair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyValuePair>.Builder#build()} is called immediately and its
         * result is passed to {@link #environment(List<KeyValuePair>)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link List<KeyValuePair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(List<KeyValuePair>)
         */
        Builder environment(Consumer<KeyValuePair.Builder>... environment);

        /**
         * <p>
         * A list of files containing the environment variables to pass to a container. This parameter maps to the
         * <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <p>
         * You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line
         * in an environment file should contain an environment variable in <code>VARIABLE=VALUE</code> format. Lines
         * beginning with <code>#</code> are treated as comments and are ignored. For more information on the
         * environment variable file syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default
         * environment variables in file</a>.
         * </p>
         * <p>
         * If there are environment variables specified using the <code>environment</code> parameter in a container
         * definition, they take precedence over the variables contained within an environment file. If multiple
         * environment files are specified that contain the same variable, they are processed from the top down. It is
         * recommended to use unique variable names. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying
         * Environment Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * This field is not valid for containers in tasks using the Fargate launch type.
         * </p>
         * 
         * @param environmentFiles
         *        A list of files containing the environment variables to pass to a container. This parameter maps to
         *        the <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p>
         *        <p>
         *        You can specify up to ten environment files. The file must have a <code>.env</code> file extension.
         *        Each line in an environment file should contain an environment variable in <code>VARIABLE=VALUE</code>
         *        format. Lines beginning with <code>#</code> are treated as comments and are ignored. For more
         *        information on the environment variable file syntax, see <a
         *        href="https://docs.docker.com/compose/env-file/">Declare default environment variables in file</a>.
         *        </p>
         *        <p>
         *        If there are environment variables specified using the <code>environment</code> parameter in a
         *        container definition, they take precedence over the variables contained within an environment file. If
         *        multiple environment files are specified that contain the same variable, they are processed from the
         *        top down. It is recommended to use unique variable names. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying
         *        Environment Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        This field is not valid for containers in tasks using the Fargate launch type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentFiles(Collection<EnvironmentFile> environmentFiles);

        /**
         * <p>
         * A list of files containing the environment variables to pass to a container. This parameter maps to the
         * <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <p>
         * You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line
         * in an environment file should contain an environment variable in <code>VARIABLE=VALUE</code> format. Lines
         * beginning with <code>#</code> are treated as comments and are ignored. For more information on the
         * environment variable file syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default
         * environment variables in file</a>.
         * </p>
         * <p>
         * If there are environment variables specified using the <code>environment</code> parameter in a container
         * definition, they take precedence over the variables contained within an environment file. If multiple
         * environment files are specified that contain the same variable, they are processed from the top down. It is
         * recommended to use unique variable names. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying
         * Environment Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * This field is not valid for containers in tasks using the Fargate launch type.
         * </p>
         * 
         * @param environmentFiles
         *        A list of files containing the environment variables to pass to a container. This parameter maps to
         *        the <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p>
         *        <p>
         *        You can specify up to ten environment files. The file must have a <code>.env</code> file extension.
         *        Each line in an environment file should contain an environment variable in <code>VARIABLE=VALUE</code>
         *        format. Lines beginning with <code>#</code> are treated as comments and are ignored. For more
         *        information on the environment variable file syntax, see <a
         *        href="https://docs.docker.com/compose/env-file/">Declare default environment variables in file</a>.
         *        </p>
         *        <p>
         *        If there are environment variables specified using the <code>environment</code> parameter in a
         *        container definition, they take precedence over the variables contained within an environment file. If
         *        multiple environment files are specified that contain the same variable, they are processed from the
         *        top down. It is recommended to use unique variable names. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying
         *        Environment Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        This field is not valid for containers in tasks using the Fargate launch type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentFiles(EnvironmentFile... environmentFiles);

        /**
         * <p>
         * A list of files containing the environment variables to pass to a container. This parameter maps to the
         * <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <p>
         * You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line
         * in an environment file should contain an environment variable in <code>VARIABLE=VALUE</code> format. Lines
         * beginning with <code>#</code> are treated as comments and are ignored. For more information on the
         * environment variable file syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default
         * environment variables in file</a>.
         * </p>
         * <p>
         * If there are environment variables specified using the <code>environment</code> parameter in a container
         * definition, they take precedence over the variables contained within an environment file. If multiple
         * environment files are specified that contain the same variable, they are processed from the top down. It is
         * recommended to use unique variable names. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying
         * Environment Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * This field is not valid for containers in tasks using the Fargate launch type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnvironmentFile>.Builder} avoiding the need
         * to create one manually via {@link List<EnvironmentFile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentFile>.Builder#build()} is called immediately and
         * its result is passed to {@link #environmentFiles(List<EnvironmentFile>)}.
         * 
         * @param environmentFiles
         *        a consumer that will call methods on {@link List<EnvironmentFile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentFiles(List<EnvironmentFile>)
         */
        Builder environmentFiles(Consumer<EnvironmentFile.Builder>... environmentFiles);

        /**
         * <p>
         * The mount points for data volumes in your container.
         * </p>
         * <p>
         * This parameter maps to <code>Volumes</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volume</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <p>
         * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>. Windows
         * containers cannot mount directories on a different drive, and mount point cannot be across drives.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for data volumes in your container.</p>
         *        <p>
         *        This parameter maps to <code>Volumes</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         *        </p>
         *        <p>
         *        Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>.
         *        Windows containers cannot mount directories on a different drive, and mount point cannot be across
         *        drives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(Collection<MountPoint> mountPoints);

        /**
         * <p>
         * The mount points for data volumes in your container.
         * </p>
         * <p>
         * This parameter maps to <code>Volumes</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volume</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <p>
         * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>. Windows
         * containers cannot mount directories on a different drive, and mount point cannot be across drives.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for data volumes in your container.</p>
         *        <p>
         *        This parameter maps to <code>Volumes</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         *        </p>
         *        <p>
         *        Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>.
         *        Windows containers cannot mount directories on a different drive, and mount point cannot be across
         *        drives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(MountPoint... mountPoints);

        /**
         * <p>
         * The mount points for data volumes in your container.
         * </p>
         * <p>
         * This parameter maps to <code>Volumes</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volume</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <p>
         * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>. Windows
         * containers cannot mount directories on a different drive, and mount point cannot be across drives.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MountPoint>.Builder} avoiding the need to
         * create one manually via {@link List<MountPoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MountPoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #mountPoints(List<MountPoint>)}.
         * 
         * @param mountPoints
         *        a consumer that will call methods on {@link List<MountPoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountPoints(List<MountPoint>)
         */
        Builder mountPoints(Consumer<MountPoint.Builder>... mountPoints);

        /**
         * <p>
         * Data volumes to mount from another container. This parameter maps to <code>VolumesFrom</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--volumes-from</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param volumesFrom
         *        Data volumes to mount from another container. This parameter maps to <code>VolumesFrom</code> in the
         *        <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--volumes-from</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesFrom(Collection<VolumeFrom> volumesFrom);

        /**
         * <p>
         * Data volumes to mount from another container. This parameter maps to <code>VolumesFrom</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--volumes-from</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param volumesFrom
         *        Data volumes to mount from another container. This parameter maps to <code>VolumesFrom</code> in the
         *        <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--volumes-from</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesFrom(VolumeFrom... volumesFrom);

        /**
         * <p>
         * Data volumes to mount from another container. This parameter maps to <code>VolumesFrom</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--volumes-from</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VolumeFrom>.Builder} avoiding the need to
         * create one manually via {@link List<VolumeFrom>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeFrom>.Builder#build()} is called immediately and its
         * result is passed to {@link #volumesFrom(List<VolumeFrom>)}.
         * 
         * @param volumesFrom
         *        a consumer that will call methods on {@link List<VolumeFrom>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumesFrom(List<VolumeFrom>)
         */
        Builder volumesFrom(Consumer<VolumeFrom.Builder>... volumesFrom);

        /**
         * <p>
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more
         * information see <a>KernelCapabilities</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param linuxParameters
         *        Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For
         *        more information see <a>KernelCapabilities</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linuxParameters(LinuxParameters linuxParameters);

        /**
         * <p>
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more
         * information see <a>KernelCapabilities</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link LinuxParameters.Builder} avoiding the
         * need to create one manually via {@link LinuxParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link LinuxParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #linuxParameters(LinuxParameters)}.
         * 
         * @param linuxParameters
         *        a consumer that will call methods on {@link LinuxParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linuxParameters(LinuxParameters)
         */
        default Builder linuxParameters(Consumer<LinuxParameters.Builder> linuxParameters) {
            return linuxParameters(LinuxParameters.builder().applyMutation(linuxParameters).build());
        }

        /**
         * <p>
         * The secrets to pass to the container. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
         * Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param secrets
         *        The secrets to pass to the container. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html"
         *        >Specifying Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secrets(Collection<Secret> secrets);

        /**
         * <p>
         * The secrets to pass to the container. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
         * Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param secrets
         *        The secrets to pass to the container. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html"
         *        >Specifying Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secrets(Secret... secrets);

        /**
         * <p>
         * The secrets to pass to the container. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
         * Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Secret>.Builder} avoiding the need to
         * create one manually via {@link List<Secret>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Secret>.Builder#build()} is called immediately and its
         * result is passed to {@link #secrets(List<Secret>)}.
         * 
         * @param secrets
         *        a consumer that will call methods on {@link List<Secret>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secrets(List<Secret>)
         */
        Builder secrets(Consumer<Secret.Builder>... secrets);

        /**
         * <p>
         * The dependencies defined for container startup and shutdown. A container can contain multiple dependencies.
         * When a dependency is defined for container startup, for container shutdown it is reversed.
         * </p>
         * <p>
         * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container
         * agent to enable container dependencies. However, we recommend using the latest container agent version. For
         * information about checking your agent version and updating to the latest version, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon
         * ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are using an
         * Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code>
         * package. If your container instances are launched from version <code>20190301</code> or later, then they
         * contain the required versions of the container agent and <code>ecs-init</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         * ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * For tasks using the Fargate launch type, the task or service requires platform version <code>1.3.0</code> or
         * later.
         * </p>
         * 
         * @param dependsOn
         *        The dependencies defined for container startup and shutdown. A container can contain multiple
         *        dependencies. When a dependency is defined for container startup, for container shutdown it is
         *        reversed.</p>
         *        <p>
         *        For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the
         *        container agent to enable container dependencies. However, we recommend using the latest container
         *        agent version. For information about checking your agent version and updating to the latest version,
         *        see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the
         *        Amazon ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you
         *        are using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
         *        <code>ecs-init</code> package. If your container instances are launched from version
         *        <code>20190301</code> or later, then they contain the required versions of the container agent and
         *        <code>ecs-init</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         *        ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        For tasks using the Fargate launch type, the task or service requires platform version
         *        <code>1.3.0</code> or later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<ContainerDependency> dependsOn);

        /**
         * <p>
         * The dependencies defined for container startup and shutdown. A container can contain multiple dependencies.
         * When a dependency is defined for container startup, for container shutdown it is reversed.
         * </p>
         * <p>
         * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container
         * agent to enable container dependencies. However, we recommend using the latest container agent version. For
         * information about checking your agent version and updating to the latest version, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon
         * ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are using an
         * Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code>
         * package. If your container instances are launched from version <code>20190301</code> or later, then they
         * contain the required versions of the container agent and <code>ecs-init</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         * ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * For tasks using the Fargate launch type, the task or service requires platform version <code>1.3.0</code> or
         * later.
         * </p>
         * 
         * @param dependsOn
         *        The dependencies defined for container startup and shutdown. A container can contain multiple
         *        dependencies. When a dependency is defined for container startup, for container shutdown it is
         *        reversed.</p>
         *        <p>
         *        For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the
         *        container agent to enable container dependencies. However, we recommend using the latest container
         *        agent version. For information about checking your agent version and updating to the latest version,
         *        see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the
         *        Amazon ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you
         *        are using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
         *        <code>ecs-init</code> package. If your container instances are launched from version
         *        <code>20190301</code> or later, then they contain the required versions of the container agent and
         *        <code>ecs-init</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         *        ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        For tasks using the Fargate launch type, the task or service requires platform version
         *        <code>1.3.0</code> or later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(ContainerDependency... dependsOn);

        /**
         * <p>
         * The dependencies defined for container startup and shutdown. A container can contain multiple dependencies.
         * When a dependency is defined for container startup, for container shutdown it is reversed.
         * </p>
         * <p>
         * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container
         * agent to enable container dependencies. However, we recommend using the latest container agent version. For
         * information about checking your agent version and updating to the latest version, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon
         * ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are using an
         * Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code>
         * package. If your container instances are launched from version <code>20190301</code> or later, then they
         * contain the required versions of the container agent and <code>ecs-init</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         * ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * For tasks using the Fargate launch type, the task or service requires platform version <code>1.3.0</code> or
         * later.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContainerDependency>.Builder} avoiding the
         * need to create one manually via {@link List<ContainerDependency>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerDependency>.Builder#build()} is called immediately
         * and its result is passed to {@link #dependsOn(List<ContainerDependency>)}.
         * 
         * @param dependsOn
         *        a consumer that will call methods on {@link List<ContainerDependency>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependsOn(List<ContainerDependency>)
         */
        Builder dependsOn(Consumer<ContainerDependency.Builder>... dependsOn);

        /**
         * <p>
         * Time duration (in seconds) to wait before giving up on resolving dependencies for a container. For example,
         * you specify two containers in a task definition with containerA having a dependency on containerB reaching a
         * <code>COMPLETE</code>, <code>SUCCESS</code>, or <code>HEALTHY</code> status. If a <code>startTimeout</code>
         * value is specified for containerB and it does not reach the desired status within that time then containerA
         * will give up and not start. This results in the task transitioning to a <code>STOPPED</code> state.
         * </p>
         * <p>
         * For tasks using the Fargate launch type, this parameter requires that the task or service uses platform
         * version 1.3.0 or later. If this parameter is not specified, the default value of 3 minutes is used.
         * </p>
         * <p>
         * For tasks using the EC2 launch type, if the <code>startTimeout</code> parameter is not specified, the value
         * set for the Amazon ECS container agent configuration variable <code>ECS_CONTAINER_START_TIMEOUT</code> is
         * used by default. If neither the <code>startTimeout</code> parameter or the
         * <code>ECS_CONTAINER_START_TIMEOUT</code> agent configuration variable are set, then the default values of 3
         * minutes for Linux containers and 8 minutes on Windows containers are used. Your container instances require
         * at least version 1.26.0 of the container agent to enable a container start timeout value. However, we
         * recommend using the latest container agent version. For information about checking your agent version and
         * updating to the latest version, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon
         * ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are using an
         * Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code>
         * package. If your container instances are launched from version <code>20190301</code> or later, then they
         * contain the required versions of the container agent and <code>ecs-init</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         * ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param startTimeout
         *        Time duration (in seconds) to wait before giving up on resolving dependencies for a container. For
         *        example, you specify two containers in a task definition with containerA having a dependency on
         *        containerB reaching a <code>COMPLETE</code>, <code>SUCCESS</code>, or <code>HEALTHY</code> status. If
         *        a <code>startTimeout</code> value is specified for containerB and it does not reach the desired status
         *        within that time then containerA will give up and not start. This results in the task transitioning to
         *        a <code>STOPPED</code> state.</p>
         *        <p>
         *        For tasks using the Fargate launch type, this parameter requires that the task or service uses
         *        platform version 1.3.0 or later. If this parameter is not specified, the default value of 3 minutes is
         *        used.
         *        </p>
         *        <p>
         *        For tasks using the EC2 launch type, if the <code>startTimeout</code> parameter is not specified, the
         *        value set for the Amazon ECS container agent configuration variable
         *        <code>ECS_CONTAINER_START_TIMEOUT</code> is used by default. If neither the <code>startTimeout</code>
         *        parameter or the <code>ECS_CONTAINER_START_TIMEOUT</code> agent configuration variable are set, then
         *        the default values of 3 minutes for Linux containers and 8 minutes on Windows containers are used.
         *        Your container instances require at least version 1.26.0 of the container agent to enable a container
         *        start timeout value. However, we recommend using the latest container agent version. For information
         *        about checking your agent version and updating to the latest version, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the
         *        Amazon ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you
         *        are using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
         *        <code>ecs-init</code> package. If your container instances are launched from version
         *        <code>20190301</code> or later, then they contain the required versions of the container agent and
         *        <code>ecs-init</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         *        ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeout(Integer startTimeout);

        /**
         * <p>
         * Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on
         * its own.
         * </p>
         * <p>
         * For tasks using the Fargate launch type, the task or service requires platform version 1.3.0 or later. The
         * max stop timeout value is 120 seconds and if the parameter is not specified, the default value of 30 seconds
         * is used.
         * </p>
         * <p>
         * For tasks using the EC2 launch type, if the <code>stopTimeout</code> parameter is not specified, the value
         * set for the Amazon ECS container agent configuration variable <code>ECS_CONTAINER_STOP_TIMEOUT</code> is used
         * by default. If neither the <code>stopTimeout</code> parameter or the <code>ECS_CONTAINER_STOP_TIMEOUT</code>
         * agent configuration variable are set, then the default values of 30 seconds for Linux containers and 30
         * seconds on Windows containers are used. Your container instances require at least version 1.26.0 of the
         * container agent to enable a container stop timeout value. However, we recommend using the latest container
         * agent version. For information about checking your agent version and updating to the latest version, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon
         * ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are using an
         * Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code>
         * package. If your container instances are launched from version <code>20190301</code> or later, then they
         * contain the required versions of the container agent and <code>ecs-init</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         * ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param stopTimeout
         *        Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit
         *        normally on its own.</p>
         *        <p>
         *        For tasks using the Fargate launch type, the task or service requires platform version 1.3.0 or later.
         *        The max stop timeout value is 120 seconds and if the parameter is not specified, the default value of
         *        30 seconds is used.
         *        </p>
         *        <p>
         *        For tasks using the EC2 launch type, if the <code>stopTimeout</code> parameter is not specified, the
         *        value set for the Amazon ECS container agent configuration variable
         *        <code>ECS_CONTAINER_STOP_TIMEOUT</code> is used by default. If neither the <code>stopTimeout</code>
         *        parameter or the <code>ECS_CONTAINER_STOP_TIMEOUT</code> agent configuration variable are set, then
         *        the default values of 30 seconds for Linux containers and 30 seconds on Windows containers are used.
         *        Your container instances require at least version 1.26.0 of the container agent to enable a container
         *        stop timeout value. However, we recommend using the latest container agent version. For information
         *        about checking your agent version and updating to the latest version, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the
         *        Amazon ECS Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you
         *        are using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
         *        <code>ecs-init</code> package. If your container instances are launched from version
         *        <code>20190301</code> or later, then they contain the required versions of the container agent and
         *        <code>ecs-init</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         *        ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTimeout(Integer stopTimeout);

        /**
         * <p>
         * The hostname to use for your container. This parameter maps to <code>Hostname</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--hostname</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * The <code>hostname</code> parameter is not supported if you are using the <code>awsvpc</code> network mode.
         * </p>
         * </note>
         * 
         * @param hostname
         *        The hostname to use for your container. This parameter maps to <code>Hostname</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--hostname</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        The <code>hostname</code> parameter is not supported if you are using the <code>awsvpc</code> network
         *        mode.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The user name to use inside the container. This parameter maps to <code>User</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--user</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <p>
         * You can use the following formats. If specifying a UID or GID, you must specify it as a positive integer.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>user</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>user:group</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>uid</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>uid:gid</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>user:gid</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>uid:group</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param user
         *        The user name to use inside the container. This parameter maps to <code>User</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--user</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p>
         *        <p>
         *        You can use the following formats. If specifying a UID or GID, you must specify it as a positive
         *        integer.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>user</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>user:group</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>uid</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>uid:gid</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>user:gid</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>uid:group</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * The working directory in which to run commands inside the container. This parameter maps to
         * <code>WorkingDir</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--workdir</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param workingDirectory
         *        The working directory in which to run commands inside the container. This parameter maps to
         *        <code>WorkingDir</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--workdir</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingDirectory(String workingDirectory);

        /**
         * <p>
         * When this parameter is true, networking is disabled within the container. This parameter maps to
         * <code>NetworkDisabled</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param disableNetworking
         *        When this parameter is true, networking is disabled within the container. This parameter maps to
         *        <code>NetworkDisabled</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableNetworking(Boolean disableNetworking);

        /**
         * <p>
         * When this parameter is true, the container is given elevated privileges on the host container instance
         * (similar to the <code>root</code> user). This parameter maps to <code>Privileged</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers or tasks using the Fargate launch type.
         * </p>
         * </note>
         * 
         * @param privileged
         *        When this parameter is true, the container is given elevated privileges on the host container instance
         *        (similar to the <code>root</code> user). This parameter maps to <code>Privileged</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers or tasks using the Fargate launch type.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privileged(Boolean privileged);

        /**
         * <p>
         * When this parameter is true, the container is given read-only access to its root file system. This parameter
         * maps to <code>ReadonlyRootfs</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--read-only</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param readonlyRootFilesystem
         *        When this parameter is true, the container is given read-only access to its root file system. This
         *        parameter maps to <code>ReadonlyRootfs</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--read-only</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem);

        /**
         * <p>
         * A list of DNS servers that are presented to the container. This parameter maps to <code>Dns</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--dns</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param dnsServers
         *        A list of DNS servers that are presented to the container. This parameter maps to <code>Dns</code> in
         *        the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a
         *        container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>
         *        and the <code>--dns</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(Collection<String> dnsServers);

        /**
         * <p>
         * A list of DNS servers that are presented to the container. This parameter maps to <code>Dns</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--dns</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param dnsServers
         *        A list of DNS servers that are presented to the container. This parameter maps to <code>Dns</code> in
         *        the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a
         *        container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>
         *        and the <code>--dns</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(String... dnsServers);

        /**
         * <p>
         * A list of DNS search domains that are presented to the container. This parameter maps to
         * <code>DnsSearch</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--dns-search</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param dnsSearchDomains
         *        A list of DNS search domains that are presented to the container. This parameter maps to
         *        <code>DnsSearch</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--dns-search</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsSearchDomains(Collection<String> dnsSearchDomains);

        /**
         * <p>
         * A list of DNS search domains that are presented to the container. This parameter maps to
         * <code>DnsSearch</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--dns-search</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param dnsSearchDomains
         *        A list of DNS search domains that are presented to the container. This parameter maps to
         *        <code>DnsSearch</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--dns-search</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsSearchDomains(String... dnsSearchDomains);

        /**
         * <p>
         * A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the container.
         * This parameter maps to <code>ExtraHosts</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--add-host</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers or tasks that use the <code>awsvpc</code> network
         * mode.
         * </p>
         * </note>
         * 
         * @param extraHosts
         *        A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the
         *        container. This parameter maps to <code>ExtraHosts</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--add-host</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers or tasks that use the <code>awsvpc</code>
         *        network mode.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraHosts(Collection<HostEntry> extraHosts);

        /**
         * <p>
         * A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the container.
         * This parameter maps to <code>ExtraHosts</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--add-host</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers or tasks that use the <code>awsvpc</code> network
         * mode.
         * </p>
         * </note>
         * 
         * @param extraHosts
         *        A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the
         *        container. This parameter maps to <code>ExtraHosts</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--add-host</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers or tasks that use the <code>awsvpc</code>
         *        network mode.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraHosts(HostEntry... extraHosts);

        /**
         * <p>
         * A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the container.
         * This parameter maps to <code>ExtraHosts</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--add-host</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers or tasks that use the <code>awsvpc</code> network
         * mode.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<HostEntry>.Builder} avoiding the
         * need to create one manually via {@link List<HostEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HostEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #extraHosts(List<HostEntry>)}.
         * 
         * @param extraHosts
         *        a consumer that will call methods on {@link List<HostEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extraHosts(List<HostEntry>)
         */
        Builder extraHosts(Consumer<HostEntry.Builder>... extraHosts);

        /**
         * <p>
         * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems. This field
         * is not valid for containers in tasks using the Fargate launch type.
         * </p>
         * <p>
         * With Windows containers, this parameter can be used to reference a credential spec file when configuring a
         * container for Active Directory authentication. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows
         * Containers</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * This parameter maps to <code>SecurityOpt</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--security-opt</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * The Amazon ECS container agent running on a container instance must register with the
         * <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code> environment variables before
         * containers placed on that instance can use these security options. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
         * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param dockerSecurityOptions
         *        A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems. This
         *        field is not valid for containers in tasks using the Fargate launch type.</p>
         *        <p>
         *        With Windows containers, this parameter can be used to reference a credential spec file when
         *        configuring a container for Active Directory authentication. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for
         *        Windows Containers</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        This parameter maps to <code>SecurityOpt</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--security-opt</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         *        </p>
         *        <note>
         *        <p>
         *        The Amazon ECS container agent running on a container instance must register with the
         *        <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code> environment variables
         *        before containers placed on that instance can use these security options. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS
         *        Container Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerSecurityOptions(Collection<String> dockerSecurityOptions);

        /**
         * <p>
         * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems. This field
         * is not valid for containers in tasks using the Fargate launch type.
         * </p>
         * <p>
         * With Windows containers, this parameter can be used to reference a credential spec file when configuring a
         * container for Active Directory authentication. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows
         * Containers</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * This parameter maps to <code>SecurityOpt</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--security-opt</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * The Amazon ECS container agent running on a container instance must register with the
         * <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code> environment variables before
         * containers placed on that instance can use these security options. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
         * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param dockerSecurityOptions
         *        A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems. This
         *        field is not valid for containers in tasks using the Fargate launch type.</p>
         *        <p>
         *        With Windows containers, this parameter can be used to reference a credential spec file when
         *        configuring a container for Active Directory authentication. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for
         *        Windows Containers</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        This parameter maps to <code>SecurityOpt</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--security-opt</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         *        </p>
         *        <note>
         *        <p>
         *        The Amazon ECS container agent running on a container instance must register with the
         *        <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code> environment variables
         *        before containers placed on that instance can use these security options. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS
         *        Container Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerSecurityOptions(String... dockerSecurityOptions);

        /**
         * <p>
         * When this parameter is <code>true</code>, this allows you to deploy containerized applications that require
         * <code>stdin</code> or a <code>tty</code> to be allocated. This parameter maps to <code>OpenStdin</code> in
         * the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         * section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--interactive</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param interactive
         *        When this parameter is <code>true</code>, this allows you to deploy containerized applications that
         *        require <code>stdin</code> or a <code>tty</code> to be allocated. This parameter maps to
         *        <code>OpenStdin</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--interactive</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactive(Boolean interactive);

        /**
         * <p>
         * When this parameter is <code>true</code>, a TTY is allocated. This parameter maps to <code>Tty</code> in the
         * <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section
         * of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--tty</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param pseudoTerminal
         *        When this parameter is <code>true</code>, a TTY is allocated. This parameter maps to <code>Tty</code>
         *        in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a
         *        container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>
         *        and the <code>--tty</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pseudoTerminal(Boolean pseudoTerminal);

        /**
         * <p>
         * A key/value map of labels to add to the container. This parameter maps to <code>Labels</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--label</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. This parameter requires
         * version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API
         * version on your container instance, log in to your container instance and run the following command:
         * <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * </p>
         * 
         * @param dockerLabels
         *        A key/value map of labels to add to the container. This parameter maps to <code>Labels</code> in the
         *        <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--label</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         *        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.
         *        To check the Docker Remote API version on your container instance, log in to your container instance
         *        and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerLabels(Map<String, String> dockerLabels);

        /**
         * <p>
         * A list of <code>ulimits</code> to set in the container. If a ulimit value is specified in a task definition,
         * it will override the default values set by Docker. This parameter maps to <code>Ulimits</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Valid naming values are
         * displayed in the <a>Ulimit</a> data type. This parameter requires version 1.18 of the Docker Remote API or
         * greater on your container instance. To check the Docker Remote API version on your container instance, log in
         * to your container instance and run the following command:
         * <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param ulimits
         *        A list of <code>ulimits</code> to set in the container. If a ulimit value is specified in a task
         *        definition, it will override the default values set by Docker. This parameter maps to
         *        <code>Ulimits</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. Valid naming values are displayed in the <a>Ulimit</a> data type. This parameter requires
         *        version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker
         *        Remote API version on your container instance, log in to your container instance and run the following
         *        command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code> </p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulimits(Collection<Ulimit> ulimits);

        /**
         * <p>
         * A list of <code>ulimits</code> to set in the container. If a ulimit value is specified in a task definition,
         * it will override the default values set by Docker. This parameter maps to <code>Ulimits</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Valid naming values are
         * displayed in the <a>Ulimit</a> data type. This parameter requires version 1.18 of the Docker Remote API or
         * greater on your container instance. To check the Docker Remote API version on your container instance, log in
         * to your container instance and run the following command:
         * <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note>
         * 
         * @param ulimits
         *        A list of <code>ulimits</code> to set in the container. If a ulimit value is specified in a task
         *        definition, it will override the default values set by Docker. This parameter maps to
         *        <code>Ulimits</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. Valid naming values are displayed in the <a>Ulimit</a> data type. This parameter requires
         *        version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker
         *        Remote API version on your container instance, log in to your container instance and run the following
         *        command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code> </p> <note>
         *        <p>
         *        This parameter is not supported for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulimits(Ulimit... ulimits);

        /**
         * <p>
         * A list of <code>ulimits</code> to set in the container. If a ulimit value is specified in a task definition,
         * it will override the default values set by Docker. This parameter maps to <code>Ulimits</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Valid naming values are
         * displayed in the <a>Ulimit</a> data type. This parameter requires version 1.18 of the Docker Remote API or
         * greater on your container instance. To check the Docker Remote API version on your container instance, log in
         * to your container instance and run the following command:
         * <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Ulimit>.Builder} avoiding the need
         * to create one manually via {@link List<Ulimit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ulimit>.Builder#build()} is called immediately and its
         * result is passed to {@link #ulimits(List<Ulimit>)}.
         * 
         * @param ulimits
         *        a consumer that will call methods on {@link List<Ulimit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ulimits(List<Ulimit>)
         */
        Builder ulimits(Consumer<Ulimit.Builder>... ulimits);

        /**
         * <p>
         * The log configuration specification for the container.
         * </p>
         * <p>
         * This parameter maps to <code>LogConfig</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * By default, containers use the same logging driver that the Docker daemon uses. However the container may use
         * a different logging driver than the Docker daemon by specifying a log driver with this parameter in the
         * container definition. To use a different logging driver for a container, the log system must be configured
         * properly on the container instance (or on a different log server for remote logging options). For more
         * information on the options for different supported log drivers, see <a
         * href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker
         * documentation.
         * </p>
         * <note>
         * <p>
         * Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the
         * <a>LogConfiguration</a> data type). Additional log drivers may be available in future releases of the Amazon
         * ECS container agent.
         * </p>
         * </note>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check
         * the Docker Remote API version on your container instance, log in to your container instance and run the
         * following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * </p>
         * <note>
         * <p>
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on
         * that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers
         * placed on that instance can use these log configuration options. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
         * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param logConfiguration
         *        The log configuration specification for the container.</p>
         *        <p>
         *        This parameter maps to <code>LogConfig</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. By default, containers use the same logging driver that the Docker daemon uses. However the
         *        container may use a different logging driver than the Docker daemon by specifying a log driver with
         *        this parameter in the container definition. To use a different logging driver for a container, the log
         *        system must be configured properly on the container instance (or on a different log server for remote
         *        logging options). For more information on the options for different supported log drivers, see <a
         *        href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the
         *        Docker documentation.
         *        </p>
         *        <note>
         *        <p>
         *        Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in
         *        the <a>LogConfiguration</a> data type). Additional log drivers may be available in future releases of
         *        the Amazon ECS container agent.
         *        </p>
         *        </note>
         *        <p>
         *        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.
         *        To check the Docker Remote API version on your container instance, log in to your container instance
         *        and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         *        </p>
         *        <note>
         *        <p>
         *        The Amazon ECS container agent running on a container instance must register the logging drivers
         *        available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable
         *        before containers placed on that instance can use these log configuration options. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS
         *        Container Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LogConfiguration logConfiguration);

        /**
         * <p>
         * The log configuration specification for the container.
         * </p>
         * <p>
         * This parameter maps to <code>LogConfig</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * By default, containers use the same logging driver that the Docker daemon uses. However the container may use
         * a different logging driver than the Docker daemon by specifying a log driver with this parameter in the
         * container definition. To use a different logging driver for a container, the log system must be configured
         * properly on the container instance (or on a different log server for remote logging options). For more
         * information on the options for different supported log drivers, see <a
         * href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker
         * documentation.
         * </p>
         * <note>
         * <p>
         * Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the
         * <a>LogConfiguration</a> data type). Additional log drivers may be available in future releases of the Amazon
         * ECS container agent.
         * </p>
         * </note>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check
         * the Docker Remote API version on your container instance, log in to your container instance and run the
         * following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * </p>
         * <note>
         * <p>
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on
         * that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers
         * placed on that instance can use these log configuration options. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
         * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfiguration(LogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LogConfiguration)
         */
        default Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The container health check command and associated configuration parameters for the container. This parameter
         * maps to <code>HealthCheck</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>HEALTHCHECK</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param healthCheck
         *        The container health check command and associated configuration parameters for the container. This
         *        parameter maps to <code>HealthCheck</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>HEALTHCHECK</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(HealthCheck healthCheck);

        /**
         * <p>
         * The container health check command and associated configuration parameters for the container. This parameter
         * maps to <code>HealthCheck</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
         * the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>HEALTHCHECK</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link HealthCheck.Builder} avoiding the need to create
         * one manually via {@link HealthCheck#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheck.Builder#build()} is called immediately and its result
         * is passed to {@link #healthCheck(HealthCheck)}.
         * 
         * @param healthCheck
         *        a consumer that will call methods on {@link HealthCheck.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheck(HealthCheck)
         */
        default Builder healthCheck(Consumer<HealthCheck.Builder> healthCheck) {
            return healthCheck(HealthCheck.builder().applyMutation(healthCheck).build());
        }

        /**
         * <p>
         * A list of namespaced kernel parameters to set in the container. This parameter maps to <code>Sysctls</code>
         * in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         * section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * It is not recommended that you specify network-related <code>systemControls</code> parameters for multiple
         * containers in a single task that also uses either the <code>awsvpc</code> or <code>host</code> network modes.
         * For tasks that use the <code>awsvpc</code> network mode, the container that is started last determines which
         * <code>systemControls</code> parameters take effect. For tasks that use the <code>host</code> network mode, it
         * changes the container instance's namespaced kernel parameters as well as the containers.
         * </p>
         * </note>
         * 
         * @param systemControls
         *        A list of namespaced kernel parameters to set in the container. This parameter maps to
         *        <code>Sysctls</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        It is not recommended that you specify network-related <code>systemControls</code> parameters for
         *        multiple containers in a single task that also uses either the <code>awsvpc</code> or
         *        <code>host</code> network modes. For tasks that use the <code>awsvpc</code> network mode, the
         *        container that is started last determines which <code>systemControls</code> parameters take effect.
         *        For tasks that use the <code>host</code> network mode, it changes the container instance's namespaced
         *        kernel parameters as well as the containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemControls(Collection<SystemControl> systemControls);

        /**
         * <p>
         * A list of namespaced kernel parameters to set in the container. This parameter maps to <code>Sysctls</code>
         * in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         * section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * It is not recommended that you specify network-related <code>systemControls</code> parameters for multiple
         * containers in a single task that also uses either the <code>awsvpc</code> or <code>host</code> network modes.
         * For tasks that use the <code>awsvpc</code> network mode, the container that is started last determines which
         * <code>systemControls</code> parameters take effect. For tasks that use the <code>host</code> network mode, it
         * changes the container instance's namespaced kernel parameters as well as the containers.
         * </p>
         * </note>
         * 
         * @param systemControls
         *        A list of namespaced kernel parameters to set in the container. This parameter maps to
         *        <code>Sysctls</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        It is not recommended that you specify network-related <code>systemControls</code> parameters for
         *        multiple containers in a single task that also uses either the <code>awsvpc</code> or
         *        <code>host</code> network modes. For tasks that use the <code>awsvpc</code> network mode, the
         *        container that is started last determines which <code>systemControls</code> parameters take effect.
         *        For tasks that use the <code>host</code> network mode, it changes the container instance's namespaced
         *        kernel parameters as well as the containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemControls(SystemControl... systemControls);

        /**
         * <p>
         * A list of namespaced kernel parameters to set in the container. This parameter maps to <code>Sysctls</code>
         * in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
         * section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         * <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * It is not recommended that you specify network-related <code>systemControls</code> parameters for multiple
         * containers in a single task that also uses either the <code>awsvpc</code> or <code>host</code> network modes.
         * For tasks that use the <code>awsvpc</code> network mode, the container that is started last determines which
         * <code>systemControls</code> parameters take effect. For tasks that use the <code>host</code> network mode, it
         * changes the container instance's namespaced kernel parameters as well as the containers.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<SystemControl>.Builder} avoiding
         * the need to create one manually via {@link List<SystemControl>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SystemControl>.Builder#build()} is called immediately and
         * its result is passed to {@link #systemControls(List<SystemControl>)}.
         * 
         * @param systemControls
         *        a consumer that will call methods on {@link List<SystemControl>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemControls(List<SystemControl>)
         */
        Builder systemControls(Consumer<SystemControl.Builder>... systemControls);

        /**
         * <p>
         * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(Collection<ResourceRequirement> resourceRequirements);

        /**
         * <p>
         * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(ResourceRequirement... resourceRequirements);

        /**
         * <p>
         * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceRequirement>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceRequirement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceRequirement>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceRequirements(List<ResourceRequirement>)}.
         * 
         * @param resourceRequirements
         *        a consumer that will call methods on {@link List<ResourceRequirement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRequirements(List<ResourceRequirement>)
         */
        Builder resourceRequirements(Consumer<ResourceRequirement.Builder>... resourceRequirements);

        /**
         * <p>
         * The FireLens configuration for the container. This is used to specify and configure a log router for
         * container logs. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param firelensConfiguration
         *        The FireLens configuration for the container. This is used to specify and configure a log router for
         *        container logs. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log
         *        Routing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firelensConfiguration(FirelensConfiguration firelensConfiguration);

        /**
         * <p>
         * The FireLens configuration for the container. This is used to specify and configure a log router for
         * container logs. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link FirelensConfiguration.Builder} avoiding the need
         * to create one manually via {@link FirelensConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirelensConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #firelensConfiguration(FirelensConfiguration)}.
         * 
         * @param firelensConfiguration
         *        a consumer that will call methods on {@link FirelensConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firelensConfiguration(FirelensConfiguration)
         */
        default Builder firelensConfiguration(Consumer<FirelensConfiguration.Builder> firelensConfiguration) {
            return firelensConfiguration(FirelensConfiguration.builder().applyMutation(firelensConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String image;

        private RepositoryCredentials repositoryCredentials;

        private Integer cpu;

        private Integer memory;

        private Integer memoryReservation;

        private List<String> links = DefaultSdkAutoConstructList.getInstance();

        private List<PortMapping> portMappings = DefaultSdkAutoConstructList.getInstance();

        private Boolean essential;

        private List<String> entryPoint = DefaultSdkAutoConstructList.getInstance();

        private List<String> command = DefaultSdkAutoConstructList.getInstance();

        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();

        private List<EnvironmentFile> environmentFiles = DefaultSdkAutoConstructList.getInstance();

        private List<MountPoint> mountPoints = DefaultSdkAutoConstructList.getInstance();

        private List<VolumeFrom> volumesFrom = DefaultSdkAutoConstructList.getInstance();

        private LinuxParameters linuxParameters;

        private List<Secret> secrets = DefaultSdkAutoConstructList.getInstance();

        private List<ContainerDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();

        private Integer startTimeout;

        private Integer stopTimeout;

        private String hostname;

        private String user;

        private String workingDirectory;

        private Boolean disableNetworking;

        private Boolean privileged;

        private Boolean readonlyRootFilesystem;

        private List<String> dnsServers = DefaultSdkAutoConstructList.getInstance();

        private List<String> dnsSearchDomains = DefaultSdkAutoConstructList.getInstance();

        private List<HostEntry> extraHosts = DefaultSdkAutoConstructList.getInstance();

        private List<String> dockerSecurityOptions = DefaultSdkAutoConstructList.getInstance();

        private Boolean interactive;

        private Boolean pseudoTerminal;

        private Map<String, String> dockerLabels = DefaultSdkAutoConstructMap.getInstance();

        private List<Ulimit> ulimits = DefaultSdkAutoConstructList.getInstance();

        private LogConfiguration logConfiguration;

        private HealthCheck healthCheck;

        private List<SystemControl> systemControls = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();

        private FirelensConfiguration firelensConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDefinition model) {
            name(model.name);
            image(model.image);
            repositoryCredentials(model.repositoryCredentials);
            cpu(model.cpu);
            memory(model.memory);
            memoryReservation(model.memoryReservation);
            links(model.links);
            portMappings(model.portMappings);
            essential(model.essential);
            entryPoint(model.entryPoint);
            command(model.command);
            environment(model.environment);
            environmentFiles(model.environmentFiles);
            mountPoints(model.mountPoints);
            volumesFrom(model.volumesFrom);
            linuxParameters(model.linuxParameters);
            secrets(model.secrets);
            dependsOn(model.dependsOn);
            startTimeout(model.startTimeout);
            stopTimeout(model.stopTimeout);
            hostname(model.hostname);
            user(model.user);
            workingDirectory(model.workingDirectory);
            disableNetworking(model.disableNetworking);
            privileged(model.privileged);
            readonlyRootFilesystem(model.readonlyRootFilesystem);
            dnsServers(model.dnsServers);
            dnsSearchDomains(model.dnsSearchDomains);
            extraHosts(model.extraHosts);
            dockerSecurityOptions(model.dockerSecurityOptions);
            interactive(model.interactive);
            pseudoTerminal(model.pseudoTerminal);
            dockerLabels(model.dockerLabels);
            ulimits(model.ulimits);
            logConfiguration(model.logConfiguration);
            healthCheck(model.healthCheck);
            systemControls(model.systemControls);
            resourceRequirements(model.resourceRequirements);
            firelensConfiguration(model.firelensConfiguration);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImage() {
            return image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final RepositoryCredentials.Builder getRepositoryCredentials() {
            return repositoryCredentials != null ? repositoryCredentials.toBuilder() : null;
        }

        @Override
        public final Builder repositoryCredentials(RepositoryCredentials repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials;
            return this;
        }

        public final void setRepositoryCredentials(RepositoryCredentials.BuilderImpl repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials != null ? repositoryCredentials.build() : null;
        }

        public final Integer getCpu() {
            return cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        public final Integer getMemory() {
            return memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        public final Integer getMemoryReservation() {
            return memoryReservation;
        }

        @Override
        public final Builder memoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public final void setMemoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        public final Collection<String> getLinks() {
            return links;
        }

        @Override
        public final Builder links(Collection<String> links) {
            this.links = StringListCopier.copy(links);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(String... links) {
            links(Arrays.asList(links));
            return this;
        }

        public final void setLinks(Collection<String> links) {
            this.links = StringListCopier.copy(links);
        }

        public final Collection<PortMapping.Builder> getPortMappings() {
            return portMappings != null ? portMappings.stream().map(PortMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portMappings(Collection<PortMapping> portMappings) {
            this.portMappings = PortMappingListCopier.copy(portMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(PortMapping... portMappings) {
            portMappings(Arrays.asList(portMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(Consumer<PortMapping.Builder>... portMappings) {
            portMappings(Stream.of(portMappings).map(c -> PortMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPortMappings(Collection<PortMapping.BuilderImpl> portMappings) {
            this.portMappings = PortMappingListCopier.copyFromBuilder(portMappings);
        }

        public final Boolean getEssential() {
            return essential;
        }

        @Override
        public final Builder essential(Boolean essential) {
            this.essential = essential;
            return this;
        }

        public final void setEssential(Boolean essential) {
            this.essential = essential;
        }

        public final Collection<String> getEntryPoint() {
            return entryPoint;
        }

        @Override
        public final Builder entryPoint(Collection<String> entryPoint) {
            this.entryPoint = StringListCopier.copy(entryPoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryPoint(String... entryPoint) {
            entryPoint(Arrays.asList(entryPoint));
            return this;
        }

        public final void setEntryPoint(Collection<String> entryPoint) {
            this.entryPoint = StringListCopier.copy(entryPoint);
        }

        public final Collection<String> getCommand() {
            return command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String... command) {
            command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        public final Collection<KeyValuePair.Builder> getEnvironment() {
            return environment != null ? environment.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder>... environment) {
            environment(Stream.of(environment).map(c -> KeyValuePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        public final Collection<EnvironmentFile.Builder> getEnvironmentFiles() {
            return environmentFiles != null ? environmentFiles.stream().map(EnvironmentFile::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentFiles(Collection<EnvironmentFile> environmentFiles) {
            this.environmentFiles = EnvironmentFilesCopier.copy(environmentFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(EnvironmentFile... environmentFiles) {
            environmentFiles(Arrays.asList(environmentFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(Consumer<EnvironmentFile.Builder>... environmentFiles) {
            environmentFiles(Stream.of(environmentFiles).map(c -> EnvironmentFile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironmentFiles(Collection<EnvironmentFile.BuilderImpl> environmentFiles) {
            this.environmentFiles = EnvironmentFilesCopier.copyFromBuilder(environmentFiles);
        }

        public final Collection<MountPoint.Builder> getMountPoints() {
            return mountPoints != null ? mountPoints.stream().map(MountPoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointListCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(MountPoint... mountPoints) {
            mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(Consumer<MountPoint.Builder>... mountPoints) {
            mountPoints(Stream.of(mountPoints).map(c -> MountPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMountPoints(Collection<MountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = MountPointListCopier.copyFromBuilder(mountPoints);
        }

        public final Collection<VolumeFrom.Builder> getVolumesFrom() {
            return volumesFrom != null ? volumesFrom.stream().map(VolumeFrom::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumesFrom(Collection<VolumeFrom> volumesFrom) {
            this.volumesFrom = VolumeFromListCopier.copy(volumesFrom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesFrom(VolumeFrom... volumesFrom) {
            volumesFrom(Arrays.asList(volumesFrom));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesFrom(Consumer<VolumeFrom.Builder>... volumesFrom) {
            volumesFrom(Stream.of(volumesFrom).map(c -> VolumeFrom.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVolumesFrom(Collection<VolumeFrom.BuilderImpl> volumesFrom) {
            this.volumesFrom = VolumeFromListCopier.copyFromBuilder(volumesFrom);
        }

        public final LinuxParameters.Builder getLinuxParameters() {
            return linuxParameters != null ? linuxParameters.toBuilder() : null;
        }

        @Override
        public final Builder linuxParameters(LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        public final void setLinuxParameters(LinuxParameters.BuilderImpl linuxParameters) {
            this.linuxParameters = linuxParameters != null ? linuxParameters.build() : null;
        }

        public final Collection<Secret.Builder> getSecrets() {
            return secrets != null ? secrets.stream().map(Secret::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secrets(Collection<Secret> secrets) {
            this.secrets = SecretListCopier.copy(secrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Secret... secrets) {
            secrets(Arrays.asList(secrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Consumer<Secret.Builder>... secrets) {
            secrets(Stream.of(secrets).map(c -> Secret.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecrets(Collection<Secret.BuilderImpl> secrets) {
            this.secrets = SecretListCopier.copyFromBuilder(secrets);
        }

        public final Collection<ContainerDependency.Builder> getDependsOn() {
            return dependsOn != null ? dependsOn.stream().map(ContainerDependency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dependsOn(Collection<ContainerDependency> dependsOn) {
            this.dependsOn = ContainerDependenciesCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(ContainerDependency... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<ContainerDependency.Builder>... dependsOn) {
            dependsOn(Stream.of(dependsOn).map(c -> ContainerDependency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDependsOn(Collection<ContainerDependency.BuilderImpl> dependsOn) {
            this.dependsOn = ContainerDependenciesCopier.copyFromBuilder(dependsOn);
        }

        public final Integer getStartTimeout() {
            return startTimeout;
        }

        @Override
        public final Builder startTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        public final void setStartTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
        }

        public final Integer getStopTimeout() {
            return stopTimeout;
        }

        @Override
        public final Builder stopTimeout(Integer stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        public final void setStopTimeout(Integer stopTimeout) {
            this.stopTimeout = stopTimeout;
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getUser() {
            return user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        public final String getWorkingDirectory() {
            return workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public final Boolean getDisableNetworking() {
            return disableNetworking;
        }

        @Override
        public final Builder disableNetworking(Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
            return this;
        }

        public final void setDisableNetworking(Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
        }

        public final Boolean getPrivileged() {
            return privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        public final Boolean getReadonlyRootFilesystem() {
            return readonlyRootFilesystem;
        }

        @Override
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        public final Collection<String> getDnsServers() {
            return dnsServers;
        }

        @Override
        public final Builder dnsServers(Collection<String> dnsServers) {
            this.dnsServers = StringListCopier.copy(dnsServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsServers(String... dnsServers) {
            dnsServers(Arrays.asList(dnsServers));
            return this;
        }

        public final void setDnsServers(Collection<String> dnsServers) {
            this.dnsServers = StringListCopier.copy(dnsServers);
        }

        public final Collection<String> getDnsSearchDomains() {
            return dnsSearchDomains;
        }

        @Override
        public final Builder dnsSearchDomains(Collection<String> dnsSearchDomains) {
            this.dnsSearchDomains = StringListCopier.copy(dnsSearchDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsSearchDomains(String... dnsSearchDomains) {
            dnsSearchDomains(Arrays.asList(dnsSearchDomains));
            return this;
        }

        public final void setDnsSearchDomains(Collection<String> dnsSearchDomains) {
            this.dnsSearchDomains = StringListCopier.copy(dnsSearchDomains);
        }

        public final Collection<HostEntry.Builder> getExtraHosts() {
            return extraHosts != null ? extraHosts.stream().map(HostEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder extraHosts(Collection<HostEntry> extraHosts) {
            this.extraHosts = HostEntryListCopier.copy(extraHosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraHosts(HostEntry... extraHosts) {
            extraHosts(Arrays.asList(extraHosts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraHosts(Consumer<HostEntry.Builder>... extraHosts) {
            extraHosts(Stream.of(extraHosts).map(c -> HostEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExtraHosts(Collection<HostEntry.BuilderImpl> extraHosts) {
            this.extraHosts = HostEntryListCopier.copyFromBuilder(extraHosts);
        }

        public final Collection<String> getDockerSecurityOptions() {
            return dockerSecurityOptions;
        }

        @Override
        public final Builder dockerSecurityOptions(Collection<String> dockerSecurityOptions) {
            this.dockerSecurityOptions = StringListCopier.copy(dockerSecurityOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dockerSecurityOptions(String... dockerSecurityOptions) {
            dockerSecurityOptions(Arrays.asList(dockerSecurityOptions));
            return this;
        }

        public final void setDockerSecurityOptions(Collection<String> dockerSecurityOptions) {
            this.dockerSecurityOptions = StringListCopier.copy(dockerSecurityOptions);
        }

        public final Boolean getInteractive() {
            return interactive;
        }

        @Override
        public final Builder interactive(Boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public final void setInteractive(Boolean interactive) {
            this.interactive = interactive;
        }

        public final Boolean getPseudoTerminal() {
            return pseudoTerminal;
        }

        @Override
        public final Builder pseudoTerminal(Boolean pseudoTerminal) {
            this.pseudoTerminal = pseudoTerminal;
            return this;
        }

        public final void setPseudoTerminal(Boolean pseudoTerminal) {
            this.pseudoTerminal = pseudoTerminal;
        }

        public final Map<String, String> getDockerLabels() {
            return dockerLabels;
        }

        @Override
        public final Builder dockerLabels(Map<String, String> dockerLabels) {
            this.dockerLabels = DockerLabelsMapCopier.copy(dockerLabels);
            return this;
        }

        public final void setDockerLabels(Map<String, String> dockerLabels) {
            this.dockerLabels = DockerLabelsMapCopier.copy(dockerLabels);
        }

        public final Collection<Ulimit.Builder> getUlimits() {
            return ulimits != null ? ulimits.stream().map(Ulimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ulimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitListCopier.copy(ulimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Ulimit... ulimits) {
            ulimits(Arrays.asList(ulimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Consumer<Ulimit.Builder>... ulimits) {
            ulimits(Stream.of(ulimits).map(c -> Ulimit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUlimits(Collection<Ulimit.BuilderImpl> ulimits) {
            this.ulimits = UlimitListCopier.copyFromBuilder(ulimits);
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        public final HealthCheck.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        public final Collection<SystemControl.Builder> getSystemControls() {
            return systemControls != null ? systemControls.stream().map(SystemControl::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder systemControls(Collection<SystemControl> systemControls) {
            this.systemControls = SystemControlsCopier.copy(systemControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemControls(SystemControl... systemControls) {
            systemControls(Arrays.asList(systemControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemControls(Consumer<SystemControl.Builder>... systemControls) {
            systemControls(Stream.of(systemControls).map(c -> SystemControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSystemControls(Collection<SystemControl.BuilderImpl> systemControls) {
            this.systemControls = SystemControlsCopier.copyFromBuilder(systemControls);
        }

        public final Collection<ResourceRequirement.Builder> getResourceRequirements() {
            return resourceRequirements != null ? resourceRequirements.stream().map(ResourceRequirement::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(ResourceRequirement... resourceRequirements) {
            resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<ResourceRequirement.Builder>... resourceRequirements) {
            resourceRequirements(Stream.of(resourceRequirements).map(c -> ResourceRequirement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceRequirements(Collection<ResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copyFromBuilder(resourceRequirements);
        }

        public final FirelensConfiguration.Builder getFirelensConfiguration() {
            return firelensConfiguration != null ? firelensConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder firelensConfiguration(FirelensConfiguration firelensConfiguration) {
            this.firelensConfiguration = firelensConfiguration;
            return this;
        }

        public final void setFirelensConfiguration(FirelensConfiguration.BuilderImpl firelensConfiguration) {
            this.firelensConfiguration = firelensConfiguration != null ? firelensConfiguration.build() : null;
        }

        @Override
        public ContainerDefinition build() {
            return new ContainerDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
