/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContainerInstancesRequest extends EcsRequest implements
        ToCopyableBuilder<ListContainerInstancesRequest.Builder, ListContainerInstancesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListContainerInstancesRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListContainerInstancesRequest::filter)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListContainerInstancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListContainerInstancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListContainerInstancesRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, FILTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD));

    private final String cluster;

    private final String filter;

    private final String nextToken;

    private final Integer maxResults;

    private final String status;

    private ListContainerInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to list. If
     * you do not specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
     *         list. If you do not specify a cluster, the default cluster is assumed.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * <p>
     * You can filter the results of a <code>ListContainerInstances</code> operation with cluster query language
     * statements. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query
     * Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return You can filter the results of a <code>ListContainerInstances</code> operation with cluster query language
     *         statements. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster
     *         Query Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public String filter() {
        return filter;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a <code>ListContainerInstances</code> request indicating that more
     * results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was
     * provided, it is possible the number of results to be fewer than <code>maxResults</code>.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a <code>ListContainerInstances</code> request indicating
     *         that more results are available to fulfill the request and further calls will be needed. If
     *         <code>maxResults</code> was provided, it is possible the number of results to be fewer than
     *         <code>maxResults</code>.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of container instance results returned by <code>ListContainerInstances</code> in paginated
     * output. When this parameter is used, <code>ListContainerInstances</code> only returns <code>maxResults</code>
     * results in a single page along with a <code>nextToken</code> response element. The remaining results of the
     * initial request can be seen by sending another <code>ListContainerInstances</code> request with the returned
     * <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then
     * <code>ListContainerInstances</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of container instance results returned by <code>ListContainerInstances</code> in
     *         paginated output. When this parameter is used, <code>ListContainerInstances</code> only returns
     *         <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
     *         The remaining results of the initial request can be seen by sending another
     *         <code>ListContainerInstances</code> request with the returned <code>nextToken</code> value. This value
     *         can be between 1 and 100. If this parameter is not used, then <code>ListContainerInstances</code> returns
     *         up to 100 results and a <code>nextToken</code> value if applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filters the container instances by status. For example, if you specify the <code>DRAINING</code> status, the
     * results include only container instances that have been set to <code>DRAINING</code> using
     * <a>UpdateContainerInstancesState</a>. If you do not specify this parameter, the default is to include container
     * instances set to all states other than <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContainerInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filters the container instances by status. For example, if you specify the <code>DRAINING</code> status,
     *         the results include only container instances that have been set to <code>DRAINING</code> using
     *         <a>UpdateContainerInstancesState</a>. If you do not specify this parameter, the default is to include
     *         container instances set to all states other than <code>INACTIVE</code>.
     * @see ContainerInstanceStatus
     */
    public ContainerInstanceStatus status() {
        return ContainerInstanceStatus.fromValue(status);
    }

    /**
     * <p>
     * Filters the container instances by status. For example, if you specify the <code>DRAINING</code> status, the
     * results include only container instances that have been set to <code>DRAINING</code> using
     * <a>UpdateContainerInstancesState</a>. If you do not specify this parameter, the default is to include container
     * instances set to all states other than <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContainerInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filters the container instances by status. For example, if you specify the <code>DRAINING</code> status,
     *         the results include only container instances that have been set to <code>DRAINING</code> using
     *         <a>UpdateContainerInstancesState</a>. If you do not specify this parameter, the default is to include
     *         container instances set to all states other than <code>INACTIVE</code>.
     * @see ContainerInstanceStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainerInstancesRequest)) {
            return false;
        }
        ListContainerInstancesRequest other = (ListContainerInstancesRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(filter(), other.filter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListContainerInstancesRequest").add("Cluster", cluster()).add("Filter", filter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContainerInstancesRequest, T> g) {
        return obj -> g.apply((ListContainerInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListContainerInstancesRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to list.
         * If you do not specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
         *        list. If you do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * You can filter the results of a <code>ListContainerInstances</code> operation with cluster query language
         * statements. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query
         * Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param filter
         *        You can filter the results of a <code>ListContainerInstances</code> operation with cluster query
         *        language statements. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster
         *        Query Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(String filter);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a <code>ListContainerInstances</code> request indicating that
         * more results are available to fulfill the request and further calls will be needed. If
         * <code>maxResults</code> was provided, it is possible the number of results to be fewer than
         * <code>maxResults</code>.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a <code>ListContainerInstances</code> request
         *        indicating that more results are available to fulfill the request and further calls will be needed. If
         *        <code>maxResults</code> was provided, it is possible the number of results to be fewer than
         *        <code>maxResults</code>.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of container instance results returned by <code>ListContainerInstances</code> in paginated
         * output. When this parameter is used, <code>ListContainerInstances</code> only returns <code>maxResults</code>
         * results in a single page along with a <code>nextToken</code> response element. The remaining results of the
         * initial request can be seen by sending another <code>ListContainerInstances</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then
         * <code>ListContainerInstances</code> returns up to 100 results and a <code>nextToken</code> value if
         * applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of container instance results returned by <code>ListContainerInstances</code> in
         *        paginated output. When this parameter is used, <code>ListContainerInstances</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>ListContainerInstances</code> request with the returned <code>nextToken</code> value. This value
         *        can be between 1 and 100. If this parameter is not used, then <code>ListContainerInstances</code>
         *        returns up to 100 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters the container instances by status. For example, if you specify the <code>DRAINING</code> status, the
         * results include only container instances that have been set to <code>DRAINING</code> using
         * <a>UpdateContainerInstancesState</a>. If you do not specify this parameter, the default is to include
         * container instances set to all states other than <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        Filters the container instances by status. For example, if you specify the <code>DRAINING</code>
         *        status, the results include only container instances that have been set to <code>DRAINING</code> using
         *        <a>UpdateContainerInstancesState</a>. If you do not specify this parameter, the default is to include
         *        container instances set to all states other than <code>INACTIVE</code>.
         * @see ContainerInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerInstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Filters the container instances by status. For example, if you specify the <code>DRAINING</code> status, the
         * results include only container instances that have been set to <code>DRAINING</code> using
         * <a>UpdateContainerInstancesState</a>. If you do not specify this parameter, the default is to include
         * container instances set to all states other than <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        Filters the container instances by status. For example, if you specify the <code>DRAINING</code>
         *        status, the results include only container instances that have been set to <code>DRAINING</code> using
         *        <a>UpdateContainerInstancesState</a>. If you do not specify this parameter, the default is to include
         *        container instances set to all states other than <code>INACTIVE</code>.
         * @see ContainerInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerInstanceStatus
         */
        Builder status(ContainerInstanceStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String filter;

        private String nextToken;

        private Integer maxResults;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainerInstancesRequest model) {
            super(model);
            cluster(model.cluster);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            status(model.status);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getFilter() {
            return filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContainerInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContainerInstancesRequest build() {
            return new ListContainerInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
