/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.AgentUpdateStatus;
import software.amazon.awssdk.services.ecs.model.Attachment;
import software.amazon.awssdk.services.ecs.model.AttachmentsCopier;
import software.amazon.awssdk.services.ecs.model.Attribute;
import software.amazon.awssdk.services.ecs.model.AttributesCopier;
import software.amazon.awssdk.services.ecs.model.Resource;
import software.amazon.awssdk.services.ecs.model.ResourcesCopier;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.VersionInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerInstance> {
    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerInstance.getter(ContainerInstance::containerInstanceArn)).setter(ContainerInstance.setter(Builder::containerInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerInstance.getter(ContainerInstance::ec2InstanceId)).setter(ContainerInstance.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceId").build()}).build();
    private static final SdkField<String> CAPACITY_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerInstance.getter(ContainerInstance::capacityProviderName)).setter(ContainerInstance.setter(Builder::capacityProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderName").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ContainerInstance.getter(ContainerInstance::version)).setter(ContainerInstance.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<VersionInfo> VERSION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ContainerInstance.getter(ContainerInstance::versionInfo)).setter(ContainerInstance.setter(Builder::versionInfo)).constructor(VersionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionInfo").build()}).build();
    private static final SdkField<List<Resource>> REMAINING_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ContainerInstance.getter(ContainerInstance::remainingResources)).setter(ContainerInstance.setter(Builder::remainingResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remainingResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Resource>> REGISTERED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ContainerInstance.getter(ContainerInstance::registeredResources)).setter(ContainerInstance.setter(Builder::registeredResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerInstance.getter(ContainerInstance::status)).setter(ContainerInstance.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerInstance.getter(ContainerInstance::statusReason)).setter(ContainerInstance.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Boolean> AGENT_CONNECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ContainerInstance.getter(ContainerInstance::agentConnected)).setter(ContainerInstance.setter(Builder::agentConnected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentConnected").build()}).build();
    private static final SdkField<Integer> RUNNING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ContainerInstance.getter(ContainerInstance::runningTasksCount)).setter(ContainerInstance.setter(Builder::runningTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTasksCount").build()}).build();
    private static final SdkField<Integer> PENDING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ContainerInstance.getter(ContainerInstance::pendingTasksCount)).setter(ContainerInstance.setter(Builder::pendingTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingTasksCount").build()}).build();
    private static final SdkField<String> AGENT_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerInstance.getter(ContainerInstance::agentUpdateStatusAsString)).setter(ContainerInstance.setter(Builder::agentUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentUpdateStatus").build()}).build();
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ContainerInstance.getter(ContainerInstance::attributes)).setter(ContainerInstance.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> REGISTERED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ContainerInstance.getter(ContainerInstance::registeredAt)).setter(ContainerInstance.setter(Builder::registeredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredAt").build()}).build();
    private static final SdkField<List<Attachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ContainerInstance.getter(ContainerInstance::attachments)).setter(ContainerInstance.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ContainerInstance.getter(ContainerInstance::tags)).setter(ContainerInstance.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_INSTANCE_ARN_FIELD, EC2_INSTANCE_ID_FIELD, CAPACITY_PROVIDER_NAME_FIELD, VERSION_FIELD, VERSION_INFO_FIELD, REMAINING_RESOURCES_FIELD, REGISTERED_RESOURCES_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, AGENT_CONNECTED_FIELD, RUNNING_TASKS_COUNT_FIELD, PENDING_TASKS_COUNT_FIELD, AGENT_UPDATE_STATUS_FIELD, ATTRIBUTES_FIELD, REGISTERED_AT_FIELD, ATTACHMENTS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerInstanceArn;
    private final String ec2InstanceId;
    private final String capacityProviderName;
    private final Long version;
    private final VersionInfo versionInfo;
    private final List<Resource> remainingResources;
    private final List<Resource> registeredResources;
    private final String status;
    private final String statusReason;
    private final Boolean agentConnected;
    private final Integer runningTasksCount;
    private final Integer pendingTasksCount;
    private final String agentUpdateStatus;
    private final List<Attribute> attributes;
    private final Instant registeredAt;
    private final List<Attachment> attachments;
    private final List<Tag> tags;

    private ContainerInstance(BuilderImpl builder) {
        this.containerInstanceArn = builder.containerInstanceArn;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.capacityProviderName = builder.capacityProviderName;
        this.version = builder.version;
        this.versionInfo = builder.versionInfo;
        this.remainingResources = builder.remainingResources;
        this.registeredResources = builder.registeredResources;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.agentConnected = builder.agentConnected;
        this.runningTasksCount = builder.runningTasksCount;
        this.pendingTasksCount = builder.pendingTasksCount;
        this.agentUpdateStatus = builder.agentUpdateStatus;
        this.attributes = builder.attributes;
        this.registeredAt = builder.registeredAt;
        this.attachments = builder.attachments;
        this.tags = builder.tags;
    }

    public String containerInstanceArn() {
        return this.containerInstanceArn;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public String capacityProviderName() {
        return this.capacityProviderName;
    }

    public Long version() {
        return this.version;
    }

    public VersionInfo versionInfo() {
        return this.versionInfo;
    }

    public boolean hasRemainingResources() {
        return this.remainingResources != null && !(this.remainingResources instanceof SdkAutoConstructList);
    }

    public List<Resource> remainingResources() {
        return this.remainingResources;
    }

    public boolean hasRegisteredResources() {
        return this.registeredResources != null && !(this.registeredResources instanceof SdkAutoConstructList);
    }

    public List<Resource> registeredResources() {
        return this.registeredResources;
    }

    public String status() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Boolean agentConnected() {
        return this.agentConnected;
    }

    public Integer runningTasksCount() {
        return this.runningTasksCount;
    }

    public Integer pendingTasksCount() {
        return this.pendingTasksCount;
    }

    public AgentUpdateStatus agentUpdateStatus() {
        return AgentUpdateStatus.fromValue(this.agentUpdateStatus);
    }

    public String agentUpdateStatusAsString() {
        return this.agentUpdateStatus;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public List<Attribute> attributes() {
        return this.attributes;
    }

    public Instant registeredAt() {
        return this.registeredAt;
    }

    public boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public List<Attachment> attachments() {
        return this.attachments;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.remainingResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentConnected());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerInstance)) {
            return false;
        }
        ContainerInstance other = (ContainerInstance)obj;
        return Objects.equals(this.containerInstanceArn(), other.containerInstanceArn()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.capacityProviderName(), other.capacityProviderName()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.versionInfo(), other.versionInfo()) && Objects.equals(this.remainingResources(), other.remainingResources()) && Objects.equals(this.registeredResources(), other.registeredResources()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.agentConnected(), other.agentConnected()) && Objects.equals(this.runningTasksCount(), other.runningTasksCount()) && Objects.equals(this.pendingTasksCount(), other.pendingTasksCount()) && Objects.equals(this.agentUpdateStatusAsString(), other.agentUpdateStatusAsString()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.registeredAt(), other.registeredAt()) && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ContainerInstance").add("ContainerInstanceArn", (Object)this.containerInstanceArn()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("CapacityProviderName", (Object)this.capacityProviderName()).add("Version", (Object)this.version()).add("VersionInfo", (Object)this.versionInfo()).add("RemainingResources", this.remainingResources()).add("RegisteredResources", this.registeredResources()).add("Status", (Object)this.status()).add("StatusReason", (Object)this.statusReason()).add("AgentConnected", (Object)this.agentConnected()).add("RunningTasksCount", (Object)this.runningTasksCount()).add("PendingTasksCount", (Object)this.pendingTasksCount()).add("AgentUpdateStatus", (Object)this.agentUpdateStatusAsString()).add("Attributes", this.attributes()).add("RegisteredAt", (Object)this.registeredAt()).add("Attachments", this.attachments()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.containerInstanceArn()));
            }
            case "ec2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "capacityProviderName": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderName()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "versionInfo": {
                return Optional.ofNullable(clazz.cast(this.versionInfo()));
            }
            case "remainingResources": {
                return Optional.ofNullable(clazz.cast(this.remainingResources()));
            }
            case "registeredResources": {
                return Optional.ofNullable(clazz.cast(this.registeredResources()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "agentConnected": {
                return Optional.ofNullable(clazz.cast(this.agentConnected()));
            }
            case "runningTasksCount": {
                return Optional.ofNullable(clazz.cast(this.runningTasksCount()));
            }
            case "pendingTasksCount": {
                return Optional.ofNullable(clazz.cast(this.pendingTasksCount()));
            }
            case "agentUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.agentUpdateStatusAsString()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "registeredAt": {
                return Optional.ofNullable(clazz.cast(this.registeredAt()));
            }
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerInstance, T> g) {
        return obj -> g.apply((ContainerInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerInstanceArn;
        private String ec2InstanceId;
        private String capacityProviderName;
        private Long version;
        private VersionInfo versionInfo;
        private List<Resource> remainingResources = DefaultSdkAutoConstructList.getInstance();
        private List<Resource> registeredResources = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusReason;
        private Boolean agentConnected;
        private Integer runningTasksCount;
        private Integer pendingTasksCount;
        private String agentUpdateStatus;
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private Instant registeredAt;
        private List<Attachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerInstance model) {
            this.containerInstanceArn(model.containerInstanceArn);
            this.ec2InstanceId(model.ec2InstanceId);
            this.capacityProviderName(model.capacityProviderName);
            this.version(model.version);
            this.versionInfo(model.versionInfo);
            this.remainingResources(model.remainingResources);
            this.registeredResources(model.registeredResources);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.agentConnected(model.agentConnected);
            this.runningTasksCount(model.runningTasksCount);
            this.pendingTasksCount(model.pendingTasksCount);
            this.agentUpdateStatus(model.agentUpdateStatus);
            this.attributes(model.attributes);
            this.registeredAt(model.registeredAt);
            this.attachments(model.attachments);
            this.tags(model.tags);
        }

        public final String getContainerInstanceArn() {
            return this.containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getCapacityProviderName() {
            return this.capacityProviderName;
        }

        @Override
        public final Builder capacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        public final void setCapacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final VersionInfo.Builder getVersionInfo() {
            return this.versionInfo != null ? this.versionInfo.toBuilder() : null;
        }

        @Override
        public final Builder versionInfo(VersionInfo versionInfo) {
            this.versionInfo = versionInfo;
            return this;
        }

        public final void setVersionInfo(VersionInfo.BuilderImpl versionInfo) {
            this.versionInfo = versionInfo != null ? versionInfo.build() : null;
        }

        public final Collection<Resource.Builder> getRemainingResources() {
            return this.remainingResources != null ? (Collection)this.remainingResources.stream().map(Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remainingResources(Collection<Resource> remainingResources) {
            this.remainingResources = ResourcesCopier.copy(remainingResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remainingResources(Resource ... remainingResources) {
            this.remainingResources(Arrays.asList(remainingResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remainingResources(Consumer<Resource.Builder> ... remainingResources) {
            this.remainingResources(Stream.of(remainingResources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemainingResources(Collection<Resource.BuilderImpl> remainingResources) {
            this.remainingResources = ResourcesCopier.copyFromBuilder(remainingResources);
        }

        public final Collection<Resource.Builder> getRegisteredResources() {
            return this.registeredResources != null ? (Collection)this.registeredResources.stream().map(Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder registeredResources(Collection<Resource> registeredResources) {
            this.registeredResources = ResourcesCopier.copy(registeredResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registeredResources(Resource ... registeredResources) {
            this.registeredResources(Arrays.asList(registeredResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registeredResources(Consumer<Resource.Builder> ... registeredResources) {
            this.registeredResources(Stream.of(registeredResources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegisteredResources(Collection<Resource.BuilderImpl> registeredResources) {
            this.registeredResources = ResourcesCopier.copyFromBuilder(registeredResources);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Boolean getAgentConnected() {
            return this.agentConnected;
        }

        @Override
        public final Builder agentConnected(Boolean agentConnected) {
            this.agentConnected = agentConnected;
            return this;
        }

        public final void setAgentConnected(Boolean agentConnected) {
            this.agentConnected = agentConnected;
        }

        public final Integer getRunningTasksCount() {
            return this.runningTasksCount;
        }

        @Override
        public final Builder runningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
            return this;
        }

        public final void setRunningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
        }

        public final Integer getPendingTasksCount() {
            return this.pendingTasksCount;
        }

        @Override
        public final Builder pendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
            return this;
        }

        public final void setPendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
        }

        public final String getAgentUpdateStatus() {
            return this.agentUpdateStatus;
        }

        @Override
        public final Builder agentUpdateStatus(String agentUpdateStatus) {
            this.agentUpdateStatus = agentUpdateStatus;
            return this;
        }

        @Override
        public final Builder agentUpdateStatus(AgentUpdateStatus agentUpdateStatus) {
            this.agentUpdateStatus(agentUpdateStatus == null ? null : agentUpdateStatus.toString());
            return this;
        }

        public final void setAgentUpdateStatus(String agentUpdateStatus) {
            this.agentUpdateStatus = agentUpdateStatus;
        }

        public final Collection<Attribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributesCopier.copyFromBuilder(attributes);
        }

        public final Instant getRegisteredAt() {
            return this.registeredAt;
        }

        @Override
        public final Builder registeredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        public final void setRegisteredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
        }

        public final Collection<Attachment.Builder> getAttachments() {
            return this.attachments != null ? (Collection)this.attachments.stream().map(Attachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<Attachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (Attachment)((Attachment.Builder)Attachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentsCopier.copyFromBuilder(attachments);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public ContainerInstance build() {
            return new ContainerInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerInstance> {
        public Builder containerInstanceArn(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder capacityProviderName(String var1);

        public Builder version(Long var1);

        public Builder versionInfo(VersionInfo var1);

        default public Builder versionInfo(Consumer<VersionInfo.Builder> versionInfo) {
            return this.versionInfo((VersionInfo)((VersionInfo.Builder)VersionInfo.builder().applyMutation(versionInfo)).build());
        }

        public Builder remainingResources(Collection<Resource> var1);

        public Builder remainingResources(Resource ... var1);

        public Builder remainingResources(Consumer<Resource.Builder> ... var1);

        public Builder registeredResources(Collection<Resource> var1);

        public Builder registeredResources(Resource ... var1);

        public Builder registeredResources(Consumer<Resource.Builder> ... var1);

        public Builder status(String var1);

        public Builder statusReason(String var1);

        public Builder agentConnected(Boolean var1);

        public Builder runningTasksCount(Integer var1);

        public Builder pendingTasksCount(Integer var1);

        public Builder agentUpdateStatus(String var1);

        public Builder agentUpdateStatus(AgentUpdateStatus var1);

        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);

        public Builder registeredAt(Instant var1);

        public Builder attachments(Collection<Attachment> var1);

        public Builder attachments(Attachment ... var1);

        public Builder attachments(Consumer<Attachment.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

