/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.Setting;
import software.amazon.awssdk.services.ecs.model.SettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountSettingsResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, ListAccountSettingsResponse> {
    private static final SdkField<List<Setting>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("settings").getter(ListAccountSettingsResponse.getter(ListAccountSettingsResponse::settings)).setter(ListAccountSettingsResponse.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Setting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccountSettingsResponse.getter(ListAccountSettingsResponse::nextToken)).setter(ListAccountSettingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETTINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Setting> settings;
    private final String nextToken;

    private ListAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.settings = builder.settings;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSettings() {
        return this.settings != null && !(this.settings instanceof SdkAutoConstructList);
    }

    public List<Setting> settings() {
        return this.settings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountSettingsResponse)) {
            return false;
        }
        ListAccountSettingsResponse other = (ListAccountSettingsResponse)((Object)obj);
        return Objects.equals(this.settings(), other.settings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAccountSettingsResponse").add("Settings", this.settings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountSettingsResponse, T> g) {
        return obj -> g.apply((ListAccountSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<Setting> settings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountSettingsResponse model) {
            super(model);
            this.settings(model.settings);
            this.nextToken(model.nextToken);
        }

        public final Collection<Setting.Builder> getSettings() {
            return this.settings != null ? (Collection)this.settings.stream().map(Setting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder settings(Collection<Setting> settings) {
            this.settings = SettingsCopier.copy(settings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(Setting ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(Consumer<Setting.Builder> ... settings) {
            this.settings(Stream.of(settings).map(c -> (Setting)((Setting.Builder)Setting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSettings(Collection<Setting.BuilderImpl> settings) {
            this.settings = SettingsCopier.copyFromBuilder(settings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccountSettingsResponse build() {
            return new ListAccountSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountSettingsResponse> {
        public Builder settings(Collection<Setting> var1);

        public Builder settings(Setting ... var1);

        public Builder settings(Consumer<Setting.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

