/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.KeyValuePair;
import software.amazon.awssdk.services.ecs.model.ProxyConfigurationPropertiesCopier;
import software.amazon.awssdk.services.ecs.model.ProxyConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProxyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProxyConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ProxyConfiguration.getter(ProxyConfiguration::typeAsString)).setter(ProxyConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(ProxyConfiguration.getter(ProxyConfiguration::containerName)).setter(ProxyConfiguration.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<List<KeyValuePair>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("properties").getter(ProxyConfiguration.getter(ProxyConfiguration::properties)).setter(ProxyConfiguration.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONTAINER_NAME_FIELD, PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String containerName;
    private final List<KeyValuePair> properties;

    private ProxyConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.containerName = builder.containerName;
        this.properties = builder.properties;
    }

    public ProxyConfigurationType type() {
        return ProxyConfigurationType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String containerName() {
        return this.containerName;
    }

    public boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public List<KeyValuePair> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration other = (ProxyConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.properties(), other.properties());
    }

    public String toString() {
        return ToString.builder((String)"ProxyConfiguration").add("Type", (Object)this.typeAsString()).add("ContainerName", (Object)this.containerName()).add("Properties", this.properties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProxyConfiguration, T> g) {
        return obj -> g.apply((ProxyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String containerName;
        private List<KeyValuePair> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfiguration model) {
            this.type(model.type);
            this.containerName(model.containerName);
            this.properties(model.properties);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProxyConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getContainerName() {
            return this.containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public final Collection<KeyValuePair.Builder> getProperties() {
            return this.properties != null ? (Collection)this.properties.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder properties(Collection<KeyValuePair> properties) {
            this.properties = ProxyConfigurationPropertiesCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(KeyValuePair ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<KeyValuePair.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProperties(Collection<KeyValuePair.BuilderImpl> properties) {
            this.properties = ProxyConfigurationPropertiesCopier.copyFromBuilder(properties);
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder type(String var1);

        public Builder type(ProxyConfigurationType var1);

        public Builder containerName(String var1);

        public Builder properties(Collection<KeyValuePair> var1);

        public Builder properties(KeyValuePair ... var1);

        public Builder properties(Consumer<KeyValuePair.Builder> ... var1);
    }
}

