/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.AttachmentStateChange;
import software.amazon.awssdk.services.ecs.model.AttachmentStateChangesCopier;
import software.amazon.awssdk.services.ecs.model.ContainerStateChange;
import software.amazon.awssdk.services.ecs.model.ContainerStateChangesCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmitTaskStateChangeRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, SubmitTaskStateChangeRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::cluster)).setter(SubmitTaskStateChangeRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("task").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::task)).setter(SubmitTaskStateChangeRequest.setter(Builder::task)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::status)).setter(SubmitTaskStateChangeRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::reason)).setter(SubmitTaskStateChangeRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<List<ContainerStateChange>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::containers)).setter(SubmitTaskStateChangeRequest.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerStateChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttachmentStateChange>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachments").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::attachments)).setter(SubmitTaskStateChangeRequest.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentStateChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> PULL_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("pullStartedAt").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::pullStartedAt)).setter(SubmitTaskStateChangeRequest.setter(Builder::pullStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStartedAt").build()}).build();
    private static final SdkField<Instant> PULL_STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("pullStoppedAt").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::pullStoppedAt)).setter(SubmitTaskStateChangeRequest.setter(Builder::pullStoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStoppedAt").build()}).build();
    private static final SdkField<Instant> EXECUTION_STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("executionStoppedAt").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::executionStoppedAt)).setter(SubmitTaskStateChangeRequest.setter(Builder::executionStoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStoppedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASK_FIELD, STATUS_FIELD, REASON_FIELD, CONTAINERS_FIELD, ATTACHMENTS_FIELD, PULL_STARTED_AT_FIELD, PULL_STOPPED_AT_FIELD, EXECUTION_STOPPED_AT_FIELD));
    private final String cluster;
    private final String task;
    private final String status;
    private final String reason;
    private final List<ContainerStateChange> containers;
    private final List<AttachmentStateChange> attachments;
    private final Instant pullStartedAt;
    private final Instant pullStoppedAt;
    private final Instant executionStoppedAt;

    private SubmitTaskStateChangeRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.task = builder.task;
        this.status = builder.status;
        this.reason = builder.reason;
        this.containers = builder.containers;
        this.attachments = builder.attachments;
        this.pullStartedAt = builder.pullStartedAt;
        this.pullStoppedAt = builder.pullStoppedAt;
        this.executionStoppedAt = builder.executionStoppedAt;
    }

    public String cluster() {
        return this.cluster;
    }

    public String task() {
        return this.task;
    }

    public String status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public List<ContainerStateChange> containers() {
        return this.containers;
    }

    public boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public List<AttachmentStateChange> attachments() {
        return this.attachments;
    }

    public Instant pullStartedAt() {
        return this.pullStartedAt;
    }

    public Instant pullStoppedAt() {
        return this.pullStoppedAt;
    }

    public Instant executionStoppedAt() {
        return this.executionStoppedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.containers());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullStoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStoppedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitTaskStateChangeRequest)) {
            return false;
        }
        SubmitTaskStateChangeRequest other = (SubmitTaskStateChangeRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.pullStartedAt(), other.pullStartedAt()) && Objects.equals(this.pullStoppedAt(), other.pullStoppedAt()) && Objects.equals(this.executionStoppedAt(), other.executionStoppedAt());
    }

    public String toString() {
        return ToString.builder((String)"SubmitTaskStateChangeRequest").add("Cluster", (Object)this.cluster()).add("Task", (Object)this.task()).add("Status", (Object)this.status()).add("Reason", (Object)this.reason()).add("Containers", this.containers()).add("Attachments", this.attachments()).add("PullStartedAt", (Object)this.pullStartedAt()).add("PullStoppedAt", (Object)this.pullStoppedAt()).add("ExecutionStoppedAt", (Object)this.executionStoppedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "pullStartedAt": {
                return Optional.ofNullable(clazz.cast(this.pullStartedAt()));
            }
            case "pullStoppedAt": {
                return Optional.ofNullable(clazz.cast(this.pullStoppedAt()));
            }
            case "executionStoppedAt": {
                return Optional.ofNullable(clazz.cast(this.executionStoppedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitTaskStateChangeRequest, T> g) {
        return obj -> g.apply((SubmitTaskStateChangeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String task;
        private String status;
        private String reason;
        private List<ContainerStateChange> containers = DefaultSdkAutoConstructList.getInstance();
        private List<AttachmentStateChange> attachments = DefaultSdkAutoConstructList.getInstance();
        private Instant pullStartedAt;
        private Instant pullStoppedAt;
        private Instant executionStoppedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitTaskStateChangeRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.task(model.task);
            this.status(model.status);
            this.reason(model.reason);
            this.containers(model.containers);
            this.attachments(model.attachments);
            this.pullStartedAt(model.pullStartedAt);
            this.pullStoppedAt(model.pullStoppedAt);
            this.executionStoppedAt(model.executionStoppedAt);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getTask() {
            return this.task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Collection<ContainerStateChange.Builder> getContainers() {
            return this.containers != null ? (Collection)this.containers.stream().map(ContainerStateChange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containers(Collection<ContainerStateChange> containers) {
            this.containers = ContainerStateChangesCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(ContainerStateChange ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<ContainerStateChange.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (ContainerStateChange)((ContainerStateChange.Builder)ContainerStateChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainers(Collection<ContainerStateChange.BuilderImpl> containers) {
            this.containers = ContainerStateChangesCopier.copyFromBuilder(containers);
        }

        public final Collection<AttachmentStateChange.Builder> getAttachments() {
            return this.attachments != null ? (Collection)this.attachments.stream().map(AttachmentStateChange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<AttachmentStateChange> attachments) {
            this.attachments = AttachmentStateChangesCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AttachmentStateChange ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentStateChange.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (AttachmentStateChange)((AttachmentStateChange.Builder)AttachmentStateChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<AttachmentStateChange.BuilderImpl> attachments) {
            this.attachments = AttachmentStateChangesCopier.copyFromBuilder(attachments);
        }

        public final Instant getPullStartedAt() {
            return this.pullStartedAt;
        }

        @Override
        public final Builder pullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
            return this;
        }

        public final void setPullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
        }

        public final Instant getPullStoppedAt() {
            return this.pullStoppedAt;
        }

        @Override
        public final Builder pullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
            return this;
        }

        public final void setPullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
        }

        public final Instant getExecutionStoppedAt() {
            return this.executionStoppedAt;
        }

        @Override
        public final Builder executionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
            return this;
        }

        public final void setExecutionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitTaskStateChangeRequest build() {
            return new SubmitTaskStateChangeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubmitTaskStateChangeRequest> {
        public Builder cluster(String var1);

        public Builder task(String var1);

        public Builder status(String var1);

        public Builder reason(String var1);

        public Builder containers(Collection<ContainerStateChange> var1);

        public Builder containers(ContainerStateChange ... var1);

        public Builder containers(Consumer<ContainerStateChange.Builder> ... var1);

        public Builder attachments(Collection<AttachmentStateChange> var1);

        public Builder attachments(AttachmentStateChange ... var1);

        public Builder attachments(Consumer<AttachmentStateChange.Builder> ... var1);

        public Builder pullStartedAt(Instant var1);

        public Builder pullStoppedAt(Instant var1);

        public Builder executionStoppedAt(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

