/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration;
import software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration;
import software.amazon.awssdk.services.ecs.model.HostVolumeProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Volume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Volume> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Volume.getter(Volume::name)).setter(Volume.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<HostVolumeProperties> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("host").getter(Volume.getter(Volume::host)).setter(Volume.setter(Builder::host)).constructor(HostVolumeProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()}).build();
    private static final SdkField<DockerVolumeConfiguration> DOCKER_VOLUME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dockerVolumeConfiguration").getter(Volume.getter(Volume::dockerVolumeConfiguration)).setter(Volume.setter(Builder::dockerVolumeConfiguration)).constructor(DockerVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerVolumeConfiguration").build()}).build();
    private static final SdkField<EFSVolumeConfiguration> EFS_VOLUME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("efsVolumeConfiguration").getter(Volume.getter(Volume::efsVolumeConfiguration)).setter(Volume.setter(Builder::efsVolumeConfiguration)).constructor(EFSVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("efsVolumeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOST_FIELD, DOCKER_VOLUME_CONFIGURATION_FIELD, EFS_VOLUME_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final HostVolumeProperties host;
    private final DockerVolumeConfiguration dockerVolumeConfiguration;
    private final EFSVolumeConfiguration efsVolumeConfiguration;

    private Volume(BuilderImpl builder) {
        this.name = builder.name;
        this.host = builder.host;
        this.dockerVolumeConfiguration = builder.dockerVolumeConfiguration;
        this.efsVolumeConfiguration = builder.efsVolumeConfiguration;
    }

    public String name() {
        return this.name;
    }

    public HostVolumeProperties host() {
        return this.host;
    }

    public DockerVolumeConfiguration dockerVolumeConfiguration() {
        return this.dockerVolumeConfiguration;
    }

    public EFSVolumeConfiguration efsVolumeConfiguration() {
        return this.efsVolumeConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.dockerVolumeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.efsVolumeConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.host(), other.host()) && Objects.equals(this.dockerVolumeConfiguration(), other.dockerVolumeConfiguration()) && Objects.equals(this.efsVolumeConfiguration(), other.efsVolumeConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"Volume").add("Name", (Object)this.name()).add("Host", (Object)this.host()).add("DockerVolumeConfiguration", (Object)this.dockerVolumeConfiguration()).add("EfsVolumeConfiguration", (Object)this.efsVolumeConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "dockerVolumeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dockerVolumeConfiguration()));
            }
            case "efsVolumeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.efsVolumeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private HostVolumeProperties host;
        private DockerVolumeConfiguration dockerVolumeConfiguration;
        private EFSVolumeConfiguration efsVolumeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            this.name(model.name);
            this.host(model.host);
            this.dockerVolumeConfiguration(model.dockerVolumeConfiguration);
            this.efsVolumeConfiguration(model.efsVolumeConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final HostVolumeProperties.Builder getHost() {
            return this.host != null ? this.host.toBuilder() : null;
        }

        @Override
        public final Builder host(HostVolumeProperties host) {
            this.host = host;
            return this;
        }

        public final void setHost(HostVolumeProperties.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        public final DockerVolumeConfiguration.Builder getDockerVolumeConfiguration() {
            return this.dockerVolumeConfiguration != null ? this.dockerVolumeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dockerVolumeConfiguration(DockerVolumeConfiguration dockerVolumeConfiguration) {
            this.dockerVolumeConfiguration = dockerVolumeConfiguration;
            return this;
        }

        public final void setDockerVolumeConfiguration(DockerVolumeConfiguration.BuilderImpl dockerVolumeConfiguration) {
            this.dockerVolumeConfiguration = dockerVolumeConfiguration != null ? dockerVolumeConfiguration.build() : null;
        }

        public final EFSVolumeConfiguration.Builder getEfsVolumeConfiguration() {
            return this.efsVolumeConfiguration != null ? this.efsVolumeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder efsVolumeConfiguration(EFSVolumeConfiguration efsVolumeConfiguration) {
            this.efsVolumeConfiguration = efsVolumeConfiguration;
            return this;
        }

        public final void setEfsVolumeConfiguration(EFSVolumeConfiguration.BuilderImpl efsVolumeConfiguration) {
            this.efsVolumeConfiguration = efsVolumeConfiguration != null ? efsVolumeConfiguration.build() : null;
        }

        public Volume build() {
            return new Volume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Volume> {
        public Builder name(String var1);

        public Builder host(HostVolumeProperties var1);

        default public Builder host(Consumer<HostVolumeProperties.Builder> host) {
            return this.host((HostVolumeProperties)((HostVolumeProperties.Builder)HostVolumeProperties.builder().applyMutation(host)).build());
        }

        public Builder dockerVolumeConfiguration(DockerVolumeConfiguration var1);

        default public Builder dockerVolumeConfiguration(Consumer<DockerVolumeConfiguration.Builder> dockerVolumeConfiguration) {
            return this.dockerVolumeConfiguration((DockerVolumeConfiguration)((DockerVolumeConfiguration.Builder)DockerVolumeConfiguration.builder().applyMutation(dockerVolumeConfiguration)).build());
        }

        public Builder efsVolumeConfiguration(EFSVolumeConfiguration var1);

        default public Builder efsVolumeConfiguration(Consumer<EFSVolumeConfiguration.Builder> efsVolumeConfiguration) {
            return this.efsVolumeConfiguration((EFSVolumeConfiguration)((EFSVolumeConfiguration.Builder)EFSVolumeConfiguration.builder().applyMutation(efsVolumeConfiguration)).build());
        }
    }
}

