/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the networking details for a task or service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsVpcConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsVpcConfiguration.Builder, AwsVpcConfiguration> {
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(AwsVpcConfiguration::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroups")
            .getter(getter(AwsVpcConfiguration::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ASSIGN_PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assignPublicIp").getter(getter(AwsVpcConfiguration::assignPublicIpAsString))
            .setter(setter(Builder::assignPublicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignPublicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNETS_FIELD,
            SECURITY_GROUPS_FIELD, ASSIGN_PUBLIC_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> subnets;

    private final List<String> securityGroups;

    private final String assignPublicIp;

    private AwsVpcConfiguration(BuilderImpl builder) {
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.assignPublicIp = builder.assignPublicIp;
    }

    /**
     * Returns true if the Subnets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets associated with the task or service. There is a limit of 16 subnets that can be specified
     * per <code>AwsVpcConfiguration</code>.
     * </p>
     * <note>
     * <p>
     * All specified subnets must be from the same VPC.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the subnets associated with the task or service. There is a limit of 16 subnets that can be
     *         specified per <code>AwsVpcConfiguration</code>.</p> <note>
     *         <p>
     *         All specified subnets must be from the same VPC.
     *         </p>
     */
    public List<String> subnets() {
        return subnets;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups associated with the task or service. If you do not specify a security group, the
     * default security group for the VPC is used. There is a limit of 5 security groups that can be specified per
     * <code>AwsVpcConfiguration</code>.
     * </p>
     * <note>
     * <p>
     * All specified security groups must be from the same VPC.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the security groups associated with the task or service. If you do not specify a security
     *         group, the default security group for the VPC is used. There is a limit of 5 security groups that can be
     *         specified per <code>AwsVpcConfiguration</code>.</p> <note>
     *         <p>
     *         All specified security groups must be from the same VPC.
     *         </p>
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Whether the task's elastic network interface receives a public IP address. The default value is
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignPublicIp}
     * will return {@link AssignPublicIp#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignPublicIpAsString}.
     * </p>
     * 
     * @return Whether the task's elastic network interface receives a public IP address. The default value is
     *         <code>DISABLED</code>.
     * @see AssignPublicIp
     */
    public AssignPublicIp assignPublicIp() {
        return AssignPublicIp.fromValue(assignPublicIp);
    }

    /**
     * <p>
     * Whether the task's elastic network interface receives a public IP address. The default value is
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignPublicIp}
     * will return {@link AssignPublicIp#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignPublicIpAsString}.
     * </p>
     * 
     * @return Whether the task's elastic network interface receives a public IP address. The default value is
     *         <code>DISABLED</code>.
     * @see AssignPublicIp
     */
    public String assignPublicIpAsString() {
        return assignPublicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assignPublicIpAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsVpcConfiguration)) {
            return false;
        }
        AwsVpcConfiguration other = (AwsVpcConfiguration) obj;
        return hasSubnets() == other.hasSubnets() && Objects.equals(subnets(), other.subnets())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(assignPublicIpAsString(), other.assignPublicIpAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsVpcConfiguration").add("Subnets", hasSubnets() ? subnets() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("AssignPublicIp", assignPublicIpAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "securityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "assignPublicIp":
            return Optional.ofNullable(clazz.cast(assignPublicIpAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsVpcConfiguration, T> g) {
        return obj -> g.apply((AwsVpcConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsVpcConfiguration> {
        /**
         * <p>
         * The IDs of the subnets associated with the task or service. There is a limit of 16 subnets that can be
         * specified per <code>AwsVpcConfiguration</code>.
         * </p>
         * <note>
         * <p>
         * All specified subnets must be from the same VPC.
         * </p>
         * </note>
         * 
         * @param subnets
         *        The IDs of the subnets associated with the task or service. There is a limit of 16 subnets that can be
         *        specified per <code>AwsVpcConfiguration</code>.</p> <note>
         *        <p>
         *        All specified subnets must be from the same VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of the subnets associated with the task or service. There is a limit of 16 subnets that can be
         * specified per <code>AwsVpcConfiguration</code>.
         * </p>
         * <note>
         * <p>
         * All specified subnets must be from the same VPC.
         * </p>
         * </note>
         * 
         * @param subnets
         *        The IDs of the subnets associated with the task or service. There is a limit of 16 subnets that can be
         *        specified per <code>AwsVpcConfiguration</code>.</p> <note>
         *        <p>
         *        All specified subnets must be from the same VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The IDs of the security groups associated with the task or service. If you do not specify a security group,
         * the default security group for the VPC is used. There is a limit of 5 security groups that can be specified
         * per <code>AwsVpcConfiguration</code>.
         * </p>
         * <note>
         * <p>
         * All specified security groups must be from the same VPC.
         * </p>
         * </note>
         * 
         * @param securityGroups
         *        The IDs of the security groups associated with the task or service. If you do not specify a security
         *        group, the default security group for the VPC is used. There is a limit of 5 security groups that can
         *        be specified per <code>AwsVpcConfiguration</code>.</p> <note>
         *        <p>
         *        All specified security groups must be from the same VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The IDs of the security groups associated with the task or service. If you do not specify a security group,
         * the default security group for the VPC is used. There is a limit of 5 security groups that can be specified
         * per <code>AwsVpcConfiguration</code>.
         * </p>
         * <note>
         * <p>
         * All specified security groups must be from the same VPC.
         * </p>
         * </note>
         * 
         * @param securityGroups
         *        The IDs of the security groups associated with the task or service. If you do not specify a security
         *        group, the default security group for the VPC is used. There is a limit of 5 security groups that can
         *        be specified per <code>AwsVpcConfiguration</code>.</p> <note>
         *        <p>
         *        All specified security groups must be from the same VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * Whether the task's elastic network interface receives a public IP address. The default value is
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param assignPublicIp
         *        Whether the task's elastic network interface receives a public IP address. The default value is
         *        <code>DISABLED</code>.
         * @see AssignPublicIp
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignPublicIp
         */
        Builder assignPublicIp(String assignPublicIp);

        /**
         * <p>
         * Whether the task's elastic network interface receives a public IP address. The default value is
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param assignPublicIp
         *        Whether the task's elastic network interface receives a public IP address. The default value is
         *        <code>DISABLED</code>.
         * @see AssignPublicIp
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignPublicIp
         */
        Builder assignPublicIp(AssignPublicIp assignPublicIp);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String assignPublicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsVpcConfiguration model) {
            subnets(model.subnets);
            securityGroups(model.securityGroups);
            assignPublicIp(model.assignPublicIp);
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        public final String getAssignPublicIp() {
            return assignPublicIp;
        }

        @Override
        public final Builder assignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        @Override
        public final Builder assignPublicIp(AssignPublicIp assignPublicIp) {
            this.assignPublicIp(assignPublicIp == null ? null : assignPublicIp.toString());
            return this;
        }

        public final void setAssignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
        }

        @Override
        public AwsVpcConfiguration build() {
            return new AwsVpcConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
