/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCapacityProviderResponse extends EcsResponse implements
        ToCopyableBuilder<CreateCapacityProviderResponse.Builder, CreateCapacityProviderResponse> {
    private static final SdkField<CapacityProvider> CAPACITY_PROVIDER_FIELD = SdkField
            .<CapacityProvider> builder(MarshallingType.SDK_POJO).memberName("capacityProvider")
            .getter(getter(CreateCapacityProviderResponse::capacityProvider)).setter(setter(Builder::capacityProvider))
            .constructor(CapacityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_FIELD));

    private final CapacityProvider capacityProvider;

    private CreateCapacityProviderResponse(BuilderImpl builder) {
        super(builder);
        this.capacityProvider = builder.capacityProvider;
    }

    /**
     * <p>
     * The full description of the new capacity provider.
     * </p>
     * 
     * @return The full description of the new capacity provider.
     */
    public CapacityProvider capacityProvider() {
        return capacityProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityProvider());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityProviderResponse)) {
            return false;
        }
        CreateCapacityProviderResponse other = (CreateCapacityProviderResponse) obj;
        return Objects.equals(capacityProvider(), other.capacityProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCapacityProviderResponse").add("CapacityProvider", capacityProvider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacityProvider":
            return Optional.ofNullable(clazz.cast(capacityProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityProviderResponse, T> g) {
        return obj -> g.apply((CreateCapacityProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCapacityProviderResponse> {
        /**
         * <p>
         * The full description of the new capacity provider.
         * </p>
         * 
         * @param capacityProvider
         *        The full description of the new capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProvider(CapacityProvider capacityProvider);

        /**
         * <p>
         * The full description of the new capacity provider.
         * </p>
         * This is a convenience that creates an instance of the {@link CapacityProvider.Builder} avoiding the need to
         * create one manually via {@link CapacityProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link CapacityProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #capacityProvider(CapacityProvider)}.
         * 
         * @param capacityProvider
         *        a consumer that will call methods on {@link CapacityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProvider(CapacityProvider)
         */
        default Builder capacityProvider(Consumer<CapacityProvider.Builder> capacityProvider) {
            return capacityProvider(CapacityProvider.builder().applyMutation(capacityProvider).build());
        }
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private CapacityProvider capacityProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityProviderResponse model) {
            super(model);
            capacityProvider(model.capacityProvider);
        }

        public final CapacityProvider.Builder getCapacityProvider() {
            return capacityProvider != null ? capacityProvider.toBuilder() : null;
        }

        @Override
        public final Builder capacityProvider(CapacityProvider capacityProvider) {
            this.capacityProvider = capacityProvider;
            return this;
        }

        public final void setCapacityProvider(CapacityProvider.BuilderImpl capacityProvider) {
            this.capacityProvider = capacityProvider != null ? capacityProvider.build() : null;
        }

        @Override
        public CreateCapacityProviderResponse build() {
            return new CreateCapacityProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
