/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTasksRequest extends EcsRequest implements
        ToCopyableBuilder<DescribeTasksRequest.Builder, DescribeTasksRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(DescribeTasksRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<List<String>> TASKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tasks")
            .getter(getter(DescribeTasksRequest::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("include")
            .getter(getter(DescribeTasksRequest::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASKS_FIELD,
            INCLUDE_FIELD));

    private final String cluster;

    private final List<String> tasks;

    private final List<String> include;

    private DescribeTasksRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.tasks = builder.tasks;
        this.include = builder.include;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to describe. If you
     * do not specify a cluster, the default cluster is assumed. This parameter is required if the task or tasks you are
     * describing were launched in any cluster other than the default cluster.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to
     *         describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if
     *         the task or tasks you are describing were launched in any cluster other than the default cluster.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * Returns true if the Tasks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 task IDs or full ARN entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTasks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of up to 100 task IDs or full ARN entries.
     */
    public List<String> tasks() {
        return tasks;
    }

    /**
     * <p>
     * Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the tags are
     * included in the response. If this field is omitted, tags are not included in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInclude()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the
     *         tags are included in the response. If this field is omitted, tags are not included in the response.
     */
    public List<TaskField> include() {
        return TaskFieldListCopier.copyStringToEnum(include);
    }

    /**
     * Returns true if the Include property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the tags are
     * included in the response. If this field is omitted, tags are not included in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInclude()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the
     *         tags are included in the response. If this field is omitted, tags are not included in the response.
     */
    public List<String> includeAsStrings() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? includeAsStrings() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTasksRequest)) {
            return false;
        }
        DescribeTasksRequest other = (DescribeTasksRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && hasTasks() == other.hasTasks()
                && Objects.equals(tasks(), other.tasks()) && hasInclude() == other.hasInclude()
                && Objects.equals(includeAsStrings(), other.includeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTasksRequest").add("Cluster", cluster()).add("Tasks", hasTasks() ? tasks() : null)
                .add("Include", hasInclude() ? includeAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTasksRequest, T> g) {
        return obj -> g.apply((DescribeTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTasksRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to describe. If
         * you do not specify a cluster, the default cluster is assumed. This parameter is required if the task or tasks
         * you are describing were launched in any cluster other than the default cluster.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to
         *        describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required
         *        if the task or tasks you are describing were launched in any cluster other than the default cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * A list of up to 100 task IDs or full ARN entries.
         * </p>
         * 
         * @param tasks
         *        A list of up to 100 task IDs or full ARN entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<String> tasks);

        /**
         * <p>
         * A list of up to 100 task IDs or full ARN entries.
         * </p>
         * 
         * @param tasks
         *        A list of up to 100 task IDs or full ARN entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(String... tasks);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the tags
         * are included in the response. If this field is omitted, tags are not included in the response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified,
         *        the tags are included in the response. If this field is omitted, tags are not included in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Collection<String> include);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the tags
         * are included in the response. If this field is omitted, tags are not included in the response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified,
         *        the tags are included in the response. If this field is omitted, tags are not included in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(String... include);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the tags
         * are included in the response. If this field is omitted, tags are not included in the response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified,
         *        the tags are included in the response. If this field is omitted, tags are not included in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<TaskField> include);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the tags
         * are included in the response. If this field is omitted, tags are not included in the response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified,
         *        the tags are included in the response. If this field is omitted, tags are not included in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(TaskField... include);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private List<String> tasks = DefaultSdkAutoConstructList.getInstance();

        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTasksRequest model) {
            super(model);
            cluster(model.cluster);
            tasks(model.tasks);
            includeWithStrings(model.include);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final Collection<String> getTasks() {
            if (tasks instanceof SdkAutoConstructList) {
                return null;
            }
            return tasks;
        }

        @Override
        public final Builder tasks(Collection<String> tasks) {
            this.tasks = StringListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(String... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        public final void setTasks(Collection<String> tasks) {
            this.tasks = StringListCopier.copy(tasks);
        }

        public final Collection<String> getInclude() {
            if (include instanceof SdkAutoConstructList) {
                return null;
            }
            return include;
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = TaskFieldListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String... include) {
            includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<TaskField> include) {
            this.include = TaskFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(TaskField... include) {
            include(Arrays.asList(include));
            return this;
        }

        public final void setInclude(Collection<String> include) {
            this.include = TaskFieldListCopier.copy(include);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTasksRequest build() {
            return new DescribeTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
