/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitTaskStateChangeResponse extends EcsResponse implements
        ToCopyableBuilder<SubmitTaskStateChangeResponse.Builder, SubmitTaskStateChangeResponse> {
    private static final SdkField<String> ACKNOWLEDGMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acknowledgment").getter(getter(SubmitTaskStateChangeResponse::acknowledgment))
            .setter(setter(Builder::acknowledgment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acknowledgment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACKNOWLEDGMENT_FIELD));

    private final String acknowledgment;

    private SubmitTaskStateChangeResponse(BuilderImpl builder) {
        super(builder);
        this.acknowledgment = builder.acknowledgment;
    }

    /**
     * <p>
     * Acknowledgement of the state change.
     * </p>
     * 
     * @return Acknowledgement of the state change.
     */
    public String acknowledgment() {
        return acknowledgment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitTaskStateChangeResponse)) {
            return false;
        }
        SubmitTaskStateChangeResponse other = (SubmitTaskStateChangeResponse) obj;
        return Objects.equals(acknowledgment(), other.acknowledgment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubmitTaskStateChangeResponse").add("Acknowledgment", acknowledgment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acknowledgment":
            return Optional.ofNullable(clazz.cast(acknowledgment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitTaskStateChangeResponse, T> g) {
        return obj -> g.apply((SubmitTaskStateChangeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, SubmitTaskStateChangeResponse> {
        /**
         * <p>
         * Acknowledgement of the state change.
         * </p>
         * 
         * @param acknowledgment
         *        Acknowledgement of the state change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgment(String acknowledgment);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private String acknowledgment;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitTaskStateChangeResponse model) {
            super(model);
            acknowledgment(model.acknowledgment);
        }

        public final String getAcknowledgment() {
            return acknowledgment;
        }

        @Override
        public final Builder acknowledgment(String acknowledgment) {
            this.acknowledgment = acknowledgment;
            return this;
        }

        public final void setAcknowledgment(String acknowledgment) {
            this.acknowledgment = acknowledgment;
        }

        @Override
        public SubmitTaskStateChangeResponse build() {
            return new SubmitTaskStateChangeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
