/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.AttachmentDetailsCopier;
import software.amazon.awssdk.services.ecs.model.KeyValuePair;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attachment> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Attachment.getter(Attachment::id)).setter(Attachment.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Attachment.getter(Attachment::type)).setter(Attachment.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Attachment.getter(Attachment::status)).setter(Attachment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<KeyValuePair>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("details").getter(Attachment.getter(Attachment::details)).setter(Attachment.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, STATUS_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String status;
    private final List<KeyValuePair> details;

    private Attachment(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.details = builder.details;
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public String status() {
        return this.status;
    }

    public boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructList);
    }

    public List<KeyValuePair> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetails() ? this.details() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.status(), other.status()) && this.hasDetails() == other.hasDetails() && Objects.equals(this.details(), other.details());
    }

    public String toString() {
        return ToString.builder((String)"Attachment").add("Id", (Object)this.id()).add("Type", (Object)this.type()).add("Status", (Object)this.status()).add("Details", this.hasDetails() ? this.details() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String status;
        private List<KeyValuePair> details = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            this.id(model.id);
            this.type(model.type);
            this.status(model.status);
            this.details(model.details);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<KeyValuePair.Builder> getDetails() {
            if (this.details instanceof SdkAutoConstructList) {
                return null;
            }
            return this.details != null ? (Collection)this.details.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<KeyValuePair> details) {
            this.details = AttachmentDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(KeyValuePair ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<KeyValuePair.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetails(Collection<KeyValuePair.BuilderImpl> details) {
            this.details = AttachmentDetailsCopier.copyFromBuilder(details);
        }

        public Attachment build() {
            return new Attachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attachment> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder status(String var1);

        public Builder details(Collection<KeyValuePair> var1);

        public Builder details(KeyValuePair ... var1);

        public Builder details(Consumer<KeyValuePair.Builder> ... var1);
    }
}

