/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitContainerStateChangeRequest extends EcsRequest implements
        ToCopyableBuilder<SubmitContainerStateChangeRequest.Builder, SubmitContainerStateChangeRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(SubmitContainerStateChangeRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> TASK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("task")
            .getter(getter(SubmitContainerStateChangeRequest::task)).setter(setter(Builder::task))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()).build();

    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerName").getter(getter(SubmitContainerStateChangeRequest::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()).build();

    private static final SdkField<String> RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runtimeId").getter(getter(SubmitContainerStateChangeRequest::runtimeId))
            .setter(setter(Builder::runtimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SubmitContainerStateChangeRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("exitCode").getter(getter(SubmitContainerStateChangeRequest::exitCode)).setter(setter(Builder::exitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(SubmitContainerStateChangeRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<List<NetworkBinding>> NETWORK_BINDINGS_FIELD = SdkField
            .<List<NetworkBinding>> builder(MarshallingType.LIST)
            .memberName("networkBindings")
            .getter(getter(SubmitContainerStateChangeRequest::networkBindings))
            .setter(setter(Builder::networkBindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkBindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkBinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkBinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASK_FIELD,
            CONTAINER_NAME_FIELD, RUNTIME_ID_FIELD, STATUS_FIELD, EXIT_CODE_FIELD, REASON_FIELD, NETWORK_BINDINGS_FIELD));

    private final String cluster;

    private final String task;

    private final String containerName;

    private final String runtimeId;

    private final String status;

    private final Integer exitCode;

    private final String reason;

    private final List<NetworkBinding> networkBindings;

    private SubmitContainerStateChangeRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.task = builder.task;
        this.containerName = builder.containerName;
        this.runtimeId = builder.runtimeId;
        this.status = builder.status;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.networkBindings = builder.networkBindings;
    }

    /**
     * <p>
     * The short name or full ARN of the cluster that hosts the container.
     * </p>
     * 
     * @return The short name or full ARN of the cluster that hosts the container.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.
     * </p>
     * 
     * @return The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.
     */
    public String task() {
        return task;
    }

    /**
     * <p>
     * The name of the container.
     * </p>
     * 
     * @return The name of the container.
     */
    public String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The ID of the Docker container.
     * </p>
     * 
     * @return The ID of the Docker container.
     */
    public String runtimeId() {
        return runtimeId;
    }

    /**
     * <p>
     * The status of the state change request.
     * </p>
     * 
     * @return The status of the state change request.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The exit code returned for the state change request.
     * </p>
     * 
     * @return The exit code returned for the state change request.
     */
    public Integer exitCode() {
        return exitCode;
    }

    /**
     * <p>
     * The reason for the state change request.
     * </p>
     * 
     * @return The reason for the state change request.
     */
    public String reason() {
        return reason;
    }

    /**
     * Returns true if the NetworkBindings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkBindings() {
        return networkBindings != null && !(networkBindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network bindings of the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkBindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The network bindings of the container.
     */
    public List<NetworkBinding> networkBindings() {
        return networkBindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkBindings() ? networkBindings() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitContainerStateChangeRequest)) {
            return false;
        }
        SubmitContainerStateChangeRequest other = (SubmitContainerStateChangeRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(task(), other.task())
                && Objects.equals(containerName(), other.containerName()) && Objects.equals(runtimeId(), other.runtimeId())
                && Objects.equals(status(), other.status()) && Objects.equals(exitCode(), other.exitCode())
                && Objects.equals(reason(), other.reason()) && hasNetworkBindings() == other.hasNetworkBindings()
                && Objects.equals(networkBindings(), other.networkBindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubmitContainerStateChangeRequest").add("Cluster", cluster()).add("Task", task())
                .add("ContainerName", containerName()).add("RuntimeId", runtimeId()).add("Status", status())
                .add("ExitCode", exitCode()).add("Reason", reason())
                .add("NetworkBindings", hasNetworkBindings() ? networkBindings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "task":
            return Optional.ofNullable(clazz.cast(task()));
        case "containerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "runtimeId":
            return Optional.ofNullable(clazz.cast(runtimeId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "exitCode":
            return Optional.ofNullable(clazz.cast(exitCode()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "networkBindings":
            return Optional.ofNullable(clazz.cast(networkBindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitContainerStateChangeRequest, T> g) {
        return obj -> g.apply((SubmitContainerStateChangeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubmitContainerStateChangeRequest> {
        /**
         * <p>
         * The short name or full ARN of the cluster that hosts the container.
         * </p>
         * 
         * @param cluster
         *        The short name or full ARN of the cluster that hosts the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.
         * </p>
         * 
         * @param task
         *        The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(String task);

        /**
         * <p>
         * The name of the container.
         * </p>
         * 
         * @param containerName
         *        The name of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The ID of the Docker container.
         * </p>
         * 
         * @param runtimeId
         *        The ID of the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeId(String runtimeId);

        /**
         * <p>
         * The status of the state change request.
         * </p>
         * 
         * @param status
         *        The status of the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The exit code returned for the state change request.
         * </p>
         * 
         * @param exitCode
         *        The exit code returned for the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(Integer exitCode);

        /**
         * <p>
         * The reason for the state change request.
         * </p>
         * 
         * @param reason
         *        The reason for the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The network bindings of the container.
         * </p>
         * 
         * @param networkBindings
         *        The network bindings of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBindings(Collection<NetworkBinding> networkBindings);

        /**
         * <p>
         * The network bindings of the container.
         * </p>
         * 
         * @param networkBindings
         *        The network bindings of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBindings(NetworkBinding... networkBindings);

        /**
         * <p>
         * The network bindings of the container.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkBinding>.Builder} avoiding the need
         * to create one manually via {@link List<NetworkBinding>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkBinding>.Builder#build()} is called immediately and
         * its result is passed to {@link #networkBindings(List<NetworkBinding>)}.
         * 
         * @param networkBindings
         *        a consumer that will call methods on {@link List<NetworkBinding>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkBindings(List<NetworkBinding>)
         */
        Builder networkBindings(Consumer<NetworkBinding.Builder>... networkBindings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String task;

        private String containerName;

        private String runtimeId;

        private String status;

        private Integer exitCode;

        private String reason;

        private List<NetworkBinding> networkBindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitContainerStateChangeRequest model) {
            super(model);
            cluster(model.cluster);
            task(model.task);
            containerName(model.containerName);
            runtimeId(model.runtimeId);
            status(model.status);
            exitCode(model.exitCode);
            reason(model.reason);
            networkBindings(model.networkBindings);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getTask() {
            return task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        public final String getContainerName() {
            return containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public final String getRuntimeId() {
            return runtimeId;
        }

        @Override
        public final Builder runtimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public final void setRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getExitCode() {
            return exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Collection<NetworkBinding.Builder> getNetworkBindings() {
            if (networkBindings instanceof SdkAutoConstructList) {
                return null;
            }
            return networkBindings != null ? networkBindings.stream().map(NetworkBinding::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkBindings(Collection<NetworkBinding> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copy(networkBindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(NetworkBinding... networkBindings) {
            networkBindings(Arrays.asList(networkBindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(Consumer<NetworkBinding.Builder>... networkBindings) {
            networkBindings(Stream.of(networkBindings).map(c -> NetworkBinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkBindings(Collection<NetworkBinding.BuilderImpl> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copyFromBuilder(networkBindings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitContainerStateChangeRequest build() {
            return new SubmitContainerStateChangeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
