/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.DeploymentCircuitBreaker;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentConfiguration> {
    private static final SdkField<DeploymentCircuitBreaker> DEPLOYMENT_CIRCUIT_BREAKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentCircuitBreaker").getter(DeploymentConfiguration.getter(DeploymentConfiguration::deploymentCircuitBreaker)).setter(DeploymentConfiguration.setter(Builder::deploymentCircuitBreaker)).constructor(DeploymentCircuitBreaker::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentCircuitBreaker").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumPercent").getter(DeploymentConfiguration.getter(DeploymentConfiguration::maximumPercent)).setter(DeploymentConfiguration.setter(Builder::maximumPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPercent").build()}).build();
    private static final SdkField<Integer> MINIMUM_HEALTHY_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumHealthyPercent").getter(DeploymentConfiguration.getter(DeploymentConfiguration::minimumHealthyPercent)).setter(DeploymentConfiguration.setter(Builder::minimumHealthyPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumHealthyPercent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CIRCUIT_BREAKER_FIELD, MAXIMUM_PERCENT_FIELD, MINIMUM_HEALTHY_PERCENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final DeploymentCircuitBreaker deploymentCircuitBreaker;
    private final Integer maximumPercent;
    private final Integer minimumHealthyPercent;

    private DeploymentConfiguration(BuilderImpl builder) {
        this.deploymentCircuitBreaker = builder.deploymentCircuitBreaker;
        this.maximumPercent = builder.maximumPercent;
        this.minimumHealthyPercent = builder.minimumHealthyPercent;
    }

    public DeploymentCircuitBreaker deploymentCircuitBreaker() {
        return this.deploymentCircuitBreaker;
    }

    public Integer maximumPercent() {
        return this.maximumPercent;
    }

    public Integer minimumHealthyPercent() {
        return this.minimumHealthyPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentCircuitBreaker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumHealthyPercent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfiguration)) {
            return false;
        }
        DeploymentConfiguration other = (DeploymentConfiguration)obj;
        return Objects.equals(this.deploymentCircuitBreaker(), other.deploymentCircuitBreaker()) && Objects.equals(this.maximumPercent(), other.maximumPercent()) && Objects.equals(this.minimumHealthyPercent(), other.minimumHealthyPercent());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentConfiguration").add("DeploymentCircuitBreaker", (Object)this.deploymentCircuitBreaker()).add("MaximumPercent", (Object)this.maximumPercent()).add("MinimumHealthyPercent", (Object)this.minimumHealthyPercent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentCircuitBreaker": {
                return Optional.ofNullable(clazz.cast(this.deploymentCircuitBreaker()));
            }
            case "maximumPercent": {
                return Optional.ofNullable(clazz.cast(this.maximumPercent()));
            }
            case "minimumHealthyPercent": {
                return Optional.ofNullable(clazz.cast(this.minimumHealthyPercent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfiguration, T> g) {
        return obj -> g.apply((DeploymentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DeploymentCircuitBreaker deploymentCircuitBreaker;
        private Integer maximumPercent;
        private Integer minimumHealthyPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfiguration model) {
            this.deploymentCircuitBreaker(model.deploymentCircuitBreaker);
            this.maximumPercent(model.maximumPercent);
            this.minimumHealthyPercent(model.minimumHealthyPercent);
        }

        public final DeploymentCircuitBreaker.Builder getDeploymentCircuitBreaker() {
            return this.deploymentCircuitBreaker != null ? this.deploymentCircuitBreaker.toBuilder() : null;
        }

        @Override
        public final Builder deploymentCircuitBreaker(DeploymentCircuitBreaker deploymentCircuitBreaker) {
            this.deploymentCircuitBreaker = deploymentCircuitBreaker;
            return this;
        }

        public final void setDeploymentCircuitBreaker(DeploymentCircuitBreaker.BuilderImpl deploymentCircuitBreaker) {
            this.deploymentCircuitBreaker = deploymentCircuitBreaker != null ? deploymentCircuitBreaker.build() : null;
        }

        public final Integer getMaximumPercent() {
            return this.maximumPercent;
        }

        @Override
        public final Builder maximumPercent(Integer maximumPercent) {
            this.maximumPercent = maximumPercent;
            return this;
        }

        public final void setMaximumPercent(Integer maximumPercent) {
            this.maximumPercent = maximumPercent;
        }

        public final Integer getMinimumHealthyPercent() {
            return this.minimumHealthyPercent;
        }

        @Override
        public final Builder minimumHealthyPercent(Integer minimumHealthyPercent) {
            this.minimumHealthyPercent = minimumHealthyPercent;
            return this;
        }

        public final void setMinimumHealthyPercent(Integer minimumHealthyPercent) {
            this.minimumHealthyPercent = minimumHealthyPercent;
        }

        public DeploymentConfiguration build() {
            return new DeploymentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentConfiguration> {
        public Builder deploymentCircuitBreaker(DeploymentCircuitBreaker var1);

        default public Builder deploymentCircuitBreaker(Consumer<DeploymentCircuitBreaker.Builder> deploymentCircuitBreaker) {
            return this.deploymentCircuitBreaker((DeploymentCircuitBreaker)((DeploymentCircuitBreaker.Builder)DeploymentCircuitBreaker.builder().applyMutation(deploymentCircuitBreaker)).build());
        }

        public Builder maximumPercent(Integer var1);

        public Builder minimumHealthyPercent(Integer var1);
    }
}

