/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.SettingName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountSettingsRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, ListAccountSettingsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ListAccountSettingsRequest.getter(ListAccountSettingsRequest::nameAsString)).setter(ListAccountSettingsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(ListAccountSettingsRequest.getter(ListAccountSettingsRequest::value)).setter(ListAccountSettingsRequest.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(ListAccountSettingsRequest.getter(ListAccountSettingsRequest::principalArn)).setter(ListAccountSettingsRequest.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()}).build();
    private static final SdkField<Boolean> EFFECTIVE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("effectiveSettings").getter(ListAccountSettingsRequest.getter(ListAccountSettingsRequest::effectiveSettings)).setter(ListAccountSettingsRequest.setter(Builder::effectiveSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveSettings").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccountSettingsRequest.getter(ListAccountSettingsRequest::nextToken)).setter(ListAccountSettingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAccountSettingsRequest.getter(ListAccountSettingsRequest::maxResults)).setter(ListAccountSettingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD, PRINCIPAL_ARN_FIELD, EFFECTIVE_SETTINGS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String name;
    private final String value;
    private final String principalArn;
    private final Boolean effectiveSettings;
    private final String nextToken;
    private final Integer maxResults;

    private ListAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.value = builder.value;
        this.principalArn = builder.principalArn;
        this.effectiveSettings = builder.effectiveSettings;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public SettingName name() {
        return SettingName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public String principalArn() {
        return this.principalArn;
    }

    public Boolean effectiveSettings() {
        return this.effectiveSettings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountSettingsRequest)) {
            return false;
        }
        ListAccountSettingsRequest other = (ListAccountSettingsRequest)((Object)obj);
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.effectiveSettings(), other.effectiveSettings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListAccountSettingsRequest").add("Name", (Object)this.nameAsString()).add("Value", (Object)this.value()).add("PrincipalArn", (Object)this.principalArn()).add("EffectiveSettings", (Object)this.effectiveSettings()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "effectiveSettings": {
                return Optional.ofNullable(clazz.cast(this.effectiveSettings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountSettingsRequest, T> g) {
        return obj -> g.apply((ListAccountSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String value;
        private String principalArn;
        private Boolean effectiveSettings;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountSettingsRequest model) {
            super(model);
            this.name(model.name);
            this.value(model.value);
            this.principalArn(model.principalArn);
            this.effectiveSettings(model.effectiveSettings);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(SettingName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final Boolean getEffectiveSettings() {
            return this.effectiveSettings;
        }

        @Override
        public final Builder effectiveSettings(Boolean effectiveSettings) {
            this.effectiveSettings = effectiveSettings;
            return this;
        }

        public final void setEffectiveSettings(Boolean effectiveSettings) {
            this.effectiveSettings = effectiveSettings;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountSettingsRequest build() {
            return new ListAccountSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountSettingsRequest> {
        public Builder name(String var1);

        public Builder name(SettingName var1);

        public Builder value(String var1);

        public Builder principalArn(String var1);

        public Builder effectiveSettings(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

