/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ManagedScalingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedScaling
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedScaling> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ManagedScaling.getter(ManagedScaling::statusAsString)).setter(ManagedScaling.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("targetCapacity").getter(ManagedScaling.getter(ManagedScaling::targetCapacity)).setter(ManagedScaling.setter(Builder::targetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCapacity").build()}).build();
    private static final SdkField<Integer> MINIMUM_SCALING_STEP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumScalingStepSize").getter(ManagedScaling.getter(ManagedScaling::minimumScalingStepSize)).setter(ManagedScaling.setter(Builder::minimumScalingStepSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumScalingStepSize").build()}).build();
    private static final SdkField<Integer> MAXIMUM_SCALING_STEP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumScalingStepSize").getter(ManagedScaling.getter(ManagedScaling::maximumScalingStepSize)).setter(ManagedScaling.setter(Builder::maximumScalingStepSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumScalingStepSize").build()}).build();
    private static final SdkField<Integer> INSTANCE_WARMUP_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("instanceWarmupPeriod").getter(ManagedScaling.getter(ManagedScaling::instanceWarmupPeriod)).setter(ManagedScaling.setter(Builder::instanceWarmupPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceWarmupPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, TARGET_CAPACITY_FIELD, MINIMUM_SCALING_STEP_SIZE_FIELD, MAXIMUM_SCALING_STEP_SIZE_FIELD, INSTANCE_WARMUP_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Integer targetCapacity;
    private final Integer minimumScalingStepSize;
    private final Integer maximumScalingStepSize;
    private final Integer instanceWarmupPeriod;

    private ManagedScaling(BuilderImpl builder) {
        this.status = builder.status;
        this.targetCapacity = builder.targetCapacity;
        this.minimumScalingStepSize = builder.minimumScalingStepSize;
        this.maximumScalingStepSize = builder.maximumScalingStepSize;
        this.instanceWarmupPeriod = builder.instanceWarmupPeriod;
    }

    public ManagedScalingStatus status() {
        return ManagedScalingStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Integer targetCapacity() {
        return this.targetCapacity;
    }

    public Integer minimumScalingStepSize() {
        return this.minimumScalingStepSize;
    }

    public Integer maximumScalingStepSize() {
        return this.maximumScalingStepSize;
    }

    public Integer instanceWarmupPeriod() {
        return this.instanceWarmupPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumScalingStepSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumScalingStepSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceWarmupPeriod());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedScaling)) {
            return false;
        }
        ManagedScaling other = (ManagedScaling)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetCapacity(), other.targetCapacity()) && Objects.equals(this.minimumScalingStepSize(), other.minimumScalingStepSize()) && Objects.equals(this.maximumScalingStepSize(), other.maximumScalingStepSize()) && Objects.equals(this.instanceWarmupPeriod(), other.instanceWarmupPeriod());
    }

    public String toString() {
        return ToString.builder((String)"ManagedScaling").add("Status", (Object)this.statusAsString()).add("TargetCapacity", (Object)this.targetCapacity()).add("MinimumScalingStepSize", (Object)this.minimumScalingStepSize()).add("MaximumScalingStepSize", (Object)this.maximumScalingStepSize()).add("InstanceWarmupPeriod", (Object)this.instanceWarmupPeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "targetCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetCapacity()));
            }
            case "minimumScalingStepSize": {
                return Optional.ofNullable(clazz.cast(this.minimumScalingStepSize()));
            }
            case "maximumScalingStepSize": {
                return Optional.ofNullable(clazz.cast(this.maximumScalingStepSize()));
            }
            case "instanceWarmupPeriod": {
                return Optional.ofNullable(clazz.cast(this.instanceWarmupPeriod()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedScaling, T> g) {
        return obj -> g.apply((ManagedScaling)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Integer targetCapacity;
        private Integer minimumScalingStepSize;
        private Integer maximumScalingStepSize;
        private Integer instanceWarmupPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedScaling model) {
            this.status(model.status);
            this.targetCapacity(model.targetCapacity);
            this.minimumScalingStepSize(model.minimumScalingStepSize);
            this.maximumScalingStepSize(model.maximumScalingStepSize);
            this.instanceWarmupPeriod(model.instanceWarmupPeriod);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManagedScalingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getTargetCapacity() {
            return this.targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        public final Integer getMinimumScalingStepSize() {
            return this.minimumScalingStepSize;
        }

        @Override
        public final Builder minimumScalingStepSize(Integer minimumScalingStepSize) {
            this.minimumScalingStepSize = minimumScalingStepSize;
            return this;
        }

        public final void setMinimumScalingStepSize(Integer minimumScalingStepSize) {
            this.minimumScalingStepSize = minimumScalingStepSize;
        }

        public final Integer getMaximumScalingStepSize() {
            return this.maximumScalingStepSize;
        }

        @Override
        public final Builder maximumScalingStepSize(Integer maximumScalingStepSize) {
            this.maximumScalingStepSize = maximumScalingStepSize;
            return this;
        }

        public final void setMaximumScalingStepSize(Integer maximumScalingStepSize) {
            this.maximumScalingStepSize = maximumScalingStepSize;
        }

        public final Integer getInstanceWarmupPeriod() {
            return this.instanceWarmupPeriod;
        }

        @Override
        public final Builder instanceWarmupPeriod(Integer instanceWarmupPeriod) {
            this.instanceWarmupPeriod = instanceWarmupPeriod;
            return this;
        }

        public final void setInstanceWarmupPeriod(Integer instanceWarmupPeriod) {
            this.instanceWarmupPeriod = instanceWarmupPeriod;
        }

        public ManagedScaling build() {
            return new ManagedScaling(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedScaling> {
        public Builder status(String var1);

        public Builder status(ManagedScalingStatus var1);

        public Builder targetCapacity(Integer var1);

        public Builder minimumScalingStepSize(Integer var1);

        public Builder maximumScalingStepSize(Integer var1);

        public Builder instanceWarmupPeriod(Integer var1);
    }
}

