/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.LoadBalancer;
import software.amazon.awssdk.services.ecs.model.LoadBalancersCopier;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.Scale;
import software.amazon.awssdk.services.ecs.model.ServiceRegistriesCopier;
import software.amazon.awssdk.services.ecs.model.ServiceRegistry;
import software.amazon.awssdk.services.ecs.model.StabilityStatus;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskSet> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(TaskSet.getter(TaskSet::id)).setter(TaskSet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TASK_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskSetArn").getter(TaskSet.getter(TaskSet::taskSetArn)).setter(TaskSet.setter(Builder::taskSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSetArn").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(TaskSet.getter(TaskSet::serviceArn)).setter(TaskSet.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(TaskSet.getter(TaskSet::clusterArn)).setter(TaskSet.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startedBy").getter(TaskSet.getter(TaskSet::startedBy)).setter(TaskSet.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(TaskSet.getter(TaskSet::externalId)).setter(TaskSet.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TaskSet.getter(TaskSet::status)).setter(TaskSet.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinition").getter(TaskSet.getter(TaskSet::taskDefinition)).setter(TaskSet.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<Integer> COMPUTED_DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("computedDesiredCount").getter(TaskSet.getter(TaskSet::computedDesiredCount)).setter(TaskSet.setter(Builder::computedDesiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computedDesiredCount").build()}).build();
    private static final SdkField<Integer> PENDING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pendingCount").getter(TaskSet.getter(TaskSet::pendingCount)).setter(TaskSet.setter(Builder::pendingCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingCount").build()}).build();
    private static final SdkField<Integer> RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("runningCount").getter(TaskSet.getter(TaskSet::runningCount)).setter(TaskSet.setter(Builder::runningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningCount").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(TaskSet.getter(TaskSet::createdAt)).setter(TaskSet.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(TaskSet.getter(TaskSet::updatedAt)).setter(TaskSet.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchType").getter(TaskSet.getter(TaskSet::launchTypeAsString)).setter(TaskSet.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviderStrategy").getter(TaskSet.getter(TaskSet::capacityProviderStrategy)).setter(TaskSet.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(TaskSet.getter(TaskSet::platformVersion)).setter(TaskSet.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(TaskSet.getter(TaskSet::networkConfiguration)).setter(TaskSet.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loadBalancers").getter(TaskSet.getter(TaskSet::loadBalancers)).setter(TaskSet.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceRegistries").getter(TaskSet.getter(TaskSet::serviceRegistries)).setter(TaskSet.setter(Builder::serviceRegistries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceRegistry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Scale> SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scale").getter(TaskSet.getter(TaskSet::scale)).setter(TaskSet.setter(Builder::scale)).constructor(Scale::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()}).build();
    private static final SdkField<String> STABILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stabilityStatus").getter(TaskSet.getter(TaskSet::stabilityStatusAsString)).setter(TaskSet.setter(Builder::stabilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stabilityStatus").build()}).build();
    private static final SdkField<Instant> STABILITY_STATUS_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stabilityStatusAt").getter(TaskSet.getter(TaskSet::stabilityStatusAt)).setter(TaskSet.setter(Builder::stabilityStatusAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stabilityStatusAt").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(TaskSet.getter(TaskSet::tags)).setter(TaskSet.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TASK_SET_ARN_FIELD, SERVICE_ARN_FIELD, CLUSTER_ARN_FIELD, STARTED_BY_FIELD, EXTERNAL_ID_FIELD, STATUS_FIELD, TASK_DEFINITION_FIELD, COMPUTED_DESIRED_COUNT_FIELD, PENDING_COUNT_FIELD, RUNNING_COUNT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, LAUNCH_TYPE_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, NETWORK_CONFIGURATION_FIELD, LOAD_BALANCERS_FIELD, SERVICE_REGISTRIES_FIELD, SCALE_FIELD, STABILITY_STATUS_FIELD, STABILITY_STATUS_AT_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String taskSetArn;
    private final String serviceArn;
    private final String clusterArn;
    private final String startedBy;
    private final String externalId;
    private final String status;
    private final String taskDefinition;
    private final Integer computedDesiredCount;
    private final Integer pendingCount;
    private final Integer runningCount;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String launchType;
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final String platformVersion;
    private final NetworkConfiguration networkConfiguration;
    private final List<LoadBalancer> loadBalancers;
    private final List<ServiceRegistry> serviceRegistries;
    private final Scale scale;
    private final String stabilityStatus;
    private final Instant stabilityStatusAt;
    private final List<Tag> tags;

    private TaskSet(BuilderImpl builder) {
        this.id = builder.id;
        this.taskSetArn = builder.taskSetArn;
        this.serviceArn = builder.serviceArn;
        this.clusterArn = builder.clusterArn;
        this.startedBy = builder.startedBy;
        this.externalId = builder.externalId;
        this.status = builder.status;
        this.taskDefinition = builder.taskDefinition;
        this.computedDesiredCount = builder.computedDesiredCount;
        this.pendingCount = builder.pendingCount;
        this.runningCount = builder.runningCount;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.launchType = builder.launchType;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.platformVersion = builder.platformVersion;
        this.networkConfiguration = builder.networkConfiguration;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.scale = builder.scale;
        this.stabilityStatus = builder.stabilityStatus;
        this.stabilityStatusAt = builder.stabilityStatusAt;
        this.tags = builder.tags;
    }

    public String id() {
        return this.id;
    }

    public String taskSetArn() {
        return this.taskSetArn;
    }

    public String serviceArn() {
        return this.serviceArn;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public String startedBy() {
        return this.startedBy;
    }

    public String externalId() {
        return this.externalId;
    }

    public String status() {
        return this.status;
    }

    public String taskDefinition() {
        return this.taskDefinition;
    }

    public Integer computedDesiredCount() {
        return this.computedDesiredCount;
    }

    public Integer pendingCount() {
        return this.pendingCount;
    }

    public Integer runningCount() {
        return this.runningCount;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public String launchTypeAsString() {
        return this.launchType;
    }

    public boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public boolean hasLoadBalancers() {
        return this.loadBalancers != null && !(this.loadBalancers instanceof SdkAutoConstructList);
    }

    public List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public boolean hasServiceRegistries() {
        return this.serviceRegistries != null && !(this.serviceRegistries instanceof SdkAutoConstructList);
    }

    public List<ServiceRegistry> serviceRegistries() {
        return this.serviceRegistries;
    }

    public Scale scale() {
        return this.scale;
    }

    public StabilityStatus stabilityStatus() {
        return StabilityStatus.fromValue(this.stabilityStatus);
    }

    public String stabilityStatusAsString() {
        return this.stabilityStatus;
    }

    public Instant stabilityStatusAt() {
        return this.stabilityStatusAt;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.computedDesiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancers() ? this.loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceRegistries() ? this.serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scale());
        hashCode = 31 * hashCode + Objects.hashCode(this.stabilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stabilityStatusAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSet)) {
            return false;
        }
        TaskSet other = (TaskSet)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.taskSetArn(), other.taskSetArn()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.computedDesiredCount(), other.computedDesiredCount()) && Objects.equals(this.pendingCount(), other.pendingCount()) && Objects.equals(this.runningCount(), other.runningCount()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && this.hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy() && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && this.hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(this.loadBalancers(), other.loadBalancers()) && this.hasServiceRegistries() == other.hasServiceRegistries() && Objects.equals(this.serviceRegistries(), other.serviceRegistries()) && Objects.equals(this.scale(), other.scale()) && Objects.equals(this.stabilityStatusAsString(), other.stabilityStatusAsString()) && Objects.equals(this.stabilityStatusAt(), other.stabilityStatusAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"TaskSet").add("Id", (Object)this.id()).add("TaskSetArn", (Object)this.taskSetArn()).add("ServiceArn", (Object)this.serviceArn()).add("ClusterArn", (Object)this.clusterArn()).add("StartedBy", (Object)this.startedBy()).add("ExternalId", (Object)this.externalId()).add("Status", (Object)this.status()).add("TaskDefinition", (Object)this.taskDefinition()).add("ComputedDesiredCount", (Object)this.computedDesiredCount()).add("PendingCount", (Object)this.pendingCount()).add("RunningCount", (Object)this.runningCount()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("LaunchType", (Object)this.launchTypeAsString()).add("CapacityProviderStrategy", this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null).add("PlatformVersion", (Object)this.platformVersion()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("LoadBalancers", this.hasLoadBalancers() ? this.loadBalancers() : null).add("ServiceRegistries", this.hasServiceRegistries() ? this.serviceRegistries() : null).add("Scale", (Object)this.scale()).add("StabilityStatus", (Object)this.stabilityStatusAsString()).add("StabilityStatusAt", (Object)this.stabilityStatusAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "taskSetArn": {
                return Optional.ofNullable(clazz.cast(this.taskSetArn()));
            }
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "computedDesiredCount": {
                return Optional.ofNullable(clazz.cast(this.computedDesiredCount()));
            }
            case "pendingCount": {
                return Optional.ofNullable(clazz.cast(this.pendingCount()));
            }
            case "runningCount": {
                return Optional.ofNullable(clazz.cast(this.runningCount()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "capacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "loadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
            case "serviceRegistries": {
                return Optional.ofNullable(clazz.cast(this.serviceRegistries()));
            }
            case "scale": {
                return Optional.ofNullable(clazz.cast(this.scale()));
            }
            case "stabilityStatus": {
                return Optional.ofNullable(clazz.cast(this.stabilityStatusAsString()));
            }
            case "stabilityStatusAt": {
                return Optional.ofNullable(clazz.cast(this.stabilityStatusAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskSet, T> g) {
        return obj -> g.apply((TaskSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String taskSetArn;
        private String serviceArn;
        private String clusterArn;
        private String startedBy;
        private String externalId;
        private String status;
        private String taskDefinition;
        private Integer computedDesiredCount;
        private Integer pendingCount;
        private Integer runningCount;
        private Instant createdAt;
        private Instant updatedAt;
        private String launchType;
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private String platformVersion;
        private NetworkConfiguration networkConfiguration;
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();
        private Scale scale;
        private String stabilityStatus;
        private Instant stabilityStatusAt;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskSet model) {
            this.id(model.id);
            this.taskSetArn(model.taskSetArn);
            this.serviceArn(model.serviceArn);
            this.clusterArn(model.clusterArn);
            this.startedBy(model.startedBy);
            this.externalId(model.externalId);
            this.status(model.status);
            this.taskDefinition(model.taskDefinition);
            this.computedDesiredCount(model.computedDesiredCount);
            this.pendingCount(model.pendingCount);
            this.runningCount(model.runningCount);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.launchType(model.launchType);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.platformVersion(model.platformVersion);
            this.networkConfiguration(model.networkConfiguration);
            this.loadBalancers(model.loadBalancers);
            this.serviceRegistries(model.serviceRegistries);
            this.scale(model.scale);
            this.stabilityStatus(model.stabilityStatus);
            this.stabilityStatusAt(model.stabilityStatusAt);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTaskSetArn() {
            return this.taskSetArn;
        }

        @Override
        public final Builder taskSetArn(String taskSetArn) {
            this.taskSetArn = taskSetArn;
            return this;
        }

        public final void setTaskSetArn(String taskSetArn) {
            this.taskSetArn = taskSetArn;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final Integer getComputedDesiredCount() {
            return this.computedDesiredCount;
        }

        @Override
        public final Builder computedDesiredCount(Integer computedDesiredCount) {
            this.computedDesiredCount = computedDesiredCount;
            return this;
        }

        public final void setComputedDesiredCount(Integer computedDesiredCount) {
            this.computedDesiredCount = computedDesiredCount;
        }

        public final Integer getPendingCount() {
            return this.pendingCount;
        }

        @Override
        public final Builder pendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
            return this;
        }

        public final void setPendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
        }

        public final Integer getRunningCount() {
            return this.runningCount;
        }

        @Override
        public final Builder runningCount(Integer runningCount) {
            this.runningCount = runningCount;
            return this;
        }

        public final void setRunningCount(Integer runningCount) {
            this.runningCount = runningCount;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final Collection<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            if (this.capacityProviderStrategy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityProviderStrategy != null ? (Collection)this.capacityProviderStrategy.stream().map(CapacityProviderStrategyItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            if (this.loadBalancers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBalancers != null ? (Collection)this.loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        public final Collection<ServiceRegistry.Builder> getServiceRegistries() {
            if (this.serviceRegistries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceRegistries != null ? (Collection)this.serviceRegistries.stream().map(ServiceRegistry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry ... serviceRegistries) {
            this.serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... serviceRegistries) {
            this.serviceRegistries(Stream.of(serviceRegistries).map(c -> (ServiceRegistry)((ServiceRegistry.Builder)ServiceRegistry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        public final Scale.Builder getScale() {
            return this.scale != null ? this.scale.toBuilder() : null;
        }

        @Override
        public final Builder scale(Scale scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Scale.BuilderImpl scale) {
            this.scale = scale != null ? scale.build() : null;
        }

        public final String getStabilityStatus() {
            return this.stabilityStatus;
        }

        @Override
        public final Builder stabilityStatus(String stabilityStatus) {
            this.stabilityStatus = stabilityStatus;
            return this;
        }

        @Override
        public final Builder stabilityStatus(StabilityStatus stabilityStatus) {
            this.stabilityStatus(stabilityStatus == null ? null : stabilityStatus.toString());
            return this;
        }

        public final void setStabilityStatus(String stabilityStatus) {
            this.stabilityStatus = stabilityStatus;
        }

        public final Instant getStabilityStatusAt() {
            return this.stabilityStatusAt;
        }

        @Override
        public final Builder stabilityStatusAt(Instant stabilityStatusAt) {
            this.stabilityStatusAt = stabilityStatusAt;
            return this;
        }

        public final void setStabilityStatusAt(Instant stabilityStatusAt) {
            this.stabilityStatusAt = stabilityStatusAt;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public TaskSet build() {
            return new TaskSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskSet> {
        public Builder id(String var1);

        public Builder taskSetArn(String var1);

        public Builder serviceArn(String var1);

        public Builder clusterArn(String var1);

        public Builder startedBy(String var1);

        public Builder externalId(String var1);

        public Builder status(String var1);

        public Builder taskDefinition(String var1);

        public Builder computedDesiredCount(Integer var1);

        public Builder pendingCount(Integer var1);

        public Builder runningCount(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder platformVersion(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);

        public Builder serviceRegistries(Collection<ServiceRegistry> var1);

        public Builder serviceRegistries(ServiceRegistry ... var1);

        public Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... var1);

        public Builder scale(Scale var1);

        default public Builder scale(Consumer<Scale.Builder> scale) {
            return this.scale((Scale)((Scale.Builder)Scale.builder().applyMutation(scale)).build());
        }

        public Builder stabilityStatus(String var1);

        public Builder stabilityStatus(StabilityStatus var1);

        public Builder stabilityStatusAt(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

