/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoverPollEndpointRequest extends EcsRequest implements
        ToCopyableBuilder<DiscoverPollEndpointRequest.Builder, DiscoverPollEndpointRequest> {
    private static final SdkField<String> CONTAINER_INSTANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerInstance").getter(getter(DiscoverPollEndpointRequest::containerInstance))
            .setter(setter(Builder::containerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstance").build()).build();

    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(DiscoverPollEndpointRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_INSTANCE_FIELD,
            CLUSTER_FIELD));

    private final String containerInstance;

    private final String cluster;

    private DiscoverPollEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.containerInstance = builder.containerInstance;
        this.cluster = builder.cluster;
    }

    /**
     * <p>
     * The container instance ID or full ARN of the container instance. The ARN contains the <code>arn:aws:ecs</code>
     * namespace, followed by the Region of the container instance, the AWS account ID of the container instance owner,
     * the <code>container-instance</code> namespace, and then the container instance ID. For example,
     * <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.
     * </p>
     * 
     * @return The container instance ID or full ARN of the container instance. The ARN contains the
     *         <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the AWS account ID
     *         of the container instance owner, the <code>container-instance</code> namespace, and then the container
     *         instance ID. For example,
     *         <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.
     */
    public final String containerInstance() {
        return containerInstance;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster to which the container instance belongs.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster to which the container instance belongs.
     */
    public final String cluster() {
        return cluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverPollEndpointRequest)) {
            return false;
        }
        DiscoverPollEndpointRequest other = (DiscoverPollEndpointRequest) obj;
        return Objects.equals(containerInstance(), other.containerInstance()) && Objects.equals(cluster(), other.cluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoverPollEndpointRequest").add("ContainerInstance", containerInstance())
                .add("Cluster", cluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerInstance":
            return Optional.ofNullable(clazz.cast(containerInstance()));
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverPollEndpointRequest, T> g) {
        return obj -> g.apply((DiscoverPollEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DiscoverPollEndpointRequest> {
        /**
         * <p>
         * The container instance ID or full ARN of the container instance. The ARN contains the
         * <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the AWS account ID of
         * the container instance owner, the <code>container-instance</code> namespace, and then the container instance
         * ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.
         * </p>
         * 
         * @param containerInstance
         *        The container instance ID or full ARN of the container instance. The ARN contains the
         *        <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the AWS account
         *        ID of the container instance owner, the <code>container-instance</code> namespace, and then the
         *        container instance ID. For example,
         *        <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstance(String containerInstance);

        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster to which the container instance belongs.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster to which the container instance
         *        belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String containerInstance;

        private String cluster;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverPollEndpointRequest model) {
            super(model);
            containerInstance(model.containerInstance);
            cluster(model.cluster);
        }

        public final String getContainerInstance() {
            return containerInstance;
        }

        @Override
        public final Builder containerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
            return this;
        }

        public final void setContainerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DiscoverPollEndpointRequest build() {
            return new DiscoverPollEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
