/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterTaskDefinitionRequest extends EcsRequest implements
        ToCopyableBuilder<RegisterTaskDefinitionRequest.Builder, RegisterTaskDefinitionRequest> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("family")
            .getter(getter(RegisterTaskDefinitionRequest::family)).setter(setter(Builder::family))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("family").build()).build();

    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRoleArn").getter(getter(RegisterTaskDefinitionRequest::taskRoleArn))
            .setter(setter(Builder::taskRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(RegisterTaskDefinitionRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> NETWORK_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkMode").getter(getter(RegisterTaskDefinitionRequest::networkModeAsString))
            .setter(setter(Builder::networkMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkMode").build()).build();

    private static final SdkField<List<ContainerDefinition>> CONTAINER_DEFINITIONS_FIELD = SdkField
            .<List<ContainerDefinition>> builder(MarshallingType.LIST)
            .memberName("containerDefinitions")
            .getter(getter(RegisterTaskDefinitionRequest::containerDefinitions))
            .setter(setter(Builder::containerDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField
            .<List<Volume>> builder(MarshallingType.LIST)
            .memberName("volumes")
            .getter(getter(RegisterTaskDefinitionRequest::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Volume> builder(MarshallingType.SDK_POJO)
                                            .constructor(Volume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TaskDefinitionPlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<TaskDefinitionPlacementConstraint>> builder(MarshallingType.LIST)
            .memberName("placementConstraints")
            .getter(getter(RegisterTaskDefinitionRequest::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskDefinitionPlacementConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskDefinitionPlacementConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REQUIRES_COMPATIBILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("requiresCompatibilities")
            .getter(getter(RegisterTaskDefinitionRequest::requiresCompatibilitiesAsStrings))
            .setter(setter(Builder::requiresCompatibilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiresCompatibilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CPU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cpu")
            .getter(getter(RegisterTaskDefinitionRequest::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("memory")
            .getter(getter(RegisterTaskDefinitionRequest::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(RegisterTaskDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PID_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pidMode").getter(getter(RegisterTaskDefinitionRequest::pidModeAsString))
            .setter(setter(Builder::pidMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pidMode").build()).build();

    private static final SdkField<String> IPC_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipcMode").getter(getter(RegisterTaskDefinitionRequest::ipcModeAsString))
            .setter(setter(Builder::ipcMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipcMode").build()).build();

    private static final SdkField<ProxyConfiguration> PROXY_CONFIGURATION_FIELD = SdkField
            .<ProxyConfiguration> builder(MarshallingType.SDK_POJO).memberName("proxyConfiguration")
            .getter(getter(RegisterTaskDefinitionRequest::proxyConfiguration)).setter(setter(Builder::proxyConfiguration))
            .constructor(ProxyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proxyConfiguration").build())
            .build();

    private static final SdkField<List<InferenceAccelerator>> INFERENCE_ACCELERATORS_FIELD = SdkField
            .<List<InferenceAccelerator>> builder(MarshallingType.LIST)
            .memberName("inferenceAccelerators")
            .getter(getter(RegisterTaskDefinitionRequest::inferenceAccelerators))
            .setter(setter(Builder::inferenceAccelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceAccelerators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceAccelerator> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceAccelerator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD,
            TASK_ROLE_ARN_FIELD, EXECUTION_ROLE_ARN_FIELD, NETWORK_MODE_FIELD, CONTAINER_DEFINITIONS_FIELD, VOLUMES_FIELD,
            PLACEMENT_CONSTRAINTS_FIELD, REQUIRES_COMPATIBILITIES_FIELD, CPU_FIELD, MEMORY_FIELD, TAGS_FIELD, PID_MODE_FIELD,
            IPC_MODE_FIELD, PROXY_CONFIGURATION_FIELD, INFERENCE_ACCELERATORS_FIELD));

    private final String family;

    private final String taskRoleArn;

    private final String executionRoleArn;

    private final String networkMode;

    private final List<ContainerDefinition> containerDefinitions;

    private final List<Volume> volumes;

    private final List<TaskDefinitionPlacementConstraint> placementConstraints;

    private final List<String> requiresCompatibilities;

    private final String cpu;

    private final String memory;

    private final List<Tag> tags;

    private final String pidMode;

    private final String ipcMode;

    private final ProxyConfiguration proxyConfiguration;

    private final List<InferenceAccelerator> inferenceAccelerators;

    private RegisterTaskDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.family = builder.family;
        this.taskRoleArn = builder.taskRoleArn;
        this.executionRoleArn = builder.executionRoleArn;
        this.networkMode = builder.networkMode;
        this.containerDefinitions = builder.containerDefinitions;
        this.volumes = builder.volumes;
        this.placementConstraints = builder.placementConstraints;
        this.requiresCompatibilities = builder.requiresCompatibilities;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.tags = builder.tags;
        this.pidMode = builder.pidMode;
        this.ipcMode = builder.ipcMode;
        this.proxyConfiguration = builder.proxyConfiguration;
        this.inferenceAccelerators = builder.inferenceAccelerators;
    }

    /**
     * <p>
     * You must specify a <code>family</code> for a task definition, which allows you to track multiple versions of the
     * same task definition. The <code>family</code> is used as a name for your task definition. Up to 255 letters
     * (uppercase and lowercase), numbers, and hyphens are allowed.
     * </p>
     * 
     * @return You must specify a <code>family</code> for a task definition, which allows you to track multiple versions
     *         of the same task definition. The <code>family</code> is used as a name for your task definition. Up to
     *         255 letters (uppercase and lowercase), numbers, and hyphens are allowed.
     */
    public final String family() {
        return family;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All
     * containers in this task are granted the permissions that are specified in this role. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for Tasks</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can
     *         assume. All containers in this task are granted the permissions that are specified in this role. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for
     *         Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String taskRoleArn() {
        return taskRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission
     * to make AWS API calls on your behalf. The task execution IAM role is required depending on the requirements of
     * your task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
     * execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
     *         permission to make AWS API calls on your behalf. The task execution IAM role is required depending on the
     *         requirements of your task. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon
     *         ECS task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The Docker networking mode to use for the containers in the task. The valid values are <code>none</code>,
     * <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode is specified, the default is
     * <code>bridge</code>.
     * </p>
     * <p>
     * For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on Amazon
     * EC2 instances, any network mode can be used. If the network mode is set to <code>none</code>, you cannot specify
     * port mappings in your container definitions, and the tasks containers do not have external connectivity. The
     * <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers
     * because they use the EC2 network stack instead of the virtualized network stack provided by the
     * <code>bridge</code> mode.
     * </p>
     * <p>
     * With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to
     * the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface
     * port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings.
     * </p>
     * <important>
     * <p>
     * When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It is
     * considered best practice to use a non-root user.
     * </p>
     * </important>
     * <p>
     * If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and you must
     * specify a <a>NetworkConfiguration</a> value when you create a service or run a task with the task definition. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code> package, or
     * AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
     * </p>
     * </note>
     * <p>
     * If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a single
     * container instance when port mappings are used.
     * </p>
     * <p>
     * Docker for Windows uses different network modes than Docker for Linux. When you register a task definition with
     * Windows containers, you must not specify a network mode. If you use the console to register a task definition
     * with Windows containers, you must choose the <code>&lt;default&gt;</code> network mode object.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
     * settings</a> in the <i>Docker run reference</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkMode} will
     * return {@link NetworkMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkModeAsString}.
     * </p>
     * 
     * @return The Docker networking mode to use for the containers in the task. The valid values are <code>none</code>,
     *         <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode is specified, the
     *         default is <code>bridge</code>.</p>
     *         <p>
     *         For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks
     *         on Amazon EC2 instances, any network mode can be used. If the network mode is set to <code>none</code>,
     *         you cannot specify port mappings in your container definitions, and the tasks containers do not have
     *         external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest
     *         networking performance for containers because they use the EC2 network stack instead of the virtualized
     *         network stack provided by the <code>bridge</code> mode.
     *         </p>
     *         <p>
     *         With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped
     *         directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic
     *         network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of
     *         dynamic host port mappings.
     *         </p>
     *         <important>
     *         <p>
     *         When using the <code>host</code> network mode, you should not run containers using the root user (UID 0).
     *         It is considered best practice to use a non-root user.
     *         </p>
     *         </important>
     *         <p>
     *         If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and you
     *         must specify a <a>NetworkConfiguration</a> value when you create a service or run a task with the task
     *         definition. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
     *         Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code>
     *         package, or AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
     *         </p>
     *         </note>
     *         <p>
     *         If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a
     *         single container instance when port mappings are used.
     *         </p>
     *         <p>
     *         Docker for Windows uses different network modes than Docker for Linux. When you register a task
     *         definition with Windows containers, you must not specify a network mode. If you use the console to
     *         register a task definition with Windows containers, you must choose the <code>&lt;default&gt;</code>
     *         network mode object.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.docker.com/engine/reference/run/#network-settings">Network settings</a> in the
     *         <i>Docker run reference</i>.
     * @see NetworkMode
     */
    public final NetworkMode networkMode() {
        return NetworkMode.fromValue(networkMode);
    }

    /**
     * <p>
     * The Docker networking mode to use for the containers in the task. The valid values are <code>none</code>,
     * <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode is specified, the default is
     * <code>bridge</code>.
     * </p>
     * <p>
     * For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on Amazon
     * EC2 instances, any network mode can be used. If the network mode is set to <code>none</code>, you cannot specify
     * port mappings in your container definitions, and the tasks containers do not have external connectivity. The
     * <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers
     * because they use the EC2 network stack instead of the virtualized network stack provided by the
     * <code>bridge</code> mode.
     * </p>
     * <p>
     * With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to
     * the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface
     * port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings.
     * </p>
     * <important>
     * <p>
     * When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It is
     * considered best practice to use a non-root user.
     * </p>
     * </important>
     * <p>
     * If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and you must
     * specify a <a>NetworkConfiguration</a> value when you create a service or run a task with the task definition. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code> package, or
     * AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
     * </p>
     * </note>
     * <p>
     * If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a single
     * container instance when port mappings are used.
     * </p>
     * <p>
     * Docker for Windows uses different network modes than Docker for Linux. When you register a task definition with
     * Windows containers, you must not specify a network mode. If you use the console to register a task definition
     * with Windows containers, you must choose the <code>&lt;default&gt;</code> network mode object.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
     * settings</a> in the <i>Docker run reference</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkMode} will
     * return {@link NetworkMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkModeAsString}.
     * </p>
     * 
     * @return The Docker networking mode to use for the containers in the task. The valid values are <code>none</code>,
     *         <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode is specified, the
     *         default is <code>bridge</code>.</p>
     *         <p>
     *         For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks
     *         on Amazon EC2 instances, any network mode can be used. If the network mode is set to <code>none</code>,
     *         you cannot specify port mappings in your container definitions, and the tasks containers do not have
     *         external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest
     *         networking performance for containers because they use the EC2 network stack instead of the virtualized
     *         network stack provided by the <code>bridge</code> mode.
     *         </p>
     *         <p>
     *         With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped
     *         directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic
     *         network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of
     *         dynamic host port mappings.
     *         </p>
     *         <important>
     *         <p>
     *         When using the <code>host</code> network mode, you should not run containers using the root user (UID 0).
     *         It is considered best practice to use a non-root user.
     *         </p>
     *         </important>
     *         <p>
     *         If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and you
     *         must specify a <a>NetworkConfiguration</a> value when you create a service or run a task with the task
     *         definition. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
     *         Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code>
     *         package, or AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
     *         </p>
     *         </note>
     *         <p>
     *         If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a
     *         single container instance when port mappings are used.
     *         </p>
     *         <p>
     *         Docker for Windows uses different network modes than Docker for Linux. When you register a task
     *         definition with Windows containers, you must not specify a network mode. If you use the console to
     *         register a task definition with Windows containers, you must choose the <code>&lt;default&gt;</code>
     *         network mode object.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.docker.com/engine/reference/run/#network-settings">Network settings</a> in the
     *         <i>Docker run reference</i>.
     * @see NetworkMode
     */
    public final String networkModeAsString() {
        return networkMode;
    }

    /**
     * Returns true if the ContainerDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasContainerDefinitions() {
        return containerDefinitions != null && !(containerDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of container definitions in JSON format that describe the different containers that make up your task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContainerDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of container definitions in JSON format that describe the different containers that make up your
     *         task.
     */
    public final List<ContainerDefinition> containerDefinitions() {
        return containerDefinitions;
    }

    /**
     * Returns true if the Volumes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of volume definitions in JSON format that containers in your task may use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVolumes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of volume definitions in JSON format that containers in your task may use.
     */
    public final List<Volume> volumes() {
        return volumes;
    }

    /**
     * Returns true if the PlacementConstraints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPlacementConstraints() {
        return placementConstraints != null && !(placementConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints per
     * task (this limit includes constraints in the task definition and those specified at runtime).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlacementConstraints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints
     *         per task (this limit includes constraints in the task definition and those specified at runtime).
     */
    public final List<TaskDefinitionPlacementConstraint> placementConstraints() {
        return placementConstraints;
    }

    /**
     * <p>
     * The task launch type that Amazon ECS should validate the task definition against. A client exception is returned
     * if the task definition doesn't validate against the compatibilities specified. If no value is specified, the
     * parameter is omitted from the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequiresCompatibilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The task launch type that Amazon ECS should validate the task definition against. A client exception is
     *         returned if the task definition doesn't validate against the compatibilities specified. If no value is
     *         specified, the parameter is omitted from the response.
     */
    public final List<Compatibility> requiresCompatibilities() {
        return CompatibilityListCopier.copyStringToEnum(requiresCompatibilities);
    }

    /**
     * Returns true if the RequiresCompatibilities property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRequiresCompatibilities() {
        return requiresCompatibilities != null && !(requiresCompatibilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The task launch type that Amazon ECS should validate the task definition against. A client exception is returned
     * if the task definition doesn't validate against the compatibilities specified. If no value is specified, the
     * parameter is omitted from the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequiresCompatibilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The task launch type that Amazon ECS should validate the task definition against. A client exception is
     *         returned if the task definition doesn't validate against the compatibilities specified. If no value is
     *         specified, the parameter is omitted from the response.
     */
    public final List<String> requiresCompatibilitiesAsStrings() {
        return requiresCompatibilities;
    }

    /**
     * <p>
     * The number of CPU units used by the task. It can be expressed as an integer using CPU units, for example
     * <code>1024</code>, or as a string using vCPUs, for example <code>1 vCPU</code> or <code>1 vcpu</code>, in a task
     * definition. String values are converted to an integer indicating the CPU units when the task definition is
     * registered.
     * </p>
     * <note>
     * <p>
     * Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level
     * resources for Windows containers.
     * </p>
     * </note>
     * <p>
     * If you are using the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU
     * units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     * </p>
     * <p>
     * If you are using the Fargate launch type, this field is required and you must use one of the following values,
     * which determines your range of supported values for the <code>memory</code> parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6
     * GB), 7168 (7 GB), 8192 (8 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024
     * (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024
     * (1 GB)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of CPU units used by the task. It can be expressed as an integer using CPU units, for example
     *         <code>1024</code>, or as a string using vCPUs, for example <code>1 vCPU</code> or <code>1 vcpu</code>, in
     *         a task definition. String values are converted to an integer indicating the CPU units when the task
     *         definition is registered.</p> <note>
     *         <p>
     *         Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying
     *         container-level resources for Windows containers.
     *         </p>
     *         </note>
     *         <p>
     *         If you are using the EC2 launch type, this field is optional. Supported values are between
     *         <code>128</code> CPU units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code>
     *         vCPUs).
     *         </p>
     *         <p>
     *         If you are using the Fargate launch type, this field is required and you must use one of the following
     *         values, which determines your range of supported values for the <code>memory</code> parameter:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB),
     *         6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments
     *         of 1024 (1 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments
     *         of 1024 (1 GB)
     *         </p>
     *         </li>
     */
    public final String cpu() {
        return cpu;
    }

    /**
     * <p>
     * The amount of memory (in MiB) used by the task. It can be expressed as an integer using MiB, for example
     * <code>1024</code>, or as a string using GB, for example <code>1GB</code> or <code>1 GB</code>, in a task
     * definition. String values are converted to an integer indicating the MiB when the task definition is registered.
     * </p>
     * <note>
     * <p>
     * Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level
     * resources for Windows containers.
     * </p>
     * </note>
     * <p>
     * If using the EC2 launch type, this field is optional.
     * </p>
     * <p>
     * If using the Fargate launch type, this field is required and you must use one of the following values, which
     * determines your range of supported values for the <code>cpu</code> parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     * <code>cpu</code> values: 1024 (1 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4
     * vCPU)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The amount of memory (in MiB) used by the task. It can be expressed as an integer using MiB, for example
     *         <code>1024</code>, or as a string using GB, for example <code>1GB</code> or <code>1 GB</code>, in a task
     *         definition. String values are converted to an integer indicating the MiB when the task definition is
     *         registered.</p> <note>
     *         <p>
     *         Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying
     *         container-level resources for Windows containers.
     *         </p>
     *         </note>
     *         <p>
     *         If using the EC2 launch type, this field is optional.
     *         </p>
     *         <p>
     *         If using the Fargate launch type, this field is required and you must use one of the following values,
     *         which determines your range of supported values for the <code>cpu</code> parameter:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     *         <code>cpu</code> values: 1024 (1 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *         2048 (2 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *         4096 (4 vCPU)
     *         </p>
     *         </li>
     */
    public final String memory() {
        return memory;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of
     * a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this
     * prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata that you apply to the task definition to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or
     *         values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The process namespace to use for the containers in the task. The valid values are <code>host</code> or
     * <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that specified the
     * <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon
     * EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same process
     * namespace. If no value is specified, the default is a private namespace. For more information, see <a
     * href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run
     * reference</i>.
     * </p>
     * <p>
     * If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process
     * namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
     * security</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers or tasks run on AWS Fargate.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pidMode} will
     * return {@link PidMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pidModeAsString}.
     * </p>
     * 
     * @return The process namespace to use for the containers in the task. The valid values are <code>host</code> or
     *         <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that specified
     *         the <code>host</code> PID mode on the same container instance share the same process namespace with the
     *         host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task
     *         share the same process namespace. If no value is specified, the default is a private namespace. For more
     *         information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID
     *         settings</a> in the <i>Docker run reference</i>.</p>
     *         <p>
     *         If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process
     *         namespace expose. For more information, see <a
     *         href="https://docs.docker.com/engine/security/security/">Docker security</a>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is not supported for Windows containers or tasks run on AWS Fargate.
     *         </p>
     * @see PidMode
     */
    public final PidMode pidMode() {
        return PidMode.fromValue(pidMode);
    }

    /**
     * <p>
     * The process namespace to use for the containers in the task. The valid values are <code>host</code> or
     * <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that specified the
     * <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon
     * EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same process
     * namespace. If no value is specified, the default is a private namespace. For more information, see <a
     * href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run
     * reference</i>.
     * </p>
     * <p>
     * If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process
     * namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
     * security</a>.
     * </p>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers or tasks run on AWS Fargate.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pidMode} will
     * return {@link PidMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pidModeAsString}.
     * </p>
     * 
     * @return The process namespace to use for the containers in the task. The valid values are <code>host</code> or
     *         <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that specified
     *         the <code>host</code> PID mode on the same container instance share the same process namespace with the
     *         host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task
     *         share the same process namespace. If no value is specified, the default is a private namespace. For more
     *         information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID
     *         settings</a> in the <i>Docker run reference</i>.</p>
     *         <p>
     *         If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process
     *         namespace expose. For more information, see <a
     *         href="https://docs.docker.com/engine/security/security/">Docker security</a>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is not supported for Windows containers or tasks run on AWS Fargate.
     *         </p>
     * @see PidMode
     */
    public final String pidModeAsString() {
        return pidMode;
    }

    /**
     * <p>
     * The IPC resource namespace to use for the containers in the task. The valid values are <code>host</code>,
     * <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then all containers within the tasks
     * that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with
     * the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share
     * the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are
     * private and not shared with other containers in a task or on the container instance. If no value is specified,
     * then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more
     * information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in
     * the <i>Docker run reference</i>.
     * </p>
     * <p>
     * If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace
     * expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
     * security</a>.
     * </p>
     * <p>
     * If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task,
     * the following will apply to your IPC resource namespace. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
     * Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not
     * supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply
     * to all containers within a task.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers or tasks run on AWS Fargate.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipcMode} will
     * return {@link IpcMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipcModeAsString}.
     * </p>
     * 
     * @return The IPC resource namespace to use for the containers in the task. The valid values are <code>host</code>,
     *         <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then all containers within
     *         the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC
     *         resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the
     *         specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within
     *         the containers of a task are private and not shared with other containers in a task or on the container
     *         instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon
     *         setting on the container instance. For more information, see <a
     *         href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the <i>Docker
     *         run reference</i>.</p>
     *         <p>
     *         If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC
     *         namespace expose. For more information, see <a
     *         href="https://docs.docker.com/engine/security/security/">Docker security</a>.
     *         </p>
     *         <p>
     *         If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in
     *         the task, the following will apply to your IPC resource namespace. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
     *         Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are
     *         not supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will
     *         apply to all containers within a task.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This parameter is not supported for Windows containers or tasks run on AWS Fargate.
     *         </p>
     * @see IpcMode
     */
    public final IpcMode ipcMode() {
        return IpcMode.fromValue(ipcMode);
    }

    /**
     * <p>
     * The IPC resource namespace to use for the containers in the task. The valid values are <code>host</code>,
     * <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then all containers within the tasks
     * that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with
     * the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share
     * the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are
     * private and not shared with other containers in a task or on the container instance. If no value is specified,
     * then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more
     * information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in
     * the <i>Docker run reference</i>.
     * </p>
     * <p>
     * If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace
     * expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
     * security</a>.
     * </p>
     * <p>
     * If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task,
     * the following will apply to your IPC resource namespace. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
     * Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not
     * supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply
     * to all containers within a task.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This parameter is not supported for Windows containers or tasks run on AWS Fargate.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipcMode} will
     * return {@link IpcMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipcModeAsString}.
     * </p>
     * 
     * @return The IPC resource namespace to use for the containers in the task. The valid values are <code>host</code>,
     *         <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then all containers within
     *         the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC
     *         resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the
     *         specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within
     *         the containers of a task are private and not shared with other containers in a task or on the container
     *         instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon
     *         setting on the container instance. For more information, see <a
     *         href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the <i>Docker
     *         run reference</i>.</p>
     *         <p>
     *         If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC
     *         namespace expose. For more information, see <a
     *         href="https://docs.docker.com/engine/security/security/">Docker security</a>.
     *         </p>
     *         <p>
     *         If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in
     *         the task, the following will apply to your IPC resource namespace. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
     *         Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are
     *         not supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will
     *         apply to all containers within a task.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This parameter is not supported for Windows containers or tasks run on AWS Fargate.
     *         </p>
     * @see IpcMode
     */
    public final String ipcModeAsString() {
        return ipcMode;
    }

    /**
     * Returns the value of the ProxyConfiguration property for this object.
     * 
     * @return The value of the ProxyConfiguration property for this object.
     */
    public final ProxyConfiguration proxyConfiguration() {
        return proxyConfiguration;
    }

    /**
     * Returns true if the InferenceAccelerators property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInferenceAccelerators() {
        return inferenceAccelerators != null && !(inferenceAccelerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Elastic Inference accelerators to use for the containers in the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInferenceAccelerators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Elastic Inference accelerators to use for the containers in the task.
     */
    public final List<InferenceAccelerator> inferenceAccelerators() {
        return inferenceAccelerators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerDefinitions() ? containerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementConstraints() ? placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiresCompatibilities() ? requiresCompatibilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pidModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipcModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceAccelerators() ? inferenceAccelerators() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskDefinitionRequest)) {
            return false;
        }
        RegisterTaskDefinitionRequest other = (RegisterTaskDefinitionRequest) obj;
        return Objects.equals(family(), other.family()) && Objects.equals(taskRoleArn(), other.taskRoleArn())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(networkModeAsString(), other.networkModeAsString())
                && hasContainerDefinitions() == other.hasContainerDefinitions()
                && Objects.equals(containerDefinitions(), other.containerDefinitions()) && hasVolumes() == other.hasVolumes()
                && Objects.equals(volumes(), other.volumes()) && hasPlacementConstraints() == other.hasPlacementConstraints()
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && hasRequiresCompatibilities() == other.hasRequiresCompatibilities()
                && Objects.equals(requiresCompatibilitiesAsStrings(), other.requiresCompatibilitiesAsStrings())
                && Objects.equals(cpu(), other.cpu()) && Objects.equals(memory(), other.memory()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(pidModeAsString(), other.pidModeAsString())
                && Objects.equals(ipcModeAsString(), other.ipcModeAsString())
                && Objects.equals(proxyConfiguration(), other.proxyConfiguration())
                && hasInferenceAccelerators() == other.hasInferenceAccelerators()
                && Objects.equals(inferenceAccelerators(), other.inferenceAccelerators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterTaskDefinitionRequest").add("Family", family()).add("TaskRoleArn", taskRoleArn())
                .add("ExecutionRoleArn", executionRoleArn()).add("NetworkMode", networkModeAsString())
                .add("ContainerDefinitions", hasContainerDefinitions() ? containerDefinitions() : null)
                .add("Volumes", hasVolumes() ? volumes() : null)
                .add("PlacementConstraints", hasPlacementConstraints() ? placementConstraints() : null)
                .add("RequiresCompatibilities", hasRequiresCompatibilities() ? requiresCompatibilitiesAsStrings() : null)
                .add("Cpu", cpu()).add("Memory", memory()).add("Tags", hasTags() ? tags() : null)
                .add("PidMode", pidModeAsString()).add("IpcMode", ipcModeAsString())
                .add("ProxyConfiguration", proxyConfiguration())
                .add("InferenceAccelerators", hasInferenceAccelerators() ? inferenceAccelerators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "family":
            return Optional.ofNullable(clazz.cast(family()));
        case "taskRoleArn":
            return Optional.ofNullable(clazz.cast(taskRoleArn()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "networkMode":
            return Optional.ofNullable(clazz.cast(networkModeAsString()));
        case "containerDefinitions":
            return Optional.ofNullable(clazz.cast(containerDefinitions()));
        case "volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        case "placementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "requiresCompatibilities":
            return Optional.ofNullable(clazz.cast(requiresCompatibilitiesAsStrings()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "pidMode":
            return Optional.ofNullable(clazz.cast(pidModeAsString()));
        case "ipcMode":
            return Optional.ofNullable(clazz.cast(ipcModeAsString()));
        case "proxyConfiguration":
            return Optional.ofNullable(clazz.cast(proxyConfiguration()));
        case "inferenceAccelerators":
            return Optional.ofNullable(clazz.cast(inferenceAccelerators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTaskDefinitionRequest, T> g) {
        return obj -> g.apply((RegisterTaskDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterTaskDefinitionRequest> {
        /**
         * <p>
         * You must specify a <code>family</code> for a task definition, which allows you to track multiple versions of
         * the same task definition. The <code>family</code> is used as a name for your task definition. Up to 255
         * letters (uppercase and lowercase), numbers, and hyphens are allowed.
         * </p>
         * 
         * @param family
         *        You must specify a <code>family</code> for a task definition, which allows you to track multiple
         *        versions of the same task definition. The <code>family</code> is used as a name for your task
         *        definition. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can assume.
         * All containers in this task are granted the permissions that are specified in this role. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for
         * Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param taskRoleArn
         *        The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can
         *        assume. All containers in this task are granted the permissions that are specified in this role. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for
         *        Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRoleArn(String taskRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
         * permission to make AWS API calls on your behalf. The task execution IAM role is required depending on the
         * requirements of your task. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS
         * task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
         *        permission to make AWS API calls on your behalf. The task execution IAM role is required depending on
         *        the requirements of your task. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon
         *        ECS task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Docker networking mode to use for the containers in the task. The valid values are <code>none</code>,
         * <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode is specified, the default
         * is <code>bridge</code>.
         * </p>
         * <p>
         * For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on
         * Amazon EC2 instances, any network mode can be used. If the network mode is set to <code>none</code>, you
         * cannot specify port mappings in your container definitions, and the tasks containers do not have external
         * connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking
         * performance for containers because they use the EC2 network stack instead of the virtualized network stack
         * provided by the <code>bridge</code> mode.
         * </p>
         * <p>
         * With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly
         * to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network
         * interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port
         * mappings.
         * </p>
         * <important>
         * <p>
         * When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It
         * is considered best practice to use a non-root user.
         * </p>
         * </important>
         * <p>
         * If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and you must
         * specify a <a>NetworkConfiguration</a> value when you create a service or run a task with the task definition.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code>
         * package, or AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
         * </p>
         * </note>
         * <p>
         * If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a single
         * container instance when port mappings are used.
         * </p>
         * <p>
         * Docker for Windows uses different network modes than Docker for Linux. When you register a task definition
         * with Windows containers, you must not specify a network mode. If you use the console to register a task
         * definition with Windows containers, you must choose the <code>&lt;default&gt;</code> network mode object.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
         * settings</a> in the <i>Docker run reference</i>.
         * </p>
         * 
         * @param networkMode
         *        The Docker networking mode to use for the containers in the task. The valid values are
         *        <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode
         *        is specified, the default is <code>bridge</code>.</p>
         *        <p>
         *        For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS
         *        tasks on Amazon EC2 instances, any network mode can be used. If the network mode is set to
         *        <code>none</code>, you cannot specify port mappings in your container definitions, and the tasks
         *        containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network
         *        modes offer the highest networking performance for containers because they use the EC2 network stack
         *        instead of the virtualized network stack provided by the <code>bridge</code> mode.
         *        </p>
         *        <p>
         *        With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped
         *        directly to the corresponding host port (for the <code>host</code> network mode) or the attached
         *        elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take
         *        advantage of dynamic host port mappings.
         *        </p>
         *        <important>
         *        <p>
         *        When using the <code>host</code> network mode, you should not run containers using the root user (UID
         *        0). It is considered best practice to use a non-root user.
         *        </p>
         *        </important>
         *        <p>
         *        If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and
         *        you must specify a <a>NetworkConfiguration</a> value when you create a service or run a task with the
         *        task definition. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
         *        Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code>
         *        package, or AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
         *        </p>
         *        </note>
         *        <p>
         *        If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a
         *        single container instance when port mappings are used.
         *        </p>
         *        <p>
         *        Docker for Windows uses different network modes than Docker for Linux. When you register a task
         *        definition with Windows containers, you must not specify a network mode. If you use the console to
         *        register a task definition with Windows containers, you must choose the <code>&lt;default&gt;</code>
         *        network mode object.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.docker.com/engine/reference/run/#network-settings">Network settings</a> in the
         *        <i>Docker run reference</i>.
         * @see NetworkMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkMode
         */
        Builder networkMode(String networkMode);

        /**
         * <p>
         * The Docker networking mode to use for the containers in the task. The valid values are <code>none</code>,
         * <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode is specified, the default
         * is <code>bridge</code>.
         * </p>
         * <p>
         * For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on
         * Amazon EC2 instances, any network mode can be used. If the network mode is set to <code>none</code>, you
         * cannot specify port mappings in your container definitions, and the tasks containers do not have external
         * connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking
         * performance for containers because they use the EC2 network stack instead of the virtualized network stack
         * provided by the <code>bridge</code> mode.
         * </p>
         * <p>
         * With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly
         * to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network
         * interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port
         * mappings.
         * </p>
         * <important>
         * <p>
         * When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It
         * is considered best practice to use a non-root user.
         * </p>
         * </important>
         * <p>
         * If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and you must
         * specify a <a>NetworkConfiguration</a> value when you create a service or run a task with the task definition.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code>
         * package, or AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
         * </p>
         * </note>
         * <p>
         * If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a single
         * container instance when port mappings are used.
         * </p>
         * <p>
         * Docker for Windows uses different network modes than Docker for Linux. When you register a task definition
         * with Windows containers, you must not specify a network mode. If you use the console to register a task
         * definition with Windows containers, you must choose the <code>&lt;default&gt;</code> network mode object.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
         * settings</a> in the <i>Docker run reference</i>.
         * </p>
         * 
         * @param networkMode
         *        The Docker networking mode to use for the containers in the task. The valid values are
         *        <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode
         *        is specified, the default is <code>bridge</code>.</p>
         *        <p>
         *        For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS
         *        tasks on Amazon EC2 instances, any network mode can be used. If the network mode is set to
         *        <code>none</code>, you cannot specify port mappings in your container definitions, and the tasks
         *        containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network
         *        modes offer the highest networking performance for containers because they use the EC2 network stack
         *        instead of the virtualized network stack provided by the <code>bridge</code> mode.
         *        </p>
         *        <p>
         *        With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped
         *        directly to the corresponding host port (for the <code>host</code> network mode) or the attached
         *        elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take
         *        advantage of dynamic host port mappings.
         *        </p>
         *        <important>
         *        <p>
         *        When using the <code>host</code> network mode, you should not run containers using the root user (UID
         *        0). It is considered best practice to use a non-root user.
         *        </p>
         *        </important>
         *        <p>
         *        If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and
         *        you must specify a <a>NetworkConfiguration</a> value when you create a service or run a task with the
         *        task definition. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
         *        Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code>
         *        package, or AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
         *        </p>
         *        </note>
         *        <p>
         *        If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a
         *        single container instance when port mappings are used.
         *        </p>
         *        <p>
         *        Docker for Windows uses different network modes than Docker for Linux. When you register a task
         *        definition with Windows containers, you must not specify a network mode. If you use the console to
         *        register a task definition with Windows containers, you must choose the <code>&lt;default&gt;</code>
         *        network mode object.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.docker.com/engine/reference/run/#network-settings">Network settings</a> in the
         *        <i>Docker run reference</i>.
         * @see NetworkMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkMode
         */
        Builder networkMode(NetworkMode networkMode);

        /**
         * <p>
         * A list of container definitions in JSON format that describe the different containers that make up your task.
         * </p>
         * 
         * @param containerDefinitions
         *        A list of container definitions in JSON format that describe the different containers that make up
         *        your task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerDefinitions(Collection<ContainerDefinition> containerDefinitions);

        /**
         * <p>
         * A list of container definitions in JSON format that describe the different containers that make up your task.
         * </p>
         * 
         * @param containerDefinitions
         *        A list of container definitions in JSON format that describe the different containers that make up
         *        your task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerDefinitions(ContainerDefinition... containerDefinitions);

        /**
         * <p>
         * A list of container definitions in JSON format that describe the different containers that make up your task.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContainerDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<ContainerDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerDefinition>.Builder#build()} is called immediately
         * and its result is passed to {@link #containerDefinitions(List<ContainerDefinition>)}.
         * 
         * @param containerDefinitions
         *        a consumer that will call methods on {@link List<ContainerDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerDefinitions(List<ContainerDefinition>)
         */
        Builder containerDefinitions(Consumer<ContainerDefinition.Builder>... containerDefinitions);

        /**
         * <p>
         * A list of volume definitions in JSON format that containers in your task may use.
         * </p>
         * 
         * @param volumes
         *        A list of volume definitions in JSON format that containers in your task may use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<Volume> volumes);

        /**
         * <p>
         * A list of volume definitions in JSON format that containers in your task may use.
         * </p>
         * 
         * @param volumes
         *        A list of volume definitions in JSON format that containers in your task may use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Volume... volumes);

        /**
         * <p>
         * A list of volume definitions in JSON format that containers in your task may use.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Volume>.Builder} avoiding the need to
         * create one manually via {@link List<Volume>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Volume>.Builder#build()} is called immediately and its
         * result is passed to {@link #volumes(List<Volume>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on {@link List<Volume>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(List<Volume>)
         */
        Builder volumes(Consumer<Volume.Builder>... volumes);

        /**
         * <p>
         * An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints per
         * task (this limit includes constraints in the task definition and those specified at runtime).
         * </p>
         * 
         * @param placementConstraints
         *        An array of placement constraint objects to use for the task. You can specify a maximum of 10
         *        constraints per task (this limit includes constraints in the task definition and those specified at
         *        runtime).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints);

        /**
         * <p>
         * An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints per
         * task (this limit includes constraints in the task definition and those specified at runtime).
         * </p>
         * 
         * @param placementConstraints
         *        An array of placement constraint objects to use for the task. You can specify a maximum of 10
         *        constraints per task (this limit includes constraints in the task definition and those specified at
         *        runtime).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(TaskDefinitionPlacementConstraint... placementConstraints);

        /**
         * <p>
         * An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints per
         * task (this limit includes constraints in the task definition and those specified at runtime).
         * </p>
         * This is a convenience that creates an instance of the {@link List<TaskDefinitionPlacementConstraint>.Builder}
         * avoiding the need to create one manually via {@link List<TaskDefinitionPlacementConstraint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TaskDefinitionPlacementConstraint>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #placementConstraints(List<TaskDefinitionPlacementConstraint>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on {@link List<TaskDefinitionPlacementConstraint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(List<TaskDefinitionPlacementConstraint>)
         */
        Builder placementConstraints(Consumer<TaskDefinitionPlacementConstraint.Builder>... placementConstraints);

        /**
         * <p>
         * The task launch type that Amazon ECS should validate the task definition against. A client exception is
         * returned if the task definition doesn't validate against the compatibilities specified. If no value is
         * specified, the parameter is omitted from the response.
         * </p>
         * 
         * @param requiresCompatibilities
         *        The task launch type that Amazon ECS should validate the task definition against. A client exception
         *        is returned if the task definition doesn't validate against the compatibilities specified. If no value
         *        is specified, the parameter is omitted from the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresCompatibilitiesWithStrings(Collection<String> requiresCompatibilities);

        /**
         * <p>
         * The task launch type that Amazon ECS should validate the task definition against. A client exception is
         * returned if the task definition doesn't validate against the compatibilities specified. If no value is
         * specified, the parameter is omitted from the response.
         * </p>
         * 
         * @param requiresCompatibilities
         *        The task launch type that Amazon ECS should validate the task definition against. A client exception
         *        is returned if the task definition doesn't validate against the compatibilities specified. If no value
         *        is specified, the parameter is omitted from the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresCompatibilitiesWithStrings(String... requiresCompatibilities);

        /**
         * <p>
         * The task launch type that Amazon ECS should validate the task definition against. A client exception is
         * returned if the task definition doesn't validate against the compatibilities specified. If no value is
         * specified, the parameter is omitted from the response.
         * </p>
         * 
         * @param requiresCompatibilities
         *        The task launch type that Amazon ECS should validate the task definition against. A client exception
         *        is returned if the task definition doesn't validate against the compatibilities specified. If no value
         *        is specified, the parameter is omitted from the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresCompatibilities(Collection<Compatibility> requiresCompatibilities);

        /**
         * <p>
         * The task launch type that Amazon ECS should validate the task definition against. A client exception is
         * returned if the task definition doesn't validate against the compatibilities specified. If no value is
         * specified, the parameter is omitted from the response.
         * </p>
         * 
         * @param requiresCompatibilities
         *        The task launch type that Amazon ECS should validate the task definition against. A client exception
         *        is returned if the task definition doesn't validate against the compatibilities specified. If no value
         *        is specified, the parameter is omitted from the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresCompatibilities(Compatibility... requiresCompatibilities);

        /**
         * <p>
         * The number of CPU units used by the task. It can be expressed as an integer using CPU units, for example
         * <code>1024</code>, or as a string using vCPUs, for example <code>1 vCPU</code> or <code>1 vcpu</code>, in a
         * task definition. String values are converted to an integer indicating the CPU units when the task definition
         * is registered.
         * </p>
         * <note>
         * <p>
         * Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying
         * container-level resources for Windows containers.
         * </p>
         * </note>
         * <p>
         * If you are using the EC2 launch type, this field is optional. Supported values are between <code>128</code>
         * CPU units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
         * </p>
         * <p>
         * If you are using the Fargate launch type, this field is required and you must use one of the following
         * values, which determines your range of supported values for the <code>memory</code> parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         * </p>
         * </li>
         * <li>
         * <p>
         * 512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         * </p>
         * </li>
         * <li>
         * <p>
         * 1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB),
         * 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         * </p>
         * </li>
         * <li>
         * <p>
         * 2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of
         * 1024 (1 GB)
         * </p>
         * </li>
         * <li>
         * <p>
         * 4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of
         * 1024 (1 GB)
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpu
         *        The number of CPU units used by the task. It can be expressed as an integer using CPU units, for
         *        example <code>1024</code>, or as a string using vCPUs, for example <code>1 vCPU</code> or
         *        <code>1 vcpu</code>, in a task definition. String values are converted to an integer indicating the
         *        CPU units when the task definition is registered.</p> <note>
         *        <p>
         *        Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying
         *        container-level resources for Windows containers.
         *        </p>
         *        </note>
         *        <p>
         *        If you are using the EC2 launch type, this field is optional. Supported values are between
         *        <code>128</code> CPU units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (
         *        <code>10</code> vCPUs).
         *        </p>
         *        <p>
         *        If you are using the Fargate launch type, this field is required and you must use one of the following
         *        values, which determines your range of supported values for the <code>memory</code> parameter:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4
         *        GB)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5
         *        GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in
         *        increments of 1024 (1 GB)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in
         *        increments of 1024 (1 GB)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(String cpu);

        /**
         * <p>
         * The amount of memory (in MiB) used by the task. It can be expressed as an integer using MiB, for example
         * <code>1024</code>, or as a string using GB, for example <code>1GB</code> or <code>1 GB</code>, in a task
         * definition. String values are converted to an integer indicating the MiB when the task definition is
         * registered.
         * </p>
         * <note>
         * <p>
         * Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying
         * container-level resources for Windows containers.
         * </p>
         * </note>
         * <p>
         * If using the EC2 launch type, this field is optional.
         * </p>
         * <p>
         * If using the Fargate launch type, this field is required and you must use one of the following values, which
         * determines your range of supported values for the <code>cpu</code> parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
         * </p>
         * </li>
         * <li>
         * <p>
         * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
         * </p>
         * </li>
         * <li>
         * <p>
         * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
         * <code>cpu</code> values: 1024 (1 vCPU)
         * </p>
         * </li>
         * <li>
         * <p>
         * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048
         * (2 vCPU)
         * </p>
         * </li>
         * <li>
         * <p>
         * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096
         * (4 vCPU)
         * </p>
         * </li>
         * </ul>
         * 
         * @param memory
         *        The amount of memory (in MiB) used by the task. It can be expressed as an integer using MiB, for
         *        example <code>1024</code>, or as a string using GB, for example <code>1GB</code> or <code>1 GB</code>,
         *        in a task definition. String values are converted to an integer indicating the MiB when the task
         *        definition is registered.</p> <note>
         *        <p>
         *        Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying
         *        container-level resources for Windows containers.
         *        </p>
         *        </note>
         *        <p>
         *        If using the EC2 launch type, this field is optional.
         *        </p>
         *        <p>
         *        If using the Fargate launch type, this field is required and you must use one of the following values,
         *        which determines your range of supported values for the <code>cpu</code> parameter:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
         *        <code>cpu</code> values: 1024 (1 vCPU)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code>
         *        values: 2048 (2 vCPU)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code>
         *        values: 4096 (4 vCPU)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * The metadata that you apply to the task definition to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with
         * this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the task definition to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or
         *        values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the task definition to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with
         * this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the task definition to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or
         *        values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the task definition to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with
         * this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The process namespace to use for the containers in the task. The valid values are <code>host</code> or
         * <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that specified the
         * <code>host</code> PID mode on the same container instance share the same process namespace with the host
         * Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the
         * same process namespace. If no value is specified, the default is a private namespace. For more information,
         * see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the
         * <i>Docker run reference</i>.
         * </p>
         * <p>
         * If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process
         * namespace expose. For more information, see <a
         * href="https://docs.docker.com/engine/security/security/">Docker security</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers or tasks run on AWS Fargate.
         * </p>
         * </note>
         * 
         * @param pidMode
         *        The process namespace to use for the containers in the task. The valid values are <code>host</code> or
         *        <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that
         *        specified the <code>host</code> PID mode on the same container instance share the same process
         *        namespace with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within
         *        the specified task share the same process namespace. If no value is specified, the default is a
         *        private namespace. For more information, see <a
         *        href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the
         *        <i>Docker run reference</i>.</p>
         *        <p>
         *        If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired
         *        process namespace expose. For more information, see <a
         *        href="https://docs.docker.com/engine/security/security/">Docker security</a>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is not supported for Windows containers or tasks run on AWS Fargate.
         *        </p>
         * @see PidMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PidMode
         */
        Builder pidMode(String pidMode);

        /**
         * <p>
         * The process namespace to use for the containers in the task. The valid values are <code>host</code> or
         * <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that specified the
         * <code>host</code> PID mode on the same container instance share the same process namespace with the host
         * Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the
         * same process namespace. If no value is specified, the default is a private namespace. For more information,
         * see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the
         * <i>Docker run reference</i>.
         * </p>
         * <p>
         * If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process
         * namespace expose. For more information, see <a
         * href="https://docs.docker.com/engine/security/security/">Docker security</a>.
         * </p>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers or tasks run on AWS Fargate.
         * </p>
         * </note>
         * 
         * @param pidMode
         *        The process namespace to use for the containers in the task. The valid values are <code>host</code> or
         *        <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that
         *        specified the <code>host</code> PID mode on the same container instance share the same process
         *        namespace with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within
         *        the specified task share the same process namespace. If no value is specified, the default is a
         *        private namespace. For more information, see <a
         *        href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the
         *        <i>Docker run reference</i>.</p>
         *        <p>
         *        If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired
         *        process namespace expose. For more information, see <a
         *        href="https://docs.docker.com/engine/security/security/">Docker security</a>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is not supported for Windows containers or tasks run on AWS Fargate.
         *        </p>
         * @see PidMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PidMode
         */
        Builder pidMode(PidMode pidMode);

        /**
         * <p>
         * The IPC resource namespace to use for the containers in the task. The valid values are <code>host</code>,
         * <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then all containers within the
         * tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC
         * resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the
         * specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the
         * containers of a task are private and not shared with other containers in a task or on the container instance.
         * If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the
         * container instance. For more information, see <a
         * href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the <i>Docker run
         * reference</i>.
         * </p>
         * <p>
         * If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC
         * namespace expose. For more information, see <a
         * href="https://docs.docker.com/engine/security/security/">Docker security</a>.
         * </p>
         * <p>
         * If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the
         * task, the following will apply to your IPC resource namespace. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
         * Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not
         * supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will
         * apply to all containers within a task.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers or tasks run on AWS Fargate.
         * </p>
         * </note>
         * 
         * @param ipcMode
         *        The IPC resource namespace to use for the containers in the task. The valid values are
         *        <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then
         *        all containers within the tasks that specified the <code>host</code> IPC mode on the same container
         *        instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is
         *        specified, all containers within the specified task share the same IPC resources. If <code>none</code>
         *        is specified, then IPC resources within the containers of a task are private and not shared with other
         *        containers in a task or on the container instance. If no value is specified, then the IPC resource
         *        namespace sharing depends on the Docker daemon setting on the container instance. For more
         *        information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC
         *        settings</a> in the <i>Docker run reference</i>.</p>
         *        <p>
         *        If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC
         *        namespace expose. For more information, see <a
         *        href="https://docs.docker.com/engine/security/security/">Docker security</a>.
         *        </p>
         *        <p>
         *        If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers
         *        in the task, the following will apply to your IPC resource namespace. For more information, see <a
         *        href
         *        ="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
         *        Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code>
         *        are not supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code>
         *        will apply to all containers within a task.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This parameter is not supported for Windows containers or tasks run on AWS Fargate.
         *        </p>
         * @see IpcMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpcMode
         */
        Builder ipcMode(String ipcMode);

        /**
         * <p>
         * The IPC resource namespace to use for the containers in the task. The valid values are <code>host</code>,
         * <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then all containers within the
         * tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC
         * resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the
         * specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the
         * containers of a task are private and not shared with other containers in a task or on the container instance.
         * If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the
         * container instance. For more information, see <a
         * href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the <i>Docker run
         * reference</i>.
         * </p>
         * <p>
         * If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC
         * namespace expose. For more information, see <a
         * href="https://docs.docker.com/engine/security/security/">Docker security</a>.
         * </p>
         * <p>
         * If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the
         * task, the following will apply to your IPC resource namespace. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
         * Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not
         * supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will
         * apply to all containers within a task.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This parameter is not supported for Windows containers or tasks run on AWS Fargate.
         * </p>
         * </note>
         * 
         * @param ipcMode
         *        The IPC resource namespace to use for the containers in the task. The valid values are
         *        <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then
         *        all containers within the tasks that specified the <code>host</code> IPC mode on the same container
         *        instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is
         *        specified, all containers within the specified task share the same IPC resources. If <code>none</code>
         *        is specified, then IPC resources within the containers of a task are private and not shared with other
         *        containers in a task or on the container instance. If no value is specified, then the IPC resource
         *        namespace sharing depends on the Docker daemon setting on the container instance. For more
         *        information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC
         *        settings</a> in the <i>Docker run reference</i>.</p>
         *        <p>
         *        If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC
         *        namespace expose. For more information, see <a
         *        href="https://docs.docker.com/engine/security/security/">Docker security</a>.
         *        </p>
         *        <p>
         *        If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers
         *        in the task, the following will apply to your IPC resource namespace. For more information, see <a
         *        href
         *        ="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
         *        Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code>
         *        are not supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code>
         *        will apply to all containers within a task.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This parameter is not supported for Windows containers or tasks run on AWS Fargate.
         *        </p>
         * @see IpcMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpcMode
         */
        Builder ipcMode(IpcMode ipcMode);

        /**
         * Sets the value of the ProxyConfiguration property for this object.
         *
         * @param proxyConfiguration
         *        The new value for the ProxyConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfiguration(ProxyConfiguration proxyConfiguration);

        /**
         * Sets the value of the ProxyConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link ProxyConfiguration.Builder} avoiding the need to
         * create one manually via {@link ProxyConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProxyConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #proxyConfiguration(ProxyConfiguration)}.
         * 
         * @param proxyConfiguration
         *        a consumer that will call methods on {@link ProxyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxyConfiguration(ProxyConfiguration)
         */
        default Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfiguration) {
            return proxyConfiguration(ProxyConfiguration.builder().applyMutation(proxyConfiguration).build());
        }

        /**
         * <p>
         * The Elastic Inference accelerators to use for the containers in the task.
         * </p>
         * 
         * @param inferenceAccelerators
         *        The Elastic Inference accelerators to use for the containers in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAccelerators(Collection<InferenceAccelerator> inferenceAccelerators);

        /**
         * <p>
         * The Elastic Inference accelerators to use for the containers in the task.
         * </p>
         * 
         * @param inferenceAccelerators
         *        The Elastic Inference accelerators to use for the containers in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAccelerators(InferenceAccelerator... inferenceAccelerators);

        /**
         * <p>
         * The Elastic Inference accelerators to use for the containers in the task.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InferenceAccelerator>.Builder} avoiding the
         * need to create one manually via {@link List<InferenceAccelerator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InferenceAccelerator>.Builder#build()} is called immediately
         * and its result is passed to {@link #inferenceAccelerators(List<InferenceAccelerator>)}.
         * 
         * @param inferenceAccelerators
         *        a consumer that will call methods on {@link List<InferenceAccelerator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceAccelerators(List<InferenceAccelerator>)
         */
        Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder>... inferenceAccelerators);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String family;

        private String taskRoleArn;

        private String executionRoleArn;

        private String networkMode;

        private List<ContainerDefinition> containerDefinitions = DefaultSdkAutoConstructList.getInstance();

        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();

        private List<TaskDefinitionPlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<String> requiresCompatibilities = DefaultSdkAutoConstructList.getInstance();

        private String cpu;

        private String memory;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String pidMode;

        private String ipcMode;

        private ProxyConfiguration proxyConfiguration;

        private List<InferenceAccelerator> inferenceAccelerators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTaskDefinitionRequest model) {
            super(model);
            family(model.family);
            taskRoleArn(model.taskRoleArn);
            executionRoleArn(model.executionRoleArn);
            networkMode(model.networkMode);
            containerDefinitions(model.containerDefinitions);
            volumes(model.volumes);
            placementConstraints(model.placementConstraints);
            requiresCompatibilitiesWithStrings(model.requiresCompatibilities);
            cpu(model.cpu);
            memory(model.memory);
            tags(model.tags);
            pidMode(model.pidMode);
            ipcMode(model.ipcMode);
            proxyConfiguration(model.proxyConfiguration);
            inferenceAccelerators(model.inferenceAccelerators);
        }

        public final String getFamily() {
            return family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getTaskRoleArn() {
            return taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getNetworkMode() {
            return networkMode;
        }

        @Override
        public final Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        @Override
        public final Builder networkMode(NetworkMode networkMode) {
            this.networkMode(networkMode == null ? null : networkMode.toString());
            return this;
        }

        public final void setNetworkMode(String networkMode) {
            this.networkMode = networkMode;
        }

        public final Collection<ContainerDefinition.Builder> getContainerDefinitions() {
            if (containerDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return containerDefinitions != null ? containerDefinitions.stream().map(ContainerDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionsCopier.copy(containerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(ContainerDefinition... containerDefinitions) {
            containerDefinitions(Arrays.asList(containerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(Consumer<ContainerDefinition.Builder>... containerDefinitions) {
            containerDefinitions(Stream.of(containerDefinitions).map(c -> ContainerDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContainerDefinitions(Collection<ContainerDefinition.BuilderImpl> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionsCopier.copyFromBuilder(containerDefinitions);
        }

        public final Collection<Volume.Builder> getVolumes() {
            if (volumes instanceof SdkAutoConstructList) {
                return null;
            }
            return volumes != null ? volumes.stream().map(Volume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumeListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> Volume.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumeListCopier.copyFromBuilder(volumes);
        }

        public final Collection<TaskDefinitionPlacementConstraint.Builder> getPlacementConstraints() {
            if (placementConstraints instanceof SdkAutoConstructList) {
                return null;
            }
            return placementConstraints != null ? placementConstraints.stream().map(TaskDefinitionPlacementConstraint::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
            this.placementConstraints = TaskDefinitionPlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(TaskDefinitionPlacementConstraint... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<TaskDefinitionPlacementConstraint.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints)
                    .map(c -> TaskDefinitionPlacementConstraint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<TaskDefinitionPlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = TaskDefinitionPlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<String> getRequiresCompatibilities() {
            if (requiresCompatibilities instanceof SdkAutoConstructList) {
                return null;
            }
            return requiresCompatibilities;
        }

        @Override
        public final Builder requiresCompatibilitiesWithStrings(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copy(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilitiesWithStrings(String... requiresCompatibilities) {
            requiresCompatibilitiesWithStrings(Arrays.asList(requiresCompatibilities));
            return this;
        }

        @Override
        public final Builder requiresCompatibilities(Collection<Compatibility> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copyEnumToString(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilities(Compatibility... requiresCompatibilities) {
            requiresCompatibilities(Arrays.asList(requiresCompatibilities));
            return this;
        }

        public final void setRequiresCompatibilities(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copy(requiresCompatibilities);
        }

        public final String getCpu() {
            return cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public final String getMemory() {
            return memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getPidMode() {
            return pidMode;
        }

        @Override
        public final Builder pidMode(String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        @Override
        public final Builder pidMode(PidMode pidMode) {
            this.pidMode(pidMode == null ? null : pidMode.toString());
            return this;
        }

        public final void setPidMode(String pidMode) {
            this.pidMode = pidMode;
        }

        public final String getIpcMode() {
            return ipcMode;
        }

        @Override
        public final Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        @Override
        public final Builder ipcMode(IpcMode ipcMode) {
            this.ipcMode(ipcMode == null ? null : ipcMode.toString());
            return this;
        }

        public final void setIpcMode(String ipcMode) {
            this.ipcMode = ipcMode;
        }

        public final ProxyConfiguration.Builder getProxyConfiguration() {
            return proxyConfiguration != null ? proxyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public final void setProxyConfiguration(ProxyConfiguration.BuilderImpl proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration != null ? proxyConfiguration.build() : null;
        }

        public final Collection<InferenceAccelerator.Builder> getInferenceAccelerators() {
            if (inferenceAccelerators instanceof SdkAutoConstructList) {
                return null;
            }
            return inferenceAccelerators != null ? inferenceAccelerators.stream().map(InferenceAccelerator::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inferenceAccelerators(Collection<InferenceAccelerator> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copy(inferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(InferenceAccelerator... inferenceAccelerators) {
            inferenceAccelerators(Arrays.asList(inferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder>... inferenceAccelerators) {
            inferenceAccelerators(Stream.of(inferenceAccelerators)
                    .map(c -> InferenceAccelerator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInferenceAccelerators(Collection<InferenceAccelerator.BuilderImpl> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copyFromBuilder(inferenceAccelerators);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTaskDefinitionRequest build() {
            return new RegisterTaskDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
