/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.PropagateTags;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.TaskOverride;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTaskRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, StartTaskRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(StartTaskRequest.getter(StartTaskRequest::cluster)).setter(StartTaskRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<List<String>> CONTAINER_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerInstances").getter(StartTaskRequest.getter(StartTaskRequest::containerInstances)).setter(StartTaskRequest.setter(Builder::containerInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableECSManagedTags").getter(StartTaskRequest.getter(StartTaskRequest::enableECSManagedTags)).setter(StartTaskRequest.setter(Builder::enableECSManagedTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build()}).build();
    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableExecuteCommand").getter(StartTaskRequest.getter(StartTaskRequest::enableExecuteCommand)).setter(StartTaskRequest.setter(Builder::enableExecuteCommand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("group").getter(StartTaskRequest.getter(StartTaskRequest::group)).setter(StartTaskRequest.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(StartTaskRequest.getter(StartTaskRequest::networkConfiguration)).setter(StartTaskRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<TaskOverride> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrides").getter(StartTaskRequest.getter(StartTaskRequest::overrides)).setter(StartTaskRequest.setter(Builder::overrides)).constructor(TaskOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propagateTags").getter(StartTaskRequest.getter(StartTaskRequest::propagateTagsAsString)).setter(StartTaskRequest.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceId").getter(StartTaskRequest.getter(StartTaskRequest::referenceId)).setter(StartTaskRequest.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startedBy").getter(StartTaskRequest.getter(StartTaskRequest::startedBy)).setter(StartTaskRequest.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(StartTaskRequest.getter(StartTaskRequest::tags)).setter(StartTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinition").getter(StartTaskRequest.getter(StartTaskRequest::taskDefinition)).setter(StartTaskRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, CONTAINER_INSTANCES_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD, GROUP_FIELD, NETWORK_CONFIGURATION_FIELD, OVERRIDES_FIELD, PROPAGATE_TAGS_FIELD, REFERENCE_ID_FIELD, STARTED_BY_FIELD, TAGS_FIELD, TASK_DEFINITION_FIELD));
    private final String cluster;
    private final List<String> containerInstances;
    private final Boolean enableECSManagedTags;
    private final Boolean enableExecuteCommand;
    private final String group;
    private final NetworkConfiguration networkConfiguration;
    private final TaskOverride overrides;
    private final String propagateTags;
    private final String referenceId;
    private final String startedBy;
    private final List<Tag> tags;
    private final String taskDefinition;

    private StartTaskRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.containerInstances = builder.containerInstances;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.group = builder.group;
        this.networkConfiguration = builder.networkConfiguration;
        this.overrides = builder.overrides;
        this.propagateTags = builder.propagateTags;
        this.referenceId = builder.referenceId;
        this.startedBy = builder.startedBy;
        this.tags = builder.tags;
        this.taskDefinition = builder.taskDefinition;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final boolean hasContainerInstances() {
        return this.containerInstances != null && !(this.containerInstances instanceof SdkAutoConstructList);
    }

    public final List<String> containerInstances() {
        return this.containerInstances;
    }

    public final Boolean enableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public final Boolean enableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public final String group() {
        return this.group;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final TaskOverride overrides() {
        return this.overrides;
    }

    public final PropagateTags propagateTags() {
        return PropagateTags.fromValue(this.propagateTags);
    }

    public final String propagateTagsAsString() {
        return this.propagateTags;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String taskDefinition() {
        return this.taskDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerInstances() ? this.containerInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskRequest)) {
            return false;
        }
        StartTaskRequest other = (StartTaskRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && this.hasContainerInstances() == other.hasContainerInstances() && Objects.equals(this.containerInstances(), other.containerInstances()) && Objects.equals(this.enableECSManagedTags(), other.enableECSManagedTags()) && Objects.equals(this.enableExecuteCommand(), other.enableExecuteCommand()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.overrides(), other.overrides()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString()) && Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.startedBy(), other.startedBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.taskDefinition(), other.taskDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"StartTaskRequest").add("Cluster", (Object)this.cluster()).add("ContainerInstances", this.hasContainerInstances() ? this.containerInstances() : null).add("EnableECSManagedTags", (Object)this.enableECSManagedTags()).add("EnableExecuteCommand", (Object)this.enableExecuteCommand()).add("Group", (Object)this.group()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Overrides", (Object)this.overrides()).add("PropagateTags", (Object)this.propagateTagsAsString()).add("ReferenceId", (Object)this.referenceId()).add("StartedBy", (Object)this.startedBy()).add("Tags", this.hasTags() ? this.tags() : null).add("TaskDefinition", (Object)this.taskDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "containerInstances": {
                return Optional.ofNullable(clazz.cast(this.containerInstances()));
            }
            case "enableECSManagedTags": {
                return Optional.ofNullable(clazz.cast(this.enableECSManagedTags()));
            }
            case "enableExecuteCommand": {
                return Optional.ofNullable(clazz.cast(this.enableExecuteCommand()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
            case "referenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTaskRequest, T> g) {
        return obj -> g.apply((StartTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private List<String> containerInstances = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableECSManagedTags;
        private Boolean enableExecuteCommand;
        private String group;
        private NetworkConfiguration networkConfiguration;
        private TaskOverride overrides;
        private String propagateTags;
        private String referenceId;
        private String startedBy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String taskDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTaskRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.containerInstances(model.containerInstances);
            this.enableECSManagedTags(model.enableECSManagedTags);
            this.enableExecuteCommand(model.enableExecuteCommand);
            this.group(model.group);
            this.networkConfiguration(model.networkConfiguration);
            this.overrides(model.overrides);
            this.propagateTags(model.propagateTags);
            this.referenceId(model.referenceId);
            this.startedBy(model.startedBy);
            this.tags(model.tags);
            this.taskDefinition(model.taskDefinition);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final Collection<String> getContainerInstances() {
            if (this.containerInstances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerInstances;
        }

        @Override
        public final Builder containerInstances(Collection<String> containerInstances) {
            this.containerInstances = StringListCopier.copy(containerInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerInstances(String ... containerInstances) {
            this.containerInstances(Arrays.asList(containerInstances));
            return this;
        }

        public final void setContainerInstances(Collection<String> containerInstances) {
            this.containerInstances = StringListCopier.copy(containerInstances);
        }

        public final Boolean getEnableECSManagedTags() {
            return this.enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        public final Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final TaskOverride.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(TaskOverride overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(TaskOverride.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public final String getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTaskRequest build() {
            return new StartTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTaskRequest> {
        public Builder cluster(String var1);

        public Builder containerInstances(Collection<String> var1);

        public Builder containerInstances(String ... var1);

        public Builder enableECSManagedTags(Boolean var1);

        public Builder enableExecuteCommand(Boolean var1);

        public Builder group(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder overrides(TaskOverride var1);

        default public Builder overrides(Consumer<TaskOverride.Builder> overrides) {
            return this.overrides((TaskOverride)((TaskOverride.Builder)TaskOverride.builder().applyMutation(overrides)).build());
        }

        public Builder propagateTags(String var1);

        public Builder propagateTags(PropagateTags var1);

        public Builder referenceId(String var1);

        public Builder startedBy(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder taskDefinition(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

