/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on a data volume from another container in the same task definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeFrom implements SdkPojo, Serializable, ToCopyableBuilder<VolumeFrom.Builder, VolumeFrom> {
    private static final SdkField<String> SOURCE_CONTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceContainer").getter(getter(VolumeFrom::sourceContainer)).setter(setter(Builder::sourceContainer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceContainer").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("readOnly").getter(getter(VolumeFrom::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CONTAINER_FIELD,
            READ_ONLY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceContainer;

    private final Boolean readOnly;

    private VolumeFrom(BuilderImpl builder) {
        this.sourceContainer = builder.sourceContainer;
        this.readOnly = builder.readOnly;
    }

    /**
     * <p>
     * The name of another container within the same task definition from which to mount volumes.
     * </p>
     * 
     * @return The name of another container within the same task definition from which to mount volumes.
     */
    public final String sourceContainer() {
        return sourceContainer;
    }

    /**
     * <p>
     * If this value is <code>true</code>, the container has read-only access to the volume. If this value is
     * <code>false</code>, then the container can write to the volume. The default value is <code>false</code>.
     * </p>
     * 
     * @return If this value is <code>true</code>, the container has read-only access to the volume. If this value is
     *         <code>false</code>, then the container can write to the volume. The default value is <code>false</code>.
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceContainer());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeFrom)) {
            return false;
        }
        VolumeFrom other = (VolumeFrom) obj;
        return Objects.equals(sourceContainer(), other.sourceContainer()) && Objects.equals(readOnly(), other.readOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeFrom").add("SourceContainer", sourceContainer()).add("ReadOnly", readOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceContainer":
            return Optional.ofNullable(clazz.cast(sourceContainer()));
        case "readOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeFrom, T> g) {
        return obj -> g.apply((VolumeFrom) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeFrom> {
        /**
         * <p>
         * The name of another container within the same task definition from which to mount volumes.
         * </p>
         * 
         * @param sourceContainer
         *        The name of another container within the same task definition from which to mount volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceContainer(String sourceContainer);

        /**
         * <p>
         * If this value is <code>true</code>, the container has read-only access to the volume. If this value is
         * <code>false</code>, then the container can write to the volume. The default value is <code>false</code>.
         * </p>
         * 
         * @param readOnly
         *        If this value is <code>true</code>, the container has read-only access to the volume. If this value is
         *        <code>false</code>, then the container can write to the volume. The default value is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);
    }

    static final class BuilderImpl implements Builder {
        private String sourceContainer;

        private Boolean readOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeFrom model) {
            sourceContainer(model.sourceContainer);
            readOnly(model.readOnly);
        }

        public final String getSourceContainer() {
            return sourceContainer;
        }

        @Override
        public final Builder sourceContainer(String sourceContainer) {
            this.sourceContainer = sourceContainer;
            return this;
        }

        public final void setSourceContainer(String sourceContainer) {
            this.sourceContainer = sourceContainer;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public VolumeFrom build() {
            return new VolumeFrom(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
