/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.NetworkBinding;
import software.amazon.awssdk.services.ecs.model.NetworkBindingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerStateChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerStateChange> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(ContainerStateChange.getter(ContainerStateChange::containerName)).setter(ContainerStateChange.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageDigest").getter(ContainerStateChange.getter(ContainerStateChange::imageDigest)).setter(ContainerStateChange.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final SdkField<String> RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeId").getter(ContainerStateChange.getter(ContainerStateChange::runtimeId)).setter(ContainerStateChange.setter(Builder::runtimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeId").build()}).build();
    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("exitCode").getter(ContainerStateChange.getter(ContainerStateChange::exitCode)).setter(ContainerStateChange.setter(Builder::exitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()}).build();
    private static final SdkField<List<NetworkBinding>> NETWORK_BINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkBindings").getter(ContainerStateChange.getter(ContainerStateChange::networkBindings)).setter(ContainerStateChange.setter(Builder::networkBindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkBindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkBinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(ContainerStateChange.getter(ContainerStateChange::reason)).setter(ContainerStateChange.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ContainerStateChange.getter(ContainerStateChange::status)).setter(ContainerStateChange.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, IMAGE_DIGEST_FIELD, RUNTIME_ID_FIELD, EXIT_CODE_FIELD, NETWORK_BINDINGS_FIELD, REASON_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerName;
    private final String imageDigest;
    private final String runtimeId;
    private final Integer exitCode;
    private final List<NetworkBinding> networkBindings;
    private final String reason;
    private final String status;

    private ContainerStateChange(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.imageDigest = builder.imageDigest;
        this.runtimeId = builder.runtimeId;
        this.exitCode = builder.exitCode;
        this.networkBindings = builder.networkBindings;
        this.reason = builder.reason;
        this.status = builder.status;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final String runtimeId() {
        return this.runtimeId;
    }

    public final Integer exitCode() {
        return this.exitCode;
    }

    public final boolean hasNetworkBindings() {
        return this.networkBindings != null && !(this.networkBindings instanceof SdkAutoConstructList);
    }

    public final List<NetworkBinding> networkBindings() {
        return this.networkBindings;
    }

    public final String reason() {
        return this.reason;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkBindings() ? this.networkBindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerStateChange)) {
            return false;
        }
        ContainerStateChange other = (ContainerStateChange)obj;
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.runtimeId(), other.runtimeId()) && Objects.equals(this.exitCode(), other.exitCode()) && this.hasNetworkBindings() == other.hasNetworkBindings() && Objects.equals(this.networkBindings(), other.networkBindings()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerStateChange").add("ContainerName", (Object)this.containerName()).add("ImageDigest", (Object)this.imageDigest()).add("RuntimeId", (Object)this.runtimeId()).add("ExitCode", (Object)this.exitCode()).add("NetworkBindings", this.hasNetworkBindings() ? this.networkBindings() : null).add("Reason", (Object)this.reason()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "runtimeId": {
                return Optional.ofNullable(clazz.cast(this.runtimeId()));
            }
            case "exitCode": {
                return Optional.ofNullable(clazz.cast(this.exitCode()));
            }
            case "networkBindings": {
                return Optional.ofNullable(clazz.cast(this.networkBindings()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerStateChange, T> g) {
        return obj -> g.apply((ContainerStateChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerName;
        private String imageDigest;
        private String runtimeId;
        private Integer exitCode;
        private List<NetworkBinding> networkBindings = DefaultSdkAutoConstructList.getInstance();
        private String reason;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerStateChange model) {
            this.containerName(model.containerName);
            this.imageDigest(model.imageDigest);
            this.runtimeId(model.runtimeId);
            this.exitCode(model.exitCode);
            this.networkBindings(model.networkBindings);
            this.reason(model.reason);
            this.status(model.status);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final String getRuntimeId() {
            return this.runtimeId;
        }

        @Override
        public final Builder runtimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public final void setRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final List<NetworkBinding.Builder> getNetworkBindings() {
            List<NetworkBinding.Builder> result = NetworkBindingsCopier.copyToBuilder(this.networkBindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder networkBindings(Collection<NetworkBinding> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copy(networkBindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(NetworkBinding ... networkBindings) {
            this.networkBindings(Arrays.asList(networkBindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(Consumer<NetworkBinding.Builder> ... networkBindings) {
            this.networkBindings(Stream.of(networkBindings).map(c -> (NetworkBinding)((NetworkBinding.Builder)NetworkBinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkBindings(Collection<NetworkBinding.BuilderImpl> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copyFromBuilder(networkBindings);
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ContainerStateChange build() {
            return new ContainerStateChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerStateChange> {
        public Builder containerName(String var1);

        public Builder imageDigest(String var1);

        public Builder runtimeId(String var1);

        public Builder exitCode(Integer var1);

        public Builder networkBindings(Collection<NetworkBinding> var1);

        public Builder networkBindings(NetworkBinding ... var1);

        public Builder networkBindings(Consumer<NetworkBinding.Builder> ... var1);

        public Builder reason(String var1);

        public Builder status(String var1);
    }
}

