/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContainerAgentRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, UpdateContainerAgentRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(UpdateContainerAgentRequest.getter(UpdateContainerAgentRequest::cluster)).setter(UpdateContainerAgentRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> CONTAINER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerInstance").getter(UpdateContainerAgentRequest.getter(UpdateContainerAgentRequest::containerInstance)).setter(UpdateContainerAgentRequest.setter(Builder::containerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, CONTAINER_INSTANCE_FIELD));
    private final String cluster;
    private final String containerInstance;

    private UpdateContainerAgentRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.containerInstance = builder.containerInstance;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String containerInstance() {
        return this.containerInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerAgentRequest)) {
            return false;
        }
        UpdateContainerAgentRequest other = (UpdateContainerAgentRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.containerInstance(), other.containerInstance());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContainerAgentRequest").add("Cluster", (Object)this.cluster()).add("ContainerInstance", (Object)this.containerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "containerInstance": {
                return Optional.ofNullable(clazz.cast(this.containerInstance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContainerAgentRequest, T> g) {
        return obj -> g.apply((UpdateContainerAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String containerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContainerAgentRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.containerInstance(model.containerInstance);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getContainerInstance() {
            return this.containerInstance;
        }

        @Override
        public final Builder containerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
            return this;
        }

        public final void setContainerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContainerAgentRequest build() {
            return new UpdateContainerAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContainerAgentRequest> {
        public Builder cluster(String var1);

        public Builder containerInstance(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

