/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authorization configuration details for Amazon FSx for Windows File Server file system. See <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_FSxWindowsFileServerVolumeConfiguration.html"
 * >FSxWindowsFileServerVolumeConfiguration</a> in the <i>Amazon Elastic Container Service API Reference</i>.
 * </p>
 * <p>
 * For more information and the input format, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html">Amazon FSx for Windows File
 * Server Volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FSxWindowsFileServerAuthorizationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FSxWindowsFileServerAuthorizationConfig.Builder, FSxWindowsFileServerAuthorizationConfig> {
    private static final SdkField<String> CREDENTIALS_PARAMETER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsParameter").getter(getter(FSxWindowsFileServerAuthorizationConfig::credentialsParameter))
            .setter(setter(Builder::credentialsParameter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsParameter").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(FSxWindowsFileServerAuthorizationConfig::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_PARAMETER_FIELD,
            DOMAIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String credentialsParameter;

    private final String domain;

    private FSxWindowsFileServerAuthorizationConfig(BuilderImpl builder) {
        this.credentialsParameter = builder.credentialsParameter;
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The authorization credential option to use. The authorization credential options can be provided using either the
     * Amazon Resource Name (ARN) of an Secrets Manager secret or SSM Parameter Store parameter. The ARNs refer to the
     * stored credentials.
     * </p>
     * 
     * @return The authorization credential option to use. The authorization credential options can be provided using
     *         either the Amazon Resource Name (ARN) of an Secrets Manager secret or SSM Parameter Store parameter. The
     *         ARNs refer to the stored credentials.
     */
    public final String credentialsParameter() {
        return credentialsParameter;
    }

    /**
     * <p>
     * A fully qualified domain name hosted by an <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Directory
     * Service</a> Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
     * </p>
     * 
     * @return A fully qualified domain name hosted by an <a
     *         href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html"
     *         >Directory Service</a> Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
     */
    public final String domain() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentialsParameter());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FSxWindowsFileServerAuthorizationConfig)) {
            return false;
        }
        FSxWindowsFileServerAuthorizationConfig other = (FSxWindowsFileServerAuthorizationConfig) obj;
        return Objects.equals(credentialsParameter(), other.credentialsParameter()) && Objects.equals(domain(), other.domain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FSxWindowsFileServerAuthorizationConfig").add("CredentialsParameter", credentialsParameter())
                .add("Domain", domain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentialsParameter":
            return Optional.ofNullable(clazz.cast(credentialsParameter()));
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FSxWindowsFileServerAuthorizationConfig, T> g) {
        return obj -> g.apply((FSxWindowsFileServerAuthorizationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FSxWindowsFileServerAuthorizationConfig> {
        /**
         * <p>
         * The authorization credential option to use. The authorization credential options can be provided using either
         * the Amazon Resource Name (ARN) of an Secrets Manager secret or SSM Parameter Store parameter. The ARNs refer
         * to the stored credentials.
         * </p>
         * 
         * @param credentialsParameter
         *        The authorization credential option to use. The authorization credential options can be provided using
         *        either the Amazon Resource Name (ARN) of an Secrets Manager secret or SSM Parameter Store parameter.
         *        The ARNs refer to the stored credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsParameter(String credentialsParameter);

        /**
         * <p>
         * A fully qualified domain name hosted by an <a
         * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Directory
         * Service</a> Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
         * </p>
         * 
         * @param domain
         *        A fully qualified domain name hosted by an <a
         *        href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html"
         *        >Directory Service</a> Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);
    }

    static final class BuilderImpl implements Builder {
        private String credentialsParameter;

        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(FSxWindowsFileServerAuthorizationConfig model) {
            credentialsParameter(model.credentialsParameter);
            domain(model.domain);
        }

        public final String getCredentialsParameter() {
            return credentialsParameter;
        }

        @Override
        public final Builder credentialsParameter(String credentialsParameter) {
            this.credentialsParameter = credentialsParameter;
            return this;
        }

        public final void setCredentialsParameter(String credentialsParameter) {
            this.credentialsParameter = credentialsParameter;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public FSxWindowsFileServerAuthorizationConfig build() {
            return new FSxWindowsFileServerAuthorizationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
