/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterContainerInstanceRequest extends EcsRequest implements
        ToCopyableBuilder<RegisterContainerInstanceRequest.Builder, RegisterContainerInstanceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(RegisterContainerInstanceRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> INSTANCE_IDENTITY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceIdentityDocument").getter(getter(RegisterContainerInstanceRequest::instanceIdentityDocument))
            .setter(setter(Builder::instanceIdentityDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIdentityDocument").build())
            .build();

    private static final SdkField<String> INSTANCE_IDENTITY_DOCUMENT_SIGNATURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("instanceIdentityDocumentSignature")
            .getter(getter(RegisterContainerInstanceRequest::instanceIdentityDocumentSignature))
            .setter(setter(Builder::instanceIdentityDocumentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIdentityDocumentSignature")
                    .build()).build();

    private static final SdkField<List<Resource>> TOTAL_RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("totalResources")
            .getter(getter(RegisterContainerInstanceRequest::totalResources))
            .setter(setter(Builder::totalResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VersionInfo> VERSION_INFO_FIELD = SdkField.<VersionInfo> builder(MarshallingType.SDK_POJO)
            .memberName("versionInfo").getter(getter(RegisterContainerInstanceRequest::versionInfo))
            .setter(setter(Builder::versionInfo)).constructor(VersionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionInfo").build()).build();

    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerInstanceArn").getter(getter(RegisterContainerInstanceRequest::containerInstanceArn))
            .setter(setter(Builder::containerInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build())
            .build();

    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(RegisterContainerInstanceRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlatformDevice>> PLATFORM_DEVICES_FIELD = SdkField
            .<List<PlatformDevice>> builder(MarshallingType.LIST)
            .memberName("platformDevices")
            .getter(getter(RegisterContainerInstanceRequest::platformDevices))
            .setter(setter(Builder::platformDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformDevice> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformDevice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(RegisterContainerInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            INSTANCE_IDENTITY_DOCUMENT_FIELD, INSTANCE_IDENTITY_DOCUMENT_SIGNATURE_FIELD, TOTAL_RESOURCES_FIELD,
            VERSION_INFO_FIELD, CONTAINER_INSTANCE_ARN_FIELD, ATTRIBUTES_FIELD, PLATFORM_DEVICES_FIELD, TAGS_FIELD));

    private final String cluster;

    private final String instanceIdentityDocument;

    private final String instanceIdentityDocumentSignature;

    private final List<Resource> totalResources;

    private final VersionInfo versionInfo;

    private final String containerInstanceArn;

    private final List<Attribute> attributes;

    private final List<PlatformDevice> platformDevices;

    private final List<Tag> tags;

    private RegisterContainerInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.instanceIdentityDocument = builder.instanceIdentityDocument;
        this.instanceIdentityDocumentSignature = builder.instanceIdentityDocumentSignature;
        this.totalResources = builder.totalResources;
        this.versionInfo = builder.versionInfo;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.attributes = builder.attributes;
        this.platformDevices = builder.platformDevices;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster with which to register your container instance.
     * If you do not specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster with which to register your container
     *         instance. If you do not specify a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The instance identity document for the EC2 instance to register. This document can be found by running the
     * following command from the instance:
     * <code>curl http://169.254.169.254/latest/dynamic/instance-identity/document/</code>
     * </p>
     * 
     * @return The instance identity document for the EC2 instance to register. This document can be found by running
     *         the following command from the instance:
     *         <code>curl http://169.254.169.254/latest/dynamic/instance-identity/document/</code>
     */
    public final String instanceIdentityDocument() {
        return instanceIdentityDocument;
    }

    /**
     * <p>
     * The instance identity document signature for the EC2 instance to register. This signature can be found by running
     * the following command from the instance:
     * <code>curl http://169.254.169.254/latest/dynamic/instance-identity/signature/</code>
     * </p>
     * 
     * @return The instance identity document signature for the EC2 instance to register. This signature can be found by
     *         running the following command from the instance:
     *         <code>curl http://169.254.169.254/latest/dynamic/instance-identity/signature/</code>
     */
    public final String instanceIdentityDocumentSignature() {
        return instanceIdentityDocumentSignature;
    }

    /**
     * Returns true if the TotalResources property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTotalResources() {
        return totalResources != null && !(totalResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources available on the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTotalResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The resources available on the instance.
     */
    public final List<Resource> totalResources() {
        return totalResources;
    }

    /**
     * <p>
     * The version information for the Amazon ECS container agent and Docker daemon running on the container instance.
     * </p>
     * 
     * @return The version information for the Amazon ECS container agent and Docker daemon running on the container
     *         instance.
     */
    public final VersionInfo versionInfo() {
        return versionInfo;
    }

    /**
     * <p>
     * The ARN of the container instance (if it was previously registered).
     * </p>
     * 
     * @return The ARN of the container instance (if it was previously registered).
     */
    public final String containerInstanceArn() {
        return containerInstanceArn;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container instance attributes that this container instance supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The container instance attributes that this container instance supports.
     */
    public final List<Attribute> attributes() {
        return attributes;
    }

    /**
     * Returns true if the PlatformDevices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPlatformDevices() {
        return platformDevices != null && !(platformDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The devices that are available on the container instance. The only supported device type is a GPU.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlatformDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The devices that are available on the container instance. The only supported device type is a GPU.
     */
    public final List<PlatformDevice> platformDevices() {
        return platformDevices;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the container instance to help you categorize and organize them. Each tag consists
     * of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata that you apply to the container instance to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete
     *         tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource
     *         limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIdentityDocument());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIdentityDocumentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(hasTotalResources() ? totalResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(versionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlatformDevices() ? platformDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterContainerInstanceRequest)) {
            return false;
        }
        RegisterContainerInstanceRequest other = (RegisterContainerInstanceRequest) obj;
        return Objects.equals(cluster(), other.cluster())
                && Objects.equals(instanceIdentityDocument(), other.instanceIdentityDocument())
                && Objects.equals(instanceIdentityDocumentSignature(), other.instanceIdentityDocumentSignature())
                && hasTotalResources() == other.hasTotalResources() && Objects.equals(totalResources(), other.totalResources())
                && Objects.equals(versionInfo(), other.versionInfo())
                && Objects.equals(containerInstanceArn(), other.containerInstanceArn())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && hasPlatformDevices() == other.hasPlatformDevices()
                && Objects.equals(platformDevices(), other.platformDevices()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterContainerInstanceRequest").add("Cluster", cluster())
                .add("InstanceIdentityDocument", instanceIdentityDocument())
                .add("InstanceIdentityDocumentSignature", instanceIdentityDocumentSignature())
                .add("TotalResources", hasTotalResources() ? totalResources() : null).add("VersionInfo", versionInfo())
                .add("ContainerInstanceArn", containerInstanceArn()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("PlatformDevices", hasPlatformDevices() ? platformDevices() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "instanceIdentityDocument":
            return Optional.ofNullable(clazz.cast(instanceIdentityDocument()));
        case "instanceIdentityDocumentSignature":
            return Optional.ofNullable(clazz.cast(instanceIdentityDocumentSignature()));
        case "totalResources":
            return Optional.ofNullable(clazz.cast(totalResources()));
        case "versionInfo":
            return Optional.ofNullable(clazz.cast(versionInfo()));
        case "containerInstanceArn":
            return Optional.ofNullable(clazz.cast(containerInstanceArn()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "platformDevices":
            return Optional.ofNullable(clazz.cast(platformDevices()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterContainerInstanceRequest, T> g) {
        return obj -> g.apply((RegisterContainerInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterContainerInstanceRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster with which to register your container
         * instance. If you do not specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster with which to register your container
         *        instance. If you do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The instance identity document for the EC2 instance to register. This document can be found by running the
         * following command from the instance:
         * <code>curl http://169.254.169.254/latest/dynamic/instance-identity/document/</code>
         * </p>
         * 
         * @param instanceIdentityDocument
         *        The instance identity document for the EC2 instance to register. This document can be found by running
         *        the following command from the instance:
         *        <code>curl http://169.254.169.254/latest/dynamic/instance-identity/document/</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdentityDocument(String instanceIdentityDocument);

        /**
         * <p>
         * The instance identity document signature for the EC2 instance to register. This signature can be found by
         * running the following command from the instance:
         * <code>curl http://169.254.169.254/latest/dynamic/instance-identity/signature/</code>
         * </p>
         * 
         * @param instanceIdentityDocumentSignature
         *        The instance identity document signature for the EC2 instance to register. This signature can be found
         *        by running the following command from the instance:
         *        <code>curl http://169.254.169.254/latest/dynamic/instance-identity/signature/</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdentityDocumentSignature(String instanceIdentityDocumentSignature);

        /**
         * <p>
         * The resources available on the instance.
         * </p>
         * 
         * @param totalResources
         *        The resources available on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResources(Collection<Resource> totalResources);

        /**
         * <p>
         * The resources available on the instance.
         * </p>
         * 
         * @param totalResources
         *        The resources available on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResources(Resource... totalResources);

        /**
         * <p>
         * The resources available on the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Resource>.Builder} avoiding the need to
         * create one manually via {@link List<Resource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Resource>.Builder#build()} is called immediately and its
         * result is passed to {@link #totalResources(List<Resource>)}.
         * 
         * @param totalResources
         *        a consumer that will call methods on {@link List<Resource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalResources(List<Resource>)
         */
        Builder totalResources(Consumer<Resource.Builder>... totalResources);

        /**
         * <p>
         * The version information for the Amazon ECS container agent and Docker daemon running on the container
         * instance.
         * </p>
         * 
         * @param versionInfo
         *        The version information for the Amazon ECS container agent and Docker daemon running on the container
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionInfo(VersionInfo versionInfo);

        /**
         * <p>
         * The version information for the Amazon ECS container agent and Docker daemon running on the container
         * instance.
         * </p>
         * This is a convenience that creates an instance of the {@link VersionInfo.Builder} avoiding the need to create
         * one manually via {@link VersionInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link VersionInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #versionInfo(VersionInfo)}.
         * 
         * @param versionInfo
         *        a consumer that will call methods on {@link VersionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versionInfo(VersionInfo)
         */
        default Builder versionInfo(Consumer<VersionInfo.Builder> versionInfo) {
            return versionInfo(VersionInfo.builder().applyMutation(versionInfo).build());
        }

        /**
         * <p>
         * The ARN of the container instance (if it was previously registered).
         * </p>
         * 
         * @param containerInstanceArn
         *        The ARN of the container instance (if it was previously registered).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstanceArn(String containerInstanceArn);

        /**
         * <p>
         * The container instance attributes that this container instance supports.
         * </p>
         * 
         * @param attributes
         *        The container instance attributes that this container instance supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Attribute> attributes);

        /**
         * <p>
         * The container instance attributes that this container instance supports.
         * </p>
         * 
         * @param attributes
         *        The container instance attributes that this container instance supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attribute... attributes);

        /**
         * <p>
         * The container instance attributes that this container instance supports.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(List<Attribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<Attribute>)
         */
        Builder attributes(Consumer<Attribute.Builder>... attributes);

        /**
         * <p>
         * The devices that are available on the container instance. The only supported device type is a GPU.
         * </p>
         * 
         * @param platformDevices
         *        The devices that are available on the container instance. The only supported device type is a GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDevices(Collection<PlatformDevice> platformDevices);

        /**
         * <p>
         * The devices that are available on the container instance. The only supported device type is a GPU.
         * </p>
         * 
         * @param platformDevices
         *        The devices that are available on the container instance. The only supported device type is a GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDevices(PlatformDevice... platformDevices);

        /**
         * <p>
         * The devices that are available on the container instance. The only supported device type is a GPU.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlatformDevice>.Builder} avoiding the need
         * to create one manually via {@link List<PlatformDevice>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlatformDevice>.Builder#build()} is called immediately and
         * its result is passed to {@link #platformDevices(List<PlatformDevice>)}.
         * 
         * @param platformDevices
         *        a consumer that will call methods on {@link List<PlatformDevice>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformDevices(List<PlatformDevice>)
         */
        Builder platformDevices(Consumer<PlatformDevice.Builder>... platformDevices);

        /**
         * <p>
         * The metadata that you apply to the container instance to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the container instance to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the container instance to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the container instance to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the container instance to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String instanceIdentityDocument;

        private String instanceIdentityDocumentSignature;

        private List<Resource> totalResources = DefaultSdkAutoConstructList.getInstance();

        private VersionInfo versionInfo;

        private String containerInstanceArn;

        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<PlatformDevice> platformDevices = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterContainerInstanceRequest model) {
            super(model);
            cluster(model.cluster);
            instanceIdentityDocument(model.instanceIdentityDocument);
            instanceIdentityDocumentSignature(model.instanceIdentityDocumentSignature);
            totalResources(model.totalResources);
            versionInfo(model.versionInfo);
            containerInstanceArn(model.containerInstanceArn);
            attributes(model.attributes);
            platformDevices(model.platformDevices);
            tags(model.tags);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getInstanceIdentityDocument() {
            return instanceIdentityDocument;
        }

        @Override
        public final Builder instanceIdentityDocument(String instanceIdentityDocument) {
            this.instanceIdentityDocument = instanceIdentityDocument;
            return this;
        }

        public final void setInstanceIdentityDocument(String instanceIdentityDocument) {
            this.instanceIdentityDocument = instanceIdentityDocument;
        }

        public final String getInstanceIdentityDocumentSignature() {
            return instanceIdentityDocumentSignature;
        }

        @Override
        public final Builder instanceIdentityDocumentSignature(String instanceIdentityDocumentSignature) {
            this.instanceIdentityDocumentSignature = instanceIdentityDocumentSignature;
            return this;
        }

        public final void setInstanceIdentityDocumentSignature(String instanceIdentityDocumentSignature) {
            this.instanceIdentityDocumentSignature = instanceIdentityDocumentSignature;
        }

        public final List<Resource.Builder> getTotalResources() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.totalResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder totalResources(Collection<Resource> totalResources) {
            this.totalResources = ResourcesCopier.copy(totalResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalResources(Resource... totalResources) {
            totalResources(Arrays.asList(totalResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalResources(Consumer<Resource.Builder>... totalResources) {
            totalResources(Stream.of(totalResources).map(c -> Resource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTotalResources(Collection<Resource.BuilderImpl> totalResources) {
            this.totalResources = ResourcesCopier.copyFromBuilder(totalResources);
        }

        public final VersionInfo.Builder getVersionInfo() {
            return versionInfo != null ? versionInfo.toBuilder() : null;
        }

        @Override
        public final Builder versionInfo(VersionInfo versionInfo) {
            this.versionInfo = versionInfo;
            return this;
        }

        public final void setVersionInfo(VersionInfo.BuilderImpl versionInfo) {
            this.versionInfo = versionInfo != null ? versionInfo.build() : null;
        }

        public final String getContainerInstanceArn() {
            return containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = AttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> Attribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributesCopier.copyFromBuilder(attributes);
        }

        public final List<PlatformDevice.Builder> getPlatformDevices() {
            List<PlatformDevice.Builder> result = PlatformDevicesCopier.copyToBuilder(this.platformDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder platformDevices(Collection<PlatformDevice> platformDevices) {
            this.platformDevices = PlatformDevicesCopier.copy(platformDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformDevices(PlatformDevice... platformDevices) {
            platformDevices(Arrays.asList(platformDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformDevices(Consumer<PlatformDevice.Builder>... platformDevices) {
            platformDevices(Stream.of(platformDevices).map(c -> PlatformDevice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlatformDevices(Collection<PlatformDevice.BuilderImpl> platformDevices) {
            this.platformDevices = PlatformDevicesCopier.copyFromBuilder(platformDevices);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterContainerInstanceRequest build() {
            return new RegisterContainerInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
