/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data volume used in a task definition. For tasks that use the Amazon Elastic File System (Amazon EFS), specify an
 * <code>efsVolumeConfiguration</code>. For Windows tasks that use Amazon FSx for Windows File Server file system,
 * specify a <code>fsxWindowsFileServerVolumeConfiguration</code>. For tasks that use a Docker volume, specify a
 * <code>DockerVolumeConfiguration</code>. For tasks that use a bind mount host volume, specify a <code>host</code> and
 * optional <code>sourcePath</code>. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using Data Volumes in
 * Tasks</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Volume implements SdkPojo, Serializable, ToCopyableBuilder<Volume.Builder, Volume> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Volume::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<HostVolumeProperties> HOST_FIELD = SdkField
            .<HostVolumeProperties> builder(MarshallingType.SDK_POJO).memberName("host").getter(getter(Volume::host))
            .setter(setter(Builder::host)).constructor(HostVolumeProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()).build();

    private static final SdkField<DockerVolumeConfiguration> DOCKER_VOLUME_CONFIGURATION_FIELD = SdkField
            .<DockerVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("dockerVolumeConfiguration")
            .getter(getter(Volume::dockerVolumeConfiguration)).setter(setter(Builder::dockerVolumeConfiguration))
            .constructor(DockerVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerVolumeConfiguration").build())
            .build();

    private static final SdkField<EFSVolumeConfiguration> EFS_VOLUME_CONFIGURATION_FIELD = SdkField
            .<EFSVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("efsVolumeConfiguration")
            .getter(getter(Volume::efsVolumeConfiguration)).setter(setter(Builder::efsVolumeConfiguration))
            .constructor(EFSVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("efsVolumeConfiguration").build())
            .build();

    private static final SdkField<FSxWindowsFileServerVolumeConfiguration> FSX_WINDOWS_FILE_SERVER_VOLUME_CONFIGURATION_FIELD = SdkField
            .<FSxWindowsFileServerVolumeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("fsxWindowsFileServerVolumeConfiguration")
            .getter(getter(Volume::fsxWindowsFileServerVolumeConfiguration))
            .setter(setter(Builder::fsxWindowsFileServerVolumeConfiguration))
            .constructor(FSxWindowsFileServerVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("fsxWindowsFileServerVolumeConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NAME_FIELD, HOST_FIELD, DOCKER_VOLUME_CONFIGURATION_FIELD, EFS_VOLUME_CONFIGURATION_FIELD,
                    FSX_WINDOWS_FILE_SERVER_VOLUME_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final HostVolumeProperties host;

    private final DockerVolumeConfiguration dockerVolumeConfiguration;

    private final EFSVolumeConfiguration efsVolumeConfiguration;

    private final FSxWindowsFileServerVolumeConfiguration fsxWindowsFileServerVolumeConfiguration;

    private Volume(BuilderImpl builder) {
        this.name = builder.name;
        this.host = builder.host;
        this.dockerVolumeConfiguration = builder.dockerVolumeConfiguration;
        this.efsVolumeConfiguration = builder.efsVolumeConfiguration;
        this.fsxWindowsFileServerVolumeConfiguration = builder.fsxWindowsFileServerVolumeConfiguration;
    }

    /**
     * <p>
     * The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
     * allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition
     * <code>mountPoints</code>.
     * </p>
     * 
     * @return The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens
     *         are allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition
     *         <code>mountPoints</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * This parameter is specified when you are using bind mount host volumes. The contents of the <code>host</code>
     * parameter determine whether your bind mount host volume persists on the host container instance and where it is
     * stored. If the <code>host</code> parameter is empty, then the Docker daemon assigns a host path for your data
     * volume. However, the data is not guaranteed to persist after the containers associated with it stop running.
     * </p>
     * <p>
     * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>. Windows
     * containers cannot mount directories on a different drive, and mount point cannot be across drives. For example,
     * you can mount <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code>, but not
     * <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code>.
     * </p>
     * 
     * @return This parameter is specified when you are using bind mount host volumes. The contents of the
     *         <code>host</code> parameter determine whether your bind mount host volume persists on the host container
     *         instance and where it is stored. If the <code>host</code> parameter is empty, then the Docker daemon
     *         assigns a host path for your data volume. However, the data is not guaranteed to persist after the
     *         containers associated with it stop running.</p>
     *         <p>
     *         Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>.
     *         Windows containers cannot mount directories on a different drive, and mount point cannot be across
     *         drives. For example, you can mount <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code>, but not
     *         <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code>.
     */
    public final HostVolumeProperties host() {
        return host;
    }

    /**
     * <p>
     * This parameter is specified when you are using Docker volumes.
     * </p>
     * <p>
     * Windows containers only support the use of the <code>local</code> driver. To use bind mounts, specify the
     * <code>host</code> parameter instead.
     * </p>
     * <note>
     * <p>
     * Docker volumes are not supported by tasks run on Fargate.
     * </p>
     * </note>
     * 
     * @return This parameter is specified when you are using Docker volumes.</p>
     *         <p>
     *         Windows containers only support the use of the <code>local</code> driver. To use bind mounts, specify the
     *         <code>host</code> parameter instead.
     *         </p>
     *         <note>
     *         <p>
     *         Docker volumes are not supported by tasks run on Fargate.
     *         </p>
     */
    public final DockerVolumeConfiguration dockerVolumeConfiguration() {
        return dockerVolumeConfiguration;
    }

    /**
     * <p>
     * This parameter is specified when you are using an Amazon Elastic File System file system for task storage.
     * </p>
     * 
     * @return This parameter is specified when you are using an Amazon Elastic File System file system for task
     *         storage.
     */
    public final EFSVolumeConfiguration efsVolumeConfiguration() {
        return efsVolumeConfiguration;
    }

    /**
     * <p>
     * This parameter is specified when you are using Amazon FSx for Windows File Server file system for task storage.
     * </p>
     * 
     * @return This parameter is specified when you are using Amazon FSx for Windows File Server file system for task
     *         storage.
     */
    public final FSxWindowsFileServerVolumeConfiguration fsxWindowsFileServerVolumeConfiguration() {
        return fsxWindowsFileServerVolumeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(dockerVolumeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(efsVolumeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(fsxWindowsFileServerVolumeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(host(), other.host())
                && Objects.equals(dockerVolumeConfiguration(), other.dockerVolumeConfiguration())
                && Objects.equals(efsVolumeConfiguration(), other.efsVolumeConfiguration())
                && Objects.equals(fsxWindowsFileServerVolumeConfiguration(), other.fsxWindowsFileServerVolumeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Volume").add("Name", name()).add("Host", host())
                .add("DockerVolumeConfiguration", dockerVolumeConfiguration())
                .add("EfsVolumeConfiguration", efsVolumeConfiguration())
                .add("FsxWindowsFileServerVolumeConfiguration", fsxWindowsFileServerVolumeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "host":
            return Optional.ofNullable(clazz.cast(host()));
        case "dockerVolumeConfiguration":
            return Optional.ofNullable(clazz.cast(dockerVolumeConfiguration()));
        case "efsVolumeConfiguration":
            return Optional.ofNullable(clazz.cast(efsVolumeConfiguration()));
        case "fsxWindowsFileServerVolumeConfiguration":
            return Optional.ofNullable(clazz.cast(fsxWindowsFileServerVolumeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Volume> {
        /**
         * <p>
         * The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
         * allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition
         * <code>mountPoints</code>.
         * </p>
         * 
         * @param name
         *        The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens
         *        are allowed. This name is referenced in the <code>sourceVolume</code> parameter of container
         *        definition <code>mountPoints</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * This parameter is specified when you are using bind mount host volumes. The contents of the <code>host</code>
         * parameter determine whether your bind mount host volume persists on the host container instance and where it
         * is stored. If the <code>host</code> parameter is empty, then the Docker daemon assigns a host path for your
         * data volume. However, the data is not guaranteed to persist after the containers associated with it stop
         * running.
         * </p>
         * <p>
         * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>. Windows
         * containers cannot mount directories on a different drive, and mount point cannot be across drives. For
         * example, you can mount <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code>, but not
         * <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code>.
         * </p>
         * 
         * @param host
         *        This parameter is specified when you are using bind mount host volumes. The contents of the
         *        <code>host</code> parameter determine whether your bind mount host volume persists on the host
         *        container instance and where it is stored. If the <code>host</code> parameter is empty, then the
         *        Docker daemon assigns a host path for your data volume. However, the data is not guaranteed to persist
         *        after the containers associated with it stop running.</p>
         *        <p>
         *        Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>.
         *        Windows containers cannot mount directories on a different drive, and mount point cannot be across
         *        drives. For example, you can mount <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code>, but
         *        not <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(HostVolumeProperties host);

        /**
         * <p>
         * This parameter is specified when you are using bind mount host volumes. The contents of the <code>host</code>
         * parameter determine whether your bind mount host volume persists on the host container instance and where it
         * is stored. If the <code>host</code> parameter is empty, then the Docker daemon assigns a host path for your
         * data volume. However, the data is not guaranteed to persist after the containers associated with it stop
         * running.
         * </p>
         * <p>
         * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code>. Windows
         * containers cannot mount directories on a different drive, and mount point cannot be across drives. For
         * example, you can mount <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code>, but not
         * <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link HostVolumeProperties.Builder} avoiding the need
         * to create one manually via {@link HostVolumeProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostVolumeProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #host(HostVolumeProperties)}.
         * 
         * @param host
         *        a consumer that will call methods on {@link HostVolumeProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #host(HostVolumeProperties)
         */
        default Builder host(Consumer<HostVolumeProperties.Builder> host) {
            return host(HostVolumeProperties.builder().applyMutation(host).build());
        }

        /**
         * <p>
         * This parameter is specified when you are using Docker volumes.
         * </p>
         * <p>
         * Windows containers only support the use of the <code>local</code> driver. To use bind mounts, specify the
         * <code>host</code> parameter instead.
         * </p>
         * <note>
         * <p>
         * Docker volumes are not supported by tasks run on Fargate.
         * </p>
         * </note>
         * 
         * @param dockerVolumeConfiguration
         *        This parameter is specified when you are using Docker volumes.</p>
         *        <p>
         *        Windows containers only support the use of the <code>local</code> driver. To use bind mounts, specify
         *        the <code>host</code> parameter instead.
         *        </p>
         *        <note>
         *        <p>
         *        Docker volumes are not supported by tasks run on Fargate.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerVolumeConfiguration(DockerVolumeConfiguration dockerVolumeConfiguration);

        /**
         * <p>
         * This parameter is specified when you are using Docker volumes.
         * </p>
         * <p>
         * Windows containers only support the use of the <code>local</code> driver. To use bind mounts, specify the
         * <code>host</code> parameter instead.
         * </p>
         * <note>
         * <p>
         * Docker volumes are not supported by tasks run on Fargate.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link DockerVolumeConfiguration.Builder}
         * avoiding the need to create one manually via {@link DockerVolumeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DockerVolumeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dockerVolumeConfiguration(DockerVolumeConfiguration)}.
         * 
         * @param dockerVolumeConfiguration
         *        a consumer that will call methods on {@link DockerVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dockerVolumeConfiguration(DockerVolumeConfiguration)
         */
        default Builder dockerVolumeConfiguration(Consumer<DockerVolumeConfiguration.Builder> dockerVolumeConfiguration) {
            return dockerVolumeConfiguration(DockerVolumeConfiguration.builder().applyMutation(dockerVolumeConfiguration).build());
        }

        /**
         * <p>
         * This parameter is specified when you are using an Amazon Elastic File System file system for task storage.
         * </p>
         * 
         * @param efsVolumeConfiguration
         *        This parameter is specified when you are using an Amazon Elastic File System file system for task
         *        storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsVolumeConfiguration(EFSVolumeConfiguration efsVolumeConfiguration);

        /**
         * <p>
         * This parameter is specified when you are using an Amazon Elastic File System file system for task storage.
         * </p>
         * This is a convenience that creates an instance of the {@link EFSVolumeConfiguration.Builder} avoiding the
         * need to create one manually via {@link EFSVolumeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EFSVolumeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #efsVolumeConfiguration(EFSVolumeConfiguration)}.
         * 
         * @param efsVolumeConfiguration
         *        a consumer that will call methods on {@link EFSVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efsVolumeConfiguration(EFSVolumeConfiguration)
         */
        default Builder efsVolumeConfiguration(Consumer<EFSVolumeConfiguration.Builder> efsVolumeConfiguration) {
            return efsVolumeConfiguration(EFSVolumeConfiguration.builder().applyMutation(efsVolumeConfiguration).build());
        }

        /**
         * <p>
         * This parameter is specified when you are using Amazon FSx for Windows File Server file system for task
         * storage.
         * </p>
         * 
         * @param fsxWindowsFileServerVolumeConfiguration
         *        This parameter is specified when you are using Amazon FSx for Windows File Server file system for task
         *        storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fsxWindowsFileServerVolumeConfiguration(
                FSxWindowsFileServerVolumeConfiguration fsxWindowsFileServerVolumeConfiguration);

        /**
         * <p>
         * This parameter is specified when you are using Amazon FSx for Windows File Server file system for task
         * storage.
         * </p>
         * This is a convenience that creates an instance of the {@link FSxWindowsFileServerVolumeConfiguration.Builder}
         * avoiding the need to create one manually via {@link FSxWindowsFileServerVolumeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FSxWindowsFileServerVolumeConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #fsxWindowsFileServerVolumeConfiguration(FSxWindowsFileServerVolumeConfiguration)}.
         * 
         * @param fsxWindowsFileServerVolumeConfiguration
         *        a consumer that will call methods on {@link FSxWindowsFileServerVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fsxWindowsFileServerVolumeConfiguration(FSxWindowsFileServerVolumeConfiguration)
         */
        default Builder fsxWindowsFileServerVolumeConfiguration(
                Consumer<FSxWindowsFileServerVolumeConfiguration.Builder> fsxWindowsFileServerVolumeConfiguration) {
            return fsxWindowsFileServerVolumeConfiguration(FSxWindowsFileServerVolumeConfiguration.builder()
                    .applyMutation(fsxWindowsFileServerVolumeConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private HostVolumeProperties host;

        private DockerVolumeConfiguration dockerVolumeConfiguration;

        private EFSVolumeConfiguration efsVolumeConfiguration;

        private FSxWindowsFileServerVolumeConfiguration fsxWindowsFileServerVolumeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            name(model.name);
            host(model.host);
            dockerVolumeConfiguration(model.dockerVolumeConfiguration);
            efsVolumeConfiguration(model.efsVolumeConfiguration);
            fsxWindowsFileServerVolumeConfiguration(model.fsxWindowsFileServerVolumeConfiguration);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final HostVolumeProperties.Builder getHost() {
            return host != null ? host.toBuilder() : null;
        }

        @Override
        public final Builder host(HostVolumeProperties host) {
            this.host = host;
            return this;
        }

        public final void setHost(HostVolumeProperties.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        public final DockerVolumeConfiguration.Builder getDockerVolumeConfiguration() {
            return dockerVolumeConfiguration != null ? dockerVolumeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dockerVolumeConfiguration(DockerVolumeConfiguration dockerVolumeConfiguration) {
            this.dockerVolumeConfiguration = dockerVolumeConfiguration;
            return this;
        }

        public final void setDockerVolumeConfiguration(DockerVolumeConfiguration.BuilderImpl dockerVolumeConfiguration) {
            this.dockerVolumeConfiguration = dockerVolumeConfiguration != null ? dockerVolumeConfiguration.build() : null;
        }

        public final EFSVolumeConfiguration.Builder getEfsVolumeConfiguration() {
            return efsVolumeConfiguration != null ? efsVolumeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder efsVolumeConfiguration(EFSVolumeConfiguration efsVolumeConfiguration) {
            this.efsVolumeConfiguration = efsVolumeConfiguration;
            return this;
        }

        public final void setEfsVolumeConfiguration(EFSVolumeConfiguration.BuilderImpl efsVolumeConfiguration) {
            this.efsVolumeConfiguration = efsVolumeConfiguration != null ? efsVolumeConfiguration.build() : null;
        }

        public final FSxWindowsFileServerVolumeConfiguration.Builder getFsxWindowsFileServerVolumeConfiguration() {
            return fsxWindowsFileServerVolumeConfiguration != null ? fsxWindowsFileServerVolumeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder fsxWindowsFileServerVolumeConfiguration(
                FSxWindowsFileServerVolumeConfiguration fsxWindowsFileServerVolumeConfiguration) {
            this.fsxWindowsFileServerVolumeConfiguration = fsxWindowsFileServerVolumeConfiguration;
            return this;
        }

        public final void setFsxWindowsFileServerVolumeConfiguration(
                FSxWindowsFileServerVolumeConfiguration.BuilderImpl fsxWindowsFileServerVolumeConfiguration) {
            this.fsxWindowsFileServerVolumeConfiguration = fsxWindowsFileServerVolumeConfiguration != null ? fsxWindowsFileServerVolumeConfiguration
                    .build() : null;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
