/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TaskStopCode {
    TASK_FAILED_TO_START("TaskFailedToStart"),
    ESSENTIAL_CONTAINER_EXITED("EssentialContainerExited"),
    USER_INITIATED("UserInitiated"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TaskStopCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskStopCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TaskStopCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskStopCode> knownValues() {
        return Stream.of(TaskStopCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

